/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.util;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoginRequestDispatcher {
    public static final String PARAM_USER_ID = "uid";
    public static final String PARAM_SERVER_ID = "sid";
    public static final String PARAM_TIMESTAMP = "ts";
    public static final String PARAM_HASH = "hash";
    public static final String PARAM_METHOD = "method";
    public static final String PARAM_COURSE_ID = "courseid";
    public static final String PARAM_COUNTRY = "country";
    public static final String PARAM_LANGUAGE = "lang";
    public static final String METHOD_AUTHOR = "author";
    public static final String METHOD_MONITOR = "monitor";
    public static final String METHOD_LEARNER = "learner";
    private static final String PARAM_LESSON_ID = "lsid";
    private static final String URL_DEFAULT = "/index.jsp";
    private static final String URL_AUTHOR = "/home.do?method=author";
    private static final String URL_LEARNER = "/home.do?method=learner&lessonID=";
    private static final String URL_MONITOR = "/home.do?method=monitorLesson&lessonID=";
    private static IIntegrationService integrationService = null;
    private static ILessonService lessonService = null;

    public static String getRequestURL(HttpServletRequest request) throws ServletException {
        String method = request.getParameter(PARAM_METHOD);
        String lessonId = request.getParameter(PARAM_LESSON_ID);
        try {
            LoginRequestDispatcher.addUserToLessonClass(request, lessonId, method);
        }
        catch (UserInfoFetchException e) {
            throw new ServletException((Throwable)e);
        }
        if (METHOD_AUTHOR.equals(method)) {
            return request.getContextPath() + URL_AUTHOR;
        }
        if (METHOD_MONITOR.equals(method) && lessonId != null) {
            return request.getContextPath() + URL_MONITOR + lessonId;
        }
        if (METHOD_LEARNER.equals(method) && lessonId != null) {
            return request.getContextPath() + URL_LEARNER + lessonId;
        }
        return request.getContextPath() + URL_DEFAULT;
    }

    private static void addUserToLessonClass(HttpServletRequest request, String lessonId, String method) throws UserInfoFetchException {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("integrationService");
        }
        if (lessonService == null) {
            lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("lessonService");
        }
        String serverId = request.getParameter(PARAM_SERVER_ID);
        String extUsername = request.getParameter(PARAM_USER_ID);
        ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
        ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, extUsername);
        if (METHOD_LEARNER.equals(method)) {
            lessonService.addLearner(Long.parseLong(lessonId), userMap.getUser());
        } else if (METHOD_MONITOR.equals(method)) {
            lessonService.addStaffMember(Long.parseLong(lessonId), userMap.getUser());
        }
    }
}

