/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dto;

import org.lamsfoundation.lams.tool.Tool;

public class AuthoringToolDTO {
    private Long toolID;
    private Long toolContentID;
    private String description;
    private String toolDisplayName;
    private Boolean supportsDefineLater;
    private Boolean supportsRunOffline;
    private Boolean supportsModeration;
    private Boolean supportsContribute;
    private String authoringURL;
    private String helpURL;

    public AuthoringToolDTO(Long toolID, Long toolContentID, String description, String toolDisplayName, Boolean supportsDefineLater, Boolean supportsRunOffline, Boolean supportsModeration, Boolean supportsContribute, String authoringURL, String helpURL) {
        this.toolID = toolID;
        this.toolContentID = toolContentID;
        this.description = description;
        this.toolDisplayName = toolDisplayName;
        this.supportsDefineLater = supportsDefineLater;
        this.supportsRunOffline = supportsRunOffline;
        this.supportsModeration = supportsModeration;
        this.supportsContribute = supportsContribute;
        this.authoringURL = authoringURL;
        this.helpURL = helpURL;
    }

    public AuthoringToolDTO(Tool tool) {
        this.toolID = tool.getToolId();
        this.toolContentID = new Long(tool.getDefaultToolContentId());
        this.description = tool.getDescription();
        this.toolDisplayName = tool.getToolDisplayName();
        this.supportsDefineLater = new Boolean(tool.getSupportsDefineLater());
        this.supportsRunOffline = new Boolean(tool.getSupportsRunOffline());
        this.supportsModeration = new Boolean(tool.getSupportsModeration());
        this.supportsContribute = new Boolean(tool.getSupportsContribute());
        this.authoringURL = tool.getAuthorUrl();
        this.helpURL = tool.getHelpUrl();
    }

    public String getAuthoringURL() {
        return this.authoringURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getSupportsContribute() {
        return this.supportsContribute;
    }

    public Boolean getSupportsDefineLater() {
        return this.supportsDefineLater;
    }

    public Boolean getSupportsModeration() {
        return this.supportsModeration;
    }

    public Boolean getSupportsRunOffline() {
        return this.supportsRunOffline;
    }

    public Long getToolContentID() {
        return this.toolContentID;
    }

    public String getToolDisplayName() {
        return this.toolDisplayName;
    }

    public Long getToolID() {
        return this.toolID;
    }
}

