/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.filter;

import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.web.filter.LocaleRequestWrapper;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class LocaleFilter
extends OncePerRequestFilter {
    private String encoding;
    public static final String PREFERRED_LOCALE_KEY = "org.apache.struts.action.LOCALE";
    public static final String DIRECTION = "page_direction";

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        HttpSession sharedsession;
        UserDTO user;
        if (!StringUtils.isEmpty((String)this.encoding)) {
            request.setCharacterEncoding(this.encoding);
        } else {
            request.setCharacterEncoding("UTF-8");
        }
        Locale preferredLocale = null;
        String direction = null;
        TimeZone tz = null;
        if (preferredLocale == null && (user = (UserDTO)(sharedsession = SessionManager.getSession()).getAttribute("user")) != null) {
            direction = user.getDirection();
            tz = user.getTimeZone();
            String lang = user.getLocaleLanguage();
            String country = user.getLocaleCountry();
            if (!StringUtils.isEmpty((String)lang)) {
                preferredLocale = new Locale(lang, country != null ? country : "");
            }
        }
        if (preferredLocale == null) {
            String[] defaults = LanguageUtil.getDefaultLangCountry();
            preferredLocale = new Locale(defaults[0] != null ? defaults[0] : "", defaults[1] != null ? defaults[1] : "");
        }
        if (direction == null) {
            direction = LanguageUtil.getDefaultDirection();
        }
        if (tz == null) {
            LanguageUtil.getDefaultTimeZone();
        }
        if ((session = request.getSession(false)) != null) {
            if (preferredLocale != null) {
                session.setAttribute(PREFERRED_LOCALE_KEY, (Object)preferredLocale);
                Config.set((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)preferredLocale);
                session.setAttribute(DIRECTION, (Object)direction);
            }
            Config.set((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.timeZone", (Object)tz);
        }
        if (preferredLocale != null && !(request instanceof LocaleRequestWrapper)) {
            request = new LocaleRequestWrapper((HttpServletRequest)request, preferredLocale);
            LocaleContextHolder.setLocale((Locale)preferredLocale);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        LocaleContextHolder.setLocaleContext(null);
    }
}

