/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.security.RandomPasswordGenerator;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.CSVUtil;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.LanguageUtil;

public class IntegrationService
implements IIntegrationService {
    private static Logger log = Logger.getLogger(IntegrationService.class);
    private IUserManagementService service;

    public IUserManagementService getService() {
        return this.service;
    }

    public void setService(IUserManagementService service) {
        this.service = service;
    }

    public ExtServerOrgMap getExtServerOrgMap(String serverId) {
        List list = this.service.findByProperty(ExtServerOrgMap.class, "serverid", serverId);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtServerOrgMap)list.get(0);
    }

    public ExtCourseClassMap getExtCourseClassMap(ExtServerOrgMap serverMap, ExtUserUseridMap userMap, String extCourseId, String countryIsoCode, String langIsoCode, String prettyCourseName) {
        String courseName = "";
        courseName = prettyCourseName != null ? prettyCourseName : extCourseId;
        return this.getExtCourseClassMap(serverMap, userMap, extCourseId, courseName, countryIsoCode, langIsoCode, this.service.getRootOrganisation().getOrganisationId().toString(), true, true);
    }

    public ExtCourseClassMap getExtCourseClassMap(ExtServerOrgMap serverMap, ExtUserUseridMap userMap, String extCourseId, String extCourseName, String countryIsoCode, String langIsoCode, String parentOrgId, Boolean isTeacher, Boolean prefix) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("courseid", extCourseId);
        properties.put("extServerOrgMap.sid", serverMap.getSid());
        List list = this.service.findByProperties(ExtCourseClassMap.class, properties);
        if (list == null || list.size() == 0) {
            return this.createExtCourseClassMap(serverMap, userMap.getUser(), extCourseId, extCourseName, countryIsoCode, langIsoCode, parentOrgId, isTeacher, prefix);
        }
        ExtCourseClassMap map = (ExtCourseClassMap)list.get(0);
        User user = userMap.getUser();
        Organisation org = map.getOrganisation();
        if (extCourseName != null && !org.getName().equals(this.buildName(serverMap.getPrefix(), extCourseName))) {
            org.setName(this.buildName(serverMap.getPrefix(), extCourseName));
            this.service.updateOrganisationandWorkspaceNames(org);
        }
        if (this.service.getUserOrganisation(user.getUserId(), org.getOrganisationId()) == null) {
            this.addMemberships(user, org, isTeacher);
        }
        return map;
    }

    private void addMemberships(User user, Organisation org, Boolean isTeacher) {
        UserOrganisation uo = new UserOrganisation(user, org);
        this.service.save(uo);
        Integer[] roles = isTeacher != false ? new Integer[]{Role.ROLE_AUTHOR, Role.ROLE_MONITOR, Role.ROLE_LEARNER} : new Integer[]{Role.ROLE_LEARNER};
        for (Integer roleId : roles) {
            UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)this.service.findById(Role.class, roleId));
            this.service.save(uor);
            uo.addUserOrganisationRole(uor);
        }
        user.addUserOrganisation(uo);
        this.service.save(user);
    }

    public ExtUserUseridMap getExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername) throws UserInfoFetchException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServerOrgMap.sid", serverMap.getSid());
        properties.put("extUsername", extUsername);
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            return this.createExtUserUseridMap(serverMap, extUsername);
        }
        return (ExtUserUseridMap)list.get(0);
    }

    public ExtUserUseridMap getExistingExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername) throws UserInfoFetchException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServerOrgMap.sid", serverMap.getSid());
        properties.put("extUsername", extUsername);
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ExtUserUseridMap)list.get(0);
    }

    public ExtUserUseridMap getImplicitExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername, String password, String firstName, String lastName, String email) throws UserInfoFetchException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServerOrgMap.sid", serverMap.getSid());
        properties.put("extUsername", extUsername);
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            String[] defaultLangCountry = LanguageUtil.getDefaultLangCountry();
            String[] userData = new String[]{"", firstName, lastName, "", "", "", "", "", "", "", "", email, defaultLangCountry[1], defaultLangCountry[0]};
            return this.createExtUserUseridMap(serverMap, extUsername, password, userData, false);
        }
        return (ExtUserUseridMap)list.get(0);
    }

    public ExtUserUseridMap getImplicitExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername, String firstName, String lastName, String language, String country, String email) throws UserInfoFetchException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("extServerOrgMap.sid", serverMap.getSid());
        properties.put("extUsername", extUsername);
        List list = this.service.findByProperties(ExtUserUseridMap.class, properties);
        if (list == null || list.size() == 0) {
            return this.createImplicitExtUserUseridMap(serverMap, extUsername, firstName, lastName, language, country, email);
        }
        return (ExtUserUseridMap)list.get(0);
    }

    private ExtCourseClassMap createExtCourseClassMap(ExtServerOrgMap serverMap, User user, String extCourseId, String extCourseName, String countryIsoCode, String langIsoCode, String parentOrgId, Boolean isTeacher, Boolean prefix) {
        Organisation org = this.createOrganisation(serverMap, user, extCourseId, extCourseName, countryIsoCode, langIsoCode, parentOrgId, prefix);
        this.addMemberships(user, org, isTeacher);
        ExtCourseClassMap map = new ExtCourseClassMap();
        map.setCourseid(extCourseId);
        map.setExtServerOrgMap(serverMap);
        map.setOrganisation(org);
        this.service.save(map);
        return map;
    }

    private Organisation createOrganisation(ExtServerOrgMap serverMap, User user, String extCourseId, String extCourseName, String countryIsoCode, String langIsoCode, String parentOrgId, Boolean prefix) {
        Organisation org = new Organisation();
        org.setName(prefix != false ? this.buildName(serverMap.getPrefix(), extCourseName) : extCourseName);
        org.setDescription(extCourseId);
        org.setOrganisationState((OrganisationState)this.service.findById(OrganisationState.class, OrganisationState.ACTIVE));
        org.setLocale(LanguageUtil.getSupportedLocale(langIsoCode, countryIsoCode));
        Organisation parent = (Organisation)this.service.findById(Organisation.class, Integer.valueOf(parentOrgId));
        if (parent != null) {
            org.setParentOrganisation(parent);
            if (!parent.getOrganisationId().equals(this.service.getRootOrganisation().getOrganisationId())) {
                org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.CLASS_TYPE));
            } else {
                org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.COURSE_TYPE));
            }
        } else {
            org.setParentOrganisation(this.service.getRootOrganisation());
            org.setOrganisationType((OrganisationType)this.service.findById(OrganisationType.class, OrganisationType.COURSE_TYPE));
        }
        return this.service.saveOrganisation(org, user.getUserId());
    }

    private ExtUserUseridMap createExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername, String password, String[] userData, boolean prefix) throws UserInfoFetchException {
        User user = new User();
        user.setLogin(prefix ? this.buildName(serverMap.getPrefix(), extUsername) : extUsername);
        user.setPassword(password);
        user.setTitle(userData[0]);
        user.setFirstName(userData[1]);
        user.setLastName(userData[2]);
        user.setAddressLine1(userData[3]);
        user.setCity(userData[4]);
        user.setState(userData[5]);
        user.setPostcode(userData[6]);
        user.setCountry(userData[7]);
        user.setDayPhone(userData[8]);
        user.setMobilePhone(userData[9]);
        user.setFax(userData[10]);
        user.setEmail(userData[11]);
        user.setAuthenticationMethod((AuthenticationMethod)this.service.findById(AuthenticationMethod.class, AuthenticationMethod.DB));
        user.setCreateDate(new Date());
        user.setDisabledFlag(false);
        user.setLocale(LanguageUtil.getSupportedLocale(userData[13], userData[12]));
        user.setFlashTheme(this.service.getDefaultFlashTheme());
        user.setHtmlTheme(this.service.getDefaultHtmlTheme());
        this.service.save(user);
        ExtUserUseridMap map = new ExtUserUseridMap();
        map.setExtServerOrgMap(serverMap);
        map.setExtUsername(extUsername);
        map.setUser(user);
        this.service.save(map);
        return map;
    }

    private ExtUserUseridMap createExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername) throws UserInfoFetchException {
        String[] userData = this.getUserDataFromExtServer(serverMap, extUsername);
        String password = HashUtil.sha1(RandomPasswordGenerator.nextPassword(10));
        return this.createExtUserUseridMap(serverMap, extUsername, password, userData, true);
    }

    public ExtUserUseridMap createImplicitExtUserUseridMap(ExtServerOrgMap serverMap, String extUsername, String firstName, String lastName, String language, String country, String email) throws UserInfoFetchException {
        String[] userData = new String[]{"", firstName, lastName, "", "", "", "", "", "", "", "", email, country, language};
        String password = HashUtil.sha1(RandomPasswordGenerator.nextPassword(10));
        return this.createExtUserUseridMap(serverMap, extUsername, password, userData, true);
    }

    private String[] getUserDataFromExtServer(ExtServerOrgMap serverMap, String extUsername) throws UserInfoFetchException {
        try {
            String userDataCallbackUrl = serverMap.getUserinfoUrl();
            String timestamp = Long.toString(new Date().getTime());
            String hash = this.hash(serverMap, extUsername, timestamp);
            String encodedExtUsername = URLEncoder.encode(extUsername, "UTF8");
            userDataCallbackUrl = userDataCallbackUrl.replaceAll("%username%", encodedExtUsername).replaceAll("%timestamp%", timestamp).replaceAll("%hash%", hash);
            log.debug((Object)userDataCallbackUrl);
            URL url = new URL(userDataCallbackUrl);
            URLConnection conn = url.openConnection();
            if (!(conn instanceof HttpURLConnection)) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + serverMap.getServerid() + "- Invalid connection type");
            }
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            if (httpConn.getResponseCode() != 200) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + serverMap.getServerid() + " - Unexpected return HTTP Status:" + httpConn.getResponseCode());
            }
            InputStream is = url.openConnection().getInputStream();
            BufferedReader isReader = new BufferedReader(new InputStreamReader(is));
            String str = isReader.readLine();
            if (str == null) {
                throw new UserInfoFetchException("Fail to fetch user data from external server:" + serverMap.getServerid() + " - No data returned from external server");
            }
            return CSVUtil.parse(str);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
        catch (ParseException e) {
            log.error((Object)e);
            throw new UserInfoFetchException(e);
        }
    }

    public String hash(ExtServerOrgMap serverMap, String extUsername, String timestamp) {
        String serverId = serverMap.getServerid();
        String serverKey = serverMap.getServerkey();
        String plaintext = timestamp.trim().toLowerCase() + extUsername.trim().toLowerCase() + serverId.trim().toLowerCase() + serverKey.trim().toLowerCase();
        return HashUtil.sha1(plaintext);
    }

    private String buildName(String prefix, String name) {
        return prefix + '_' + name;
    }

    public List getAllExtServerOrgMaps() {
        return this.service.findAll(ExtServerOrgMap.class);
    }

    public void saveExtServerOrgMap(ExtServerOrgMap map) {
        this.service.save(map);
    }

    public ExtServerOrgMap getExtServerOrgMap(Integer sid) {
        return (ExtServerOrgMap)this.service.findById(ExtServerOrgMap.class, sid);
    }
}

