/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.dao.IBranchActivityEntryDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchActivityEntryDAO
extends BaseDAO
implements IBranchActivityEntryDAO {
    private static final String ENTRIES_FOR_LEARNING_DESIGN = "select entry from " + BranchActivityEntry.class.getName() + " entry, " + Activity.class.getName() + " branchingActivity " + " where branchingActivity.learningDesign.id = ? " + " and entry.branchingActivity = branchingActivity";
    private static final String CONDITION_BY_ID = "FROM " + BranchCondition.class.getName() + " con WHERE con.conditionId = ?";

    @Override
    public List<BranchActivityEntry> getEntriesByLearningDesign(Long learningDesignId) {
        return this.getHibernateTemplate().find(ENTRIES_FOR_LEARNING_DESIGN, (Object)learningDesignId);
    }

    @Override
    public BranchCondition getConditionByID(Long conditionID) {
        List result = this.getHibernateTemplate().find(CONDITION_BY_ID, (Object)conditionID);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (BranchCondition)result.get(0);
    }
}

