/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import java.util.ArrayList;
import java.util.List;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.strategy.SimpleActivityStrategy;
import org.lamsfoundation.lams.usermanagement.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GateActivityStrategy
extends SimpleActivityStrategy {
    protected GateActivity gateActivity = null;

    public GateActivityStrategy(GateActivity gateActivity) {
        this.gateActivity = gateActivity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldOpenGateFor(User learner, List lessonLearners) {
        this.gateActivity.addLeaner(learner, false);
        if (!this.gateActivity.getGateOpen().booleanValue()) {
            if (!this.isOpenConditionMet(lessonLearners)) return this.gateActivity.getAllowedToPassLearners().contains(learner);
            this.gateActivity.setGateOpen(new Boolean(true));
            this.gateActivity.getAllGateUsers().clear();
            this.gateActivity.getWaitingLearners().clear();
            this.gateActivity.getAllowedToPassLearners().clear();
            return this.gateActivity.getGateOpen();
        } else {
            this.gateActivity.getAllGateUsers().clear();
            this.gateActivity.getWaitingLearners().clear();
            this.gateActivity.getAllowedToPassLearners().clear();
        }
        return this.gateActivity.getGateOpen();
    }

    protected abstract boolean isOpenConditionMet(List var1);

    @Override
    protected abstract void setUpContributionType(ArrayList<Integer> var1);

    @Override
    protected Activity getActivity() {
        return this.gateActivity;
    }
}

