/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.notebook.service;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.notebook.dao.INotebookEntryDAO;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.notebook.service.IExtendedCoreNotebookService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreNotebookService
implements ICoreNotebookService,
IExtendedCoreNotebookService {
    private static Logger log = Logger.getLogger(CoreNotebookService.class);
    private INotebookEntryDAO notebookEntryDAO;
    protected IUserManagementService userManagementService;
    protected MessageService messageService;

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String title, String entry) {
        User user = (User)this.getUserManagementService().findById(User.class, userID);
        NotebookEntry notebookEntry = new NotebookEntry(id, idType, signature, user, title, entry, new Date());
        this.saveOrUpdateNotebookEntry(notebookEntry);
        return notebookEntry.getUid();
    }

    @Override
    public List<NotebookEntry> getEntry(Long id, Integer idType, String signature, Integer userID) {
        return this.notebookEntryDAO.get(id, idType, signature, userID);
    }

    @Override
    public List<NotebookEntry> getEntry(Long id, Integer idType, String signature) {
        return this.notebookEntryDAO.get(id, idType, signature);
    }

    @Override
    public List<NotebookEntry> getEntry(Long id, Integer idType, Integer userID) {
        return this.notebookEntryDAO.get(id, idType, userID);
    }

    @Override
    public List<NotebookEntry> getEntry(Integer userID) {
        return this.notebookEntryDAO.get(userID);
    }

    @Override
    public List<NotebookEntry> getEntry(Integer userID, Integer idType) {
        return this.notebookEntryDAO.get(userID, idType);
    }

    @Override
    public List<NotebookEntry> getEntry(Integer userID, Long lessonID) {
        return this.notebookEntryDAO.get(userID, lessonID);
    }

    @Override
    public NotebookEntry getEntry(Long uid) {
        return this.notebookEntryDAO.get(uid);
    }

    @Override
    public void updateEntry(Long uid, String title, String entry) {
        NotebookEntry ne = this.getEntry(uid);
        if (ne != null) {
            ne.setTitle(title);
            ne.setEntry(entry);
            ne.setLastModified(new Date());
            this.saveOrUpdateNotebookEntry(ne);
        } else {
            log.debug((Object)("updateEntry: uid " + uid + "does not exist"));
        }
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        notebookEntry.setLastModified(new Date());
        this.saveOrUpdateNotebookEntry(notebookEntry);
    }

    @Override
    public void saveOrUpdateNotebookEntry(NotebookEntry notebookEntry) {
        this.notebookEntryDAO.saveOrUpdate(notebookEntry);
    }

    public void setNotebookEntryDAO(INotebookEntryDAO notebookEntryDAO) {
        this.notebookEntryDAO = notebookEntryDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    @Override
    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }
}

