/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class XMPPUtil {
    private static final Logger logger = Logger.getLogger(XMPPUtil.class);

    public static String createId(UserDTO user) {
        block3: {
            try {
                XMPPConnection con = new XMPPConnection(Configuration.get(ConfigurationKeys.XMPP_DOMAIN));
                AccountManager manager = con.getAccountManager();
                if (manager.supportsAccountCreation()) {
                    manager.createAccount(user.getUserID().toString(), user.getUserID().toString());
                }
            }
            catch (XMPPException e) {
                if (e.getXMPPError().getCode() == 409) break block3;
                logger.error((Object)e);
                return null;
            }
        }
        return user.getUserID() + "@" + Configuration.get(ConfigurationKeys.XMPP_DOMAIN);
    }

    public static boolean createMultiUserChat(String room) {
        try {
            XMPPConnection.DEBUG_ENABLED = false;
            XMPPConnection con = new XMPPConnection(Configuration.get(ConfigurationKeys.XMPP_DOMAIN));
            con.login(Configuration.get(ConfigurationKeys.XMPP_ADMIN), Configuration.get(ConfigurationKeys.XMPP_PASSWORD));
            MultiUserChat muc = new MultiUserChat(con, room);
            muc.create("nick");
            Form form = muc.getConfigurationForm();
            Form submitForm = form.createAnswerForm();
            Iterator fields = form.getFields();
            while (fields.hasNext()) {
                FormField field = (FormField)fields.next();
                if ("hidden".equals(field.getType()) || field.getVariable() == null) continue;
                submitForm.setDefaultAnswer(field.getVariable());
            }
            submitForm.setAnswer("muc#roomconfig_persistentroom", true);
            muc.sendConfigurationForm(submitForm);
            con.close();
            return true;
        }
        catch (XMPPException e) {
            logger.error((Object)e);
            logger.error((Object)e.getXMPPError());
            return false;
        }
    }
}

