/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.dao.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.vote.dao.IVoteContentDAO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class VoteContentDAO
extends HibernateDaoSupport
implements IVoteContentDAO {
    private static final String FIND_VOTE_CONTENT = "from " + VoteContent.class.getName() + " as vote where content_id=?";
    private static final String LOAD_VOTE_BY_SESSION = "select vote from VoteContent vote left join fetch vote.voteSessions session where session.voteSessionId=:sessionId";

    @Override
    public VoteContent getVoteContentByUID(Long uid) {
        return (VoteContent)this.getHibernateTemplate().get(VoteContent.class, (Serializable)uid);
    }

    @Override
    public void saveOrUpdateVote(VoteContent vote) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().saveOrUpdate((Object)vote);
    }

    @Override
    public VoteContent getVoteContentByContentId(Long voteContentId) {
        String query = "from VoteContent as vote where vote.voteContentId = ?";
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(query).setLong(0, voteContentId.longValue()).list();
        if (list != null && list.size() > 0) {
            VoteContent vote = (VoteContent)list.get(0);
            return vote;
        }
        return null;
    }

    @Override
    public VoteContent getVoteContentBySession(final Long voteSessionId) {
        return (VoteContent)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(VoteContentDAO.LOAD_VOTE_BY_SESSION).setLong("sessionId", voteSessionId.longValue()).uniqueResult();
            }
        });
    }

    @Override
    public void saveVoteContent(VoteContent voteContent) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().saveOrUpdate((Object)voteContent);
    }

    @Override
    public void updateVoteContent(VoteContent voteContent) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)voteContent);
    }

    @Override
    public void removeVoteById(Long voteContentId) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (voteContentId != null && (list = this.getSession().createQuery(FIND_VOTE_CONTENT).setLong(0, voteContentId.longValue()).list()) != null && list.size() > 0) {
            VoteContent vote = (VoteContent)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)vote);
            templ.flush();
        }
    }

    @Override
    public void removeVoteSessions(VoteContent voteContent) {
        this.getHibernateTemplate().deleteAll((Collection)voteContent.getVoteSessions());
    }

    @Override
    public void addVoteSession(Long voteContentId, VoteSession voteSession) {
        VoteContent content = this.getVoteContentByContentId(voteContentId);
        voteSession.setVoteContent(content);
        content.getVoteSessions().add(voteSession);
        this.getHibernateTemplate().saveOrUpdate((Object)voteSession);
        this.getHibernateTemplate().saveOrUpdate((Object)content);
    }

    @Override
    public void removeQuestionsFromCache(VoteContent voteContent) {
        if (voteContent != null) {
            for (VoteQueContent question : voteContent.getVoteQueContents()) {
                this.getHibernateTemplate().evict((Object)question);
            }
        }
    }

    @Override
    public void removeVoteContentFromCache(VoteContent voteContent) {
        if (voteContent != null) {
            this.getHibernateTemplate().evict((Object)voteContent);
        }
    }

    @Override
    public void delete(Object object) {
        this.getHibernateTemplate().delete(object);
    }
}

