/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.vote.dao.IVoteQueContentDAO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class VoteQueContentDAO
extends HibernateDaoSupport
implements IVoteQueContentDAO {
    private static final String CLEAN_QUESTION_CONTENT_BY_CONTENT_ID_SIMPLE = "from voteQueContent in class VoteQueContent where voteQueContent.voteContentId=:voteContentId";
    private static final String LOAD_QUESTION_CONTENT_BY_CONTENT_ID = "from voteQueContent in class VoteQueContent where voteQueContent.voteContentId=:voteContentId";
    private static final String LOAD_QUESTION_CONTENT_BY_DISPLAY_ORDER = "from voteQueContent in class VoteQueContent where voteQueContent.displayOrder=:displayOrder and voteQueContent.voteContentId=:voteContentUid";
    private static final String SORT_QUESTION_CONTENT_BY_DISPLAY_ORDER = "from voteQueContent in class VoteQueContent where voteQueContent.voteContentId=:voteContentId order by voteQueContent.displayOrder";

    @Override
    public VoteQueContent getQuestionByUid(Long uid) {
        return (VoteQueContent)this.getHibernateTemplate().get(VoteQueContent.class, (Serializable)uid);
    }

    @Override
    public VoteQueContent getDefaultVoteContentFirstQuestion() {
        long voteContentId = 1L;
        List list = this.getSession().createQuery("from voteQueContent in class VoteQueContent where voteQueContent.voteContentId=:voteContentId").setLong("voteContentId", 1L).list();
        if (list != null && list.size() > 0) {
            VoteQueContent voteq = (VoteQueContent)list.get(0);
            return voteq;
        }
        return null;
    }

    @Override
    public VoteQueContent getQuestionByDisplayOrder(Long displayOrder, Long voteContentUid) {
        List list = this.getSession().createQuery(LOAD_QUESTION_CONTENT_BY_DISPLAY_ORDER).setLong("displayOrder", displayOrder.longValue()).setLong("voteContentUid", voteContentUid.longValue()).list();
        if (list != null && list.size() > 0) {
            VoteQueContent voteq = (VoteQueContent)list.get(0);
            return voteq;
        }
        return null;
    }

    @Override
    public List getAllQuestionsSorted(long voteContentId) {
        List list = this.getSession().createQuery(SORT_QUESTION_CONTENT_BY_DISPLAY_ORDER).setLong("voteContentId", voteContentId).list();
        return list;
    }

    @Override
    public void saveOrUpdateQuestion(VoteQueContent voteQueContent) {
        this.getHibernateTemplate().saveOrUpdate((Object)voteQueContent);
    }

    @Override
    public void removeQuestion(VoteQueContent voteQueContent) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)voteQueContent);
    }
}

