/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.dao.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.vote.dao.IVoteSessionDAO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueUsr;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class VoteSessionDAO
extends HibernateDaoSupport
implements IVoteSessionDAO {
    private static final String FIND_VOTE_SESSION_CONTENT = "from " + VoteSession.class.getName() + " as votes where vote_session_id=?";
    private static final String LOAD_VOTESESSION_BY_USER = "select votes from VoteSession votes left join fetch votes.voteQueUsers user where user.queUsrId=:userId";
    private static final String GET_SESSIONS_FROM_CONTENT = "select votes.voteSessionId from VoteSession votes where votes.voteContent=:voteContent";
    private static final String COUNT_SESSION_COMPLETE = "from voteSession in class VoteSession where voteSession.sessionStatus='COMPLETE'";

    @Override
    public VoteSession getVoteSessionByUID(Long sessionUid) {
        return (VoteSession)this.getHibernateTemplate().get(VoteSession.class, (Serializable)sessionUid);
    }

    @Override
    public VoteSession getSessionBySessionId(Long voteSessionId) {
        String query = "from VoteSession votes where votes.voteSessionId=?";
        List list = this.getSession().createQuery(query).setLong(0, voteSessionId.longValue()).list();
        if (list != null && list.size() > 0) {
            VoteSession vote = (VoteSession)list.get(0);
            return vote;
        }
        return null;
    }

    @Override
    public int countSessionComplete() {
        List list = this.getSession().createQuery(COUNT_SESSION_COMPLETE).list();
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    @Override
    public void saveVoteSession(VoteSession voteSession) {
        this.getHibernateTemplate().save((Object)voteSession);
    }

    @Override
    public void updateVoteSession(VoteSession voteSession) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)voteSession);
    }

    @Override
    public void removeVoteSessionByUID(Long uid) {
        VoteSession votes = (VoteSession)this.getHibernateTemplate().get(VoteSession.class, (Serializable)uid);
        this.getHibernateTemplate().delete((Object)votes);
    }

    @Override
    public void removeVoteSessionById(Long voteSessionId) {
        List list;
        HibernateTemplate templ = this.getHibernateTemplate();
        if (voteSessionId != null && (list = this.getSession().createQuery(FIND_VOTE_SESSION_CONTENT).setLong(0, voteSessionId.longValue()).list()) != null && list.size() > 0) {
            VoteSession vote = (VoteSession)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            templ.delete((Object)vote);
            templ.flush();
        }
    }

    @Override
    public void removeVoteSession(VoteSession voteSession) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)voteSession);
    }

    @Override
    public VoteSession getVoteSessionByUser(final Long userId) {
        return (VoteSession)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(VoteSessionDAO.LOAD_VOTESESSION_BY_USER).setLong("userId", userId.longValue()).uniqueResult();
            }
        });
    }

    @Override
    public void removeVoteUsers(VoteSession voteSession) {
        this.getHibernateTemplate().deleteAll((Collection)voteSession.getVoteQueUsers());
    }

    @Override
    public void addVoteUsers(Long voteSessionId, VoteQueUsr user) {
        VoteSession session = this.getSessionBySessionId(voteSessionId);
        user.setVoteSession(session);
        session.getVoteQueUsers().add(user);
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        this.getHibernateTemplate().saveOrUpdate((Object)session);
    }

    @Override
    public List<Long> getSessionsFromContent(VoteContent voteContent) {
        return this.getHibernateTemplate().findByNamedParam(GET_SESSIONS_FROM_CONTENT, "voteContent", (Object)voteContent);
    }
}

