/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.dao.hibernate;

import java.util.List;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.vote.dao.IVoteUserDAO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueUsr;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class VoteUserDAO
extends HibernateDaoSupport
implements IVoteUserDAO {
    private static final String LOAD_USER_FOR_SESSION = "from voteQueUsr in class VoteQueUsr where  voteQueUsr.voteSessionId= :voteSessionId";

    @Override
    public VoteQueUsr getUserByUserId(Long userId) {
        String query = "from VoteQueUsr user where user.queUsrId=?";
        List list = this.getSession().createQuery(query).setLong(0, userId.longValue()).list();
        if (list != null && list.size() > 0) {
            VoteQueUsr voteu = (VoteQueUsr)list.get(0);
            return voteu;
        }
        return null;
    }

    @Override
    public int getCompletedVoteUserBySessionUid(Long voteSessionUid) {
        List list = this.getSession().createQuery(LOAD_USER_FOR_SESSION).setLong("voteSessionId", voteSessionUid.longValue()).list();
        int completedSessionUserCount = 0;
        if (list != null && list.size() > 0) {
            for (VoteQueUsr user : list) {
                if (!user.getVoteSession().getSessionStatus().equals("COMPLETED")) continue;
                ++completedSessionUserCount;
            }
        }
        return completedSessionUserCount;
    }

    @Override
    public VoteQueUsr getVoteUserBySession(Long queUsrId, Long voteSessionId) {
        String strGetUser = "from voteQueUsr in class VoteQueUsr where voteQueUsr.queUsrId=:queUsrId and voteQueUsr.voteSessionId=:voteSessionId";
        List list = this.getSession().createQuery(strGetUser).setLong("queUsrId", queUsrId.longValue()).setLong("voteSessionId", voteSessionId.longValue()).list();
        if (list != null && list.size() > 0) {
            VoteQueUsr usr = (VoteQueUsr)list.get(0);
            return usr;
        }
        return null;
    }

    @Override
    public VoteQueUsr getVoteQueUsrById(long voteQueUsrId) {
        String query = "from VoteQueUsr user where user.queUsrId=?";
        List list = this.getSession().createQuery(query).setLong(0, voteQueUsrId).list();
        if (list != null && list.size() > 0) {
            VoteQueUsr qu = (VoteQueUsr)list.get(0);
            return qu;
        }
        return null;
    }

    @Override
    public void saveVoteUser(VoteQueUsr voteUser) {
        this.getHibernateTemplate().save((Object)voteUser);
    }

    @Override
    public void updateVoteUser(VoteQueUsr voteUser) {
        this.getHibernateTemplate().update((Object)voteUser);
    }

    @Override
    public List<VoteQueUsr> getUserBySessionOnly(VoteSession voteSession) {
        List list = this.getSession().createQuery(LOAD_USER_FOR_SESSION).setLong("voteSessionId", voteSession.getUid().longValue()).list();
        return list;
    }

    @Override
    public void removeVoteUser(VoteQueUsr voteUser) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)voteUser);
    }

    @Override
    public int getTotalNumberOfUsers() {
        String query = "from obj in class VoteQueUsr";
        return this.getHibernateTemplate().find(query).size();
    }
}

