/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.dao.hibernate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.Type;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.vote.dao.IVoteUsrAttemptDAO;
import org.lamsfoundation.lams.tool.vote.dto.OpenTextAnswerDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteStatsDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteUsrAttempt;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class VoteUsrAttemptDAO
extends HibernateDaoSupport
implements IVoteUsrAttemptDAO {
    private static final String LOAD_ATTEMPT_FOR_USER = "from voteUsrAttempt in class VoteUsrAttempt where voteUsrAttempt.queUsrId=:queUsrId";
    private static final String LOAD_ATTEMPT_FOR_QUESTION_CONTENT_AND_SESSION = "from voteUsrAttempt in class VoteUsrAttempt where voteUsrAttempt.voteQueContent.uid=:voteQueContentId and voteUsrAttempt.voteQueUsr.voteSession.uid=:sessionUid";
    private static final String COUNT_ATTEMPT_FOR_QUESTION_CONTENT_AND_SESSION = "select count(*) from voteUsrAttempt in class VoteUsrAttempt where voteUsrAttempt.voteQueContent.uid=:voteQueContentId and voteUsrAttempt.voteQueUsr.voteSession.uid=:sessionUid";
    private static final String LOAD_ATTEMPT_FOR_USER_AND_QUESTION_CONTENT = "from voteUsrAttempt in class VoteUsrAttempt where voteUsrAttempt.queUsrId=:queUsrId and voteUsrAttempt.voteQueContent.uid=:voteQueContentId";
    private static final String LOAD_ATTEMPT_FOR_USER_AND_QUESTION_CONTENT_AND_SESSION = "from voteUsrAttempt in class VoteUsrAttempt where voteUsrAttempt.queUsrId=:queUsrId and voteUsrAttempt.voteQueContent.uid=:voteQueContentId and voteUsrAttempt.voteQueUsr.voteSession.uid=:sessionUid";
    private static final String LOAD_ATTEMPT_FOR_USER_AND_SESSION = "from voteUsrAttempt in class VoteUsrAttempt where voteUsrAttempt.queUsrId=:queUsrId and voteUsrAttempt.voteQueUsr.voteSession.uid=:sessionUid";
    private static final String LOAD_USER_ENTRIES = "select distinct voteUsrAttempt.userEntry from VoteUsrAttempt voteUsrAttempt where voteUsrAttempt.voteQueUsr.voteSession.voteContent.uid=:voteContentUid";
    private static final String LOAD_USER_ENTRY_RECORDS = "from voteUsrAttempt in class VoteUsrAttempt where voteUsrAttempt.userEntry=:userEntry and voteUsrAttempt.voteQueContent.uid=1 and voteUsrAttempt.voteQueUsr.voteSession.voteContent.uid=:voteContentUid";
    private static final String LOAD_OPEN_TEXT_ENTRIES_BY_SESSION_UID = "select att from VoteUsrAttempt att, VoteQueUsr user, VoteSession ses where att.voteQueUsr=user and user.voteSession=ses and ses.uid=:voteSessionUid and att.userEntry is not null and att.userEntry <> ''";
    private static final String COUNT_ENTRIES_BY_SESSION_ID = "select count(*) from VoteUsrAttempt att, VoteQueUsr user, VoteSession ses where att.voteQueUsr=user and user.voteSession=ses and ses.uid=:voteSessionUid";
    private static final String FIND_USER_ANSWERS_BY_QUESTION_UID = "SELECT user.username username, user.fullname fullname, attempt.attempt_time attemptTime FROM tl_lavote11_usr user  JOIN tl_lavote11_usr_attempt attempt on user.uid = attempt.que_usr_id AND attempt.vote_nomination_content_id = :questionUid ";
    private static final String FIND_USER_ANSWERS_BY_QUESTION_UID_SESSION_ADDITION = " AND user.vote_session_id = :sessionUid ";
    private static final String COUNT_USERS_BY_QUESTION_UID = "SELECT count(*)  FROM tl_lavote11_usr user  JOIN tl_lavote11_usr_attempt attempt ON user.uid = attempt.que_usr_id AND attempt.vote_nomination_content_id = :questionUid ";
    private static final String COUNT_USERS_BY_QUESTION_UID_SESSION_ADDITION = " AND user.vote_session_id = :sessionUid ";
    private static final String COUNT_USERS_BY_SESSION_UID = "SELECT count(*)  FROM tl_lavote11_usr user WHERE user.vote_session_id = :sessionUid ";
    private static final String FIND_USER_OPEN_TEXT = "SELECT user.uid userUid, user.username login, user.fullname fullName,  attempt.uid userEntryUid, attempt.userEntry userEntry, attempt.attempt_time attemptTime, attempt.visible visible  FROM tl_lavote11_usr user  JOIN tl_lavote11_usr_attempt attempt ON user.uid = attempt.que_usr_id AND attempt.vote_nomination_content_id = 1 ";
    private static final String FIND_USER_OPEN_TEXT_SESSION_UID_ADD = "AND user.vote_session_id=:sessionUid";
    private static final String FIND_USER_OPEN_TEXT_CONTENT_UID_ADD = "JOIN tl_lavote11_session session ON user.vote_session_id = session.uid  JOIN tl_lavote11_content content ON session.vote_content_id = content.uid and content.content_id = :toolContentId";
    private static final String COUNT_USERS_OPEN_TEXT_BY_SESSION_UID = "SELECT count(*)  FROM tl_lavote11_usr user  JOIN tl_lavote11_usr_attempt attempt ON user.uid = attempt.que_usr_id AND attempt.vote_nomination_content_id = 1 ";
    private static final String GET_STATISTICS = "SELECT session.session_name sessionName, session.uid sessionUid, SUM(user.responseFinalised) countUsersComplete  FROM tl_lavote11_usr user  JOIN tl_lavote11_session session ON user.vote_session_id = session.uid  JOIN tl_lavote11_content content ON session.vote_content_id = content.uid and content.content_id = :contentId  GROUP BY sessionUid  ORDER BY sessionUid";

    @Override
    public VoteUsrAttempt getAttemptByUID(Long uid) {
        String query = "from VoteUsrAttempt attempt where attempt.uid=?";
        List list = this.getSession().createQuery(query).setLong(0, uid.longValue()).list();
        if (list != null && list.size() > 0) {
            VoteUsrAttempt attempt = (VoteUsrAttempt)list.get(0);
            return attempt;
        }
        return null;
    }

    @Override
    public void saveVoteUsrAttempt(VoteUsrAttempt voteUsrAttempt) {
        this.getHibernateTemplate().save((Object)voteUsrAttempt);
    }

    @Override
    public List<VoteUsrAttempt> getAttemptsForUser(Long queUsrId) {
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_USER).setLong("queUsrId", queUsrId.longValue()).list();
        return list;
    }

    @Override
    public Set<String> getUserEntries(Long voteContentUid) {
        List list = this.getSession().createQuery(LOAD_USER_ENTRIES).setLong("voteContentUid", voteContentUid.longValue()).list();
        HashSet<String> userEntries = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (String entry : list) {
                if (entry == null || entry.length() <= 0) continue;
                userEntries.add(entry);
            }
        }
        return userEntries;
    }

    @Override
    public List<VoteUsrAttempt> getUserAttempts(Long voteContentUid, String userEntry) {
        List list = this.getSession().createQuery(LOAD_USER_ENTRY_RECORDS).setLong("voteContentUid", voteContentUid.longValue()).setString("userEntry", userEntry).list();
        return list;
    }

    @Override
    public List<VoteUsrAttempt> getSessionOpenTextUserEntries(Long voteSessionUid) {
        return this.getSession().createQuery(LOAD_OPEN_TEXT_ENTRIES_BY_SESSION_UID).setLong("voteSessionUid", voteSessionUid.longValue()).list();
    }

    @Override
    public void removeAttemptsForUserandSession(Long queUsrId, Long sessionUid) {
        String strGetUser = LOAD_ATTEMPT_FOR_USER_AND_SESSION;
        HibernateTemplate templ = this.getHibernateTemplate();
        List list = this.getSession().createQuery(strGetUser).setLong("queUsrId", queUsrId.longValue()).setLong("sessionUid", sessionUid.longValue()).list();
        if (list != null && list.size() > 0) {
            for (VoteUsrAttempt attempt : list) {
                this.getSession().setFlushMode(FlushMode.AUTO);
                templ.delete((Object)attempt);
                templ.flush();
            }
        }
    }

    @Override
    public int getStandardAttemptsForQuestionContentAndSessionUid(Long questionUid, Long sessionUid) {
        List list = this.getSession().createQuery(COUNT_ATTEMPT_FOR_QUESTION_CONTENT_AND_SESSION).setLong("voteQueContentId", questionUid.longValue()).setLong("sessionUid", sessionUid.longValue()).list();
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public List<VoteUsrAttempt> getAttemptsForQuestionContentAndSessionUid(Long questionUid, Long sessionUid) {
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_QUESTION_CONTENT_AND_SESSION).setLong("voteQueContentId", questionUid.longValue()).setLong("sessionUid", sessionUid.longValue()).list();
        ArrayList<VoteUsrAttempt> userEntries = new ArrayList<VoteUsrAttempt>();
        if (list != null && list.size() > 0) {
            userEntries.addAll(list);
        }
        return userEntries;
    }

    @Override
    public List<VoteUsrAttempt> getAttemptsForUserAndQuestionContent(Long queUsrId, Long questionUid) {
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_USER_AND_QUESTION_CONTENT).setLong("queUsrId", queUsrId.longValue()).setLong("voteQueContentId", questionUid.longValue()).list();
        return list;
    }

    @Override
    public VoteUsrAttempt getAttemptForUserAndQuestionContentAndSession(Long queUsrId, Long questionUid, Long sessionUid) {
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_USER_AND_QUESTION_CONTENT_AND_SESSION).setLong("queUsrId", queUsrId.longValue()).setLong("voteQueContentId", questionUid.longValue()).setLong("sessionUid", sessionUid.longValue()).list();
        if (list == null || list.size() == 0) {
            return null;
        }
        return (VoteUsrAttempt)list.get(0);
    }

    @Override
    public Set<String> getAttemptsForUserAndSession(Long queUsrId, Long sessionUid) {
        List list = this.getSession().createQuery(LOAD_ATTEMPT_FOR_USER_AND_SESSION).setLong("queUsrId", queUsrId.longValue()).setLong("sessionUid", sessionUid.longValue()).list();
        HashSet<String> userEntries = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (VoteUsrAttempt attempt : list) {
                Long questionUid = attempt.getVoteQueContent().getUid();
                if (questionUid.toString().equals("1")) continue;
                userEntries.add(attempt.getVoteQueContent().getQuestion());
            }
        }
        return userEntries;
    }

    @Override
    public List<VoteUsrAttempt> getAttemptsForUserAndSessionUseOpenAnswer(Long queUsrId, Long sessionUid) {
        return this.getSession().createQuery(LOAD_ATTEMPT_FOR_USER_AND_SESSION).setLong("queUsrId", queUsrId.longValue()).setLong("sessionUid", sessionUid.longValue()).list();
    }

    @Override
    public int getSessionEntriesCount(Long voteSessionUid) {
        List result = this.getSession().createQuery(COUNT_ENTRIES_BY_SESSION_ID).setLong("voteSessionUid", voteSessionUid.longValue()).list();
        Long resultLong = result.get(0) != null ? (Long)result.get(0) : new Long(0L);
        return resultLong.intValue();
    }

    @Override
    public void updateVoteUsrAttempt(VoteUsrAttempt voteUsrAttempt) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().update((Object)voteUsrAttempt);
    }

    @Override
    public void removeVoteUsrAttempt(VoteUsrAttempt voteUsrAttempt) {
        this.getSession().setFlushMode(FlushMode.AUTO);
        this.getHibernateTemplate().delete((Object)voteUsrAttempt);
    }

    @Override
    public List<Object[]> getUserAttemptsForTablesorter(Long sessionUid, Long questionUid, int page, int size, int sorting, String searchString) {
        String sortingOrder;
        switch (sorting) {
            case 1: {
                sortingOrder = "user.fullname ASC";
                break;
            }
            case 2: {
                sortingOrder = "user.fullname DESC";
                break;
            }
            case 3: {
                sortingOrder = "attempt.attempt_time ASC";
                break;
            }
            case 4: {
                sortingOrder = "attempt.attempt_time DESC";
                break;
            }
            default: {
                sortingOrder = "user.uid";
            }
        }
        StringBuilder queryText = new StringBuilder(FIND_USER_ANSWERS_BY_QUESTION_UID);
        if (sessionUid != null) {
            queryText.append(" AND user.vote_session_id = :sessionUid ");
        }
        this.buildNameSearch(searchString, queryText, true);
        queryText.append(" ORDER BY " + sortingOrder);
        SQLQuery query = this.getSession().createSQLQuery(queryText.toString());
        query.addScalar("username", (Type)Hibernate.STRING).addScalar("fullname", (Type)Hibernate.STRING).addScalar("attemptTime", (Type)Hibernate.TIMESTAMP).setLong("questionUid", questionUid.longValue()).setFirstResult(page * size).setMaxResults(size);
        if (sessionUid != null) {
            query.setLong("sessionUid", sessionUid.longValue());
        }
        return query.list();
    }

    private void buildNameSearch(String searchString, StringBuilder sqlBuilder, boolean useWhere) {
        if (!StringUtils.isBlank((String)searchString)) {
            String[] tokens;
            for (String token : tokens = searchString.trim().split("\\s+")) {
                String escToken = StringEscapeUtils.escapeSql((String)token);
                sqlBuilder.append(useWhere ? " WHERE " : " AND ").append("(user.fullname LIKE '%").append(escToken).append("%' OR user.username LIKE '%").append(escToken).append("%') ");
            }
        }
    }

    @Override
    public int getCountUsersBySession(Long sessionUid, Long questionUid, String searchString) {
        SQLQuery query;
        StringBuilder queryText;
        if (questionUid == null) {
            queryText = new StringBuilder(COUNT_USERS_BY_SESSION_UID);
            this.buildNameSearch(searchString, queryText, false);
            query = this.getSession().createSQLQuery(queryText.toString());
            query.setLong("sessionUid", sessionUid.longValue());
        } else {
            queryText = new StringBuilder(COUNT_USERS_BY_QUESTION_UID);
            if (sessionUid != null) {
                queryText.append(" AND user.vote_session_id = :sessionUid ");
            }
            this.buildNameSearch(searchString, queryText, true);
            query = this.getSession().createSQLQuery(queryText.toString());
            query.setLong("questionUid", questionUid.longValue());
            if (sessionUid != null) {
                query.setLong("sessionUid", sessionUid.longValue());
            }
        }
        List list = query.list();
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public List<Object[]> getUserReflectionsForTablesorter(Long sessionUid, int page, int size, int sorting, String searchString, ICoreNotebookService coreNotebookService) {
        String sortingOrder;
        switch (sorting) {
            case 1: {
                sortingOrder = "user.fullname ASC";
                break;
            }
            case 2: {
                sortingOrder = "user.fullname DESC";
                break;
            }
            default: {
                sortingOrder = "user.uid";
            }
        }
        String[] notebookEntryStrings = coreNotebookService.getNotebookEntrySQLStrings("session.vote_session_id", "lavote11", "user.user_id");
        StringBuilder queryText = new StringBuilder();
        queryText.append("SELECT user.username username, user.fullname fullname ");
        queryText.append(notebookEntryStrings[0]);
        queryText.append(" FROM tl_lavote11_usr user ");
        queryText.append(" JOIN tl_lavote11_session session ON user.vote_session_id = :sessionUid AND user.vote_session_id = session.uid ");
        queryText.append(notebookEntryStrings[1]);
        this.buildNameSearch(searchString, queryText, true);
        queryText.append(" ORDER BY " + sortingOrder);
        SQLQuery query = this.getSession().createSQLQuery(queryText.toString());
        query.addScalar("username", (Type)Hibernate.STRING).addScalar("fullname", (Type)Hibernate.STRING).addScalar("notebookEntry", (Type)Hibernate.STRING).setLong("sessionUid", sessionUid.longValue()).setFirstResult(page * size).setMaxResults(size);
        return query.list();
    }

    @Override
    public List<OpenTextAnswerDTO> getUserOpenTextAttemptsForTablesorter(Long sessionUid, Long toolContentId, int page, int size, int sorting, String searchStringVote, String searchStringUsername) {
        String sortingOrder;
        switch (sorting) {
            case 1: {
                sortingOrder = "user.fullname ASC";
                break;
            }
            case 2: {
                sortingOrder = "user.fullname DESC";
                break;
            }
            case 3: {
                sortingOrder = "attempt.attempt_time ASC";
                break;
            }
            case 4: {
                sortingOrder = "attempt.attempt_time DESC";
                break;
            }
            case 5: {
                sortingOrder = "attempt.userEntry ASC";
                break;
            }
            case 6: {
                sortingOrder = "attempt.userEntry DESC";
                break;
            }
            case 7: {
                sortingOrder = "attempt.visible ASC";
                break;
            }
            case 8: {
                sortingOrder = "attempt.visible DESC";
                break;
            }
            default: {
                sortingOrder = "user.uid";
            }
        }
        StringBuilder queryText = new StringBuilder(FIND_USER_OPEN_TEXT);
        if (sessionUid != null) {
            queryText.append(FIND_USER_OPEN_TEXT_SESSION_UID_ADD);
        } else {
            queryText.append(FIND_USER_OPEN_TEXT_CONTENT_UID_ADD);
        }
        this.buildCombinedSearch(searchStringVote, searchStringUsername, queryText);
        queryText.append(" ORDER BY " + sortingOrder);
        SQLQuery query = this.getSession().createSQLQuery(queryText.toString());
        query.addScalar("userUid", (Type)Hibernate.LONG).addScalar("login", (Type)Hibernate.STRING).addScalar("fullName", (Type)Hibernate.STRING).addScalar("userEntryUid", (Type)Hibernate.LONG).addScalar("userEntry", (Type)Hibernate.STRING).addScalar("attemptTime", (Type)Hibernate.TIMESTAMP).addScalar("visible", (Type)Hibernate.BOOLEAN).setFirstResult(page * size).setMaxResults(size).setResultTransformer(Transformers.aliasToBean(OpenTextAnswerDTO.class));
        if (sessionUid != null) {
            query.setLong("sessionUid", sessionUid.longValue());
        } else {
            query.setLong("toolContentId", toolContentId.longValue());
        }
        return query.list();
    }

    private void buildCombinedSearch(String searchStringVote, String searchStringUsername, StringBuilder sqlBuilder) {
        if (!StringUtils.isBlank((String)searchStringVote)) {
            String[] tokens;
            for (String token : tokens = searchStringVote.trim().split("\\s+")) {
                String escToken = StringEscapeUtils.escapeSql((String)token);
                sqlBuilder.append(" WHERE (userEntry LIKE '%").append(escToken).append("%') ");
            }
        } else {
            this.buildNameSearch(searchStringUsername, sqlBuilder, true);
        }
    }

    @Override
    public int getCountUsersForOpenTextEntries(Long sessionUid, Long toolContentId, String searchStringVote, String searchStringUsername) {
        SQLQuery query;
        StringBuilder queryText = new StringBuilder(COUNT_USERS_OPEN_TEXT_BY_SESSION_UID);
        if (sessionUid != null) {
            queryText.append(FIND_USER_OPEN_TEXT_SESSION_UID_ADD);
            this.buildCombinedSearch(searchStringVote, searchStringUsername, queryText);
            query = this.getSession().createSQLQuery(queryText.toString());
            query.setLong("sessionUid", sessionUid.longValue());
        } else {
            queryText.append(FIND_USER_OPEN_TEXT_CONTENT_UID_ADD);
            this.buildCombinedSearch(searchStringVote, searchStringUsername, queryText);
            query = this.getSession().createSQLQuery(queryText.toString());
            query.setLong("toolContentId", toolContentId.longValue());
        }
        List list = query.list();
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public List<VoteStatsDTO> getStatisticsBySession(Long toolContentId) {
        SQLQuery query = this.getSession().createSQLQuery(GET_STATISTICS);
        query.addScalar("sessionUid", (Type)Hibernate.LONG).addScalar("sessionName", (Type)Hibernate.STRING).addScalar("countUsersComplete", (Type)Hibernate.INTEGER).setLong("contentId", toolContentId.longValue()).setResultTransformer(Transformers.aliasToBean(VoteStatsDTO.class));
        return query.list();
    }
}

