/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.tool.OutputFactory;
import org.lamsfoundation.lams.tool.OutputType;
import org.lamsfoundation.lams.tool.SimpleURL;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueUsr;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.lamsfoundation.lams.tool.vote.pojos.VoteUsrAttempt;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;

public class VoteOutputFactory
extends OutputFactory {
    protected static final String OUTPUT_NAME_NOMINATION_SELECTION = "learner.selection";
    protected static final int FREE_TEXT_NOM_SELECTION = 0;
    protected static final String FREE_TEXT_NOM_SELECTION_STR = "0";

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Object toolContentObject, int definitionType) {
        TreeMap<String, ToolOutputDefinition> definitionMap = new TreeMap<String, ToolOutputDefinition>();
        if (toolContentObject != null) {
            VoteContent content = (VoteContent)toolContentObject;
            if (content.getMaxNominationCount() != null && !content.getMaxNominationCount().equals("1")) {
                this.log.error((Object)("Unable to build output definitions for Voting if the user can have more than one nomination. Vote " + content));
            } else {
                ToolOutputDefinition definition = this.buildBooleanSetOutputDefinition(OUTPUT_NAME_NOMINATION_SELECTION);
                if (definition.getDefaultConditions() == null) {
                    definition.setDefaultConditions(new ArrayList());
                }
                List defaultConditions = definition.getDefaultConditions();
                String trueString = Boolean.TRUE.toString();
                int conditionOrderId = 1;
                if (content.isAllowText()) {
                    defaultConditions.add(new BranchCondition(null, null, new Integer(conditionOrderId++), this.buildConditionName(OUTPUT_NAME_NOMINATION_SELECTION, FREE_TEXT_NOM_SELECTION_STR), this.getI18NText("label.open.vote", false), OutputType.OUTPUT_BOOLEAN.toString(), null, null, trueString));
                }
                for (VoteQueContent nomination : content.getVoteQueContents()) {
                    int displayOrder = nomination.getDisplayOrder();
                    String name = this.buildConditionName(OUTPUT_NAME_NOMINATION_SELECTION, new Integer(displayOrder).toString());
                    defaultConditions.add(new BranchCondition(null, null, new Integer(conditionOrderId++), name, VoteUtils.stripHTML(nomination.getQuestion()), OutputType.OUTPUT_BOOLEAN.toString(), null, null, trueString));
                }
                definition.setShowConditionNameOnly(Boolean.TRUE);
                definitionMap.put(OUTPUT_NAME_NOMINATION_SELECTION, definition);
            }
        } else {
            this.log.error((Object)"Unable to build output definitions for Vote as no tool content object supplied.");
        }
        return definitionMap;
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, IVoteService voteService, Long toolSessionId, Long learnerId) {
        TreeMap<String, ToolOutput> output = null;
        if (names == null) {
            output = this.createAllDisplayOrderOutputs(voteService, toolSessionId, learnerId);
        } else {
            output = new TreeMap();
            for (String name : names) {
                ToolOutput newOutput = this.getToolOutput(name, voteService, toolSessionId, learnerId);
                if (newOutput == null) continue;
                output.put(name, newOutput);
            }
        }
        return output;
    }

    public ToolOutput getToolOutput(String name, IVoteService voteService, Long toolSessionId, Long learnerId) {
        if (name != null && name.startsWith(OUTPUT_NAME_NOMINATION_SELECTION)) {
            VoteSession session = voteService.getSessionBySessionId(toolSessionId);
            VoteQueUsr queUser = voteService.getVoteUserBySession(learnerId, session.getUid());
            return new ToolOutput(name, this.getI18NText(OUTPUT_NAME_NOMINATION_SELECTION, true), Boolean.valueOf(this.checkDisplayOrderOfVoteQueContent(name, queUser)));
        }
        return null;
    }

    private boolean checkDisplayOrderOfVoteQueContent(String name, VoteQueUsr queUser) {
        Set voteAttempts;
        String[] dcNames = this.splitConditionName(name);
        if (dcNames[1] == null || dcNames[1].length() == 0) {
            this.log.error((Object)("Unable to convert the display order to an int for tool output learner.selection. Returning false. Name doesn't contain the display order. Condition name was: " + name));
            return false;
        }
        int displayOrder = 0;
        try {
            displayOrder = new Integer(dcNames[1]);
        }
        catch (NumberFormatException e) {
            this.log.error((Object)("Unable to convert the display order to an int for tool output learner.selection. Returning false. Number format exception thrown. Condition name was: " + name), (Throwable)e);
            return false;
        }
        if (queUser != null && (voteAttempts = queUser.getVoteUsrAttempts()).size() > 0) {
            if (voteAttempts.size() > 1) {
                this.log.error((Object)("Attempting to match on nomination, but more than one nomination selected for this user. Will try to match on the given display order. User " + queUser));
            }
            for (VoteUsrAttempt attempt : voteAttempts) {
                Long questionUid = attempt.getVoteQueContent().getUid();
                if (questionUid == 1L && displayOrder == 0) {
                    return true;
                }
                VoteQueContent nomination = attempt.getVoteQueContent();
                if (nomination.getDisplayOrder() != displayOrder) continue;
                return true;
            }
        }
        return false;
    }

    private TreeMap<String, ToolOutput> createAllDisplayOrderOutputs(IVoteService voteService, Long toolSessionId, Long learnerId) {
        TreeMap output = null;
        VoteSession session = voteService.getSessionBySessionId(toolSessionId);
        VoteContent content = session.getVoteContent();
        VoteQueUsr queUser = voteService.getVoteUserBySession(learnerId, session.getUid());
        String i18nDescription = this.getI18NText(OUTPUT_NAME_NOMINATION_SELECTION, true);
        if (content.isAllowText()) {
            boolean found = false;
            if (queUser != null) {
                Set voteAttempts = queUser.getVoteUsrAttempts();
                Iterator iter = voteAttempts.iterator();
                while (iter.hasNext() && !found) {
                    VoteUsrAttempt attempt = (VoteUsrAttempt)iter.next();
                    Long questionUid = attempt.getVoteQueContent().getUid();
                    found = questionUid == 1L;
                }
            }
            String name = this.buildConditionName(OUTPUT_NAME_NOMINATION_SELECTION, FREE_TEXT_NOM_SELECTION_STR);
            output.put(name, new ToolOutput(name, i18nDescription, Boolean.valueOf(found)));
        }
        for (VoteQueContent nomination : content.getVoteQueContents()) {
            int displayOrder = nomination.getDisplayOrder();
            String name = this.buildConditionName(OUTPUT_NAME_NOMINATION_SELECTION, new Integer(displayOrder).toString());
            boolean found = false;
            if (queUser != null) {
                Set voteAttempts = queUser.getVoteUsrAttempts();
                Iterator iter = voteAttempts.iterator();
                while (iter.hasNext() && !found) {
                    VoteUsrAttempt attempt = (VoteUsrAttempt)iter.next();
                    found = attempt.getVoteQueContent().getDisplayOrder() == displayOrder;
                }
            }
            output.put(name, new ToolOutput(name, i18nDescription, Boolean.valueOf(found)));
        }
        return output;
    }

    public Class[] getSupportedDefinitionClasses(int definitionType) {
        if (2 == definitionType) {
            Class<String[]> stringArrayClass = String[].class;
            Class<String[][]> arrayOfStringArrays = String[][].class;
            Class<String> stringClass = String.class;
            Class<SimpleURL[]> simpleUrlArrayClass = SimpleURL[].class;
            Class<SimpleURL[][]> arrayOfSimpleUrlArrayClass = SimpleURL[][].class;
            Class<SimpleURL> simpleUrlClass = SimpleURL.class;
            return new Class[]{stringArrayClass, arrayOfStringArrays, stringClass, simpleUrlArrayClass, arrayOfSimpleUrlArrayClass, simpleUrlClass};
        }
        return super.getSupportedDefinitionClasses(definitionType);
    }
}

