/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.DataFlowObject;
import org.lamsfoundation.lams.learningdesign.dao.IDataFlowDAO;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.rest.RestTags;
import org.lamsfoundation.lams.rest.ToolRestManager;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.SimpleURL;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dao.IVoteContentDAO;
import org.lamsfoundation.lams.tool.vote.dao.IVoteQueContentDAO;
import org.lamsfoundation.lams.tool.vote.dao.IVoteSessionDAO;
import org.lamsfoundation.lams.tool.vote.dao.IVoteUserDAO;
import org.lamsfoundation.lams.tool.vote.dao.IVoteUsrAttemptDAO;
import org.lamsfoundation.lams.tool.vote.dto.OpenTextAnswerDTO;
import org.lamsfoundation.lams.tool.vote.dto.ReflectionDTO;
import org.lamsfoundation.lams.tool.vote.dto.SessionDTO;
import org.lamsfoundation.lams.tool.vote.dto.SessionNominationDTO;
import org.lamsfoundation.lams.tool.vote.dto.SummarySessionDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteMonitoredAnswersDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteMonitoredUserDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteQuestionDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteStatsDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueUsr;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.lamsfoundation.lams.tool.vote.pojos.VoteUsrAttempt;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteApplicationException;
import org.lamsfoundation.lams.tool.vote.service.VoteImportContentVersionFilter;
import org.lamsfoundation.lams.tool.vote.service.VoteOutputFactory;
import org.lamsfoundation.lams.tool.vote.util.VoteComparator;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;
import org.lamsfoundation.lams.tool.vote.web.MonitoringUtil;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.dao.DataAccessException;

public class VoteServicePOJO
implements IVoteService,
ToolContentManager,
ToolSessionManager,
ToolContentImport102Manager,
VoteAppConstants,
ToolRestManager {
    private static Logger logger = Logger.getLogger((String)VoteServicePOJO.class.getName());
    private IVoteContentDAO voteContentDAO;
    private IVoteQueContentDAO voteQueContentDAO;
    private IVoteSessionDAO voteSessionDAO;
    private IVoteUserDAO voteUserDAO;
    private IVoteUsrAttemptDAO voteUsrAttemptDAO;
    private IUserManagementService userManagementService;
    private ILearnerService learnerService;
    private IAuditService auditService;
    private ILamsToolService toolService;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;
    private IToolContentHandler voteToolContentHandler = null;
    private VoteOutputFactory voteOutputFactory;
    private IDataFlowDAO dataFlowDAO;
    private MessageService messageService;

    @Override
    public boolean isUserGroupLeader(VoteQueUsr user, Long toolSessionId) {
        VoteSession session = this.getSessionBySessionId(toolSessionId);
        VoteQueUsr groupLeader = session.getGroupLeader();
        boolean isUserLeader = groupLeader != null && user.getUid().equals(groupLeader.getUid());
        return isUserLeader;
    }

    @Override
    public VoteQueUsr checkLeaderSelectToolForSessionLeader(VoteQueUsr user, Long toolSessionId) {
        Long leaderUserId;
        if (user == null || toolSessionId == null) {
            return null;
        }
        VoteSession session = this.getSessionBySessionId(toolSessionId);
        VoteQueUsr leader = session.getGroupLeader();
        if (leader == null && (leaderUserId = this.toolService.getLeaderUserId(toolSessionId, Integer.valueOf(user.getQueUsrId().intValue()))) != null) {
            leader = this.getVoteUserBySession(leaderUserId, session.getUid());
            if (leader == null) {
                logger.debug((Object)("creating new user with userId: " + leaderUserId));
                User leaderDto = (User)this.getUserManagementService().findById(User.class, (Serializable)Integer.valueOf(leaderUserId.intValue()));
                String userName = leaderDto.getLogin();
                String fullName = leaderDto.getFirstName() + " " + leaderDto.getLastName();
                leader = new VoteQueUsr(leaderUserId, userName, fullName, session, new TreeSet());
                this.voteUserDAO.saveVoteUser(user);
            }
            session.setGroupLeader(leader);
            this.voteSessionDAO.updateVoteSession(session);
        }
        return leader;
    }

    @Override
    public void copyAnswersFromLeader(VoteQueUsr user, VoteQueUsr leader) {
        if (user == null || leader == null || user.getUid().equals(leader.getUid())) {
            return;
        }
        List<VoteUsrAttempt> leaderAttempts = this.getAttemptsForUser(leader.getUid());
        List<VoteUsrAttempt> userAttempts = this.getAttemptsForUser(user.getUid());
        for (VoteUsrAttempt leaderAttempt : leaderAttempts) {
            VoteQueContent question = leaderAttempt.getVoteQueContent();
            Date attempTime = leaderAttempt.getAttemptTime();
            String timeZone = leaderAttempt.getTimeZone();
            String userEntry = leaderAttempt.getUserEntry();
            VoteUsrAttempt userAttempt = null;
            for (VoteUsrAttempt userAttemptDb : userAttempts) {
                if (!userAttemptDb.getUid().equals(leaderAttempt.getUid())) continue;
                userAttempt = userAttemptDb;
            }
            if (userAttempt == null) {
                VoteUsrAttempt voteUsrAttempt = new VoteUsrAttempt(attempTime, timeZone, question, user, userEntry, true);
                this.voteUsrAttemptDAO.saveVoteUsrAttempt(voteUsrAttempt);
                continue;
            }
            if (leaderAttempt.getAttemptTime().compareTo(userAttempt.getAttemptTime()) == 0) continue;
            userAttempt.setUserEntry(userEntry);
            userAttempt.setAttemptTime(attempTime);
            userAttempt.setTimeZone(timeZone);
            this.updateVoteUsrAttempt(userAttempt);
            userAttempts.remove(userAttempt);
        }
        for (VoteUsrAttempt redundantUserAttempt : userAttempts) {
            this.voteUsrAttemptDAO.removeVoteUsrAttempt(redundantUserAttempt);
        }
    }

    @Override
    public VoteGeneralLearnerFlowDTO prepareChartData(HttpServletRequest request, Long toolContentID, Long toolSessionUid, VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO) {
        VoteContent voteContent = this.getVoteContent(toolContentID);
        int entriesCount = 0;
        List<VoteUsrAttempt> userEntries = null;
        if (toolSessionUid != null) {
            entriesCount = this.voteUsrAttemptDAO.getSessionEntriesCount(toolSessionUid);
            userEntries = voteContent.isAllowText() ? this.voteUsrAttemptDAO.getSessionOpenTextUserEntries(toolSessionUid) : new ArrayList<VoteUsrAttempt>(0);
        }
        Long mapIndex = 1L;
        int totalStandardVotesCount = 0;
        TreeMap<Long, Long> mapStandardUserCount = new TreeMap<Long, Long>(new VoteComparator());
        TreeMap<Long, String> mapStandardNominationsHTMLedContent = new TreeMap<Long, String>(new VoteComparator());
        TreeMap<Long, Long> mapStandardQuestionUid = new TreeMap<Long, Long>(new VoteComparator());
        TreeMap<Long, Long> mapStandardToolSessionUid = new TreeMap<Long, Long>(new VoteComparator());
        TreeMap<Long, String> mapStandardNominationsContent = new TreeMap<Long, String>(new VoteComparator());
        TreeMap<Long, Double> mapVoteRates = new TreeMap<Long, Double>(new VoteComparator());
        for (VoteQueContent question : voteContent.getVoteQueContents()) {
            mapStandardNominationsHTMLedContent.put(mapIndex, question.getQuestion());
            String noHTMLNomination = VoteUtils.stripHTML(question.getQuestion());
            mapStandardNominationsContent.put(mapIndex, noHTMLNomination);
            int votesCount = this.voteUsrAttemptDAO.getStandardAttemptsForQuestionContentAndSessionUid(question.getUid(), toolSessionUid);
            totalStandardVotesCount += votesCount;
            mapStandardUserCount.put(mapIndex, new Long(votesCount));
            mapStandardQuestionUid.put(mapIndex, question.getUid());
            mapStandardToolSessionUid.put(mapIndex, toolSessionUid);
            Double voteRate = entriesCount != 0 ? (double)(votesCount * 100 / entriesCount) : 0.0;
            mapVoteRates.put(mapIndex, voteRate);
            mapIndex = new Long(mapIndex + 1L);
        }
        if (voteContent.isAllowText()) {
            int userEnteredVotesCount = entriesCount - totalStandardVotesCount;
            Double voteRate = userEnteredVotesCount != 0 ? (double)(userEnteredVotesCount * 100 / entriesCount) : 0.0;
            mapVoteRates.put(mapIndex, voteRate);
            mapStandardNominationsContent.put(mapIndex, this.messageService.getMessage("label.open.vote"));
            mapStandardNominationsHTMLedContent.put(mapIndex, this.messageService.getMessage("label.open.vote"));
            mapStandardUserCount.put(mapIndex, new Long(userEnteredVotesCount));
            mapStandardQuestionUid.put(mapIndex, 1L);
            mapStandardToolSessionUid.put(mapIndex, 1L);
        }
        voteGeneralLearnerFlowDTO.setMapStandardNominationsContent(mapStandardNominationsContent);
        voteGeneralLearnerFlowDTO.setMapStandardNominationsHTMLedContent(mapStandardNominationsHTMLedContent);
        voteGeneralLearnerFlowDTO.setMapStandardRatesContent(mapVoteRates);
        voteGeneralLearnerFlowDTO.setMapStandardUserCount(mapStandardUserCount);
        voteGeneralLearnerFlowDTO.setMapStandardToolSessionUid(mapStandardToolSessionUid);
        voteGeneralLearnerFlowDTO.setMapStandardQuestionUid(mapStandardQuestionUid);
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        request.setAttribute("listUserEntriesContent", userEntries);
        return voteGeneralLearnerFlowDTO;
    }

    @Override
    public LinkedList<SessionDTO> getSessionDTOs(Long toolContentID) {
        LinkedList<SessionDTO> sessionDTOs = new LinkedList<SessionDTO>();
        VoteContent voteContent = this.getVoteContent(toolContentID);
        for (VoteSession session : voteContent.getVoteSessions()) {
            SessionDTO sessionDTO = new SessionDTO();
            sessionDTO.setSessionId(session.getVoteSessionId().toString());
            sessionDTO.setSessionName(session.getSession_name());
            int entriesCount = this.voteUsrAttemptDAO.getSessionEntriesCount(session.getUid());
            Long mapIndex = 1L;
            int totalStandardVotesCount = 0;
            TreeMap mapVoteRates = new TreeMap(new VoteComparator());
            TreeMap<Long, Long> mapStandardUserCount = new TreeMap<Long, Long>(new VoteComparator());
            TreeMap<Long, String> mapStandardNominationsHTMLedContent = new TreeMap<Long, String>(new VoteComparator());
            TreeMap mapStandardQuestionUid = new TreeMap(new VoteComparator());
            TreeMap<Long, Long> mapStandardToolSessionUid = new TreeMap<Long, Long>(new VoteComparator());
            for (VoteQueContent question : voteContent.getVoteQueContents()) {
                mapStandardNominationsHTMLedContent.put(mapIndex, question.getQuestion());
                int votesCount = this.voteUsrAttemptDAO.getStandardAttemptsForQuestionContentAndSessionUid(question.getUid(), session.getUid());
                totalStandardVotesCount += votesCount;
                mapStandardUserCount.put(mapIndex, new Long(votesCount));
                mapStandardQuestionUid.put(mapIndex, question.getUid());
                mapStandardToolSessionUid.put(mapIndex, session.getUid());
                Double voteRate = entriesCount != 0 ? (double)(votesCount * 100 / entriesCount) : 0.0;
                mapVoteRates.put(mapIndex, voteRate);
                mapIndex = new Long(mapIndex + 1L);
            }
            if (voteContent.isAllowText()) {
                int userEnteredVotesCount = entriesCount - totalStandardVotesCount;
                Double voteRate = userEnteredVotesCount != 0 ? (double)(userEnteredVotesCount * 100 / entriesCount) : 0.0;
                mapVoteRates.put(mapIndex, voteRate);
                mapStandardNominationsHTMLedContent.put(mapIndex, this.messageService.getMessage("label.open.vote"));
                mapStandardUserCount.put(mapIndex, new Long(userEnteredVotesCount));
                mapStandardQuestionUid.put(mapIndex, 1L);
                mapStandardToolSessionUid.put(mapIndex, 1L);
            }
            sessionDTO.setMapStandardNominationsHTMLedContent(mapStandardNominationsHTMLedContent);
            sessionDTO.setMapStandardUserCount(mapStandardUserCount);
            sessionDTO.setMapStandardRatesContent(mapVoteRates);
            sessionDTO.setMapStandardQuestionUid(mapStandardQuestionUid);
            sessionDTO.setMapStandardToolSessionUid(mapStandardToolSessionUid);
            List<VoteMonitoredAnswersDTO> openVotes = this.getOpenVotes(voteContent.getUid(), session.getVoteSessionId(), null);
            sessionDTO.setOpenVotes(openVotes);
            boolean isExistsOpenVote = openVotes.size() > 0;
            sessionDTO.setExistsOpenVote(isExistsOpenVote);
            sessionDTOs.add(sessionDTO);
        }
        if (sessionDTOs.size() > 1) {
            SessionDTO totalSessionDTO = new SessionDTO();
            totalSessionDTO.setSessionId("0");
            totalSessionDTO.setSessionName(this.messageService.getMessage("label.all.groups.total"));
            ArrayList<VoteMonitoredAnswersDTO> totalOpenVotes = new ArrayList<VoteMonitoredAnswersDTO>();
            int totalPotentialUserCount = 0;
            int totalCompletedSessionUserCount = 0;
            int allSessionsVotesCount = 0;
            TreeMap<Long, Long> totalMapStandardUserCount = new TreeMap<Long, Long>(new VoteComparator());
            for (SessionDTO sessionDTO : sessionDTOs) {
                totalPotentialUserCount += sessionDTO.getSessionUserCount();
                totalCompletedSessionUserCount += sessionDTO.getCompletedSessionUserCount();
                Long mapIndex = 1L;
                for (VoteQueContent question : voteContent.getVoteQueContents()) {
                    Long votesCount = sessionDTO.getMapStandardUserCount().get(mapIndex);
                    Long oldTotalVotesCount = totalMapStandardUserCount.get(mapIndex) != null ? (Long)totalMapStandardUserCount.get(mapIndex) : 0L;
                    totalMapStandardUserCount.put(mapIndex, oldTotalVotesCount + votesCount);
                    allSessionsVotesCount = (int)((long)allSessionsVotesCount + votesCount);
                    mapIndex = new Long(mapIndex + 1L);
                }
                if (voteContent.isAllowText()) {
                    Long votesCount = sessionDTO.getMapStandardUserCount().get(mapIndex);
                    Long oldTotalVotesCount = totalMapStandardUserCount.get(mapIndex) != null ? (Long)totalMapStandardUserCount.get(mapIndex) : 0L;
                    totalMapStandardUserCount.put(mapIndex, oldTotalVotesCount + votesCount);
                    allSessionsVotesCount = (int)((long)allSessionsVotesCount + votesCount);
                }
                totalOpenVotes.addAll(sessionDTO.getOpenVotes());
            }
            totalSessionDTO.setSessionUserCount(totalPotentialUserCount);
            totalSessionDTO.setCompletedSessionUserCount(totalCompletedSessionUserCount);
            totalSessionDTO.setOpenVotes(totalOpenVotes);
            boolean isExistsOpenVote = totalOpenVotes.size() > 0;
            totalSessionDTO.setExistsOpenVote(isExistsOpenVote);
            totalSessionDTO.setMapStandardNominationsHTMLedContent(sessionDTOs.get(0).getMapStandardNominationsHTMLedContent());
            totalSessionDTO.setMapStandardQuestionUid(sessionDTOs.get(0).getMapStandardQuestionUid());
            totalSessionDTO.setMapStandardToolSessionUid(sessionDTOs.get(0).getMapStandardToolSessionUid());
            totalSessionDTO.setMapStandardUserCount(totalMapStandardUserCount);
            Long mapIndex = 1L;
            TreeMap<Long, Double> totalMapVoteRates = new TreeMap<Long, Double>(new VoteComparator());
            int totalStandardVotesCount = 0;
            for (VoteQueContent question : voteContent.getVoteQueContents()) {
                Long votesCount = (Long)totalMapStandardUserCount.get(mapIndex);
                double voteRate = allSessionsVotesCount != 0 ? (double)(votesCount * 100L / (long)allSessionsVotesCount) : 0.0;
                totalMapVoteRates.put(mapIndex, voteRate);
                totalStandardVotesCount = (int)((long)totalStandardVotesCount + votesCount);
                mapIndex = new Long(mapIndex + 1L);
            }
            if (voteContent.isAllowText()) {
                int userEnteredVotesCount = allSessionsVotesCount - totalStandardVotesCount;
                double voteRate = userEnteredVotesCount != 0 ? (double)(userEnteredVotesCount * 100 / allSessionsVotesCount) : 0.0;
                totalMapVoteRates.put(mapIndex, voteRate);
            }
            totalSessionDTO.setMapStandardRatesContent(totalMapVoteRates);
            sessionDTOs.addFirst(totalSessionDTO);
        }
        return sessionDTOs;
    }

    @Override
    public SortedSet<SummarySessionDTO> getMonitoringSessionDTOs(Long toolContentID) {
        TreeSet<SummarySessionDTO> sessionDTOs = new TreeSet<SummarySessionDTO>();
        VoteContent voteContent = this.getVoteContent(toolContentID);
        for (VoteSession session : voteContent.getVoteSessions()) {
            SummarySessionDTO sessionDTO = new SummarySessionDTO();
            sessionDTO.setSessionName(session.getSession_name());
            sessionDTO.setSessionUid(session.getUid());
            sessionDTO.setToolSessionId(session.getVoteSessionId());
            sessionDTO.setNominations(new TreeSet<SessionNominationDTO>());
            int entriesCount = this.voteUsrAttemptDAO.getSessionEntriesCount(session.getUid());
            int totalStandardVotesCount = 0;
            for (VoteQueContent question : voteContent.getVoteQueContents()) {
                SessionNominationDTO nominationDTO = new SessionNominationDTO();
                nominationDTO.setQuestionUid(question.getUid());
                nominationDTO.setNomination(question.getQuestion());
                int votesCount = this.voteUsrAttemptDAO.getStandardAttemptsForQuestionContentAndSessionUid(question.getUid(), session.getUid());
                totalStandardVotesCount += votesCount;
                nominationDTO.setNumberOfVotes(votesCount);
                nominationDTO.setPercentageOfVotes(entriesCount != 0 ? (double)(votesCount * 100 / entriesCount) : 0.0);
                sessionDTO.getNominations().add(nominationDTO);
            }
            if (voteContent.isAllowText()) {
                int userEnteredVotesCount = entriesCount - totalStandardVotesCount;
                Double voteRate = userEnteredVotesCount != 0 ? (double)(userEnteredVotesCount * 100 / entriesCount) : 0.0;
                sessionDTO.setOpenTextNumberOfVotes(userEnteredVotesCount);
                sessionDTO.setOpenTextPercentageOfVotes(voteRate);
            } else {
                sessionDTO.setOpenTextNumberOfVotes(0);
                sessionDTO.setOpenTextPercentageOfVotes(0.0);
            }
            sessionDTOs.add(sessionDTO);
        }
        if (sessionDTOs.size() > 1) {
            SummarySessionDTO totalSessionDTO = new SummarySessionDTO();
            totalSessionDTO.setSessionUid(0L);
            totalSessionDTO.setToolSessionId(0L);
            totalSessionDTO.setSessionName(this.messageService.getMessage("label.all.groups.total"));
            totalSessionDTO.setNominations(new TreeSet<SessionNominationDTO>());
            HashMap<Long, SessionNominationDTO> nominationsTotals = new HashMap<Long, SessionNominationDTO>();
            int totalOpenVotes = 0;
            int totalVotes = 0;
            for (SummarySessionDTO sessionDTO : sessionDTOs) {
                for (SessionNominationDTO nomination : sessionDTO.getNominations()) {
                    Long questionUid = nomination.getQuestionUid();
                    SessionNominationDTO dto = (SessionNominationDTO)nominationsTotals.get(questionUid);
                    if (dto == null) {
                        dto = new SessionNominationDTO();
                        dto.setQuestionUid(questionUid);
                        dto.setNomination(nomination.getNomination());
                        dto.setNumberOfVotes(0);
                        nominationsTotals.put(questionUid, dto);
                        totalSessionDTO.getNominations().add(dto);
                    }
                    totalVotes += nomination.getNumberOfVotes().intValue();
                    dto.setNumberOfVotes(dto.getNumberOfVotes() + nomination.getNumberOfVotes());
                }
                totalVotes += sessionDTO.getOpenTextNumberOfVotes().intValue();
                totalOpenVotes += sessionDTO.getOpenTextNumberOfVotes().intValue();
            }
            for (SessionNominationDTO nomination : totalSessionDTO.getNominations()) {
                nomination.setPercentageOfVotes(totalVotes != 0 ? (double)(nomination.getNumberOfVotes() * 100 / totalVotes) : 0.0);
            }
            totalSessionDTO.setOpenTextNumberOfVotes(totalOpenVotes);
            totalSessionDTO.setOpenTextPercentageOfVotes(totalVotes != 0 ? (double)(totalOpenVotes * 100 / totalVotes) : 0.0);
            sessionDTOs.add(totalSessionDTO);
        }
        return sessionDTOs;
    }

    private int getVoteSessionPotentialLearnersCount(Long sessionUid) {
        VoteSession session = this.voteSessionDAO.getVoteSessionByUID(sessionUid);
        if (session != null) {
            return this.toolService.getCountUsersForActivity(session.getVoteSessionId());
        }
        logger.error((Object)("Unable to find vote session record id=" + sessionUid + ". Returning 0 users."));
        return 0;
    }

    @Override
    public List<VoteMonitoredAnswersDTO> getOpenVotes(Long voteContentUid, Long currentSessionId, Long userId) {
        Set<String> userEntries = this.voteUsrAttemptDAO.getUserEntries(voteContentUid);
        LinkedList<VoteMonitoredAnswersDTO> monitoredAnswersDTOs = new LinkedList<VoteMonitoredAnswersDTO>();
        for (String userEntry : userEntries) {
            if (userEntry == null || userEntry.length() == 0) continue;
            VoteMonitoredAnswersDTO voteMonitoredAnswersDTO = new VoteMonitoredAnswersDTO();
            voteMonitoredAnswersDTO.setQuestion(userEntry);
            List<VoteUsrAttempt> userAttempts = this.voteUsrAttemptDAO.getUserAttempts(voteContentUid, userEntry);
            LinkedList<VoteMonitoredUserDTO> monitoredUserContainerDTOs = new LinkedList<VoteMonitoredUserDTO>();
            for (VoteUsrAttempt voteUsrAttempt : userAttempts) {
                VoteMonitoredUserDTO voteMonitoredUserDTO = new VoteMonitoredUserDTO();
                if (currentSessionId == null) {
                    voteMonitoredUserDTO.setAttemptTime(voteUsrAttempt.getAttemptTime());
                    voteMonitoredUserDTO.setTimeZone(voteUsrAttempt.getTimeZone());
                    voteMonitoredUserDTO.setUserName(voteUsrAttempt.getVoteQueUsr().getFullname());
                    voteMonitoredUserDTO.setQueUsrId(voteUsrAttempt.getVoteQueUsr().getUid().toString());
                    voteMonitoredUserDTO.setUserEntry(voteUsrAttempt.getUserEntry());
                    voteMonitoredUserDTO.setUid(voteUsrAttempt.getUid().toString());
                    voteMonitoredUserDTO.setVisible(new Boolean(voteUsrAttempt.isVisible()).toString());
                    monitoredUserContainerDTOs.add(voteMonitoredUserDTO);
                    continue;
                }
                Long userSessionId = voteUsrAttempt.getVoteQueUsr().getVoteSession().getVoteSessionId();
                if (userId != null) {
                    Long localUserId;
                    if (!userSessionId.equals(currentSessionId) || !userId.equals(localUserId = voteUsrAttempt.getVoteQueUsr().getQueUsrId())) continue;
                    voteMonitoredUserDTO.setAttemptTime(voteUsrAttempt.getAttemptTime());
                    voteMonitoredUserDTO.setTimeZone(voteUsrAttempt.getTimeZone());
                    voteMonitoredUserDTO.setUserName(voteUsrAttempt.getVoteQueUsr().getFullname());
                    voteMonitoredUserDTO.setQueUsrId(voteUsrAttempt.getVoteQueUsr().getUid().toString());
                    voteMonitoredUserDTO.setUserEntry(voteUsrAttempt.getUserEntry());
                    monitoredUserContainerDTOs.add(voteMonitoredUserDTO);
                    voteMonitoredUserDTO.setUid(voteUsrAttempt.getUid().toString());
                    voteMonitoredUserDTO.setVisible(new Boolean(voteUsrAttempt.isVisible()).toString());
                    if (voteUsrAttempt.isVisible()) continue;
                    voteMonitoredAnswersDTO.setQuestion("Nomination Hidden");
                    continue;
                }
                if (!userSessionId.equals(currentSessionId)) continue;
                voteMonitoredUserDTO.setAttemptTime(voteUsrAttempt.getAttemptTime());
                voteMonitoredUserDTO.setTimeZone(voteUsrAttempt.getTimeZone());
                voteMonitoredUserDTO.setUserName(voteUsrAttempt.getVoteQueUsr().getFullname());
                voteMonitoredUserDTO.setQueUsrId(voteUsrAttempt.getVoteQueUsr().getUid().toString());
                voteMonitoredUserDTO.setUserEntry(voteUsrAttempt.getUserEntry());
                monitoredUserContainerDTOs.add(voteMonitoredUserDTO);
                voteMonitoredUserDTO.setUid(voteUsrAttempt.getUid().toString());
                voteMonitoredUserDTO.setVisible(new Boolean(voteUsrAttempt.isVisible()).toString());
            }
            if (monitoredUserContainerDTOs.size() <= 0) continue;
            Map<String, VoteMonitoredUserDTO> mapMonitoredUserContainerDTO = MonitoringUtil.convertToVoteMonitoredUserDTOMap(monitoredUserContainerDTOs);
            voteMonitoredAnswersDTO.setQuestionAttempts(mapMonitoredUserContainerDTO);
            monitoredAnswersDTOs.add(voteMonitoredAnswersDTO);
        }
        return monitoredAnswersDTOs;
    }

    @Override
    public List<ReflectionDTO> getReflectionData(VoteContent voteContent, Long userID) {
        LinkedList<ReflectionDTO> reflectionsContainerDTO = new LinkedList<ReflectionDTO>();
        if (userID == null) {
            for (VoteSession voteSession : voteContent.getVoteSessions()) {
                for (VoteQueUsr user : voteSession.getVoteQueUsers()) {
                    NotebookEntry notebookEntry = this.getEntry(voteSession.getVoteSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lavote11", new Integer(user.getQueUsrId().toString()));
                    if (notebookEntry == null) continue;
                    ReflectionDTO reflectionDTO = new ReflectionDTO();
                    reflectionDTO.setUserId(user.getQueUsrId().toString());
                    reflectionDTO.setSessionId(voteSession.getVoteSessionId().toString());
                    reflectionDTO.setUserName(user.getFullname());
                    reflectionDTO.setReflectionUid(notebookEntry.getUid().toString());
                    reflectionDTO.setEntry(notebookEntry.getEntry());
                    reflectionsContainerDTO.add(reflectionDTO);
                }
            }
        } else {
            for (VoteSession voteSession : voteContent.getVoteSessions()) {
                for (VoteQueUsr user : voteSession.getVoteQueUsers()) {
                    NotebookEntry notebookEntry;
                    if (!user.getQueUsrId().equals(userID) || (notebookEntry = this.getEntry(voteSession.getVoteSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lavote11", new Integer(user.getQueUsrId().toString()))) == null) continue;
                    ReflectionDTO reflectionDTO = new ReflectionDTO();
                    reflectionDTO.setUserId(user.getQueUsrId().toString());
                    reflectionDTO.setSessionId(voteSession.getVoteSessionId().toString());
                    reflectionDTO.setUserName(user.getFullname());
                    reflectionDTO.setReflectionUid(notebookEntry.getUid().toString());
                    reflectionDTO.setEntry(notebookEntry.getEntry());
                    reflectionsContainerDTO.add(reflectionDTO);
                }
            }
        }
        return reflectionsContainerDTO;
    }

    @Override
    public VoteContent getVoteContent(Long toolContentID) {
        return this.voteContentDAO.getVoteContentByContentId(toolContentID);
    }

    @Override
    public VoteQueContent getQuestionByDisplayOrder(Long displayOrder, Long voteContentUid) {
        return this.voteQueContentDAO.getQuestionByDisplayOrder(displayOrder, voteContentUid);
    }

    @Override
    public VoteQueUsr getUserById(long voteQueUsrId) {
        VoteQueUsr voteQueUsr = this.voteUserDAO.getVoteQueUsrById(voteQueUsrId);
        return voteQueUsr;
    }

    @Override
    public List<VoteUsrAttempt> getAttemptsForQuestionContentAndSessionUid(Long questionUid, Long voteSessionUid) {
        return this.voteUsrAttemptDAO.getAttemptsForQuestionContentAndSessionUid(questionUid, voteSessionUid);
    }

    @Override
    public Set<String> getAttemptsForUserAndSessionUseOpenAnswer(Long userUid, Long sessionUid) {
        List<VoteUsrAttempt> list = this.voteUsrAttemptDAO.getAttemptsForUserAndSessionUseOpenAnswer(userUid, sessionUid);
        String openAnswer = "";
        HashSet<String> userEntries = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (VoteUsrAttempt attempt : list) {
                Long questionUid = attempt.getVoteQueContent().getUid();
                if (!questionUid.toString().equals("1")) {
                    userEntries.add(attempt.getVoteQueContent().getQuestion());
                    continue;
                }
                if (attempt.getUserEntry().length() <= 0) continue;
                if (attempt.isVisible()) {
                    userEntries.add(attempt.getUserEntry());
                    continue;
                }
                userEntries.add(this.getMessageService().getMessage("label.hidden"));
            }
        }
        return userEntries;
    }

    @Override
    public Set<String> getAttemptsForUserAndSession(Long queUsrUid, Long sessionUid) {
        return this.voteUsrAttemptDAO.getAttemptsForUserAndSession(queUsrUid, sessionUid);
    }

    @Override
    public VoteQueContent getVoteQueContentByUID(Long uid) {
        if (uid == null) {
            return null;
        }
        return this.voteQueContentDAO.getQuestionByUid(uid);
    }

    @Override
    public void saveOrUpdateVoteQueContent(VoteQueContent voteQueContent) {
        this.voteQueContentDAO.saveOrUpdateQuestion(voteQueContent);
    }

    @Override
    public VoteContent createQuestions(List<VoteQuestionDTO> questionDTOs, VoteContent voteContent) {
        int displayOrder = 0;
        for (VoteQuestionDTO questionDTO : questionDTOs) {
            String currentQuestionText = questionDTO.getQuestion();
            if (currentQuestionText.isEmpty()) continue;
            ++displayOrder;
            VoteQueContent question = this.getVoteQueContentByUID(questionDTO.getUid());
            if (question == null) {
                question = new VoteQueContent(currentQuestionText, displayOrder, voteContent);
                voteContent.getVoteQueContents().add(question);
                question.setVoteContent(voteContent);
            } else {
                question.setQuestion(currentQuestionText);
                question.setDisplayOrder(displayOrder);
            }
            this.saveOrUpdateVoteQueContent(question);
        }
        return voteContent;
    }

    @Override
    public Map<String, String> buildQuestionMap(VoteContent voteContent, Collection<String> checkedOptions) {
        TreeMap<String, String> mapQuestionsContent = new TreeMap<String, String>(new VoteComparator());
        Set questions = voteContent.getVoteQueContents();
        if (Boolean.TRUE.equals(voteContent.getAssignedDataFlowObject()) && (voteContent.getMaxExternalInputs() == null || voteContent.getExternalInputsAdded() == null || voteContent.getExternalInputsAdded() < voteContent.getMaxExternalInputs())) {
            VoteQueContent nomination;
            int nominationIndex;
            HttpSession ss = SessionManager.getSession();
            UserDTO toolUser = (UserDTO)ss.getAttribute("user");
            long userId = toolUser.getUserID().longValue();
            ToolOutput toolInput = this.getToolInput(voteContent.getVoteContentId(), new Long(userId).intValue());
            Object value = toolInput.getValue().getComplex();
            short inputsAdded = voteContent.getExternalInputsAdded() == null ? (short)0 : voteContent.getExternalInputsAdded();
            Short maxInputs = voteContent.getMaxExternalInputs();
            Set existingNominations = voteContent.getVoteQueContents();
            if (value instanceof String[][]) {
                if (value != null) {
                    String[][] usersAndAnswers = (String[][])value;
                    nominationIndex = voteContent.getVoteQueContents().size() + 1;
                    for (String[] stringArray : usersAndAnswers) {
                        if (stringArray == null) continue;
                        if (maxInputs == null || inputsAdded < maxInputs) {
                            boolean anyAnswersAdded = false;
                            for (String questionText : stringArray) {
                                if (StringUtils.isBlank((String)questionText)) continue;
                                nomination = new VoteQueContent();
                                nomination.setDisplayOrder(nominationIndex);
                                nomination.setMcContent(voteContent);
                                nomination.setQuestion(questionText);
                                if (VoteServicePOJO.isNominationExists(nomination, existingNominations)) continue;
                                this.saveOrUpdateVoteQueContent(nomination);
                                voteContent.getVoteQueContents().add(nomination);
                                ++nominationIndex;
                                anyAnswersAdded = true;
                            }
                            if (!anyAnswersAdded) continue;
                            inputsAdded = (short)(inputsAdded + 1);
                            continue;
                        }
                        break;
                    }
                }
            } else if (value instanceof String[]) {
                int nominationIndex2 = voteContent.getVoteQueContents().size() + 1;
                String[] userAnswers = (String[])value;
                for (String[] stringArray : userAnswers) {
                    if (maxInputs == null || inputsAdded < maxInputs) {
                        if (StringUtils.isBlank((String)stringArray)) continue;
                        VoteQueContent nomination2 = new VoteQueContent();
                        nomination2.setDisplayOrder(nominationIndex2);
                        nomination2.setMcContent(voteContent);
                        nomination2.setQuestion((String)stringArray);
                        if (VoteServicePOJO.isNominationExists(nomination2, existingNominations)) continue;
                        this.saveOrUpdateVoteQueContent(nomination2);
                        voteContent.getVoteQueContents().add(nomination2);
                        ++nominationIndex2;
                        inputsAdded = (short)(inputsAdded + 1);
                        continue;
                    }
                    break;
                }
            } else if (value instanceof String && !StringUtils.isBlank((String)((String)value))) {
                int nominationIndex3 = voteContent.getVoteQueContents().size() + 1;
                VoteQueContent nomination3 = new VoteQueContent();
                nomination3.setDisplayOrder(nominationIndex3);
                nomination3.setMcContent(voteContent);
                nomination3.setQuestion((String)value);
                if (!VoteServicePOJO.isNominationExists(nomination3, existingNominations)) {
                    this.saveOrUpdateVoteQueContent(nomination3);
                    voteContent.getVoteQueContents().add(nomination3);
                }
            }
            if (value instanceof SimpleURL[][]) {
                if (value != null) {
                    SimpleURL[][] usersAndUrls = (SimpleURL[][])value;
                    nominationIndex = voteContent.getVoteQueContents().size() + 1;
                    for (String[] stringArray : usersAndUrls) {
                        if (stringArray == null) continue;
                        if (maxInputs == null || inputsAdded < maxInputs) {
                            boolean anyAnswersAdded = false;
                            for (String url : stringArray) {
                                if (url == null) continue;
                                nomination = new VoteQueContent();
                                nomination.setDisplayOrder(nominationIndex);
                                nomination.setMcContent(voteContent);
                                String link = "<a href=\"" + url.getUrl() + "\">" + url.getNameToDisplay() + "</a>";
                                nomination.setQuestion(link);
                                if (VoteServicePOJO.isNominationExists(nomination, existingNominations)) continue;
                                this.saveOrUpdateVoteQueContent(nomination);
                                voteContent.getVoteQueContents().add(nomination);
                                ++nominationIndex;
                                anyAnswersAdded = true;
                            }
                            if (!anyAnswersAdded) continue;
                            inputsAdded = (short)(inputsAdded + 1);
                            continue;
                        }
                        break;
                    }
                }
            } else if (value instanceof SimpleURL[]) {
                int nominationIndex4 = voteContent.getVoteQueContents().size() + 1;
                SimpleURL[] userUrls = (SimpleURL[])value;
                for (String[] stringArray : userUrls) {
                    if (maxInputs == null || inputsAdded < maxInputs) {
                        if (stringArray == null) continue;
                        VoteQueContent nomination4 = new VoteQueContent();
                        nomination4.setDisplayOrder(nominationIndex4);
                        nomination4.setMcContent(voteContent);
                        String link = "<a href=\"" + stringArray.getUrl() + "\">" + stringArray.getNameToDisplay() + "</a>";
                        nomination4.setQuestion(link);
                        if (VoteServicePOJO.isNominationExists(nomination4, existingNominations)) continue;
                        this.saveOrUpdateVoteQueContent(nomination4);
                        voteContent.getVoteQueContents().add(nomination4);
                        ++nominationIndex4;
                        inputsAdded = (short)(inputsAdded + 1);
                        continue;
                    }
                    break;
                }
            } else if (value instanceof SimpleURL) {
                int nominationIndex5 = voteContent.getVoteQueContents().size() + 1;
                VoteQueContent nomination5 = new VoteQueContent();
                nomination5.setDisplayOrder(nominationIndex5);
                SimpleURL url = (SimpleURL)value;
                String link = "<a href=\"" + url.getUrl() + "\">" + url.getNameToDisplay() + "</a>";
                nomination5.setQuestion(link);
                if (!VoteServicePOJO.isNominationExists(nomination5, existingNominations)) {
                    nomination5.setMcContent(voteContent);
                    this.saveOrUpdateVoteQueContent(nomination5);
                    voteContent.getVoteQueContents().add(nomination5);
                }
            }
            voteContent.setExternalInputsAdded(inputsAdded);
            this.saveVoteContent(voteContent);
            questions = voteContent.getVoteQueContents();
        }
        for (VoteQueContent question : questions) {
            String displayOrder = "" + question.getDisplayOrder();
            if (checkedOptions != null && !checkedOptions.contains(displayOrder) || displayOrder.equals("0")) continue;
            mapQuestionsContent.put(displayOrder.toString(), question.getQuestion());
        }
        return mapQuestionsContent;
    }

    private static boolean isNominationExists(VoteQueContent nomination, Set<VoteQueContent> existingNominations) {
        if (existingNominations != null && nomination != null) {
            for (VoteQueContent existingNomination : existingNominations) {
                if (existingNomination.getQuestion() == null || !existingNomination.getQuestion().equals(nomination.getQuestion())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<VoteQueUsr> getUserBySessionOnly(VoteSession voteSession) {
        return this.voteUserDAO.getUserBySessionOnly(voteSession);
    }

    @Override
    public VoteSession getVoteSessionByUID(Long uid) {
        return this.voteSessionDAO.getVoteSessionByUID(uid);
    }

    @Override
    public void createVoteQueUsr(VoteQueUsr voteQueUsr) {
        this.voteUserDAO.saveVoteUser(voteQueUsr);
    }

    @Override
    public VoteQueUsr getVoteUserBySession(Long queUsrId, Long sessionUid) {
        return this.voteUserDAO.getVoteUserBySession(queUsrId, sessionUid);
    }

    @Override
    public void updateVoteUser(VoteQueUsr voteUser) {
        this.voteUserDAO.updateVoteUser(voteUser);
    }

    @Override
    public VoteQueUsr getUserByUserId(Long userID) {
        VoteQueUsr voteQueUsr = this.voteUserDAO.getUserByUserId(userID);
        return voteQueUsr;
    }

    @Override
    public VoteUsrAttempt getAttemptByUID(Long uid) {
        return this.voteUsrAttemptDAO.getAttemptByUID(uid);
    }

    @Override
    public void updateVoteUsrAttempt(VoteUsrAttempt voteUsrAttempt) {
        this.voteUsrAttemptDAO.updateVoteUsrAttempt(voteUsrAttempt);
    }

    @Override
    public void removeAttemptsForUserandSession(Long queUsrId, Long sessionUid) {
        this.voteUsrAttemptDAO.removeAttemptsForUserandSession(queUsrId, sessionUid);
    }

    @Override
    public List<VoteUsrAttempt> getAttemptsForUser(Long userUid) {
        return this.voteUsrAttemptDAO.getAttemptsForUser(userUid);
    }

    @Override
    public void createAttempt(VoteQueUsr voteQueUsr, Map mapGeneralCheckedOptionsContent, String userEntry, VoteSession voteSession, Long voteContentUid) {
        Date attempTime = new Date(System.currentTimeMillis());
        String timeZone = TimeZone.getDefault().getDisplayName();
        if (mapGeneralCheckedOptionsContent.size() == 0) {
            VoteQueContent defaultContentFirstQuestion = this.voteQueContentDAO.getDefaultVoteContentFirstQuestion();
            this.createAttempt(defaultContentFirstQuestion, voteQueUsr, attempTime, timeZone, userEntry, voteSession);
        } else if (voteContentUid != null) {
            for (Map.Entry checkedPairs : mapGeneralCheckedOptionsContent.entrySet()) {
                Long questionDisplayOrder = new Long(checkedPairs.getKey().toString());
                VoteQueContent question = this.getQuestionByDisplayOrder(questionDisplayOrder, voteContentUid);
                this.createAttempt(question, voteQueUsr, attempTime, timeZone, userEntry, voteSession);
            }
        }
    }

    private void createAttempt(VoteQueContent question, VoteQueUsr user, Date attempTime, String timeZone, String userEntry, VoteSession session) {
        if (question != null) {
            VoteUsrAttempt existingAttempt = this.voteUsrAttemptDAO.getAttemptForUserAndQuestionContentAndSession(user.getQueUsrId(), question.getVoteContentId(), session.getUid());
            if (existingAttempt != null) {
                existingAttempt.setUserEntry(userEntry);
                existingAttempt.setAttemptTime(attempTime);
                existingAttempt.setTimeZone(timeZone);
                this.updateVoteUsrAttempt(existingAttempt);
            } else {
                VoteUsrAttempt voteUsrAttempt = new VoteUsrAttempt(attempTime, timeZone, question, user, userEntry, true);
                this.voteUsrAttemptDAO.saveVoteUsrAttempt(voteUsrAttempt);
            }
        }
    }

    @Override
    public VoteQueContent getQuestionByUid(Long uid) {
        return this.voteQueContentDAO.getQuestionByUid(uid);
    }

    @Override
    public void removeVoteQueContent(VoteQueContent voteQueContent) {
        this.voteQueContentDAO.removeQuestion(voteQueContent);
    }

    @Override
    public VoteSession getSessionBySessionId(Long voteSessionId) {
        return this.voteSessionDAO.getSessionBySessionId(voteSessionId);
    }

    @Override
    public void updateVote(VoteContent vote) {
        this.voteContentDAO.updateVoteContent(vote);
    }

    @Override
    public int countSessionComplete() {
        return this.voteSessionDAO.countSessionComplete();
    }

    @Override
    public void hideOpenVote(VoteUsrAttempt voteUsrAttempt) {
        this.auditService.logHideEntry("lavote11", voteUsrAttempt.getQueUsrId(), voteUsrAttempt.getVoteQueUsr().getUsername(), voteUsrAttempt.getUserEntry());
    }

    @Override
    public void showOpenVote(VoteUsrAttempt voteUsrAttempt) {
        this.auditService.logShowEntry("lavote11", voteUsrAttempt.getQueUsrId(), voteUsrAttempt.getVoteQueUsr().getUsername(), voteUsrAttempt.getUserEntry());
    }

    @Override
    public void saveVoteContent(VoteContent vote) {
        this.voteContentDAO.saveVoteContent(vote);
    }

    @Override
    public List<Long> getSessionsFromContent(VoteContent voteContent) {
        return this.voteSessionDAO.getSessionsFromContent(voteContent);
    }

    @Override
    public int getTotalNumberOfUsers() {
        return this.voteUserDAO.getTotalNumberOfUsers();
    }

    @Override
    public List<VoteUsrAttempt> getAttemptsForUserAndQuestionContent(Long userUid, Long questionUid) {
        try {
            return this.voteUsrAttemptDAO.getAttemptsForUserAndQuestionContent(userUid, questionUid);
        }
        catch (DataAccessException e) {
            throw new VoteApplicationException("Exception occured when lams is getting vote voteUsrRespDAO by user id and que content id: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean studentActivityOccurredGlobal(VoteContent voteContent) {
        return !voteContent.getVoteSessions().isEmpty();
    }

    @Override
    public void recalculateUserAnswers(VoteContent content, Set<VoteQueContent> oldQuestions, List<VoteQuestionDTO> questionDTOs, List<VoteQuestionDTO> deletedQuestions) {
        ArrayList<VoteQuestionDTO> modifiedQuestions = new ArrayList<VoteQuestionDTO>();
        for (VoteQueContent oldQuestion : oldQuestions) {
            for (VoteQuestionDTO questionDTO : questionDTOs) {
                if (!oldQuestion.getUid().equals(questionDTO.getUid()) || oldQuestion.getQuestion().equals(questionDTO.getQuestion())) continue;
                modifiedQuestions.add(questionDTO);
            }
        }
        Set sessionList = content.getVoteSessions();
        for (VoteSession session : sessionList) {
            Long toolSessionId = session.getVoteSessionId();
            Set sessionUsers = session.getVoteQueUsers();
            for (VoteQueUsr user : sessionUsers) {
                List<VoteUsrAttempt> userAttempts = this.getAttemptsForUser(user.getUid());
                Iterator<VoteUsrAttempt> iter = userAttempts.iterator();
                while (iter.hasNext()) {
                    VoteUsrAttempt userAttempt = iter.next();
                    VoteQueContent question = userAttempt.getVoteQueContent();
                    boolean isRemoveQuestionResult = false;
                    for (VoteQuestionDTO modifiedQuestion : modifiedQuestions) {
                        if (!question.getUid().equals(modifiedQuestion.getUid())) continue;
                        isRemoveQuestionResult = true;
                        break;
                    }
                    for (VoteQuestionDTO deletedQuestion : deletedQuestions) {
                        if (!question.getUid().equals(deletedQuestion.getUid())) continue;
                        isRemoveQuestionResult = true;
                        break;
                    }
                    if (!isRemoveQuestionResult) continue;
                    iter.remove();
                    this.voteUsrAttemptDAO.removeVoteUsrAttempt(userAttempt);
                }
            }
        }
    }

    @Override
    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        VoteContent toContent;
        if (fromContentId == null) {
            long defaultContentId = this.getToolDefaultContentIdBySignature("lavote11");
            fromContentId = new Long(defaultContentId);
        }
        if (toContentId == null) {
            logger.error((Object)"throwing ToolException: toContentId is null");
            throw new ToolException("toContentId is missing");
        }
        VoteContent fromContent = this.voteContentDAO.getVoteContentByContentId(fromContentId);
        if (fromContent == null) {
            long defaultContentId = this.getToolDefaultContentIdBySignature("lavote11");
            fromContentId = new Long(defaultContentId);
            fromContent = this.voteContentDAO.getVoteContentByContentId(fromContentId);
        }
        if ((toContent = VoteContent.newInstance(fromContent, toContentId)) == null) {
            logger.error((Object)"throwing ToolException: WARNING!, retrieved toContent is null.");
            throw new ToolException("WARNING! Fail to create toContent. Can't continue!");
        }
        this.voteContentDAO.saveVoteContent(toContent);
    }

    public void removeToolContent(Long toolContentId) throws ToolException {
        VoteContent voteContent = this.voteContentDAO.getVoteContentByContentId(toolContentId);
        if (voteContent == null) {
            logger.warn((Object)("Can not remove the tool content as it does not exist, ID: " + toolContentId));
            return;
        }
        for (VoteSession session : voteContent.getVoteSessions()) {
            List entries = this.coreNotebookService.getEntry(session.getVoteSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lavote11");
            for (NotebookEntry entry : entries) {
                this.coreNotebookService.deleteEntry(entry);
            }
        }
        this.voteContentDAO.delete(voteContent);
    }

    public void removeLearnerContent(Long toolContentId, Integer userId) throws ToolException {
        VoteContent voteContent;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing Vote attempts for user ID " + userId + " and toolContentId " + toolContentId));
        }
        if ((voteContent = this.voteContentDAO.getVoteContentByContentId(toolContentId)) == null) {
            logger.warn((Object)("Did not find activity with toolContentId: " + toolContentId + " to remove learner content"));
            return;
        }
        for (VoteSession session : voteContent.getVoteSessions()) {
            VoteQueUsr user = this.voteUserDAO.getVoteUserBySession(userId.longValue(), session.getUid());
            if (user == null) continue;
            this.voteUsrAttemptDAO.removeAttemptsForUserandSession(user.getUid(), session.getUid());
            NotebookEntry entry = this.getEntry(session.getVoteSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lavote11", userId);
            if (entry != null) {
                this.voteContentDAO.delete(entry);
            }
            this.voteUserDAO.removeVoteUser(user);
        }
    }

    public void exportToolContent(Long toolContentID, String rootPath) throws DataMissingException, ToolException {
        VoteContent toolContentObj = this.voteContentDAO.getVoteContentByContentId(toolContentID);
        if (toolContentObj == null) {
            long defaultContentId = this.getToolDefaultContentIdBySignature("lavote11");
            toolContentObj = this.voteContentDAO.getVoteContentByContentId(defaultContentId);
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the voting tool");
        }
        try {
            toolContentObj = VoteContent.newInstance(toolContentObj, toolContentID);
            toolContentObj.setVoteSessions(null);
            this.exportContentService.exportToolContent(toolContentID, (Object)toolContentObj, this.voteToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentID, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerImportVersionFilterClass(VoteImportContentVersionFilter.class);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.voteToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof VoteContent)) {
                throw new ImportToolContentException("Import Vote tool content failed. Deserialized object is " + toolPOJO);
            }
            VoteContent toolContentObj = (VoteContent)toolPOJO;
            toolContentObj.setVoteContentId(toolContentID);
            toolContentObj.setCreatedBy(newUserUid.intValue());
            this.voteContentDAO.saveVoteContent(toolContentObj);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void resetDefineLater(Long toolContentId) throws DataMissingException, ToolException {
        VoteContent voteContent = this.getVoteContent(toolContentId);
        if (voteContent == null) {
            logger.error((Object)"throwing DataMissingException: WARNING!: retrieved voteContent is null.");
            throw new DataMissingException("voteContent is missing");
        }
        voteContent.setDefineLater(false);
        this.saveVoteContent(voteContent);
    }

    @Override
    public void createToolSession(Long toolSessionID, String toolSessionName, Long toolContentID) throws ToolException {
        if (toolSessionID == null) {
            logger.error((Object)"toolSessionID is null");
            throw new ToolException("toolSessionID is missing");
        }
        VoteContent voteContent = this.voteContentDAO.getVoteContentByContentId(toolContentID);
        VoteSession voteSession = this.getSessionBySessionId(toolSessionID);
        if (voteSession == null) {
            try {
                voteSession = new VoteSession(toolSessionID, new Date(System.currentTimeMillis()), "INCOMPLETE", toolSessionName, voteContent, new TreeSet());
                this.voteSessionDAO.saveVoteSession(voteSession);
            }
            catch (Exception e) {
                logger.error((Object)"Error creating new toolsession in the db");
                throw new ToolException("Error creating new toolsession in the db: " + e);
            }
        }
    }

    @Override
    public void removeToolSession(Long toolSessionID) throws DataMissingException, ToolException {
        if (toolSessionID == null) {
            logger.error((Object)"toolSessionID is null");
            throw new DataMissingException("toolSessionID is missing");
        }
        VoteSession voteSession = null;
        try {
            voteSession = this.getSessionBySessionId(toolSessionID);
        }
        catch (VoteApplicationException e) {
            throw new DataMissingException("error retrieving voteSession: " + e);
        }
        catch (Exception e) {
            throw new ToolException("error retrieving voteSession: " + e);
        }
        if (voteSession == null) {
            logger.error((Object)"voteSession is null");
            throw new DataMissingException("voteSession is missing");
        }
        try {
            this.voteSessionDAO.removeVoteSession(voteSession);
        }
        catch (VoteApplicationException e) {
            throw new ToolException("error deleting voteSession:" + e);
        }
    }

    @Override
    public String leaveToolSession(Long toolSessionID, Long learnerId) throws DataMissingException, ToolException {
        if (this.learnerService == null) {
            return "dummyNextUrl";
        }
        if (learnerId == null) {
            logger.error((Object)"learnerId is null");
            throw new DataMissingException("learnerId is missing");
        }
        if (toolSessionID == null) {
            logger.error((Object)"toolSessionID is null");
            throw new DataMissingException("toolSessionID is missing");
        }
        VoteSession voteSession = null;
        try {
            voteSession = this.getSessionBySessionId(toolSessionID);
        }
        catch (VoteApplicationException e) {
            throw new DataMissingException("error retrieving voteSession: " + e);
        }
        catch (Exception e) {
            throw new ToolException("error retrieving voteSession: " + e);
        }
        voteSession.setSessionStatus("COMPLETED");
        this.voteSessionDAO.updateVoteSession(voteSession);
        String nextUrl = this.learnerService.completeToolSession(toolSessionID, learnerId);
        if (nextUrl == null) {
            logger.error((Object)"nextUrl is null");
            throw new ToolException("nextUrl is null");
        }
        return nextUrl;
    }

    @Override
    public ToolSessionExportOutputData exportToolSession(Long toolSessionID) throws DataMissingException, ToolException {
        throw new ToolException("not yet implemented");
    }

    @Override
    public ToolSessionExportOutputData exportToolSession(List toolSessionIDs) throws DataMissingException, ToolException {
        throw new ToolException("not yet implemented");
    }

    @Override
    public IToolVO getToolBySignature(String toolSignature) {
        IToolVO tool = this.toolService.getToolBySignature(toolSignature);
        return tool;
    }

    @Override
    public long getToolDefaultContentIdBySignature(String toolSignature) {
        long contentId = 0L;
        contentId = this.toolService.getToolDefaultContentIdBySignature(toolSignature);
        return contentId;
    }

    @Override
    public List getToolSessionsForContent(VoteContent vote) {
        List<Long> listToolSessionIds = this.voteSessionDAO.getSessionsFromContent(vote);
        return listToolSessionIds;
    }

    @Override
    public boolean isGroupedActivity(long toolContentID) {
        return this.toolService.isGroupedActivity(toolContentID);
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId, int definitionType) throws ToolException {
        VoteContent content = this.getVoteContent(toolContentId);
        if (content == null) {
            long defaultToolContentId = this.getToolDefaultContentIdBySignature("lavote11");
            content = this.getVoteContent(defaultToolContentId);
        }
        return this.getVoteOutputFactory().getToolOutputDefinitions(content, definitionType);
    }

    public String getToolContentTitle(Long toolContentId) {
        return this.getVoteContent(toolContentId).getTitle();
    }

    public boolean isContentEdited(Long toolContentId) {
        return this.getVoteContent(toolContentId).isDefineLater();
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return this.voteOutputFactory.getToolOutput(names, (IVoteService)this, toolSessionId, learnerId);
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return this.voteOutputFactory.getToolOutput(name, (IVoteService)this, toolSessionId, learnerId);
    }

    public void forceCompleteUser(Long toolSessionId, User user) {
        Long userId = user.getUserId().longValue();
        VoteSession session = this.getSessionBySessionId(toolSessionId);
        if (session == null || session.getVoteContent() == null) {
            return;
        }
        VoteContent content = session.getVoteContent();
        if (content.isUseSelectLeaderToolOuput()) {
            VoteQueUsr groupLeader;
            VoteQueUsr voteUser = this.voteUserDAO.getVoteUserBySession(userId, toolSessionId);
            if (voteUser == null) {
                String userName = user.getLogin();
                String fullName = user.getFirstName() + " " + user.getLastName();
                voteUser = new VoteQueUsr(userId, userName, fullName, session, new TreeSet());
                this.createVoteQueUsr(voteUser);
            }
            if ((groupLeader = session.getGroupLeader()) != null && groupLeader.isResponseFinalised()) {
                this.copyAnswersFromLeader(voteUser, groupLeader);
            }
        }
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        VoteContent toolContentObj = new VoteContent();
        toolContentObj.setCreatedBy(user.getUserID().longValue());
        toolContentObj.setCreationDate(now);
        toolContentObj.setDefineLater(false);
        toolContentObj.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
        toolContentObj.setReflectionSubject(null);
        toolContentObj.setReflect(false);
        toolContentObj.setUseSelectLeaderToolOuput(false);
        toolContentObj.setTitle((String)importValues.get("title"));
        toolContentObj.setContent(null);
        toolContentObj.setUpdateDate(now);
        toolContentObj.setVoteContentId(toolContentId);
        toolContentObj.setLockOnFinish(false);
        toolContentObj.setShowResults(true);
        try {
            Boolean bool = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"nominatePollTime");
            toolContentObj.setAllowText(bool != null ? bool : false);
            bool = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"isReusable");
            toolContentObj.setLockOnFinish(bool != null ? bool : true);
            Integer maxCount = WDDXProcessor.convertToInteger((Hashtable)importValues, (String)"maxChoose");
            toolContentObj.setMaxNominationCount(maxCount != null ? maxCount.toString() : "1");
            Integer minCount = WDDXProcessor.convertToInteger((Hashtable)importValues, (String)"minChoose");
            toolContentObj.setMinNominationCount(minCount != null ? minCount.toString() : "1");
        }
        catch (WDDXProcessorConversionException e) {
            logger.error((Object)("Unable to content for activity " + toolContentObj.getTitle() + "properly due to a WDDXProcessorConversionException."), (Throwable)e);
            throw new ToolException("Invalid import data format for activity " + toolContentObj.getTitle() + "- WDDX caused an exception. Some data from the design will have been lost. See log for more details.");
        }
        Vector nominations = (Vector)importValues.get("nominations");
        if (nominations != null) {
            Iterator iter = nominations.iterator();
            int order = 1;
            while (iter.hasNext()) {
                String element = (String)iter.next();
                VoteQueContent nomination = new VoteQueContent(element, toolContentObj);
                nomination.setDisplayOrder(order++);
                toolContentObj.getVoteQueContents().add(nomination);
            }
        }
        this.voteContentDAO.saveVoteContent(toolContentObj);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        VoteContent toolContentObj = null;
        if (toolContentId != null) {
            toolContentObj = this.getVoteContent(toolContentId);
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        toolContentObj.setReflect(Boolean.TRUE);
        toolContentObj.setReflectionSubject(description);
    }

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    @Override
    public NotebookEntry getEntry(Long id, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(id, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public List<VoteQueContent> getAllQuestionsSorted(long voteContentId) {
        return this.voteQueContentDAO.getAllQuestionsSorted(voteContentId);
    }

    @Override
    public List<Object[]> getUserAttemptsForTablesorter(Long sessionUid, Long questionUid, int page, int size, int sorting, String searchString) {
        return this.voteUsrAttemptDAO.getUserAttemptsForTablesorter(sessionUid, questionUid, page, size, sorting, searchString);
    }

    @Override
    public int getCountUsersBySession(Long sessionUid, Long questionUid, String searchString) {
        return this.voteUsrAttemptDAO.getCountUsersBySession(sessionUid, questionUid, searchString);
    }

    @Override
    public List<Object[]> getUserReflectionsForTablesorter(Long sessionUid, int page, int size, int sorting, String searchString) {
        return this.voteUsrAttemptDAO.getUserReflectionsForTablesorter(sessionUid, page, size, sorting, searchString, this.getCoreNotebookService());
    }

    @Override
    public List<VoteStatsDTO> getStatisticsBySession(Long toolContentId) {
        List<VoteStatsDTO> stats = this.voteUsrAttemptDAO.getStatisticsBySession(toolContentId);
        for (VoteStatsDTO stat : stats) {
            stat.setCountAllUsers(this.getVoteSessionPotentialLearnersCount(stat.getSessionUid()));
        }
        return stats;
    }

    @Override
    public List<OpenTextAnswerDTO> getUserOpenTextAttemptsForTablesorter(Long sessionUid, Long contentUid, int page, int size, int sorting, String searchStringVote, String searchStringUsername) {
        return this.voteUsrAttemptDAO.getUserOpenTextAttemptsForTablesorter(sessionUid, contentUid, page, size, sorting, searchStringVote, searchStringUsername);
    }

    @Override
    public int getCountUsersForOpenTextEntries(Long sessionUid, Long contentUid, String searchStringVote, String searchStringUsername) {
        return this.voteUsrAttemptDAO.getCountUsersForOpenTextEntries(sessionUid, contentUid, searchStringVote, searchStringUsername);
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public IUserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public IVoteSessionDAO getvoteSessionDAO() {
        return this.voteSessionDAO;
    }

    public void setvoteSessionDAO(IVoteSessionDAO voteSessionDAO) {
        this.voteSessionDAO = voteSessionDAO;
    }

    public IVoteUserDAO getvoteUserDAO() {
        return this.voteUserDAO;
    }

    public void setvoteUserDAO(IVoteUserDAO voteUserDAO) {
        this.voteUserDAO = voteUserDAO;
    }

    public IVoteUsrAttemptDAO getvoteUsrAttemptDAO() {
        return this.voteUsrAttemptDAO;
    }

    public void setvoteUsrAttemptDAO(IVoteUsrAttemptDAO voteUsrAttemptDAO) {
        this.voteUsrAttemptDAO = voteUsrAttemptDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IToolContentHandler getVoteToolContentHandler() {
        return this.voteToolContentHandler;
    }

    public void setVoteToolContentHandler(IToolContentHandler voteToolContentHandler) {
        this.voteToolContentHandler = voteToolContentHandler;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public IVoteContentDAO getvoteContentDAO() {
        return this.voteContentDAO;
    }

    public void setvoteContentDAO(IVoteContentDAO voteContentDAO) {
        this.voteContentDAO = voteContentDAO;
    }

    public IVoteQueContentDAO getvoteQueContentDAO() {
        return this.voteQueContentDAO;
    }

    public void setvoteQueContentDAO(IVoteQueContentDAO voteQueContentDAO) {
        this.voteQueContentDAO = voteQueContentDAO;
    }

    public IVoteContentDAO getVoteContentDAO() {
        return this.voteContentDAO;
    }

    public void setVoteContentDAO(IVoteContentDAO voteContentDAO) {
        this.voteContentDAO = voteContentDAO;
    }

    public IVoteQueContentDAO getVoteQueContentDAO() {
        return this.voteQueContentDAO;
    }

    public void setVoteQueContentDAO(IVoteQueContentDAO voteQueContentDAO) {
        this.voteQueContentDAO = voteQueContentDAO;
    }

    public IVoteSessionDAO getVoteSessionDAO() {
        return this.voteSessionDAO;
    }

    public void setVoteSessionDAO(IVoteSessionDAO voteSessionDAO) {
        this.voteSessionDAO = voteSessionDAO;
    }

    public IVoteUserDAO getVoteUserDAO() {
        return this.voteUserDAO;
    }

    public void setVoteUserDAO(IVoteUserDAO voteUserDAO) {
        this.voteUserDAO = voteUserDAO;
    }

    public IVoteUsrAttemptDAO getVoteUsrAttemptDAO() {
        return this.voteUsrAttemptDAO;
    }

    public void setVoteUsrAttemptDAO(IVoteUsrAttemptDAO voteUsrAttemptDAO) {
        this.voteUsrAttemptDAO = voteUsrAttemptDAO;
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    public VoteOutputFactory getVoteOutputFactory() {
        return this.voteOutputFactory;
    }

    public void setVoteOutputFactory(VoteOutputFactory voteOutputFactory) {
        this.voteOutputFactory = voteOutputFactory;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public void removeQuestionsFromCache(VoteContent voteContent) {
        this.voteContentDAO.removeQuestionsFromCache(voteContent);
    }

    @Override
    public void removeVoteContentFromCache(VoteContent voteContent) {
        this.voteContentDAO.removeVoteContentFromCache(voteContent);
    }

    public void setDataFlowDAO(IDataFlowDAO dataFlowDAO) {
        this.dataFlowDAO = dataFlowDAO;
    }

    @Override
    public ToolOutput getToolInput(Long requestingToolContentId, Integer learnerId) {
        return this.learnerService.getToolInput(requestingToolContentId, VoteAppConstants.DATA_FLOW_OBJECT_ASSIGMENT_ID, learnerId);
    }

    @Override
    public void saveDataFlowObjectAssigment(DataFlowObject assignedDataFlowObject) {
        if (assignedDataFlowObject != null) {
            assignedDataFlowObject.setToolAssigmentId(VoteAppConstants.DATA_FLOW_OBJECT_ASSIGMENT_ID);
            this.dataFlowDAO.update((Object)assignedDataFlowObject);
        }
    }

    @Override
    public DataFlowObject getAssignedDataFlowObject(Long toolContentId) {
        return this.dataFlowDAO.getAssignedDataFlowObject(toolContentId, VoteAppConstants.DATA_FLOW_OBJECT_ASSIGMENT_ID);
    }

    @Override
    public List<DataFlowObject> getDataFlowObjects(Long toolContentId) {
        return this.dataFlowDAO.getDataFlowObjectsByToolContentId(toolContentId);
    }

    public Class[] getSupportedToolOutputDefinitionClasses(int definitionType) {
        return this.getVoteOutputFactory().getSupportedDefinitionClasses(definitionType);
    }

    public void createRestToolContent(Integer userID, Long toolContentID, JSONObject toolContentJSON) throws JSONException {
        Date updateDate = new Date();
        VoteContent vote = new VoteContent();
        vote.setVoteContentId(toolContentID);
        vote.setContent(toolContentID.toString());
        vote.setTitle(toolContentJSON.getString(RestTags.TITLE));
        vote.setInstructions(toolContentJSON.getString(RestTags.INSTRUCTIONS));
        vote.setCreatedBy(userID.intValue());
        vote.setCreationDate(updateDate);
        vote.setUpdateDate(updateDate);
        vote.setAllowText((Boolean)JsonUtil.opt((JSONObject)toolContentJSON, (String)"allowText", (Object)Boolean.FALSE));
        vote.setDefineLater(false);
        vote.setLockOnFinish((Boolean)JsonUtil.opt((JSONObject)toolContentJSON, (String)RestTags.LOCK_WHEN_FINISHED, (Object)Boolean.FALSE));
        vote.setMaxNominationCount((String)JsonUtil.opt((JSONObject)toolContentJSON, (String)"maxNominations", (Object)"1"));
        vote.setMinNominationCount((String)JsonUtil.opt((JSONObject)toolContentJSON, (String)"minNominations", (Object)"1"));
        vote.setReflect((Boolean)JsonUtil.opt((JSONObject)toolContentJSON, (String)RestTags.REFLECT_ON_ACTIVITY, (Object)Boolean.FALSE));
        vote.setReflectionSubject((String)JsonUtil.opt((JSONObject)toolContentJSON, (String)RestTags.REFLECT_INSTRUCTIONS, (Object)null));
        vote.setShowResults((Boolean)JsonUtil.opt((JSONObject)toolContentJSON, (String)"showResults", (Object)Boolean.TRUE));
        vote.setUseSelectLeaderToolOuput((Boolean)JsonUtil.opt((JSONObject)toolContentJSON, (String)RestTags.USE_SELECT_LEADER_TOOL_OUTPUT, (Object)Boolean.FALSE));
        vote.setAssignedDataFlowObject((Boolean)JsonUtil.opt((JSONObject)toolContentJSON, (String)"assignedDataFlowObject", null));
        vote.setExternalInputsAdded((Short)JsonUtil.opt((JSONObject)toolContentJSON, (String)"externalInputsAdded", null));
        vote.setMaxExternalInputs((Short)JsonUtil.opt((JSONObject)toolContentJSON, (String)"maxInputs", (Object)Short.valueOf("0")));
        JSONArray answers = toolContentJSON.getJSONArray(RestTags.ANSWERS);
        Set newAnswersSet = vote.getVoteQueContents();
        for (int i = 0; i < answers.length(); ++i) {
            String answerJSONData = (String)answers.get(i);
            VoteQueContent answer = new VoteQueContent();
            answer.setDisplayOrder(i + 1);
            answer.setMcContent(vote);
            answer.setQuestion((String)answers.get(i));
            answer.setVoteContent(vote);
            vote.getVoteQueContents().add(answer);
        }
        this.saveVoteContent(vote);
    }
}

