/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dto.VoteQuestionDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.util.VoteComparator;
import org.lamsfoundation.lams.tool.vote.web.form.VoteAuthoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.session.SessionManager;

public class AuthoringUtil
implements VoteAppConstants {
    private static Logger logger = Logger.getLogger((String)AuthoringUtil.class.getName());

    protected static List<VoteQuestionDTO> swapQuestions(List<VoteQuestionDTO> questionDTOs, String questionIndex, String direction) {
        int intQuestionIndex = new Integer(questionIndex);
        int intOriginalQuestionIndex = intQuestionIndex++;
        int replacedQuestionIndex = 0;
        replacedQuestionIndex = direction.equals("down") ? intQuestionIndex : --intQuestionIndex;
        VoteQuestionDTO mainQuestion = AuthoringUtil.getQuestionAtDisplayOrder(questionDTOs, intOriginalQuestionIndex);
        VoteQuestionDTO replacedQuestion = AuthoringUtil.getQuestionAtDisplayOrder(questionDTOs, replacedQuestionIndex);
        LinkedList<VoteQuestionDTO> newQuestionDtos = new LinkedList<VoteQuestionDTO>();
        for (VoteQuestionDTO questionDTO : questionDTOs) {
            VoteQuestionDTO tempQuestion = new VoteQuestionDTO();
            if (!questionDTO.getDisplayOrder().equals(new Integer(intOriginalQuestionIndex).toString()) && !questionDTO.getDisplayOrder().equals(new Integer(replacedQuestionIndex).toString())) {
                tempQuestion = questionDTO;
            } else if (questionDTO.getDisplayOrder().equals(new Integer(intOriginalQuestionIndex).toString())) {
                tempQuestion = replacedQuestion;
            } else if (questionDTO.getDisplayOrder().equals(new Integer(replacedQuestionIndex).toString())) {
                tempQuestion = mainQuestion;
            }
            newQuestionDtos.add(tempQuestion);
        }
        return newQuestionDtos;
    }

    protected static VoteQuestionDTO getQuestionAtDisplayOrder(List<VoteQuestionDTO> questionDTOs, int intOriginalQuestionIndex) {
        for (VoteQuestionDTO voteQuestionDTO : questionDTOs) {
            if (!new Integer(intOriginalQuestionIndex).toString().equals(voteQuestionDTO.getDisplayOrder())) continue;
            return voteQuestionDTO;
        }
        return null;
    }

    protected static List<VoteQuestionDTO> reorderQuestionDTOs(List<VoteQuestionDTO> listQuestionDTO) {
        LinkedList<VoteQuestionDTO> listFinalQuestionDTO = new LinkedList<VoteQuestionDTO>();
        int queIndex = 0;
        for (VoteQuestionDTO voteQuestionDTO : listQuestionDTO) {
            String question = voteQuestionDTO.getNomination();
            String displayOrder = voteQuestionDTO.getDisplayOrder();
            if (question == null || question.equals("")) continue;
            voteQuestionDTO.setNomination(question);
            voteQuestionDTO.setDisplayOrder(new Integer(++queIndex).toString());
            listFinalQuestionDTO.add(voteQuestionDTO);
        }
        return listFinalQuestionDTO;
    }

    public static boolean checkDuplicateNominations(List listQuestionDTO, String newQuestion) {
        Map mapQuestion = AuthoringUtil.extractMapQuestion(listQuestionDTO);
        for (Map.Entry pairs : mapQuestion.entrySet()) {
            if (pairs.getValue() == null || pairs.getValue().equals("") || !pairs.getValue().equals(newQuestion)) continue;
            return true;
        }
        return false;
    }

    protected static Map extractMapQuestion(List listQuestionDTO) {
        TreeMap<String, String> mapQuestion = new TreeMap<String, String>(new VoteComparator());
        Iterator iter = listQuestionDTO.iterator();
        int queIndex = 0;
        while (iter.hasNext()) {
            VoteQuestionDTO voteQuestionDTO = (VoteQuestionDTO)iter.next();
            mapQuestion.put(new Integer(++queIndex).toString(), voteQuestionDTO.getNomination());
        }
        return mapQuestion;
    }

    protected static List reorderUpdateListQuestionDTO(List listQuestionDTO, VoteQuestionDTO voteQuestionDTONew, String editableQuestionIndex) {
        LinkedList<VoteQuestionDTO> listFinalQuestionDTO = new LinkedList<VoteQuestionDTO>();
        int queIndex = 0;
        for (VoteQuestionDTO voteQuestionDTO : listQuestionDTO) {
            ++queIndex;
            String question = voteQuestionDTO.getNomination();
            String displayOrder = voteQuestionDTO.getDisplayOrder();
            if (displayOrder.equals(editableQuestionIndex)) {
                voteQuestionDTO.setNomination(voteQuestionDTONew.getNomination());
                voteQuestionDTO.setDisplayOrder(voteQuestionDTONew.getDisplayOrder());
                listFinalQuestionDTO.add(voteQuestionDTO);
                continue;
            }
            voteQuestionDTO.setNomination(question);
            voteQuestionDTO.setDisplayOrder(displayOrder);
            listFinalQuestionDTO.add(voteQuestionDTO);
        }
        return listFinalQuestionDTO;
    }

    public static VoteContent saveOrUpdateVoteContent(IVoteService voteService, VoteAuthoringForm voteAuthoringForm, HttpServletRequest request, VoteContent voteContent, String strToolContentID) {
        HttpSession ss;
        UserDTO user;
        UserDTO toolUser = (UserDTO)SessionManager.getSession().getAttribute("user");
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        String lockOnFinish = request.getParameter("lockOnFinish");
        String allowTextEntry = request.getParameter("allowText");
        String showResults = request.getParameter("showResults");
        String maxInputs = request.getParameter("maxInputs");
        String useSelectLeaderToolOuput = request.getParameter("useSelectLeaderToolOuput");
        String reflect = request.getParameter("reflect");
        String reflectionSubject = voteAuthoringForm.getReflectionSubject();
        String maxNomcount = voteAuthoringForm.getMaxNominationCount();
        String minNomcount = voteAuthoringForm.getMinNominationCount();
        boolean lockOnFinishBoolean = false;
        boolean allowTextEntryBoolean = false;
        boolean useSelectLeaderToolOuputBoolean = false;
        boolean reflectBoolean = false;
        boolean showResultsBoolean = false;
        short maxInputsShort = 0;
        if (lockOnFinish != null && lockOnFinish.equalsIgnoreCase("1")) {
            lockOnFinishBoolean = true;
        }
        if (allowTextEntry != null && allowTextEntry.equalsIgnoreCase("1")) {
            allowTextEntryBoolean = true;
        }
        if (useSelectLeaderToolOuput != null && useSelectLeaderToolOuput.equalsIgnoreCase("1")) {
            useSelectLeaderToolOuputBoolean = true;
        }
        if (reflect != null && reflect.equalsIgnoreCase("1")) {
            reflectBoolean = true;
        }
        if (showResults != null && showResults.equalsIgnoreCase("1")) {
            showResultsBoolean = true;
        }
        if (maxInputs != null && !"0".equals(maxInputs)) {
            maxInputsShort = Short.parseShort(maxInputs);
        }
        long userId = 0L;
        userId = toolUser != null ? toolUser.getUserID().longValue() : ((user = (UserDTO)(ss = SessionManager.getSession()).getAttribute("user")) != null ? user.getUserID().longValue() : 0L);
        boolean newContent = false;
        if (voteContent == null) {
            voteContent = new VoteContent();
            newContent = true;
        }
        voteContent.setVoteContentId(new Long(strToolContentID));
        voteContent.setTitle(richTextTitle);
        voteContent.setInstructions(richTextInstructions);
        voteContent.setUpdateDate(new Date(System.currentTimeMillis()));
        voteContent.setCreatedBy(userId);
        voteContent.setLockOnFinish(lockOnFinishBoolean);
        voteContent.setAllowText(allowTextEntryBoolean);
        voteContent.setShowResults(showResultsBoolean);
        voteContent.setUseSelectLeaderToolOuput(useSelectLeaderToolOuputBoolean);
        voteContent.setReflect(reflectBoolean);
        voteContent.setMaxNominationCount(maxNomcount);
        voteContent.setMinNominationCount(minNomcount);
        voteContent.setReflectionSubject(reflectionSubject);
        voteContent.setMaxExternalInputs(maxInputsShort);
        if (newContent) {
            voteService.saveVoteContent(voteContent);
        } else {
            voteService.updateVote(voteContent);
        }
        voteContent = voteService.getVoteContent(new Long(strToolContentID));
        return voteContent;
    }
}

