/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dto.ExportPortfolioDTO;
import org.lamsfoundation.lams.tool.vote.dto.ReflectionDTO;
import org.lamsfoundation.lams.tool.vote.dto.SessionDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteMonitoredAnswersDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueUsr;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.lamsfoundation.lams.tool.vote.pojos.VoteUsrAttempt;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteApplicationException;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;

public class ExportServlet
extends AbstractExportPortfolioServlet
implements VoteAppConstants {
    static Logger logger = Logger.getLogger((String)ExportServlet.class.getName());
    private static final long serialVersionUID = -1529093489007108983L;
    private final String FILENAME = "vote_main.html";

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        String basePath = WebUtil.getBaseServerURL() + request.getContextPath();
        if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
            this.learner(request, response, directoryName, cookies);
        } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
            this.teacher(request, response, directoryName, cookies);
        }
        this.writeResponseToFile(basePath + "/export/exportportfolio.jsp", directoryName, "vote_main.html", cookies);
        return "vote_main.html";
    }

    public void learner(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServletContext());
        if (this.userID == null || this.toolSessionID == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new VoteApplicationException(error);
        }
        VoteSession voteSession = voteService.getSessionBySessionId(this.toolSessionID);
        VoteQueUsr learner = voteService.getVoteUserBySession(this.userID, voteSession.getUid());
        ExportPortfolioDTO exportPortfolioDTO = new ExportPortfolioDTO();
        if (learner != null && learner.isFinalScreenRequested()) {
            VoteContent content = voteSession.getVoteContent();
            if (content == null) {
                String error = "The content for this activity has not been defined yet.";
                logger.error((Object)error);
                throw new VoteApplicationException(error);
            }
            LinkedList<SessionDTO> sessionDTOs = this.getSessionDTOs(request, content, voteService, this.toolSessionID, this.userID);
            exportPortfolioDTO.setSessionDtos(sessionDTOs);
            boolean userExceptionNoToolSessions = !voteService.studentActivityOccurredGlobal(content);
            exportPortfolioDTO.setUserExceptionNoToolSessions(userExceptionNoToolSessions);
            boolean isGroupedActivity = voteService.isGroupedActivity(content.getVoteContentId());
            request.getSession().setAttribute("isGroupedActivity", (Object)isGroupedActivity);
            List<ReflectionDTO> reflectionsContainerDTO = voteService.getReflectionData(content, this.userID);
            request.getSession().setAttribute("reflectionsContainerDTO", reflectionsContainerDTO);
        } else {
            exportPortfolioDTO.setUserExceptionNoToolSessions(false);
        }
        exportPortfolioDTO.setPortfolioExportMode("learner");
        request.getSession().setAttribute("exportPortfolioDto", (Object)exportPortfolioDTO);
    }

    public void teacher(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServletContext());
        if (this.toolContentID == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new VoteApplicationException(error);
        }
        VoteContent content = voteService.getVoteContent(this.toolContentID);
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new VoteApplicationException(error);
        }
        ExportPortfolioDTO exportPortfolioDTO = new ExportPortfolioDTO();
        exportPortfolioDTO.setPortfolioExportMode("teacher");
        LinkedList<SessionDTO> sessionDTOs = this.getSessionDTOs(request, content, voteService, null, null);
        exportPortfolioDTO.setSessionDtos(sessionDTOs);
        boolean userExceptionNoToolSessions = !voteService.studentActivityOccurredGlobal(content);
        exportPortfolioDTO.setUserExceptionNoToolSessions(userExceptionNoToolSessions);
        request.getSession().setAttribute("exportPortfolioDto", (Object)exportPortfolioDTO);
        boolean isGroupedActivity = voteService.isGroupedActivity(content.getVoteContentId());
        request.getSession().setAttribute("isGroupedActivity", (Object)isGroupedActivity);
        List<ReflectionDTO> reflectionsContainerDTO = voteService.getReflectionData(content, null);
        request.getSession().setAttribute("reflectionsContainerDTO", reflectionsContainerDTO);
    }

    public LinkedList<SessionDTO> getSessionDTOs(HttpServletRequest request, VoteContent voteContent, IVoteService voteService, Long currentSessionId, Long userId) {
        Set<VoteSession> sessions = new HashSet();
        if (currentSessionId == null) {
            sessions = voteContent.getVoteSessions();
        } else {
            VoteSession voteSession = voteService.getSessionBySessionId(currentSessionId);
            sessions.add(voteSession);
        }
        LinkedList<SessionDTO> sessionDTOs = new LinkedList<SessionDTO>();
        for (VoteSession session : sessions) {
            SessionDTO sessionDTO = new SessionDTO();
            sessionDTO.setSessionId(session.getVoteSessionId().toString());
            sessionDTO.setSessionName(session.getSession_name());
            List<VoteMonitoredAnswersDTO> openVotes = voteService.getOpenVotes(voteContent.getUid(), session.getVoteSessionId(), userId);
            sessionDTO.setOpenVotes(openVotes);
            LinkedList<VoteMonitoredAnswersDTO> answerDTOs = new LinkedList<VoteMonitoredAnswersDTO>();
            for (VoteQueContent question : voteContent.getVoteQueContents()) {
                List<VoteUsrAttempt> userAttempts;
                Long questionUid = question.getUid();
                if (userId == null) {
                    userAttempts = voteService.getAttemptsForQuestionContentAndSessionUid(questionUid, session.getUid());
                } else {
                    VoteQueUsr user = voteService.getVoteUserBySession(userId, session.getUid());
                    userAttempts = voteService.getAttemptsForUserAndQuestionContent(user.getUid(), questionUid);
                }
                HashMap<Integer, VoteUsrAttempt> questionAttempts = new HashMap<Integer, VoteUsrAttempt>();
                Integer i = 0;
                for (VoteUsrAttempt userAttempt : userAttempts) {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                    questionAttempts.put(n, userAttempt);
                }
                VoteMonitoredAnswersDTO answerDTO = new VoteMonitoredAnswersDTO();
                answerDTO.setQuestionUid(question.getUid().toString());
                answerDTO.setQuestion(question.getQuestion());
                answerDTO.setQuestionAttempts(questionAttempts);
                answerDTOs.add(answerDTO);
            }
            sessionDTO.setAnswers(answerDTOs);
            sessionDTOs.add(sessionDTO);
        }
        return sessionDTOs;
    }
}

