/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.learningdesign.DataFlowObject;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralAuthoringDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteQuestionDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;
import org.lamsfoundation.lams.tool.vote.web.AuthoringUtil;
import org.lamsfoundation.lams.tool.vote.web.form.VoteAuthoringForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.util.SessionMap;

public class VoteAction
extends LamsDispatchAction
implements VoteAppConstants {
    private static Logger logger = Logger.getLogger((String)VoteAction.class.getName());

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteUtils.cleanUpUserExceptions(request);
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        if (richTextTitle != null) {
            voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        }
        if (richTextInstructions != null) {
            voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        }
        voteAuthoringForm.resetUserAction();
        return null;
    }

    protected void repopulateRequestParameters(HttpServletRequest request, VoteAuthoringForm voteAuthoringForm, VoteGeneralAuthoringDTO voteGeneralAuthoringDTO) {
        String toolContentID = request.getParameter("toolContentID");
        voteAuthoringForm.setToolContentID(toolContentID);
        voteGeneralAuthoringDTO.setToolContentID(toolContentID);
        String httpSessionID = request.getParameter("httpSessionID");
        voteAuthoringForm.setHttpSessionID(httpSessionID);
        voteGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        String lockOnFinish = request.getParameter("lockOnFinish");
        voteAuthoringForm.setLockOnFinish(lockOnFinish);
        voteGeneralAuthoringDTO.setLockOnFinish(lockOnFinish);
        String useSelectLeaderToolOuput = request.getParameter("useSelectLeaderToolOuput");
        voteAuthoringForm.setUseSelectLeaderToolOuput(useSelectLeaderToolOuput);
        voteGeneralAuthoringDTO.setUseSelectLeaderToolOuput(useSelectLeaderToolOuput);
        String allowText = request.getParameter("allowText");
        voteAuthoringForm.setAllowText(allowText);
        voteGeneralAuthoringDTO.setAllowText(allowText);
        String showResults = request.getParameter("showResults");
        voteAuthoringForm.setShowResults(showResults);
        voteGeneralAuthoringDTO.setShowResults(showResults);
        String maxNominationCount = request.getParameter("maxNominationCount");
        voteAuthoringForm.setMaxNominationCount(maxNominationCount);
        voteGeneralAuthoringDTO.setMaxNominationCount(maxNominationCount);
        String minNominationCount = request.getParameter("minNominationCount");
        voteAuthoringForm.setMinNominationCount(minNominationCount);
        voteGeneralAuthoringDTO.setMinNominationCount(minNominationCount);
        String reflect = request.getParameter("reflect");
        voteAuthoringForm.setReflect(reflect);
        voteGeneralAuthoringDTO.setReflect(reflect);
        String reflectionSubject = request.getParameter("reflectionSubject");
        voteAuthoringForm.setReflectionSubject(reflectionSubject);
        voteGeneralAuthoringDTO.setReflectionSubject(reflectionSubject);
        String maxInputs = request.getParameter("maxInputs");
        if (maxInputs == null) {
            maxInputs = "0";
        }
        voteAuthoringForm.setMaxInputs(new Short(maxInputs));
        ToolAccessMode mode = this.getAccessMode(request);
        request.setAttribute("mode", (Object)mode.toString());
    }

    public ActionForward moveNominationDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        String httpSessionID = voteAuthoringForm.getHttpSessionID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        String questionIndex = request.getParameter("questionIndex");
        List<VoteQuestionDTO> questionDTOs = (List<VoteQuestionDTO>)sessionMap.get((Object)"listQuestionDTO");
        questionDTOs = AuthoringUtil.swapQuestions(questionDTOs, questionIndex, "down");
        questionDTOs = AuthoringUtil.reorderQuestionDTOs(questionDTOs);
        sessionMap.put((Object)"listQuestionDTO", questionDTOs);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        voteAuthoringForm.setTitle(richTextTitle);
        voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        voteGeneralAuthoringDTO.setToolContentID(strToolContentID);
        voteGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setToolContentID(strToolContentID);
        voteAuthoringForm.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionDTO", questionDTOs);
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        return mapping.findForward("load");
    }

    public ActionForward moveNominationUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        String httpSessionID = voteAuthoringForm.getHttpSessionID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        String questionIndex = request.getParameter("questionIndex");
        List<VoteQuestionDTO> questionDTOs = (List<VoteQuestionDTO>)sessionMap.get((Object)"listQuestionDTO");
        questionDTOs = AuthoringUtil.swapQuestions(questionDTOs, questionIndex, "up");
        questionDTOs = AuthoringUtil.reorderQuestionDTOs(questionDTOs);
        sessionMap.put((Object)"listQuestionDTO", questionDTOs);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        voteAuthoringForm.setTitle(richTextTitle);
        voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        voteGeneralAuthoringDTO.setToolContentID(strToolContentID);
        voteGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setToolContentID(strToolContentID);
        voteAuthoringForm.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setCurrentTab("1");
        request.setAttribute("listQuestionDTO", questionDTOs);
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        return mapping.findForward("load");
    }

    public ActionForward removeNomination(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        String httpSessionID = voteAuthoringForm.getHttpSessionID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        String questionIndexToDelete = request.getParameter("questionIndex");
        List questionDTOs = (List)sessionMap.get((Object)"listQuestionDTO");
        LinkedList<VoteQuestionDTO> listFinalQuestionDTO = new LinkedList<VoteQuestionDTO>();
        int queIndex = 0;
        for (VoteQuestionDTO questionDTO : questionDTOs) {
            String questionText = questionDTO.getNomination();
            String displayOrder = questionDTO.getDisplayOrder();
            if (questionText != null && !questionText.equals("") && !displayOrder.equals(questionIndexToDelete)) {
                questionDTO.setDisplayOrder(new Integer(++queIndex).toString());
                listFinalQuestionDTO.add(questionDTO);
            }
            if (questionText == null || questionText.isEmpty() || !displayOrder.equals(questionIndexToDelete)) continue;
            List deletedQuestionDTOs = (List)sessionMap.get((Object)"deletedQuestionDTOs");
            deletedQuestionDTOs.add(questionDTO);
            sessionMap.put((Object)"deletedQuestionDTOs", (Object)deletedQuestionDTOs);
        }
        sessionMap.put((Object)"listQuestionDTO", listFinalQuestionDTO);
        request.setAttribute("listQuestionDTO", listFinalQuestionDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        String strToolContentID = request.getParameter("toolContentID");
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        voteAuthoringForm.setTitle(richTextTitle);
        voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        voteGeneralAuthoringDTO.setToolContentID(strToolContentID);
        voteGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setToolContentID(strToolContentID);
        voteAuthoringForm.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setCurrentTab("1");
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        return mapping.findForward("load");
    }

    public ActionForward newEditableNominationBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        String httpSessionID = voteAuthoringForm.getHttpSessionID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        String questionIndex = request.getParameter("questionIndex");
        voteAuthoringForm.setEditableNominationIndex(questionIndex);
        List questionDTOs = (List)sessionMap.get((Object)"listQuestionDTO");
        String editableNomination = "";
        for (VoteQuestionDTO voteQuestionDTO : questionDTOs) {
            String question = voteQuestionDTO.getNomination();
            String displayOrder = voteQuestionDTO.getDisplayOrder();
            if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(questionIndex)) continue;
            editableNomination = voteQuestionDTO.getNomination();
            break;
        }
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        voteAuthoringForm.setTitle(richTextTitle);
        voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        voteGeneralAuthoringDTO.setEditableNominationText(editableNomination);
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        return mapping.findForward("editNominationBox");
    }

    public ActionForward newNominationBox(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        String httpSessionID = voteAuthoringForm.getHttpSessionID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        voteAuthoringForm.setTitle(richTextTitle);
        voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        return mapping.findForward("newNominationBox");
    }

    public ActionForward addSingleNomination(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean duplicates;
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        String httpSessionID = voteAuthoringForm.getHttpSessionID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        String strToolContentID = request.getParameter("toolContentID");
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        List questionDTOs = (List)sessionMap.get((Object)"listQuestionDTO");
        String newNomination = request.getParameter("newNomination");
        int listSize = questionDTOs.size();
        if (newNomination != null && newNomination.length() > 0 && !(duplicates = AuthoringUtil.checkDuplicateNominations(questionDTOs, newNomination))) {
            VoteQuestionDTO voteQuestionDTO = new VoteQuestionDTO();
            voteQuestionDTO.setDisplayOrder(new Long(listSize + 1).toString());
            voteQuestionDTO.setNomination(newNomination);
            questionDTOs.add(voteQuestionDTO);
        }
        request.setAttribute("listQuestionDTO", (Object)questionDTOs);
        sessionMap.put((Object)"listQuestionDTO", (Object)questionDTOs);
        String richTextTitle = (String)sessionMap.get((Object)"activityTitleKey");
        String richTextInstructions = (String)sessionMap.get((Object)"activityInstructionsKey");
        voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        voteAuthoringForm.setTitle(richTextTitle);
        voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        voteGeneralAuthoringDTO.setToolContentID(strToolContentID);
        voteGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setToolContentID(strToolContentID);
        voteAuthoringForm.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setCurrentTab("1");
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        return mapping.findForward("load");
    }

    public ActionForward saveSingleNomination(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        String httpSessionID = voteAuthoringForm.getHttpSessionID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        String strToolContentID = request.getParameter("toolContentID");
        String editNominationBoxRequest = request.getParameter("editNominationBoxRequest");
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        List questionDTOs = (List)sessionMap.get((Object)"listQuestionDTO");
        String newNomination = request.getParameter("newNomination");
        String editableNominationIndex = request.getParameter("editableNominationIndex");
        if (newNomination != null && newNomination.length() > 0) {
            if (editNominationBoxRequest != null && editNominationBoxRequest.equals("false")) {
                boolean duplicates = AuthoringUtil.checkDuplicateNominations(questionDTOs, newNomination);
                if (!duplicates) {
                    VoteQuestionDTO voteQuestionDTO2 = null;
                    for (VoteQuestionDTO voteQuestionDTO2 : questionDTOs) {
                        String question = voteQuestionDTO2.getNomination();
                        String displayOrder = voteQuestionDTO2.getDisplayOrder();
                        if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(editableNominationIndex)) continue;
                        break;
                    }
                    voteQuestionDTO2.setQuestion(newNomination);
                    voteQuestionDTO2.setDisplayOrder(editableNominationIndex);
                    questionDTOs = AuthoringUtil.reorderUpdateListQuestionDTO(questionDTOs, voteQuestionDTO2, editableNominationIndex);
                }
            } else {
                VoteQuestionDTO voteQuestionDTO3 = null;
                for (VoteQuestionDTO voteQuestionDTO3 : questionDTOs) {
                    String question = voteQuestionDTO3.getNomination();
                    String displayOrder = voteQuestionDTO3.getDisplayOrder();
                    if (displayOrder == null || displayOrder.equals("") || !displayOrder.equals(editableNominationIndex)) continue;
                    break;
                }
                voteQuestionDTO3.setNomination(newNomination);
                voteQuestionDTO3.setDisplayOrder(editableNominationIndex);
                questionDTOs = AuthoringUtil.reorderUpdateListQuestionDTO(questionDTOs, voteQuestionDTO3, editableNominationIndex);
            }
        }
        request.setAttribute("listQuestionDTO", (Object)questionDTOs);
        sessionMap.put((Object)"listQuestionDTO", (Object)questionDTOs);
        String richTextTitle = (String)sessionMap.get((Object)"activityTitleKey");
        String richTextInstructions = (String)sessionMap.get((Object)"activityInstructionsKey");
        voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        voteAuthoringForm.setTitle(richTextTitle);
        voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        voteGeneralAuthoringDTO.setToolContentID(strToolContentID);
        voteGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setToolContentID(strToolContentID);
        voteAuthoringForm.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setCurrentTab("1");
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        return mapping.findForward("load");
    }

    public ActionForward submitAllContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String maxNomCount;
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        String httpSessionID = voteAuthoringForm.getHttpSessionID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(httpSessionID);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        String strToolContentID = request.getParameter("toolContentID");
        List questionDTOs = (List)sessionMap.get((Object)"listQuestionDTO");
        ActionMessages errors = new ActionMessages();
        if (questionDTOs.isEmpty() && (voteAuthoringForm.getAssignedDataFlowObject() == null || voteAuthoringForm.getAssignedDataFlowObject() == 0)) {
            ActionMessage error = new ActionMessage("nominations.none.submitted");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        if ((maxNomCount = voteAuthoringForm.getMaxNominationCount()) != null) {
            if (maxNomCount.equals("0") || maxNomCount.contains("-")) {
                ActionMessage error = new ActionMessage("maxNomination.invalid");
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
            }
            try {
                int error = new Integer(maxNomCount);
            }
            catch (NumberFormatException e) {
                ActionMessage error = new ActionMessage("maxNomination.invalid");
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
            }
        }
        Map mapQuestion = AuthoringUtil.extractMapQuestion(questionDTOs);
        int optionCount = 0;
        boolean isNominationsDuplicate = false;
        for (long i = 1L; i <= 10L; ++i) {
            String currentOption = (String)mapQuestion.get(new Long(i).toString());
            optionCount = 0;
            for (long j = 1L; j <= 10L; ++j) {
                String backedOption = (String)mapQuestion.get(new Long(j).toString());
                if (currentOption == null || backedOption == null) continue;
                if (currentOption.equals(backedOption)) {
                    ++optionCount;
                }
                if (optionCount <= 1) continue;
                isNominationsDuplicate = true;
            }
        }
        if (isNominationsDuplicate) {
            ActionMessage error = new ActionMessage("nominations.duplicate");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
        }
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        this.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        DataFlowObject assignedDataFlowObject = null;
        List<DataFlowObject> dataFlowObjects = voteService.getDataFlowObjects(new Long(strToolContentID));
        ArrayList<String> dataFlowObjectNames = null;
        if (dataFlowObjects != null) {
            dataFlowObjectNames = new ArrayList<String>(dataFlowObjects.size());
            int objectIndex = 1;
            for (DataFlowObject dataFlowObject : dataFlowObjects) {
                dataFlowObjectNames.add(dataFlowObject.getDisplayName());
                if (VoteAppConstants.DATA_FLOW_OBJECT_ASSIGMENT_ID.equals(dataFlowObject.getToolAssigmentId())) {
                    voteAuthoringForm.setAssignedDataFlowObject(objectIndex);
                }
                ++objectIndex;
            }
        }
        voteGeneralAuthoringDTO.setDataFlowObjectNames(dataFlowObjectNames);
        if (voteAuthoringForm.getAssignedDataFlowObject() != null && voteAuthoringForm.getAssignedDataFlowObject() != 0) {
            assignedDataFlowObject = dataFlowObjects.get(voteAuthoringForm.getAssignedDataFlowObject() - 1);
        }
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        String richTextTitle = request.getParameter("title");
        String richTextInstructions = request.getParameter("instructions");
        voteGeneralAuthoringDTO.setActivityTitle(richTextTitle);
        voteAuthoringForm.setTitle(richTextTitle);
        voteGeneralAuthoringDTO.setActivityInstructions(richTextInstructions);
        sessionMap.put((Object)"activityTitleKey", (Object)richTextTitle);
        sessionMap.put((Object)"activityInstructionsKey", (Object)richTextInstructions);
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        VoteContent voteContentTest = voteService.getVoteContent(new Long(strToolContentID));
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            logger.error((Object)("errors saved: " + errors));
        }
        if (errors.isEmpty()) {
            ToolAccessMode mode = this.getAccessMode(request);
            request.setAttribute("mode", (Object)mode.toString());
            List deletedQuestionDTOs = (List)sessionMap.get((Object)"deletedQuestionDTOs");
            if (mode.isTeacher()) {
                Set oldQuestions = voteContentTest.getVoteQueContents();
                voteService.removeQuestionsFromCache(voteContentTest);
                VoteUtils.setDefineLater(request, false, strToolContentID, voteService);
                voteService.recalculateUserAnswers(voteContentTest, oldQuestions, questionDTOs, deletedQuestionDTOs);
            }
            for (VoteQuestionDTO deletedQuestionDTO : deletedQuestionDTOs) {
                VoteQueContent removeableQuestion = voteService.getVoteQueContentByUID(deletedQuestionDTO.getUid());
                if (removeableQuestion == null) continue;
                voteContentTest.getVoteQueContents().remove(removeableQuestion);
                voteService.removeVoteQueContent(removeableQuestion);
            }
            VoteContent voteContent = AuthoringUtil.saveOrUpdateVoteContent(voteService, voteAuthoringForm, request, voteContentTest, strToolContentID);
            voteContent = voteService.createQuestions(questionDTOs, voteContent);
            voteService.saveDataFlowObjectAssigment(assignedDataFlowObject);
            List sortedQuestions = voteService.getAllQuestionsSorted(voteContent.getUid());
            for (VoteQueContent question : sortedQuestions) {
                VoteQueContent existingQuestion = voteService.getQuestionByUid(question.getUid());
                voteService.saveOrUpdateVoteQueContent(existingQuestion);
            }
            request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        }
        voteAuthoringForm.resetUserAction();
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        request.setAttribute("listQuestionDTO", (Object)questionDTOs);
        sessionMap.put((Object)"listQuestionDTO", (Object)questionDTOs);
        request.getSession().setAttribute(httpSessionID, (Object)sessionMap);
        voteGeneralAuthoringDTO.setToolContentID(strToolContentID);
        voteGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setToolContentID(strToolContentID);
        voteAuthoringForm.setHttpSessionID(httpSessionID);
        voteAuthoringForm.setCurrentTab("1");
        return mapping.findForward("load");
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }
}

