/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.tool.vote.dto.SessionDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class VoteChartGeneratorAction
extends LamsDispatchAction {
    private static IVoteService voteService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException {
        String currentSessionId = request.getParameter("currentSessionId");
        Map<Object, Object> nominationNames = new HashMap();
        Map<Object, Object> nominationVotes = new HashMap();
        if ("0".equals(currentSessionId)) {
            long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
            LinkedList<SessionDTO> sessionDTOs = this.getVoteService().getSessionDTOs(toolContentID);
            SessionDTO allSessionsSummary = sessionDTOs.getFirst();
            if ("0".equals(allSessionsSummary.getSessionId())) {
                nominationNames = allSessionsSummary.getMapStandardNominationsHTMLedContent();
                nominationVotes = allSessionsSummary.getMapStandardRatesContent();
                for (Long index : nominationNames.keySet()) {
                    String name = (String)nominationNames.get(index);
                    String noHTMLNomination = VoteUtils.stripHTML(name);
                    nominationNames.put(index, noHTMLNomination);
                }
            }
        } else if (!StringUtils.isBlank((String)currentSessionId)) {
            VoteSession voteSession = this.getVoteService().getSessionBySessionId(new Long(currentSessionId));
            VoteContent voteContent = voteSession.getVoteContent();
            VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = this.getVoteService().prepareChartData(request, voteContent.getVoteContentId(), voteSession.getUid(), new VoteGeneralLearnerFlowDTO());
            nominationNames = voteGeneralLearnerFlowDTO.getMapStandardNominationsContent();
            nominationVotes = voteGeneralLearnerFlowDTO.getMapStandardRatesContent();
        }
        JSONObject responseJSON = new JSONObject();
        for (Long index : nominationNames.keySet()) {
            JSONObject nomination = new JSONObject();
            nomination.put("name", nominationNames.get(index));
            nomination.put("value", nominationVotes.get(index));
            responseJSON.append("data", (Object)nomination);
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    private IVoteService getVoteService() {
        if (voteService == null) {
            voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        }
        return voteService;
    }
}

