/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueUsr;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.lamsfoundation.lams.tool.vote.pojos.VoteUsrAttempt;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteApplicationException;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.tool.vote.util.VoteComparator;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;
import org.lamsfoundation.lams.tool.vote.web.form.VoteLearningForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class VoteLearningAction
extends LamsDispatchAction
implements VoteAppConstants {
    static Logger logger = Logger.getLogger((String)VoteLearningAction.class.getName());

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        voteLearningForm.setNominationsSubmited(new Boolean(false).toString());
        this.repopulateRequestParameters(request, voteLearningForm);
        VoteUtils.cleanUpUserExceptions(request);
        voteLearningForm.setMaxNominationCountReached(new Boolean(false).toString());
        voteLearningForm.setMinNominationCountReached(new Boolean(false).toString());
        return null;
    }

    public ActionForward viewAllResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteUtils.cleanUpUserExceptions(request);
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        voteLearningForm.setNominationsSubmited(new Boolean(false).toString());
        voteLearningForm.setMaxNominationCountReached(new Boolean(false).toString());
        voteLearningForm.setMinNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setNominationsSubmited(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMaxNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMinNominationCountReached(new Boolean(false).toString());
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        this.repopulateRequestParameters(request, voteLearningForm);
        String toolSessionID = request.getParameter("toolSessionID");
        voteLearningForm.setToolSessionID(toolSessionID);
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        VoteSession voteSession = voteService.getSessionBySessionId(new Long(toolSessionID));
        VoteContent voteContent = voteSession.getVoteContent();
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralLearnerFlowDTO.setActivityInstructions(voteContent.getInstructions());
        Long toolContentID = voteContent.getVoteContentId();
        Long toolSessionUid = voteSession.getUid();
        VoteQueUsr existingVoteQueUsr = voteService.getVoteUserBySession(new Long(userID), voteSession.getUid());
        existingVoteQueUsr.setFinalScreenRequested(true);
        voteService.updateVoteUser(existingVoteQueUsr);
        Set<String> userAttempts = voteService.getAttemptsForUserAndSession(existingVoteQueUsr.getUid(), toolSessionUid);
        request.setAttribute("listGeneralCheckedOptionsContent", userAttempts);
        voteService.prepareChartData(request, toolContentID, toolSessionUid, voteGeneralLearnerFlowDTO);
        voteGeneralLearnerFlowDTO.setReflection(new Boolean(voteContent.isReflect()).toString());
        voteGeneralLearnerFlowDTO.setReflectionSubject(voteContent.getReflectionSubject());
        voteLearningForm.resetCommands();
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        LearningWebUtil.putActivityPositionInRequestByToolSessionId((Long)new Long(toolSessionID), (HttpServletRequest)request, (ServletContext)this.getServlet().getServletContext());
        return mapping.findForward("allNominations");
    }

    public ActionForward viewAnswers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteUtils.cleanUpUserExceptions(request);
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        voteLearningForm.setNominationsSubmited(new Boolean(false).toString());
        voteLearningForm.setMaxNominationCountReached(new Boolean(false).toString());
        voteLearningForm.setMinNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setNominationsSubmited(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMaxNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMinNominationCountReached(new Boolean(false).toString());
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        this.repopulateRequestParameters(request, voteLearningForm);
        String toolSessionID = request.getParameter("toolSessionID");
        voteLearningForm.setToolSessionID(toolSessionID);
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        String revisitingUser = request.getParameter("revisitingUser");
        voteLearningForm.setRevisitingUser(revisitingUser);
        VoteSession voteSession = voteService.getSessionBySessionId(new Long(toolSessionID));
        VoteContent voteContent = voteSession.getVoteContent();
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralLearnerFlowDTO.setActivityInstructions(voteContent.getInstructions());
        if (revisitingUser.equals("true")) {
            HttpSession ss = SessionManager.getSession();
            UserDTO toolUser = (UserDTO)ss.getAttribute("user");
            long userId = toolUser.getUserID().longValue();
            VoteQueUsr voteQueUsr = voteService.getUserByUserId(userId);
            List attempts = voteService.getAttemptsForUser(voteQueUsr.getUid());
            TreeMap<String, String> mapQuestionsContent = new TreeMap<String, String>(new VoteComparator());
            Iterator listIterator = attempts.iterator();
            int order = 0;
            while (listIterator.hasNext()) {
                VoteUsrAttempt attempt = (VoteUsrAttempt)listIterator.next();
                VoteQueContent voteQueContent = attempt.getVoteQueContent();
                ++order;
                if (voteQueContent == null) continue;
                mapQuestionsContent.put(new Integer(order).toString(), voteQueContent.getQuestion());
            }
            request.setAttribute("mapGeneralCheckedOptionsContent", mapQuestionsContent);
        }
        voteLearningForm.resetCommands();
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        LearningWebUtil.putActivityPositionInRequestByToolSessionId((Long)new Long(toolSessionID), (HttpServletRequest)request, (ServletContext)this.getServlet().getServletContext());
        return mapping.findForward("viewAnswers");
    }

    public ActionForward redoQuestionsOk(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteUtils.cleanUpUserExceptions(request);
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        this.repopulateRequestParameters(request, voteLearningForm);
        String toolSessionID = request.getParameter("toolSessionID");
        voteLearningForm.setToolSessionID(toolSessionID);
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        String revisitingUser = request.getParameter("revisitingUser");
        voteLearningForm.setRevisitingUser(revisitingUser);
        voteLearningForm.setNominationsSubmited(new Boolean(false).toString());
        voteLearningForm.setMaxNominationCountReached(new Boolean(false).toString());
        voteLearningForm.setMinNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setNominationsSubmited(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMaxNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMinNominationCountReached(new Boolean(false).toString());
        VoteSession voteSession = voteService.getSessionBySessionId(new Long(toolSessionID));
        VoteContent voteContent = voteSession.getVoteContent();
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralLearnerFlowDTO.setActivityInstructions(voteContent.getInstructions());
        voteGeneralLearnerFlowDTO.setReflection(new Boolean(voteContent.isReflect()).toString());
        voteGeneralLearnerFlowDTO.setReflectionSubject(voteContent.getReflectionSubject());
        voteLearningForm.resetCommands();
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        return this.redoQuestions(mapping, form, request, response);
    }

    public ActionForward learnerFinished(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        voteLearningForm.setNominationsSubmited(new Boolean(false).toString());
        voteLearningForm.setMaxNominationCountReached(new Boolean(false).toString());
        voteLearningForm.setMinNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setNominationsSubmited(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMaxNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMinNominationCountReached(new Boolean(false).toString());
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        this.repopulateRequestParameters(request, voteLearningForm);
        String toolSessionID = request.getParameter("toolSessionID");
        voteLearningForm.setToolSessionID(toolSessionID);
        VoteSession voteSession = voteService.getSessionBySessionId(new Long(toolSessionID));
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        VoteQueUsr voteQueUsr = voteService.getVoteUserBySession(new Long(userID), voteSession.getUid());
        voteQueUsr.setResponseFinalised(true);
        if (!voteSession.getVoteContent().isShowResults()) {
            voteQueUsr.setFinalScreenRequested(true);
        }
        voteService.updateVoteUser(voteQueUsr);
        String revisitingUser = request.getParameter("revisitingUser");
        voteLearningForm.setRevisitingUser(revisitingUser);
        VoteContent voteContent = voteSession.getVoteContent();
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralLearnerFlowDTO.setActivityInstructions(voteContent.getInstructions());
        voteGeneralLearnerFlowDTO.setReflection(new Boolean(voteContent.isReflect()).toString());
        voteGeneralLearnerFlowDTO.setReflectionSubject(voteContent.getReflectionSubject());
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        VoteUtils.cleanUpUserExceptions(request);
        String nextUrl = null;
        try {
            nextUrl = voteService.leaveToolSession(new Long(toolSessionID), new Long(userID));
        }
        catch (DataMissingException e) {
            logger.error((Object)("failure getting nextUrl: " + (Object)((Object)e)));
            voteLearningForm.resetCommands();
            return mapping.findForward("learningStarter");
        }
        catch (ToolException e) {
            logger.error((Object)("failure getting nextUrl: " + (Object)((Object)e)));
            voteLearningForm.resetCommands();
            return mapping.findForward("learningStarter");
        }
        catch (Exception e) {
            logger.error((Object)("unknown exception getting nextUrl: " + e));
            voteLearningForm.resetCommands();
            return mapping.findForward("learningStarter");
        }
        voteLearningForm.resetCommands();
        response.sendRedirect(nextUrl);
        return null;
    }

    public ActionForward continueOptionsCombined(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        TreeMap mapLeanerCheckedOptionsContent;
        int castVoteCount;
        VoteUtils.cleanUpUserExceptions(request);
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        this.repopulateRequestParameters(request, voteLearningForm);
        String toolSessionID = request.getParameter("toolSessionID");
        voteLearningForm.setToolSessionID(toolSessionID);
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        String maxNominationCount = request.getParameter("maxNominationCount");
        voteLearningForm.setMaxNominationCount(maxNominationCount);
        String minNominationCount = request.getParameter("minNominationCount");
        voteLearningForm.setMinNominationCount(minNominationCount);
        String userEntry = request.getParameter("userEntry");
        voteLearningForm.setUserEntry(userEntry);
        VoteSession session = voteService.getSessionBySessionId(new Long(toolSessionID));
        voteLearningForm.setNominationsSubmited(new Boolean(false).toString());
        voteLearningForm.setMaxNominationCountReached(new Boolean(false).toString());
        voteLearningForm.setMinNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setNominationsSubmited(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMaxNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMinNominationCountReached(new Boolean(false).toString());
        Collection<String> voteDisplayOrderIds = voteLearningForm.votesAsCollection();
        int n = castVoteCount = voteDisplayOrderIds != null ? voteDisplayOrderIds.size() : 0;
        if (userEntry != null && userEntry.length() > 0) {
            ++castVoteCount;
        }
        int intMaxNominationCount = 0;
        if (maxNominationCount != null) {
            intMaxNominationCount = new Integer(maxNominationCount);
        }
        if (castVoteCount > intMaxNominationCount) {
            voteLearningForm.setMaxNominationCountReached(new Boolean(true).toString());
            voteGeneralLearnerFlowDTO.setMaxNominationCountReached(new Boolean(true).toString());
            this.persistInRequestError(request, "error.maxNominationCount.reached");
            return mapping.findForward("loadLearner");
        }
        VoteContent voteContent = session.getVoteContent();
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralLearnerFlowDTO.setActivityInstructions(voteContent.getInstructions());
        Long toolContentID = voteContent.getVoteContentId();
        Long voteContentUid = voteContent.getUid();
        boolean userEntryAvailable = false;
        if (userEntry != null && userEntry.length() > 0) {
            userEntryAvailable = true;
        }
        Long toolSessionUid = session.getUid();
        VoteQueUsr user = voteService.getVoteUserBySession(new Long(userID), session.getUid());
        if (user == null) {
            throw new VoteApplicationException("User with userId= " + userID + " and sessionUid= " + session.getUid() + " doesn't exist.");
        }
        voteService.removeAttemptsForUserandSession(user.getUid(), session.getUid());
        Map<String, String> mapGeneralCheckedOptionsContent = voteService.buildQuestionMap(voteContent, voteDisplayOrderIds);
        if (mapGeneralCheckedOptionsContent.size() > 0) {
            voteService.createAttempt(user, mapGeneralCheckedOptionsContent, "", session, voteContentUid);
        }
        if (mapGeneralCheckedOptionsContent.size() == 0 && userEntryAvailable) {
            mapLeanerCheckedOptionsContent = new TreeMap(new VoteComparator());
            if (userEntry.length() > 0) {
                voteService.createAttempt(user, mapLeanerCheckedOptionsContent, userEntry, session, voteContentUid);
            }
        }
        if (mapGeneralCheckedOptionsContent.size() > 0 && userEntryAvailable) {
            mapLeanerCheckedOptionsContent = new TreeMap(new VoteComparator());
            if (userEntry.length() > 0) {
                voteService.createAttempt(user, mapLeanerCheckedOptionsContent, userEntry, session, voteContentUid);
            }
        }
        request.setAttribute("mapGeneralCheckedOptionsContent", mapGeneralCheckedOptionsContent);
        voteLearningForm.setMapGeneralCheckedOptionsContent(mapGeneralCheckedOptionsContent);
        voteGeneralLearnerFlowDTO.setMapGeneralCheckedOptionsContent(mapGeneralCheckedOptionsContent);
        voteLearningForm.setNominationsSubmited(new Boolean(true).toString());
        voteGeneralLearnerFlowDTO.setNominationsSubmited(new Boolean(true).toString());
        voteService.prepareChartData(request, toolContentID, toolSessionUid, voteGeneralLearnerFlowDTO);
        voteGeneralLearnerFlowDTO.setReflection(new Boolean(voteContent.isReflect()).toString());
        voteGeneralLearnerFlowDTO.setReflectionSubject(voteContent.getReflectionSubject());
        voteLearningForm.resetCommands();
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        return mapping.findForward("individualReport");
    }

    public ActionForward redoQuestions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteUtils.cleanUpUserExceptions(request);
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        this.repopulateRequestParameters(request, voteLearningForm);
        String toolSessionID = request.getParameter("toolSessionID");
        voteLearningForm.setToolSessionID(toolSessionID);
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        String revisitingUser = request.getParameter("revisitingUser");
        voteLearningForm.setRevisitingUser(revisitingUser);
        VoteSession voteSession = voteService.getSessionBySessionId(new Long(toolSessionID));
        VoteContent voteContent = voteSession.getVoteContent();
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralLearnerFlowDTO.setActivityInstructions(voteContent.getInstructions());
        voteLearningForm.setNominationsSubmited(new Boolean(false).toString());
        voteLearningForm.setMaxNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setNominationsSubmited(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setMaxNominationCountReached(new Boolean(false).toString());
        Map<String, String> mapQuestionsContent = voteService.buildQuestionMap(voteContent, null);
        request.setAttribute("mapQuestionContentLearner", mapQuestionsContent);
        TreeMap mapGeneralCheckedOptionsContent = new TreeMap(new VoteComparator());
        request.setAttribute("mapGeneralCheckedOptionsContent", mapGeneralCheckedOptionsContent);
        voteLearningForm.setUserEntry("");
        voteGeneralLearnerFlowDTO.setReflection(new Boolean(voteContent.isReflect()).toString());
        voteGeneralLearnerFlowDTO.setReflectionSubject(voteContent.getReflectionSubject());
        voteLearningForm.resetCommands();
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        return mapping.findForward("loadLearner");
    }

    public void persistInRequestError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        this.saveErrors(request, errors);
    }

    public ActionForward checkLeaderProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException {
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        Long toolSessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        VoteSession session = voteService.getSessionBySessionId(toolSessionId);
        VoteQueUsr leader = session.getGroupLeader();
        boolean isLeaderResponseFinalized = leader.isResponseFinalised();
        JSONObject JSONObject2 = new JSONObject();
        JSONObject2.put("isLeaderResponseFinalized", isLeaderResponseFinalized);
        response.setContentType("application/x-json;charset=utf-8");
        response.getWriter().print(JSONObject2);
        return null;
    }

    public ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        this.repopulateRequestParameters(request, voteLearningForm);
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        String toolSessionID = request.getParameter("toolSessionID");
        voteLearningForm.setToolSessionID(toolSessionID);
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        String reflectionEntry = request.getParameter("entryText");
        logger.info((Object)("reflection entry: " + reflectionEntry));
        voteService.createNotebookEntry(new Long(toolSessionID), CoreNotebookConstants.NOTEBOOK_TOOL, "lavote11", new Integer(userID), reflectionEntry);
        voteLearningForm.resetUserActions();
        return this.learnerFinished(mapping, form, request, response);
    }

    public ActionForward forwardtoReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        String toolSessionID = request.getParameter("toolSessionID");
        VoteSession voteSession = voteService.getSessionBySessionId(new Long(toolSessionID));
        VoteContent voteContent = voteSession.getVoteContent();
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        String reflectionSubject = voteContent.getReflectionSubject();
        voteGeneralLearnerFlowDTO.setReflectionSubject(voteContent.getReflectionSubject());
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        NotebookEntry notebookEntry = voteService.getEntry(new Long(toolSessionID), CoreNotebookConstants.NOTEBOOK_TOOL, "lavote11", new Integer(userID));
        if (notebookEntry != null) {
            String notebookEntryPresentable = notebookEntry.getEntry();
            voteGeneralLearnerFlowDTO.setNotebookEntry(notebookEntryPresentable);
            voteLearningForm.setEntryText(notebookEntryPresentable);
        }
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        voteLearningForm.resetCommands();
        LearningWebUtil.putActivityPositionInRequestByToolSessionId((Long)new Long(toolSessionID), (HttpServletRequest)request, (ServletContext)this.getServlet().getServletContext());
        return mapping.findForward("notebook");
    }

    protected void repopulateRequestParameters(HttpServletRequest request, VoteLearningForm voteLearningForm) {
        String toolSessionID = request.getParameter("toolSessionID");
        voteLearningForm.setToolSessionID(toolSessionID);
        String userID = request.getParameter("userID");
        voteLearningForm.setUserID(userID);
        String revisitingUser = request.getParameter("revisitingUser");
        voteLearningForm.setRevisitingUser(revisitingUser);
        String previewOnly = request.getParameter("previewOnly");
        voteLearningForm.setPreviewOnly(previewOnly);
        String maxNominationCount = request.getParameter("maxNominationCount");
        voteLearningForm.setMaxNominationCount(maxNominationCount);
        String minNominationCount = request.getParameter("minNominationCount");
        voteLearningForm.setMinNominationCount(minNominationCount);
        String useSelectLeaderToolOuput = request.getParameter("useSelectLeaderToolOuput");
        voteLearningForm.setUseSelectLeaderToolOuput(useSelectLeaderToolOuput);
        String allowTextEntry = request.getParameter("allowTextEntry");
        voteLearningForm.setAllowTextEntry(allowTextEntry);
        String showResults = request.getParameter("showResults");
        voteLearningForm.setShowResults(showResults);
        String lockOnFinish = request.getParameter("lockOnFinish");
        voteLearningForm.setLockOnFinish(lockOnFinish);
        String reportViewOnly = request.getParameter("reportViewOnly");
        voteLearningForm.setReportViewOnly(reportViewOnly);
        String userEntry = request.getParameter("userEntry");
        voteLearningForm.setUserEntry(userEntry);
        String groupLeaderName = request.getParameter("groupLeaderName");
        voteLearningForm.setGroupLeaderName(groupLeaderName);
        boolean isUserLeader = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"userLeader");
        voteLearningForm.setIsUserLeader(isUserLeader);
    }

    private MessageService getMessageService() {
        return VoteServiceProxy.getMessageService(this.getServlet().getServletContext());
    }
}

