/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.learning.web.util.LearningWebUtil;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueUsr;
import org.lamsfoundation.lams.tool.vote.pojos.VoteSession;
import org.lamsfoundation.lams.tool.vote.pojos.VoteUsrAttempt;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteApplicationException;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.tool.vote.util.VoteComparator;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;
import org.lamsfoundation.lams.tool.vote.web.form.VoteLearningForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class VoteLearningStarterAction
extends Action
implements VoteAppConstants {
    private static Logger logger = Logger.getLogger((String)VoteLearningStarterAction.class.getName());
    private static IVoteService voteService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, VoteApplicationException {
        Long sessionUid;
        VoteUtils.cleanUpUserExceptions(request);
        if (voteService == null) {
            voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        }
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        VoteLearningForm voteLearningForm = (VoteLearningForm)form;
        voteLearningForm.setRevisitingUser(new Boolean(false).toString());
        voteLearningForm.setUserEntry("");
        voteLearningForm.setCastVoteCount(0);
        voteLearningForm.setMaxNominationCountReached(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setRevisitingUser(new Boolean(false).toString());
        voteGeneralLearnerFlowDTO.setUserEntry("");
        voteGeneralLearnerFlowDTO.setCastVoteCount("0");
        voteGeneralLearnerFlowDTO.setMaxNominationCountReached(new Boolean(false).toString());
        ActionForward validateParameters = this.validateParameters(request, mapping, voteLearningForm);
        if (validateParameters != null) {
            return validateParameters;
        }
        String toolSessionID = voteLearningForm.getToolSessionID();
        VoteSession voteSession = voteService.getSessionBySessionId(new Long(toolSessionID));
        if (voteSession == null) {
            VoteUtils.cleanUpUserExceptions(request);
            logger.error((Object)"error: The tool expects voteSession.");
            return mapping.findForward("errorList");
        }
        VoteContent voteContent = voteSession.getVoteContent();
        if (voteContent == null) {
            VoteUtils.cleanUpUserExceptions(request);
            logger.error((Object)"error: The tool expects voteContent.");
            this.persistInRequestError(request, "error.content.doesNotExist");
            return mapping.findForward("errorList");
        }
        this.setupAttributes(request, voteContent, voteLearningForm, voteGeneralLearnerFlowDTO);
        voteLearningForm.setToolContentID(voteContent.getVoteContentId().toString());
        voteGeneralLearnerFlowDTO.setToolContentID(voteContent.getVoteContentId().toString());
        voteLearningForm.setToolContentUID(voteContent.getUid().toString());
        voteGeneralLearnerFlowDTO.setToolContentUID(voteContent.getUid().toString());
        voteGeneralLearnerFlowDTO.setReflection(new Boolean(voteContent.isReflect()).toString());
        voteGeneralLearnerFlowDTO.setReflectionSubject(voteContent.getReflectionSubject());
        String mode = voteLearningForm.getLearningMode();
        voteGeneralLearnerFlowDTO.setLearningMode(mode);
        String userId = voteLearningForm.getUserID();
        NotebookEntry notebookEntry = voteService.getEntry(new Long(toolSessionID), CoreNotebookConstants.NOTEBOOK_TOOL, "lavote11", new Integer(userId));
        if (notebookEntry != null) {
            voteGeneralLearnerFlowDTO.setNotebookEntry(notebookEntry.getEntry());
        }
        Map<String, String> mapQuestions = voteService.buildQuestionMap(voteContent, null);
        request.setAttribute("mapQuestionContentLearner", mapQuestions);
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        VoteQueUsr user = null;
        user = mode != null && mode.equals(ToolAccessMode.TEACHER.toString()) ? this.getSpecifiedUser(toolSessionID, WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)false)) : this.getCurrentUser(toolSessionID);
        Date submissionDeadline = voteContent.getSubmissionDeadline();
        if (submissionDeadline != null) {
            request.setAttribute("submissionDeadline", (Object)submissionDeadline);
            HttpSession ss = SessionManager.getSession();
            UserDTO learnerDto = (UserDTO)ss.getAttribute("user");
            TimeZone learnerTimeZone = learnerDto.getTimeZone();
            Date tzSubmissionDeadline = DateUtil.convertToTimeZoneFromDefault((TimeZone)learnerTimeZone, (Date)submissionDeadline);
            Date currentLearnerDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)learnerTimeZone, (Date)new Date());
            voteGeneralLearnerFlowDTO.setSubmissionDeadline(tzSubmissionDeadline);
            if (currentLearnerDate.after(tzSubmissionDeadline)) {
                return mapping.findForward("submissionDeadline");
            }
        }
        LearningWebUtil.putActivityPositionInRequestByToolSessionId((Long)new Long(toolSessionID), (HttpServletRequest)request, (ServletContext)this.getServlet().getServletContext());
        if (voteContent.isDefineLater()) {
            VoteUtils.cleanUpUserExceptions(request);
            return mapping.findForward("defineLater");
        }
        VoteQueUsr groupLeader = null;
        if (voteContent.isUseSelectLeaderToolOuput()) {
            groupLeader = voteService.checkLeaderSelectToolForSessionLeader(user, new Long(toolSessionID));
            if (groupLeader == null && !mode.equals(ToolAccessMode.TEACHER.toString())) {
                Set groupUsers = voteSession.getVoteQueUsers();
                request.setAttribute("groupUsers", (Object)groupUsers);
                request.setAttribute("toolSessionID", (Object)toolSessionID);
                request.setAttribute("content", (Object)voteContent);
                return mapping.findForward("waitForLeader");
            }
            if (groupLeader.isResponseFinalised() && !mode.equals(ToolAccessMode.TEACHER.toString())) {
                voteService.copyAnswersFromLeader(user, groupLeader);
                user.setFinalScreenRequested(true);
                user.setResponseFinalised(true);
                voteService.updateVoteUser(user);
            }
            voteLearningForm.setGroupLeaderName(groupLeader.getFullname());
            boolean isUserLeader = voteService.isUserGroupLeader(user, new Long(toolSessionID));
            voteLearningForm.setIsUserLeader(isUserLeader);
        }
        if (mode.equals("teacher")) {
            sessionUid = user.getVoteSessionId();
            this.putMapQuestionsContentIntoRequest(request, voteService, user);
            Set<String> userAttempts = voteService.getAttemptsForUserAndSessionUseOpenAnswer(user.getUid(), sessionUid);
            request.setAttribute("listGeneralCheckedOptionsContent", userAttempts);
            voteLearningForm.setReportViewOnly(new Boolean(true).toString());
            voteGeneralLearnerFlowDTO.setReportViewOnly(new Boolean(true).toString());
            voteService.prepareChartData(request, voteContent.getVoteContentId(), voteSession.getUid(), voteGeneralLearnerFlowDTO);
            boolean isGroupedActivity = voteService.isGroupedActivity(new Long(voteLearningForm.getToolContentID()));
            request.setAttribute("isGroupedActivity", (Object)isGroupedActivity);
            return mapping.findForward("exitPage");
        }
        if (user.isFinalScreenRequested()) {
            sessionUid = user.getVoteSessionId();
            VoteSession voteUserSession = voteService.getVoteSessionByUID(sessionUid);
            String userSessionId = voteUserSession.getVoteSessionId().toString();
            if (toolSessionID.toString().equals(userSessionId)) {
                this.putMapQuestionsContentIntoRequest(request, voteService, user);
                boolean isResponseFinalised = user.isResponseFinalised();
                if (isResponseFinalised) {
                    voteLearningForm.setReportViewOnly(new Boolean(true).toString());
                    voteGeneralLearnerFlowDTO.setReportViewOnly(new Boolean(true).toString());
                }
                Set<String> userAttempts = voteService.getAttemptsForUserAndSessionUseOpenAnswer(user.getUid(), sessionUid);
                request.setAttribute("listGeneralCheckedOptionsContent", userAttempts);
                voteService.prepareChartData(request, voteContent.getVoteContentId(), voteSession.getUid(), voteGeneralLearnerFlowDTO);
                String isContentLockOnFinish = voteLearningForm.getLockOnFinish();
                if (isContentLockOnFinish.equals(new Boolean(true).toString()) && isResponseFinalised) {
                    return mapping.findForward("exitPage");
                }
                voteLearningForm.setRevisitingUser(new Boolean(true).toString());
                voteGeneralLearnerFlowDTO.setRevisitingUser(new Boolean(true).toString());
                request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
                if (isContentLockOnFinish.equals(new Boolean(false).toString()) && isResponseFinalised) {
                    return mapping.findForward("revisitedAllNominations");
                }
                return mapping.findForward("allNominations");
            }
        }
        return mapping.findForward("loadLearner");
    }

    private void putMapQuestionsContentIntoRequest(HttpServletRequest request, IVoteService voteService, VoteQueUsr user) {
        List attempts = null;
        if (user != null) {
            attempts = voteService.getAttemptsForUser(user.getUid());
        }
        TreeMap<String, String> localMapQuestionsContent = new TreeMap<String, String>(new VoteComparator());
        if (attempts != null) {
            Iterator listIterator = attempts.iterator();
            int order = 0;
            while (listIterator.hasNext()) {
                VoteUsrAttempt attempt = (VoteUsrAttempt)listIterator.next();
                VoteQueContent voteQueContent = attempt.getVoteQueContent();
                ++order;
                if (voteQueContent == null) continue;
                String entry = voteQueContent.getQuestion();
                String questionUid = attempt.getVoteQueContent().getUid().toString();
                if (entry == null) continue;
                if (entry.equals("sample nomination") && questionUid.equals("1")) {
                    localMapQuestionsContent.put(new Integer(order).toString(), attempt.getUserEntry());
                    continue;
                }
                localMapQuestionsContent.put(new Integer(order).toString(), voteQueContent.getQuestion());
            }
        }
        request.setAttribute("mapGeneralCheckedOptionsContent", localMapQuestionsContent);
    }

    protected void setupAttributes(HttpServletRequest request, VoteContent voteContent, VoteLearningForm voteLearningForm, VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO) {
        TreeMap mapGeneralCheckedOptionsContent = new TreeMap(new VoteComparator());
        request.setAttribute("mapGeneralCheckedOptionsContent", mapGeneralCheckedOptionsContent);
        voteLearningForm.setActivityTitle(voteContent.getTitle());
        voteLearningForm.setActivityInstructions(voteContent.getInstructions());
        voteLearningForm.setMaxNominationCount(voteContent.getMaxNominationCount());
        voteLearningForm.setMinNominationCount(voteContent.getMinNominationCount());
        voteLearningForm.setUseSelectLeaderToolOuput(new Boolean(voteContent.isUseSelectLeaderToolOuput()).toString());
        voteLearningForm.setAllowTextEntry(new Boolean(voteContent.isAllowText()).toString());
        voteLearningForm.setShowResults(new Boolean(voteContent.isShowResults()).toString());
        voteLearningForm.setLockOnFinish(new Boolean(voteContent.isLockOnFinish()).toString());
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralLearnerFlowDTO.setActivityInstructions(voteContent.getInstructions());
        voteGeneralLearnerFlowDTO.setMaxNominationCount(voteContent.getMaxNominationCount());
        voteGeneralLearnerFlowDTO.setMinNominationCount(voteContent.getMinNominationCount());
        voteGeneralLearnerFlowDTO.setUseSelectLeaderToolOuput(new Boolean(voteContent.isUseSelectLeaderToolOuput()).toString());
        voteGeneralLearnerFlowDTO.setAllowTextEntry(new Boolean(voteContent.isAllowText()).toString());
        voteGeneralLearnerFlowDTO.setLockOnFinish(new Boolean(voteContent.isLockOnFinish()).toString());
        voteGeneralLearnerFlowDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralLearnerFlowDTO.setActivityInstructions(voteContent.getInstructions());
    }

    protected ActionForward validateParameters(HttpServletRequest request, ActionMapping mapping, VoteLearningForm voteLearningForm) {
        UserDTO user;
        String userID = "";
        HttpSession ss = SessionManager.getSession();
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null && user.getUserID() != null) {
            userID = user.getUserID().toString();
            voteLearningForm.setUserID(userID);
        }
        String strToolSessionId = request.getParameter("toolSessionID");
        long toolSessionID = 0L;
        if (strToolSessionId == null || strToolSessionId.length() == 0) {
            VoteUtils.cleanUpUserExceptions(request);
            return mapping.findForward("errorList");
        }
        try {
            toolSessionID = new Long(strToolSessionId);
            voteLearningForm.setToolSessionID(new Long(toolSessionID).toString());
        }
        catch (NumberFormatException e) {
            VoteUtils.cleanUpUserExceptions(request);
            logger.error((Object)"add error.sessionId.numberFormatException to ActionMessages.");
            return mapping.findForward("errorList");
        }
        String mode = request.getParameter("mode");
        if (mode == null || mode.length() == 0) {
            VoteUtils.cleanUpUserExceptions(request);
            logger.error((Object)"mode missing: ");
            return mapping.findForward("errorList");
        }
        if (!(mode.equals("learner") || mode.equals("teacher") || mode.equals("author"))) {
            VoteUtils.cleanUpUserExceptions(request);
            logger.error((Object)"mode invalid: ");
            return mapping.findForward("errorList");
        }
        voteLearningForm.setLearningMode(mode);
        return null;
    }

    boolean isSessionCompleted(String userSessionId, IVoteService voteService) {
        VoteSession voteSession = voteService.getSessionBySessionId(new Long(userSessionId));
        return voteSession.getSessionStatus() != null && voteSession.getSessionStatus().equals("COMPLETED");
    }

    public void persistInRequestError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        this.saveErrors(request, errors);
    }

    private VoteQueUsr getCurrentUser(String toolSessionId) {
        VoteSession session;
        HttpSession ss = SessionManager.getSession();
        UserDTO toolUser = (UserDTO)ss.getAttribute("user");
        Long userId = new Long(toolUser.getUserID().longValue());
        VoteQueUsr user = voteService.getVoteUserBySession(userId, (session = voteService.getSessionBySessionId(new Long(toolSessionId))).getUid());
        if (user == null) {
            String userName = toolUser.getLogin();
            String fullName = toolUser.getFirstName() + " " + toolUser.getLastName();
            user = new VoteQueUsr(userId, userName, fullName, session, new TreeSet());
            voteService.createVoteQueUsr(user);
        }
        return user;
    }

    private VoteQueUsr getSpecifiedUser(String toolSessionId, Integer userId) {
        VoteSession session = voteService.getSessionBySessionId(new Long(toolSessionId));
        VoteQueUsr user = voteService.getVoteUserBySession(new Long(userId.intValue()), session.getUid());
        if (user == null) {
            logger.error((Object)("Unable to find specified user for Vote activity. Screens are likely to fail. SessionId=" + new Long(toolSessionId) + " UserId=" + userId));
        }
        return user;
    }

    private MessageService getMessageService() {
        return VoteServiceProxy.getMessageService(this.getServlet().getServletContext());
    }
}

