/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dto.OpenTextAnswerDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralLearnerFlowDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralMonitoringDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteUsrAttempt;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;
import org.lamsfoundation.lams.tool.vote.web.MonitoringUtil;
import org.lamsfoundation.lams.tool.vote.web.form.VoteMonitoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class VoteMonitoringAction
extends LamsDispatchAction
implements VoteAppConstants {
    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VoteUtils.cleanUpUserExceptions(request);
        return null;
    }

    public ActionForward hideOpenVote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException, JSONException {
        return this.toggleHideShow(request, response, false);
    }

    public ActionForward showOpenVote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException, JSONException {
        return this.toggleHideShow(request, response, true);
    }

    private ActionForward toggleHideShow(HttpServletRequest request, HttpServletResponse response, boolean show) throws IOException, ServletException, ToolException, JSONException {
        String nextActionMethod;
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        Long currentUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentUid");
        VoteUsrAttempt voteUsrAttempt = voteService.getAttemptByUID(currentUid);
        voteUsrAttempt.setVisible(show);
        voteService.updateVoteUsrAttempt(voteUsrAttempt);
        if (show) {
            nextActionMethod = "hideOptionVote";
            voteService.showOpenVote(voteUsrAttempt);
        } else {
            nextActionMethod = "showOpenVote";
            voteService.hideOpenVote(voteUsrAttempt);
        }
        JSONObject responsedata = new JSONObject();
        responsedata.put("currentUid", (Object)currentUid);
        responsedata.put("nextActionMethod", (Object)nextActionMethod);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(new String(responsedata.toString()));
        return null;
    }

    public ActionForward getVoteNomination(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        VoteMonitoringForm voteMonitoringForm = (VoteMonitoringForm)form;
        voteMonitoringForm.setVoteService(voteService);
        VoteGeneralMonitoringDTO voteGeneralMonitoringDTO = new VoteGeneralMonitoringDTO();
        MonitoringUtil.repopulateRequestParameters(request, voteMonitoringForm, voteGeneralMonitoringDTO);
        Long questionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"questionUid", (boolean)false);
        Long sessionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"sessionUid", (boolean)true);
        VoteQueContent nomination = voteService.getQuestionByUid(questionUid);
        request.setAttribute("nominationText", (Object)nomination.getQuestion());
        request.setAttribute("voteGeneralMonitoringDTO", (Object)voteGeneralMonitoringDTO);
        request.setAttribute("questionUid", (Object)questionUid);
        if (sessionUid != null) {
            request.setAttribute("sessionUid", (Object)sessionUid);
        }
        return mapping.findForward("voteNominationViewer");
    }

    public ActionForward getVoteNominationsJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException, JSONException {
        Long sessionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"sessionUid", (boolean)true);
        if (sessionUid == 0L) {
            sessionUid = null;
        }
        Long questionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"questionUid", (boolean)false);
        int size = WebUtil.readIntParam((HttpServletRequest)request, (String)"size");
        int page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
        Integer sortByName = WebUtil.readIntParam((HttpServletRequest)request, (String)"column[0]", (boolean)true);
        Integer sortByDate = WebUtil.readIntParam((HttpServletRequest)request, (String)"column[1]", (boolean)true);
        String searchString = request.getParameter("fcol[0]");
        int sorting = 0;
        if (sortByName != null) {
            sorting = sortByName.equals(0) ? 1 : 2;
        } else if (sortByDate != null) {
            sorting = sortByDate.equals(0) ? 3 : 4;
        }
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        List<Object[]> users = voteService.getUserAttemptsForTablesorter(sessionUid, questionUid, page, size, sorting, searchString);
        JSONArray rows = new JSONArray();
        JSONObject responsedata = new JSONObject();
        responsedata.put("total_rows", voteService.getCountUsersBySession(sessionUid, questionUid, searchString));
        for (Object[] userAndAnswers : users) {
            JSONObject responseRow = new JSONObject();
            responseRow.put("userName", (Object)StringEscapeUtils.escapeHtml((String)((String)userAndAnswers[1])));
            responseRow.put("attemptTime", (Object)DateUtil.convertToStringForJSON((Date)((Date)userAndAnswers[2]), (Locale)request.getLocale()));
            rows.put((Object)responseRow);
        }
        responsedata.put("rows", (Object)rows);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(new String(responsedata.toString()));
        return null;
    }

    public ActionForward getReflectionsJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException, JSONException {
        Long sessionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"sessionUid", (boolean)true);
        int size = WebUtil.readIntParam((HttpServletRequest)request, (String)"size");
        int page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
        Integer sortByName = WebUtil.readIntParam((HttpServletRequest)request, (String)"column[0]", (boolean)true);
        String searchString = request.getParameter("fcol[0]");
        int sorting = 0;
        if (sortByName != null) {
            sorting = sortByName.equals(0) ? 1 : 2;
        }
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        List<Object[]> users = voteService.getUserReflectionsForTablesorter(sessionUid, page, size, sorting, searchString);
        JSONArray rows = new JSONArray();
        JSONObject responsedata = new JSONObject();
        responsedata.put("total_rows", voteService.getCountUsersBySession(sessionUid, null, searchString));
        for (Object[] userAndReflection : users) {
            JSONObject responseRow = new JSONObject();
            responseRow.put("userName", (Object)StringEscapeUtils.escapeHtml((String)((String)userAndReflection[1])));
            if (userAndReflection.length > 2 && userAndReflection[2] != null) {
                String reflection = StringEscapeUtils.escapeHtml((String)((String)userAndReflection[2]));
                responseRow.put("notebook", (Object)reflection.replaceAll("\n", "<br>"));
            }
            rows.put((Object)responseRow);
        }
        responsedata.put("rows", (Object)rows);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(new String(responsedata.toString()));
        return null;
    }

    public ActionForward statistics(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        request.setAttribute("isGroupedActivity", (Object)voteService.isGroupedActivity(toolContentID));
        request.setAttribute("voteStatsDTO", voteService.getStatisticsBySession(toolContentID));
        return mapping.findForward("statistics");
    }

    public ActionForward getOpenTextNominationsJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException, JSONException {
        Long sessionUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"sessionUid", (boolean)true);
        if (sessionUid == 0L) {
            sessionUid = null;
        }
        Long contentUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentUID", (boolean)false);
        int size = WebUtil.readIntParam((HttpServletRequest)request, (String)"size");
        int page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
        Integer sortByEntry = WebUtil.readIntParam((HttpServletRequest)request, (String)"column[0]", (boolean)true);
        Integer sortByName = WebUtil.readIntParam((HttpServletRequest)request, (String)"column[1]", (boolean)true);
        Integer sortByDate = WebUtil.readIntParam((HttpServletRequest)request, (String)"column[2]", (boolean)true);
        Integer sortByVisible = WebUtil.readIntParam((HttpServletRequest)request, (String)"column[3]", (boolean)true);
        String searchStringVote = request.getParameter("fcol[0]");
        String searchStringUsername = request.getParameter("fcol[1]");
        int sorting = 0;
        if (sortByEntry != null) {
            int n = sorting = sortByEntry.equals(0) ? 5 : 6;
        }
        if (sortByName != null) {
            sorting = sortByName.equals(0) ? 1 : 2;
        } else if (sortByDate != null) {
            sorting = sortByDate.equals(0) ? 3 : 4;
        } else if (sortByVisible != null) {
            sorting = sortByVisible.equals(0) ? 7 : 8;
        }
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        List<OpenTextAnswerDTO> users = voteService.getUserOpenTextAttemptsForTablesorter(sessionUid, contentUid, page, size, sorting, searchStringVote, searchStringUsername);
        JSONArray rows = new JSONArray();
        JSONObject responsedata = new JSONObject();
        responsedata.put("total_rows", voteService.getCountUsersForOpenTextEntries(sessionUid, contentUid, searchStringVote, searchStringUsername));
        for (OpenTextAnswerDTO userAndAttempt : users) {
            JSONObject responseRow = new JSONObject();
            responseRow.put("uid", (Object)userAndAttempt.getUserUid());
            responseRow.put("userName", (Object)StringEscapeUtils.escapeHtml((String)userAndAttempt.getFullName()));
            responseRow.put("userEntryUid", (Object)userAndAttempt.getUserEntryUid());
            responseRow.put("userEntry", (Object)StringEscapeUtils.escapeHtml((String)userAndAttempt.getUserEntry()));
            responseRow.put("attemptTime", (Object)DateUtil.convertToStringForJSON((Date)userAndAttempt.getAttemptTime(), (Locale)request.getLocale()));
            responseRow.put("visible", (Object)userAndAttempt.isVisible());
            rows.put((Object)responseRow);
        }
        responsedata.put("rows", (Object)rows);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(new String(responsedata.toString()));
        return null;
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ToolException {
        IVoteService VoteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        String uid = request.getParameter("uid");
        String userId = request.getParameter("userId");
        String userName = request.getParameter("userName");
        String sessionId = request.getParameter("sessionId");
        NotebookEntry notebookEntry = VoteService.getEntry(new Long(sessionId), CoreNotebookConstants.NOTEBOOK_TOOL, "lavote11", new Integer(userId));
        VoteGeneralLearnerFlowDTO voteGeneralLearnerFlowDTO = new VoteGeneralLearnerFlowDTO();
        if (notebookEntry != null) {
            voteGeneralLearnerFlowDTO.setNotebookEntry(notebookEntry.getEntry());
            voteGeneralLearnerFlowDTO.setUserName(userName);
        }
        request.setAttribute("voteGeneralLearnerFlowDTO", (Object)voteGeneralLearnerFlowDTO);
        return mapping.findForward("learnerNotebook");
    }

    public ActionForward setSubmissionDeadline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        Long contentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        VoteContent voteContent = voteService.getVoteContent(contentID);
        Long dateParameter = WebUtil.readLongParam((HttpServletRequest)request, (String)"submissionDeadline", (boolean)true);
        Date tzSubmissionDeadline = null;
        if (dateParameter != null) {
            Date submissionDeadline = new Date(dateParameter);
            HttpSession ss = SessionManager.getSession();
            UserDTO teacher = (UserDTO)ss.getAttribute("user");
            TimeZone teacherTimeZone = teacher.getTimeZone();
            tzSubmissionDeadline = DateUtil.convertFromTimeZoneToDefault((TimeZone)teacherTimeZone, (Date)submissionDeadline);
        }
        voteContent.setSubmissionDeadline(tzSubmissionDeadline);
        voteService.updateVote(voteContent);
        return null;
    }
}

