/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dto.SummarySessionDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralAuthoringDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralMonitoringDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteQuestionDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteApplicationException;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;
import org.lamsfoundation.lams.tool.vote.web.MonitoringUtil;
import org.lamsfoundation.lams.tool.vote.web.form.VoteMonitoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public class VoteMonitoringStarterAction
extends Action
implements VoteAppConstants {
    static Logger logger = Logger.getLogger((String)VoteMonitoringStarterAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, VoteApplicationException {
        VoteUtils.cleanUpUserExceptions(request);
        IVoteService voteService = VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
        VoteMonitoringForm voteMonitoringForm = (VoteMonitoringForm)form;
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        VoteGeneralMonitoringDTO voteGeneralMonitoringDTO = new VoteGeneralMonitoringDTO();
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        request.setAttribute("voteGeneralMonitoringDTO", (Object)voteGeneralMonitoringDTO);
        ActionForward validateParameters = this.validateParameters(request, mapping, voteMonitoringForm);
        if (validateParameters != null) {
            return validateParameters;
        }
        voteGeneralMonitoringDTO.setRequestLearningReport(Boolean.FALSE.toString());
        String toolContentID = voteMonitoringForm.getToolContentID();
        VoteContent voteContent = voteService.getVoteContent(new Long(toolContentID));
        if (voteContent == null) {
            VoteUtils.cleanUpUserExceptions(request);
            voteGeneralMonitoringDTO.setUserExceptionContentDoesNotExist(Boolean.TRUE.toString());
            return mapping.findForward("errorList");
        }
        voteGeneralMonitoringDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralMonitoringDTO.setActivityInstructions(voteContent.getInstructions());
        SortedSet<SummarySessionDTO> sessionDTOs = voteService.getMonitoringSessionDTOs(new Long(toolContentID));
        request.setAttribute("sessionDTOs", sessionDTOs);
        request.setAttribute("voteGeneralMonitoringDTO", (Object)voteGeneralMonitoringDTO);
        request.setAttribute("useSelectLeaderToolOuput", (Object)voteContent.isUseSelectLeaderToolOuput());
        request.setAttribute("lockOnFinish", (Object)voteContent.isLockOnFinish());
        request.setAttribute("allowText", (Object)voteContent.isAllowText());
        request.setAttribute("maxNominationCount", (Object)voteContent.getMaxNominationCount());
        request.setAttribute("minNominationCount", (Object)voteContent.getMinNominationCount());
        request.setAttribute("showResults", (Object)voteContent.isShowResults());
        request.setAttribute("reflect", (Object)voteContent.isReflect());
        request.setAttribute("reflectionSubject", (Object)voteContent.getReflectionSubject());
        request.setAttribute("toolContentID", (Object)voteContent.getVoteContentId());
        if (voteContent.getSubmissionDeadline() != null) {
            Date submissionDeadline = voteContent.getSubmissionDeadline();
            HttpSession ss = SessionManager.getSession();
            UserDTO teacher = (UserDTO)ss.getAttribute("user");
            TimeZone teacherTimeZone = teacher.getTimeZone();
            Date tzSubmissionDeadline = DateUtil.convertToTimeZoneFromDefault((TimeZone)teacherTimeZone, (Date)submissionDeadline);
            request.setAttribute("submissionDeadline", (Object)tzSubmissionDeadline.getTime());
        }
        voteMonitoringForm.setCurrentTab("1");
        voteGeneralMonitoringDTO.setCurrentTab("1");
        voteGeneralMonitoringDTO.setIsPortfolioExport(Boolean.FALSE.toString());
        if (sessionDTOs.size() > 0) {
            VoteUtils.cleanUpUserExceptions(request);
            voteGeneralMonitoringDTO.setUserExceptionContentInUse(Boolean.TRUE.toString());
        }
        SessionMap sessionMap = new SessionMap();
        sessionMap.put((Object)"activityTitleKey", (Object)voteContent.getTitle());
        sessionMap.put((Object)"activityInstructionsKey", (Object)voteContent.getInstructions());
        voteMonitoringForm.setHttpSessionID(sessionMap.getSessionID());
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        LinkedList<VoteQuestionDTO> listQuestionDTO = new LinkedList<VoteQuestionDTO>();
        Iterator queIterator = voteContent.getVoteQueContents().iterator();
        while (queIterator.hasNext()) {
            VoteQuestionDTO voteQuestionDTO = new VoteQuestionDTO();
            VoteQueContent voteQueContent = (VoteQueContent)queIterator.next();
            if (voteQueContent == null) continue;
            voteQuestionDTO.setQuestion(voteQueContent.getQuestion());
            voteQuestionDTO.setDisplayOrder(new Integer(voteQueContent.getDisplayOrder()).toString());
            listQuestionDTO.add(voteQuestionDTO);
        }
        request.setAttribute("listQuestionDTO", listQuestionDTO);
        sessionMap.put((Object)"listQuestionDTO", listQuestionDTO);
        voteGeneralAuthoringDTO.setActivityTitle(voteGeneralMonitoringDTO.getActivityTitle());
        voteGeneralAuthoringDTO.setActivityInstructions(voteGeneralMonitoringDTO.getActivityInstructions());
        MonitoringUtil.repopulateRequestParameters(request, voteMonitoringForm, voteGeneralMonitoringDTO);
        boolean isGroupedActivity = voteService.isGroupedActivity(new Long(toolContentID));
        request.setAttribute("isGroupedActivity", (Object)isGroupedActivity);
        request.setAttribute("isAllowText", (Object)voteContent.isAllowText());
        return mapping.findForward("refreshMonitoring");
    }

    private ActionForward validateParameters(HttpServletRequest request, ActionMapping mapping, VoteMonitoringForm voteMonitoringForm) {
        String strToolContentId = request.getParameter("toolContentID");
        if (strToolContentId == null || strToolContentId.length() == 0) {
            VoteUtils.cleanUpUserExceptions(request);
            return mapping.findForward("errorList");
        }
        try {
            voteMonitoringForm.setToolContentID(strToolContentId);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"add error.numberFormatException to ActionMessages.");
            VoteUtils.cleanUpUserExceptions(request);
            return mapping.findForward("errorList");
        }
        return null;
    }
}

