/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.tool.vote.web.form.VotePedagogicalPlannerForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class VotePedagogicalPlannerAction
extends LamsDispatchAction {
    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.initPedagogicalPlannerForm(mapping, form, request, response);
    }

    public ActionForward initPedagogicalPlannerForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        VotePedagogicalPlannerForm plannerForm = (VotePedagogicalPlannerForm)form;
        Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        VoteContent voteContent = this.getVoteService().getVoteContent(toolContentID);
        plannerForm.fillForm(voteContent);
        String contentFolderId = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        plannerForm.setContentFolderID(contentFolderId);
        return mapping.findForward("success");
    }

    public ActionForward saveOrUpdatePedagogicalPlannerForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        VotePedagogicalPlannerForm plannerForm = (VotePedagogicalPlannerForm)form;
        ActionMessages errors = plannerForm.validate();
        if (errors.isEmpty()) {
            VoteQueContent voteQueContent;
            VoteContent voteContent = this.getVoteService().getVoteContent(plannerForm.getToolContentID());
            voteContent.setInstructions(plannerForm.getInstructions());
            int nominationIndex = 1;
            String nomination = null;
            do {
                if (StringUtils.isEmpty((String)(nomination = plannerForm.getNomination(nominationIndex - 1)))) {
                    plannerForm.removeNomination(nominationIndex - 1);
                    continue;
                }
                if (nominationIndex <= voteContent.getVoteQueContents().size()) {
                    voteQueContent = this.getVoteService().getQuestionByDisplayOrder(Long.valueOf(nominationIndex), voteContent.getUid());
                    voteQueContent.setQuestion(nomination);
                    this.getVoteService().saveOrUpdateVoteQueContent(voteQueContent);
                } else {
                    voteQueContent = new VoteQueContent();
                    voteQueContent.setDisplayOrder(nominationIndex);
                    voteQueContent.setVoteContent(voteContent);
                    voteQueContent.setVoteContentId(voteContent.getVoteContentId());
                    voteQueContent.setQuestion(nomination);
                    this.getVoteService().saveOrUpdateVoteQueContent(voteQueContent);
                }
                ++nominationIndex;
            } while (nominationIndex <= plannerForm.getNominationCount());
            if (nominationIndex <= voteContent.getVoteQueContents().size()) {
                this.getVoteService().removeQuestionsFromCache(voteContent);
                this.getVoteService().removeVoteContentFromCache(voteContent);
                while (nominationIndex <= voteContent.getVoteQueContents().size()) {
                    voteQueContent = this.getVoteService().getQuestionByDisplayOrder(Long.valueOf(nominationIndex), voteContent.getUid());
                    this.getVoteService().removeVoteQueContent(voteQueContent);
                    ++nominationIndex;
                }
            }
        } else {
            this.saveErrors(request, errors);
        }
        return mapping.findForward("success");
    }

    public ActionForward createPedagogicalPlannerQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        VotePedagogicalPlannerForm plannerForm = (VotePedagogicalPlannerForm)form;
        plannerForm.setNomination(plannerForm.getNominationCount(), "");
        return mapping.findForward("success");
    }

    private IVoteService getVoteService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return VoteServiceProxy.getVoteService(this.getServlet().getServletContext());
    }
}

