/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.learningdesign.DataFlowObject;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.vote.VoteAppConstants;
import org.lamsfoundation.lams.tool.vote.dto.VoteGeneralAuthoringDTO;
import org.lamsfoundation.lams.tool.vote.dto.VoteQuestionDTO;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.tool.vote.service.IVoteService;
import org.lamsfoundation.lams.tool.vote.service.VoteApplicationException;
import org.lamsfoundation.lams.tool.vote.service.VoteServiceProxy;
import org.lamsfoundation.lams.tool.vote.util.VoteUtils;
import org.lamsfoundation.lams.tool.vote.web.VoteAction;
import org.lamsfoundation.lams.tool.vote.web.form.VoteAuthoringForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;

public class VoteStarterAction
extends Action
implements VoteAppConstants {
    private static Logger logger = Logger.getLogger((String)VoteStarterAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, VoteApplicationException {
        VoteUtils.cleanUpUserExceptions(request);
        VoteAuthoringForm voteAuthoringForm = (VoteAuthoringForm)form;
        VoteGeneralAuthoringDTO voteGeneralAuthoringDTO = new VoteGeneralAuthoringDTO();
        request.setAttribute("voteGeneralAuthoringDTO", (Object)voteGeneralAuthoringDTO);
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        voteAuthoringForm.setContentFolderID(contentFolderID);
        VoteAction voteAction = new VoteAction();
        voteAction.repopulateRequestParameters(request, voteAuthoringForm, voteGeneralAuthoringDTO);
        IVoteService voteService = null;
        voteService = this.getServlet() != null ? VoteServiceProxy.getVoteService(this.getServlet().getServletContext()) : voteAuthoringForm.getVoteService();
        voteGeneralAuthoringDTO.setContentFolderID(contentFolderID);
        SessionMap sessionMap = new SessionMap();
        voteAuthoringForm.setHttpSessionID(sessionMap.getSessionID());
        voteGeneralAuthoringDTO.setHttpSessionID(sessionMap.getSessionID());
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        voteAuthoringForm.resetRadioBoxes();
        voteAuthoringForm.setExceptionMaxNominationInvalid(new Boolean(false).toString());
        voteGeneralAuthoringDTO.setExceptionMaxNominationInvalid(new Boolean(false).toString());
        ActionForward validateSignature = this.validateDefaultContent(request, mapping, voteService, voteAuthoringForm);
        if (validateSignature != null) {
            return validateSignature;
        }
        String strToolContentId = request.getParameter("toolContentID");
        voteAuthoringForm.setToolContentID(new Long(strToolContentId).toString());
        voteGeneralAuthoringDTO.setToolContentID(new Long(strToolContentId).toString());
        if (strToolContentId == null || strToolContentId.equals("")) {
            VoteUtils.cleanUpUserExceptions(request);
            VoteUtils.cleanUpUserExceptions(request);
            return mapping.findForward("errorList");
        }
        ToolAccessMode mode = this.getAccessMode(request);
        if (mode.isTeacher()) {
            VoteUtils.setDefineLater(request, true, strToolContentId, voteService);
        }
        request.setAttribute("mode", (Object)mode.toString());
        VoteContent voteContent = voteService.getVoteContent(new Long(strToolContentId));
        if (voteContent == null) {
            long defaultContentID = voteService.getToolDefaultContentIdBySignature("lavote11");
            voteContent = voteService.getVoteContent(defaultContentID);
            voteContent = VoteContent.newInstance(voteContent, new Long(strToolContentId));
        }
        VoteStarterAction.prepareDTOandForm(request, voteContent, voteAuthoringForm, voteGeneralAuthoringDTO);
        if (voteContent.getTitle() == null) {
            voteGeneralAuthoringDTO.setActivityTitle("Voting");
            voteAuthoringForm.setTitle("Voting");
        } else {
            voteGeneralAuthoringDTO.setActivityTitle(voteContent.getTitle());
            voteAuthoringForm.setTitle(voteContent.getTitle());
        }
        if (voteContent.getInstructions() == null) {
            voteGeneralAuthoringDTO.setActivityInstructions("Instructions");
            voteAuthoringForm.setInstructions("Instructions");
        } else {
            voteGeneralAuthoringDTO.setActivityInstructions(voteContent.getInstructions());
            voteAuthoringForm.setInstructions(voteContent.getInstructions());
        }
        sessionMap.put((Object)"activityTitleKey", (Object)voteGeneralAuthoringDTO.getActivityTitle());
        sessionMap.put((Object)"activityInstructionsKey", (Object)voteGeneralAuthoringDTO.getActivityInstructions());
        voteAuthoringForm.setReflectionSubject(voteContent.getReflectionSubject());
        voteGeneralAuthoringDTO.setReflectionSubject(voteContent.getReflectionSubject());
        List<DataFlowObject> dataFlowObjects = voteService.getDataFlowObjects(new Long(strToolContentId));
        if (dataFlowObjects != null) {
            ArrayList<String> dataFlowObjectNames = new ArrayList<String>(dataFlowObjects.size());
            int objectIndex = 1;
            for (DataFlowObject dataFlowObject : dataFlowObjects) {
                dataFlowObjectNames.add(dataFlowObject.getDisplayName());
                if (VoteAppConstants.DATA_FLOW_OBJECT_ASSIGMENT_ID.equals(dataFlowObject.getToolAssigmentId())) {
                    voteAuthoringForm.setAssignedDataFlowObject(objectIndex);
                }
                ++objectIndex;
            }
            voteGeneralAuthoringDTO.setDataFlowObjectNames(dataFlowObjectNames);
        }
        LinkedList<VoteQuestionDTO> questionDTOs = new LinkedList<VoteQuestionDTO>();
        for (VoteQueContent question : voteContent.getVoteQueContents()) {
            VoteQuestionDTO questionDTO = new VoteQuestionDTO();
            questionDTO.setUid(question.getUid());
            questionDTO.setQuestion(question.getQuestion());
            questionDTO.setDisplayOrder(new Integer(question.getDisplayOrder()).toString());
            questionDTOs.add(questionDTO);
        }
        request.setAttribute("listQuestionDTO", questionDTOs);
        sessionMap.put((Object)"listQuestionDTO", questionDTOs);
        Short maxInputs = voteContent.getMaxExternalInputs();
        if (maxInputs == null) {
            maxInputs = 0;
        }
        voteAuthoringForm.setMaxInputs(maxInputs);
        voteAuthoringForm.resetUserAction();
        ArrayList listDeletedQuestionDTOs = new ArrayList();
        sessionMap.put((Object)"deletedQuestionDTOs", listDeletedQuestionDTOs);
        voteAuthoringForm.resetUserAction();
        voteAuthoringForm.setCurrentTab("1");
        return mapping.findForward("load");
    }

    private ActionForward validateDefaultContent(HttpServletRequest request, ActionMapping mapping, IVoteService voteService, VoteAuthoringForm voteAuthoringForm) {
        long defaultContentID = 0L;
        try {
            defaultContentID = voteService.getToolDefaultContentIdBySignature("lavote11");
            if (defaultContentID == 0L) {
                VoteUtils.cleanUpUserExceptions(request);
                this.saveInRequestError(request, "error.defaultContent.notSetup");
                return mapping.findForward("errorList");
            }
        }
        catch (Exception e) {
            VoteUtils.cleanUpUserExceptions(request);
            logger.error((Object)("error getting the default content id: " + e.getMessage()));
            this.saveInRequestError(request, "error.defaultContent.notSetup");
            return mapping.findForward("errorList");
        }
        try {
            VoteContent voteContent = voteService.getVoteContent(new Long(defaultContentID));
            if (voteContent == null) {
                VoteUtils.cleanUpUserExceptions(request);
                logger.error((Object)"Exception occured: No default content");
                this.saveInRequestError(request, "error.defaultContent.notSetup");
                return mapping.findForward("errorList");
            }
        }
        catch (Exception e) {
            logger.error((Object)("other problems: " + e));
            VoteUtils.cleanUpUserExceptions(request);
            logger.error((Object)"Exception occured: No default question content");
            this.saveInRequestError(request, "error.defaultContent.notSetup");
            return mapping.findForward("errorList");
        }
        return null;
    }

    private static void prepareDTOandForm(HttpServletRequest request, VoteContent voteContent, VoteAuthoringForm voteAuthoringForm, VoteGeneralAuthoringDTO voteGeneralAuthoringDTO) {
        voteGeneralAuthoringDTO.setActivityTitle(voteContent.getTitle());
        voteGeneralAuthoringDTO.setActivityInstructions(voteContent.getInstructions());
        voteAuthoringForm.setUseSelectLeaderToolOuput(voteContent.isUseSelectLeaderToolOuput() ? "1" : "0");
        voteAuthoringForm.setAllowText(voteContent.isAllowText() ? "1" : "0");
        voteAuthoringForm.setAllowTextEntry(voteContent.isAllowText() ? "1" : "0");
        voteAuthoringForm.setShowResults(voteContent.isShowResults() ? "1" : "0");
        voteAuthoringForm.setLockOnFinish(voteContent.isLockOnFinish() ? "1" : "0");
        voteAuthoringForm.setReflect(voteContent.isReflect() ? "1" : "0");
        voteGeneralAuthoringDTO.setUseSelectLeaderToolOuput(voteContent.isUseSelectLeaderToolOuput() ? "1" : "0");
        voteGeneralAuthoringDTO.setAllowText(voteContent.isAllowText() ? "1" : "0");
        voteGeneralAuthoringDTO.setLockOnFinish(voteContent.isLockOnFinish() ? "1" : "0");
        voteAuthoringForm.setReflect(voteContent.isReflect() ? "1" : "0");
        String maxNomcount = voteContent.getMaxNominationCount();
        if (maxNomcount.equals("")) {
            maxNomcount = "0";
        }
        voteAuthoringForm.setMaxNominationCount(maxNomcount);
        voteGeneralAuthoringDTO.setMaxNominationCount(maxNomcount);
        String minNomcount = voteContent.getMinNominationCount();
        if (minNomcount == null || minNomcount.equals("")) {
            minNomcount = "0";
        }
        voteAuthoringForm.setMinNominationCount(minNomcount);
        voteGeneralAuthoringDTO.setMinNominationCount(minNomcount);
    }

    private void saveInRequestError(HttpServletRequest request, String message) {
        ActionMessages errors = new ActionMessages();
        errors.add("org.apache.struts.action.ERROR", new ActionMessage(message));
        logger.error((Object)("add " + message + "  to ActionMessages:"));
        this.saveErrors(request, errors);
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }
}

