/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.vote.web.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.tool.vote.pojos.VoteContent;
import org.lamsfoundation.lams.tool.vote.pojos.VoteQueContent;
import org.lamsfoundation.lams.web.planner.PedagogicalPlannerActivityForm;

public class VotePedagogicalPlannerForm
extends PedagogicalPlannerActivityForm {
    private List<String> nomination;
    private String contentFolderID;
    private String instructions;

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getContentFolderID() {
        return this.contentFolderID;
    }

    public void setContentFolderID(String contentFolderID) {
        this.contentFolderID = contentFolderID;
    }

    public ActionMessages validate() {
        ActionMessages errors = new ActionMessages();
        boolean valid = true;
        boolean allEmpty = true;
        if (this.nomination != null && !this.nomination.isEmpty()) {
            for (String item : this.nomination) {
                if (StringUtils.isEmpty((String)item)) continue;
                allEmpty = false;
                break;
            }
        }
        if (allEmpty) {
            ActionMessage error = new ActionMessage("nominations.none.submitted");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", error);
            valid = false;
            this.nomination = null;
        }
        this.setValid(valid);
        return errors;
    }

    public void fillForm(VoteContent voteContent) {
        if (voteContent != null) {
            this.setToolContentID(voteContent.getVoteContentId());
            this.setInstructions(voteContent.getInstructions());
            this.nomination = new ArrayList<String>();
            Set questions = voteContent.getVoteQueContents();
            if (questions != null) {
                int topicIndex = 0;
                for (VoteQueContent message : questions) {
                    this.setNomination(topicIndex++, message.getQuestion());
                }
            }
        }
    }

    public void setNomination(int number, String nomination) {
        if (this.nomination == null) {
            this.nomination = new ArrayList<String>();
        }
        while (number >= this.nomination.size()) {
            this.nomination.add(null);
        }
        this.nomination.set(number, nomination);
    }

    public String getNomination(int number) {
        if (this.nomination == null || number >= this.nomination.size()) {
            return null;
        }
        return this.nomination.get(number);
    }

    public Integer getNominationCount() {
        return this.nomination == null ? 0 : this.nomination.size();
    }

    public boolean removeNomination(int number) {
        if (this.nomination == null || number >= this.nomination.size()) {
            return false;
        }
        this.nomination.remove(number);
        return true;
    }

    public List<String> getNominationList() {
        return this.nomination;
    }
}

