/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.web.session.SessionManager;

public class ServerSaveAction
extends Action {
    private static IIntegrationService service;
    private static IUserManagementService userService;
    private static MessageService messageService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] requiredFields;
        if (this.isCancelled(request)) {
            return mapping.findForward("success");
        }
        service = AdminServiceProxy.getIntegrationService(this.getServlet().getServletContext());
        userService = AdminServiceProxy.getService(this.getServlet().getServletContext());
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        DynaActionForm serverOrgMapForm = (DynaActionForm)form;
        ActionMessages errors = new ActionMessages();
        for (String requiredField : requiredFields = new String[]{"serverid", "serverkey", "servername", "prefix", "userinfoUrl", "timeoutUrl"}) {
            if (StringUtils.trimToNull((String)serverOrgMapForm.getString(requiredField)) != null) continue;
            errors.add(requiredField, new ActionMessage("error.required", (Object)messageService.getMessage("sysadmin." + requiredField)));
        }
        Organisation org = null;
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        if (((Boolean)serverOrgMapForm.get("newOrg")).booleanValue()) {
            String orgName = serverOrgMapForm.getString("orgName");
            if (StringUtils.trimToNull((String)orgName) == null) {
                errors.add("orgId", new ActionMessage("error.required", (Object)messageService.getMessage("sysadmin.organisation")));
            } else {
                org = new Organisation();
                org.setName(orgName);
                org.setParentOrganisation(userService.getRootOrganisation());
                org.setOrganisationType((OrganisationType)userService.findById(OrganisationType.class, (Serializable)OrganisationType.COURSE_TYPE));
                org.setOrganisationState((OrganisationState)userService.findById(OrganisationState.class, (Serializable)OrganisationState.ACTIVE));
                String defaultLocale = Configuration.get((String)ConfigurationKeys.SERVER_LANGUAGE);
                SupportedLocale locale = userService.getSupportedLocale(defaultLocale.substring(0, 2), defaultLocale.substring(3));
                org.setLocale(locale);
                userService.saveOrganisation(org, user.getUserID());
                serverOrgMapForm.set("orgId", (Object)org.getOrganisationId());
                serverOrgMapForm.set("newOrg", (Object)false);
                serverOrgMapForm.set("orgName", null);
            }
        } else {
            Integer orgId = (Integer)serverOrgMapForm.get("orgId");
            if (orgId.equals(-1)) {
                errors.add("orgId", new ActionMessage("error.required", (Object)messageService.getMessage("sysadmin.organisation")));
            } else {
                org = (Organisation)userService.findById(Organisation.class, (Serializable)orgId);
            }
        }
        Integer sid = (Integer)serverOrgMapForm.get("sid");
        if (errors.isEmpty()) {
            String[] uniqueFields;
            for (String uniqueField : uniqueFields = new String[]{"serverid", "prefix"}) {
                List list = userService.findByProperty(ExtServerOrgMap.class, uniqueField, serverOrgMapForm.get(uniqueField));
                if (list == null || list.size() <= 0) continue;
                if (sid.equals(-1)) {
                    errors.add(uniqueField, new ActionMessage("error.not.unique", (Object)messageService.getMessage("sysadmin." + uniqueField)));
                    continue;
                }
                ExtServerOrgMap map = (ExtServerOrgMap)list.get(0);
                if (map.getSid().equals(sid)) continue;
                errors.add(uniqueField, new ActionMessage("error.not.unique", (Object)messageService.getMessage("sysadmin." + uniqueField)));
            }
        }
        if (errors.isEmpty()) {
            ExtServerOrgMap map = null;
            if (sid.equals(-1)) {
                map = new ExtServerOrgMap();
                BeanUtils.copyProperties((Object)map, (Object)serverOrgMapForm);
                map.setSid(null);
            } else {
                map = service.getExtServerOrgMap(sid);
                BeanUtils.copyProperties((Object)map, (Object)serverOrgMapForm);
            }
            map.setOrganisation(org);
            service.saveExtServerOrgMap(map);
            return mapping.findForward("success");
        }
        this.saveErrors(request, errors);
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("organisationType.organisationTypeId", OrganisationType.COURSE_TYPE);
        properties.put("organisationState.organisationStateId", OrganisationState.ACTIVE);
        ArrayList<Organisation> list = userService.findByProperties(Organisation.class, properties);
        Organisation dummy = new Organisation();
        dummy.setOrganisationId(Integer.valueOf(-1));
        dummy.setName(messageService.getMessage("sysadmin.organisation.select"));
        if (list == null) {
            list = new ArrayList<Organisation>();
        }
        list.add(dummy);
        request.setAttribute("orgs", list);
        return mapping.getInputForward();
    }
}

