/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.UserListDTO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class UserManageAction
extends Action {
    private static final Logger log = Logger.getLogger(UserManageAction.class);
    private static IUserManagementService service;
    private static MessageService messageService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"org", (boolean)true);
        if (orgId == null) {
            orgId = (Integer)request.getAttribute("org");
        }
        if (orgId == null || orgId <= 0) {
            return this.forwardError(mapping, request, "error.org.invalid");
        }
        log.debug((Object)("orgId: " + orgId));
        Organisation organisation = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        if (organisation == null) {
            return this.forwardError(mapping, request, "error.org.invalid");
        }
        String orgName = organisation.getName();
        log.debug((Object)("orgName: " + orgName));
        Organisation pOrg = organisation.getParentOrganisation();
        if (pOrg != null) {
            request.setAttribute("pOrgId", (Object)pOrg.getOrganisationId());
            request.setAttribute("pOrgName", (Object)pOrg.getName());
        }
        OrganisationType orgType = organisation.getOrganisationType();
        request.setAttribute("orgType", (Object)orgType.getOrganisationTypeId());
        UserListDTO userManageForm = new UserListDTO();
        Integer userId = ((UserDTO)SessionManager.getSession().getAttribute("user")).getUserID();
        Organisation orgOfCourseAdmin = orgType.getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) ? pOrg : organisation;
        Integer rootOrgId = service.getRootOrganisation().getOrganisationId();
        if (request.isUserInRole("SYSADMIN") || service.isUserGlobalGroupAdmin() && !orgId.equals(rootOrgId)) {
            userManageForm.setCourseAdminCanAddNewUsers(true);
            userManageForm.setCourseAdminCanBrowseAllUsers(true);
        } else if ((service.isUserInRole(userId, orgOfCourseAdmin.getOrganisationId(), "GROUP ADMIN") || service.isUserInRole(userId, orgOfCourseAdmin.getOrganisationId(), "GROUP MANAGER")) && !orgId.equals(rootOrgId)) {
            userManageForm.setCourseAdminCanAddNewUsers(orgOfCourseAdmin.getCourseAdminCanAddNewUsers());
            userManageForm.setCourseAdminCanBrowseAllUsers(orgOfCourseAdmin.getCourseAdminCanBrowseAllUsers());
        } else {
            return this.forwardError(mapping, request, "error.authorisation");
        }
        userManageForm.setOrgId(orgId);
        userManageForm.setOrgName(orgName);
        List userManageBeans = service.getUserManageBeans(orgId);
        Collections.sort(userManageBeans);
        userManageForm.setUserManageBeans(userManageBeans);
        request.setAttribute("UserManageForm", (Object)userManageForm);
        return mapping.findForward("userlist");
    }

    private ActionForward forwardError(ActionMapping mapping, HttpServletRequest request, String key) {
        request.setAttribute("errorName", (Object)"UserManageAction");
        if (key.equals("error.org.invalid")) {
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.org.invalid"));
        } else if (key.equals("error.authorisation")) {
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.authorisation"));
        }
        return mapping.findForward("error");
    }
}

