/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.conf.ClassMap;
import org.jgroups.conf.ClassPathEntityResolver;
import org.jgroups.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MagicNumberReader {
    private static boolean xml_debug = false;
    public static final String MAGIC_NUMBER_FILE = "jg-magic-map.xml";
    public String mMagicNumberFile = "jg-magic-map.xml";
    protected static Log log = LogFactory.getLog((Class)(class$org$jgroups$conf$MagicNumberReader == null ? (class$org$jgroups$conf$MagicNumberReader = MagicNumberReader.class$("org.jgroups.conf.MagicNumberReader")) : class$org$jgroups$conf$MagicNumberReader));
    static /* synthetic */ Class class$org$jgroups$conf$MagicNumberReader;

    public void setFilename(String file) {
        this.mMagicNumberFile = file;
    }

    public ClassMap[] readMagicNumberMapping() {
        try {
            InputStream stream2;
            block10: {
                stream2 = this.getClass().getClassLoader().getResourceAsStream(this.mMagicNumberFile);
                if (stream2 == null) {
                    try {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Could not read " + this.mMagicNumberFile + " as Resource from the CLASSPATH, will try to read it from file."));
                        }
                        if ((stream2 = new FileInputStream(this.mMagicNumberFile)) != null && log.isInfoEnabled()) {
                            log.info((Object)("Magic number File found at '" + this.mMagicNumberFile + '\''));
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        if (!log.isWarnEnabled()) break block10;
                        log.warn((Object)("Failed reading - '" + this.mMagicNumberFile + "' is not found, got error '" + fnfe.getLocalizedMessage() + "'. Please make sure it is in the CLASSPATH or in the Specified location. Will " + "continue, but marshalling will be slower"));
                    }
                }
            }
            if (stream2 == null) {
                return new ClassMap[0];
            }
            return MagicNumberReader.parse(stream2);
        }
        catch (Exception x) {
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Util.getStackTrace(x);
            if (log.isErrorEnabled()) {
                log.error((Object)error);
            }
            return new ClassMap[0];
        }
    }

    protected static ClassMap[] parse(InputStream stream2) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new ClassPathEntityResolver());
        Document document = builder.parse(stream2);
        NodeList class_list = document.getElementsByTagName("class");
        Vector<ClassMap> v = new Vector<ClassMap>();
        for (int i = 0; i < class_list.getLength(); ++i) {
            if (class_list.item(i).getNodeType() != 1) continue;
            v.addElement(MagicNumberReader.parseClassData(class_list.item(i)));
        }
        Object[] data = new ClassMap[v.size()];
        v.copyInto(data);
        return data;
    }

    protected static ClassMap parseClassData(Node protocol) throws IOException {
        try {
            protocol.normalize();
            int pos = 0;
            NodeList children = protocol.getChildNodes();
            String clazzname = null;
            String desc = null;
            String preload = null;
            String magicnumber = null;
            block8: for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                switch (++pos) {
                    case 1: {
                        desc = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 2: {
                        clazzname = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 3: {
                        preload = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 4: {
                        magicnumber = children.item(i).getFirstChild().getNodeValue();
                    }
                }
            }
            return new ClassMap(clazzname, desc, Boolean.valueOf(preload), Integer.valueOf(magicnumber));
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Util.getStackTrace(x);
            if (log.isErrorEnabled()) {
                log.error((Object)error);
            }
            throw new IOException(x.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

