/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class MERGE2
extends Protocol {
    Address local_addr = null;
    FindSubgroups task = null;
    long min_interval = 5000L;
    long max_interval = 20000L;
    boolean is_coord = false;
    Promise find_promise = new Promise();

    public String getName() {
        return "MERGE2";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("min_interval");
        if (str != null) {
            this.min_interval = Long.parseLong(str);
            props.remove("min_interval");
        }
        if ((str = props.getProperty("max_interval")) != null) {
            this.max_interval = Long.parseLong(str);
            props.remove("max_interval");
        }
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"min_interval and max_interval have to be > 0");
            }
            return false;
        }
        if (this.max_interval <= this.min_interval) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"max_interval has to be greater than min_interval");
            }
            return false;
        }
        if (props.size() > 0) {
            System.err.println("MERGE2.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(1);
        retval.addElement(new Integer(12));
        return retval;
    }

    public void stop() {
        this.is_coord = false;
        this.stopTask();
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.passUp(evt);
                break;
            }
            case 13: {
                this.find_promise.setResult(evt.getArg());
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    public void down(Event evt) {
        Vector mbrs = null;
        switch (evt.getType()) {
            case 6: {
                this.passDown(evt);
                mbrs = ((View)evt.getArg()).getMembers();
                if (mbrs == null || mbrs.size() == 0 || this.local_addr == null) {
                    this.stopTask();
                    break;
                }
                Address coord = (Address)mbrs.elementAt(0);
                if (coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.startTask();
                    break;
                }
                if (this.is_coord) {
                    this.is_coord = false;
                }
                this.stopTask();
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    void startTask() {
        if (this.task == null) {
            this.task = new FindSubgroups();
            this.task.start();
        }
    }

    void stopTask() {
        if (this.task != null) {
            this.task.stop();
            this.task = null;
        }
    }

    private class FindSubgroups
    implements Runnable {
        Thread thread = null;

        private FindSubgroups() {
        }

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "MERGE2.FindSubgroups thread");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        public void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                Thread tmp = this.thread;
                this.thread = null;
                tmp.interrupt();
                MERGE2.this.find_promise.reset();
            }
            this.thread = null;
        }

        public void run() {
            Vector coords = null;
            if (MERGE2.this.log.isDebugEnabled()) {
                MERGE2.this.log.debug((Object)"merge task started");
            }
            while (this.thread != null) {
                long interval = this.computeInterval();
                Util.sleep(interval);
                if (this.thread == null) break;
                Vector initial_mbrs = this.findInitialMembers();
                if (this.thread == null) break;
                if (MERGE2.this.log.isDebugEnabled()) {
                    MERGE2.this.log.debug((Object)("initial_mbrs=" + initial_mbrs));
                }
                if ((coords = this.findMultipleCoordinators(initial_mbrs)) == null || coords.size() <= 1) continue;
                if (MERGE2.this.log.isDebugEnabled()) {
                    MERGE2.this.log.debug((Object)("found multiple coordinators: " + coords + "; sending up MERGE event"));
                }
                Event evt = new Event(14, coords);
                MERGE2.this.passUp(evt);
            }
        }

        long computeInterval() {
            long retval = MERGE2.this.min_interval + Util.random(MERGE2.this.max_interval - MERGE2.this.min_interval);
            return retval;
        }

        Vector findInitialMembers() {
            MERGE2.this.find_promise.reset();
            MERGE2.this.passDown(new Event(12));
            return (Vector)MERGE2.this.find_promise.getResult(0L);
        }

        Vector findMultipleCoordinators(Vector initial_mbrs) {
            Vector<Address> ret = new Vector<Address>(11);
            if (initial_mbrs == null) {
                return null;
            }
            for (int i = 0; i < initial_mbrs.size(); ++i) {
                PingRsp rsp = (PingRsp)initial_mbrs.elementAt(i);
                Address coord = rsp.getCoordAddress();
                if (ret.contains(coord)) continue;
                ret.addElement(coord);
            }
            return ret;
        }
    }
}

