/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.dao.hibernate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lamsfoundation.lams.tool.rsrc.dao.ResourceItemVisitDAO;
import org.lamsfoundation.lams.tool.rsrc.dao.hibernate.BaseDAOHibernate;
import org.lamsfoundation.lams.tool.rsrc.model.Resource;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItemVisitLog;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceSession;

public class ResourceItemVisitDAOHibernate
extends BaseDAOHibernate
implements ResourceItemVisitDAO {
    private static final String FIND_BY_ITEM_AND_USER = "from " + ResourceItemVisitLog.class.getName() + " as r where r.user.userId = ? and r.resourceItem.uid=?";
    private static final String FIND_BY_ITEM_BYSESSION = "from " + ResourceItemVisitLog.class.getName() + " as r where r.sessionId = ? and r.resourceItem.uid=?";
    private static final String FIND_VIEW_COUNT_BY_USER = "select count(*) from " + ResourceItemVisitLog.class.getName() + " as r where  r.sessionId=? and  r.user.userId =?";
    private static final String FIND_SUMMARY = "select v.resourceItem.uid, count(v.resourceItem) from  " + ResourceItemVisitLog.class.getName() + " as v , " + ResourceSession.class.getName() + " as s, " + Resource.class.getName() + "  as r " + " where v.sessionId = s.sessionId " + " and s.resource.uid = r.uid " + " and r.contentId =? " + " group by v.sessionId, v.resourceItem.uid ";

    @Override
    public ResourceItemVisitLog getResourceItemLog(Long itemUid, Long userId) {
        List list = this.getHibernateTemplate().find(FIND_BY_ITEM_AND_USER, new Object[]{userId, itemUid});
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ResourceItemVisitLog)list.get(0);
    }

    @Override
    public int getUserViewLogCount(Long toolSessionId, Long userUid) {
        List list = this.getHibernateTemplate().find(FIND_VIEW_COUNT_BY_USER, new Object[]{toolSessionId, userUid});
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public Map<Long, Integer> getSummary(Long contentId) {
        List result = this.getHibernateTemplate().find(FIND_SUMMARY, (Object)contentId);
        HashMap<Long, Integer> summaryList = new HashMap<Long, Integer>(result.size());
        for (Object[] list : result) {
            if (list[1] == null) continue;
            summaryList.put((Long)list[0], new Integer(((Number)list[1]).intValue()));
        }
        return summaryList;
    }

    @Override
    public List<ResourceItemVisitLog> getResourceItemLogBySession(Long sessionId, Long itemUid) {
        return this.getHibernateTemplate().find(FIND_BY_ITEM_BYSESSION, new Object[]{sessionId, itemUid});
    }
}

