/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.ims;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.lamsfoundation.lams.tool.rsrc.ims.IContentPackageConverter;
import org.lamsfoundation.lams.tool.rsrc.ims.IMSManifestException;
import org.lamsfoundation.lams.tool.rsrc.ims.ImscpApplicationException;
import uk.ac.reload.jdom.XMLDocument;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.contentpackaging.CP_Core;

public class SimpleContentPackageConverter
implements IContentPackageConverter {
    private Logger log = Logger.getLogger(SimpleContentPackageConverter.class);
    private XMLDocument manifestDoc = null;
    private CP_Core cpCore = null;
    private String schema = null;
    private String title = null;
    private String description = null;
    private String defaultItem = null;
    private String organzationXML = null;
    private Element[] cachedResourceList = null;

    public SimpleContentPackageConverter(String directoryName) throws IMSManifestException, ImscpApplicationException {
        this.manifestDoc = this.getDocument(directoryName);
        this.cpCore = new CP_Core(this.manifestDoc);
        System.setProperty("editor.properties.file", "uk.ac.reload.editor.properties.rb");
        this.parsePackage();
    }

    private void parsePackage() throws IMSManifestException, ImscpApplicationException {
        String schemaText = this.getText(this.manifestDoc, "//metadata/schema");
        String schemaVersion = this.getText(this.manifestDoc, "//metadata/schemaversion");
        this.schema = (schemaText != null ? schemaText : "unknown") + " " + (schemaVersion != null ? schemaVersion : "unknown");
        Document orgs = this.buildOrganisationList();
        if (orgs == null) {
            String error = "Unable to convert organizations from manifest file to our own structure. Reason unknown - buildOrganisationList returned null";
            this.log.error((Object)error);
            throw new ImscpApplicationException(error);
        }
        try {
            this.organzationXML = XMLUtils.write2XMLString((Document)orgs);
        }
        catch (IOException ioe) {
            String error = "Exception thrown converting organization structure (as document) to an XML string." + ioe.getMessage();
            this.log.error((Object)error, (Throwable)ioe);
            throw new ImscpApplicationException(error, ioe);
        }
        XMLPath xmlPath = new XMLPath("//metadata/*:lom/*:general/*:title/*:langstring");
        this.title = this.getMetaValue(xmlPath);
        if (this.title == null) {
            xmlPath = new XMLPath("//metadata/*:record/*:general/*:title/*:langstring");
            this.title = this.getMetaValue(xmlPath);
        }
        xmlPath = new XMLPath("//metadata/*:lom/*:general/*:description/*:langstring");
        this.description = this.getMetaValue(xmlPath);
        if (this.description == null) {
            xmlPath = new XMLPath("//metadata/*:record/*:general/*:description/*:langstring");
            this.description = this.getMetaValue(xmlPath);
        }
    }

    private String getMetaValue(XMLPath xmlPath) {
        Element[] elList = this.manifestDoc.getElements(xmlPath);
        String value = null;
        if (elList != null) {
            if (elList.length == 0) {
                value = "Unknown";
            } else if (elList.length == 1) {
                value = elList[0].getTextTrim();
            } else {
                value = null;
                for (int i = 0; value == null && i < elList.length; ++i) {
                    Element el = elList[i];
                    String attrValue = el.getAttributeValue("lang", Namespace.XML_NAMESPACE);
                    if (attrValue == null || !attrValue.startsWith("en")) continue;
                    value = el.getTextTrim();
                }
                if (value == null) {
                    value = elList[0].getTextTrim();
                }
            }
        }
        return value;
    }

    private String getText(XMLDocument document, String xmlPathString) {
        XMLPath xmlPath = new XMLPath(xmlPathString);
        Element el = document.getElement(xmlPath);
        return el != null ? el.getTextTrim() : null;
    }

    private String debug(XMLDocument document, String param, String xmlPathString) {
        XMLPath xmlPath = new XMLPath(xmlPathString);
        Element[] elList = document.getElements(xmlPath);
        if (elList != null) {
            this.log.error((Object)(param + " xp: length " + elList.length + " el " + elList));
            if (elList.length >= 1) {
                this.log.error((Object)("text is " + elList[0].getTextTrim()));
                return elList[0].getTextTrim();
            }
        } else {
            this.log.error((Object)(param + " xp: el is null"));
        }
        return null;
    }

    private XMLDocument getDocument(String directoryName) throws IMSManifestException {
        try {
            XMLDocument doc = new XMLDocument();
            doc.loadDocument(new File(directoryName, "imsmanifest.xml"));
            return doc;
        }
        catch (JDOMException je) {
            String error = "Parsing error occured while loading imsmanifest.xml file. Contents of file may be invalid. " + je.getMessage();
            this.log.error((Object)error, (Throwable)je);
            throw new IMSManifestException(error, je);
        }
        catch (FileNotFoundException e) {
            String error = "Unable to find imsmanifest file in the package." + e.getMessage();
            this.log.error((Object)error, (Throwable)e);
            throw new IMSManifestException(error, e);
        }
        catch (IOException ioe) {
            String error = "IOException occured while loading imsmanifest file. " + ioe.getMessage();
            this.log.error((Object)error, (Throwable)ioe);
            throw new IMSManifestException(error, ioe);
        }
    }

    private Document buildOrganisationList() throws IMSManifestException {
        Namespace nm = this.cpCore.getRootManifestElement().getNamespace();
        Element rootElement = this.cpCore.getRootManifestElement();
        Element orgsElement = rootElement.getChild("organizations", nm);
        Element defaultOrg = this.cpCore.getDefaultOrganization(orgsElement);
        String defaultOrgIdentifier = null;
        if (defaultOrg != null) {
            defaultOrgIdentifier = defaultOrg.getAttributeValue("identifier");
        }
        this.log.debug((Object)("cpCore default org id: " + defaultOrgIdentifier));
        Element newRootElement = new Element("organizations");
        this.setAttribute(newRootElement, "version", "imscp1");
        Document doc = new Document(newRootElement);
        Element[] orgs = this.cpCore.getOrganizationsAllowed(orgsElement);
        Element initOrganizationElement = null;
        for (int i = 0; i < orgs.length; ++i) {
            Element organizationElement = this.processItem(orgs[i], nm, defaultOrgIdentifier, null);
            if (initOrganizationElement == null) {
                initOrganizationElement = organizationElement;
            }
            newRootElement.addContent(organizationElement);
        }
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Organizations are: " + XMLUtils.write2XMLString((Document)doc)));
            }
            catch (IOException e) {
                this.log.debug((Object)("Unable to convert organizations to XML for log. Organizations are: " + doc));
            }
        }
        return doc;
    }

    private Element processItem(Element element, Namespace nm, String defaultOrgIdentifier, String parentOrgIdentifier) throws IMSManifestException {
        String isVisibleString = element.getAttributeValue("isvisible");
        if (this.isVisible(isVisibleString)) {
            String id = element.getAttributeValue("identifier");
            Element itref = new Element("item");
            this.setAttribute(itref, "identifier", id);
            this.setAttribute(itref, "parameters", element.getAttributeValue("parameters"));
            this.setAttribute(itref, "title", element.getChildText("title", nm));
            String resourceURL = this.getResourceURL(element);
            if (resourceURL != null) {
                this.setAttribute(itref, "resource", resourceURL);
            }
            if (resourceURL != null && this.defaultItem == null && (defaultOrgIdentifier == null || defaultOrgIdentifier.equals(parentOrgIdentifier))) {
                this.setAttribute(itref, "default", Boolean.TRUE.toString());
                this.defaultItem = resourceURL;
            } else {
                this.setAttribute(itref, "default", Boolean.FALSE.toString());
            }
            List items = element.getChildren("item", nm);
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                Element itrefChild = this.processItem((Element)iter.next(), nm, defaultOrgIdentifier, parentOrgIdentifier != null ? parentOrgIdentifier : id);
                if (itrefChild == null) continue;
                itref.addContent(itrefChild);
            }
            return itref;
        }
        return null;
    }

    private boolean isVisible(String value) {
        String trimmed;
        return value == null || !(trimmed = value.trim()).equalsIgnoreCase("false") && !trimmed.equals("0");
    }

    private void setAttribute(Element element, String attributeName, String value) {
        if (element != null && attributeName != null && value != null) {
            element.setAttribute(attributeName, value);
        }
    }

    private String getResourceURL(Element itemElement) throws IMSManifestException {
        String identifierRef;
        if (this.cachedResourceList == null) {
            this.cachedResourceList = this.cpCore.getReferencedElementsAllowed(itemElement);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Resources are " + this.cachedResourceList));
            }
        }
        if ((identifierRef = itemElement.getAttributeValue("identifierref")) == null) {
            return null;
        }
        Element resource = this.getResource2(identifierRef);
        if (resource == null) {
            this.cachedResourceList = this.cpCore.getReferencedElementsAllowed(itemElement);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Resources are " + this.cachedResourceList));
            }
            resource = this.getResource2(identifierRef);
        }
        if (resource != null) {
            return this.cpCore.getRelativeURL(resource);
        }
        throw new IMSManifestException("Unable to find resource for item element " + itemElement.getAttributeValue("title") + " looking for identifier " + identifierRef);
    }

    private Element getResource2(String identifierRef) {
        for (int i = 0; i < this.cachedResourceList.length; ++i) {
            Element resource = this.cachedResourceList[i];
            if (identifierRef == null || !identifierRef.equals(resource.getAttributeValue("identifier"))) continue;
            return resource;
        }
        return null;
    }

    @Override
    public String getDefaultItem() {
        return this.defaultItem;
    }

    public void setDefaultItem(String defaultItem) {
        this.defaultItem = defaultItem;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getOrganzationXML() {
        return this.organzationXML;
    }

    public void setOrganzationXML(String organzationXML) {
        this.organzationXML = organzationXML;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

