/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceAttachment;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItem;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceUser;
import org.lamsfoundation.lams.tool.rsrc.util.ResourceToolContentHandler;

public class Resource
implements Cloneable {
    private static final Logger log = Logger.getLogger(Resource.class);
    private Long uid;
    private Long contentId;
    private String title;
    private String instructions;
    private boolean runOffline;
    private boolean runAuto;
    private int miniViewResourceNumber;
    private boolean allowAddFiles;
    private boolean allowAddUrls;
    private boolean lockWhenFinished;
    private boolean defineLater;
    private boolean contentInUse;
    private String onlineInstructions;
    private String offlineInstructions;
    private Set attachments = new HashSet();
    private Date created;
    private Date updated;
    private ResourceUser createdBy;
    private Set resourceItems = new HashSet();
    private boolean reflectOnActivity;
    private String reflectInstructions;
    private IToolContentHandler toolContentHandler;
    private String miniViewNumberStr;
    private List<ResourceAttachment> onlineFileList;
    private List<ResourceAttachment> offlineFileList;

    public static Resource newInstance(Resource defaultContent, Long contentId, ResourceToolContentHandler resourceToolContentHandler) {
        Resource toContent = new Resource();
        defaultContent.toolContentHandler = resourceToolContentHandler;
        toContent = (Resource)defaultContent.clone();
        toContent.setContentId(contentId);
        if (toContent.getCreatedBy() != null) {
            toContent.getCreatedBy().setResource(toContent);
            Set items = toContent.getResourceItems();
            for (ResourceItem item : items) {
                item.setCreateBy(toContent.getCreatedBy());
            }
        }
        return toContent;
    }

    public Object clone() {
        Resource resource = null;
        try {
            HashSet<Cloneable> set;
            Iterator iter;
            resource = (Resource)super.clone();
            resource.setUid(null);
            if (this.resourceItems != null) {
                iter = this.resourceItems.iterator();
                set = new HashSet<Cloneable>();
                while (iter.hasNext()) {
                    ResourceItem item = (ResourceItem)iter.next();
                    ResourceItem newItem = (ResourceItem)item.clone();
                    set.add(newItem);
                }
                resource.resourceItems = set;
            }
            if (this.attachments != null) {
                iter = this.attachments.iterator();
                set = new HashSet();
                while (iter.hasNext()) {
                    ResourceAttachment file = (ResourceAttachment)iter.next();
                    ResourceAttachment newFile = (ResourceAttachment)file.clone();
                    set.add(newFile);
                }
                resource.attachments = set;
            }
            if (this.createdBy != null) {
                resource.setCreatedBy((ResourceUser)this.createdBy.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + Resource.class + " failed"));
        }
        return resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource genericEntity = (Resource)o;
        return new EqualsBuilder().append((Object)this.uid, (Object)genericEntity.uid).append((Object)this.title, (Object)genericEntity.title).append((Object)this.instructions, (Object)genericEntity.instructions).append((Object)this.onlineInstructions, (Object)genericEntity.onlineInstructions).append((Object)this.offlineInstructions, (Object)genericEntity.offlineInstructions).append((Object)this.created, (Object)genericEntity.created).append((Object)this.updated, (Object)genericEntity.updated).append((Object)this.createdBy, (Object)genericEntity.createdBy).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.title).append((Object)this.instructions).append((Object)this.onlineInstructions).append((Object)this.offlineInstructions).append((Object)this.created).append((Object)this.updated).append((Object)this.createdBy).toHashCode();
    }

    public void updateModificationData() {
        long now = System.currentTimeMillis();
        if (this.created == null) {
            this.setCreated(new Date(now));
        }
        this.setUpdated(new Date(now));
    }

    public void toDTO() {
        this.onlineFileList = new ArrayList<ResourceAttachment>();
        this.offlineFileList = new ArrayList<ResourceAttachment>();
        Set fileSet = this.getAttachments();
        if (fileSet != null) {
            for (ResourceAttachment file : fileSet) {
                if (StringUtils.equalsIgnoreCase((String)file.getFileType(), (String)"OFFLINE")) {
                    this.offlineFileList.add(file);
                    continue;
                }
                this.onlineFileList.add(file);
            }
        }
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public ResourceUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(ResourceUser createdBy) {
        this.createdBy = createdBy;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean forceOffline) {
        this.runOffline = forceOffline;
    }

    public boolean getLockWhenFinished() {
        return this.lockWhenFinished;
    }

    public void setLockWhenFinished(boolean lockWhenFinished) {
        this.lockWhenFinished = lockWhenFinished;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set attachments) {
        this.attachments = attachments;
    }

    public Set getResourceItems() {
        return this.resourceItems;
    }

    public void setResourceItems(Set resourceItems) {
        this.resourceItems = resourceItems;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Long getContentId() {
        return this.contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public boolean isAllowAddFiles() {
        return this.allowAddFiles;
    }

    public void setAllowAddFiles(boolean allowAddFiles) {
        this.allowAddFiles = allowAddFiles;
    }

    public boolean isAllowAddUrls() {
        return this.allowAddUrls;
    }

    public void setAllowAddUrls(boolean allowAddUrls) {
        this.allowAddUrls = allowAddUrls;
    }

    public int getMiniViewResourceNumber() {
        return this.miniViewResourceNumber;
    }

    public void setMiniViewResourceNumber(int minViewResourceNumber) {
        this.miniViewResourceNumber = minViewResourceNumber;
    }

    public boolean isRunAuto() {
        return this.runAuto;
    }

    public void setRunAuto(boolean runAuto) {
        this.runAuto = runAuto;
    }

    public String getMiniViewNumberStr() {
        return this.miniViewNumberStr;
    }

    public void setMiniViewNumberStr(String minViewNumber) {
        this.miniViewNumberStr = minViewNumber;
    }

    public List<ResourceAttachment> getOfflineFileList() {
        return this.offlineFileList;
    }

    public void setOfflineFileList(List<ResourceAttachment> offlineFileList) {
        this.offlineFileList = offlineFileList;
    }

    public List<ResourceAttachment> getOnlineFileList() {
        return this.onlineFileList;
    }

    public void setOnlineFileList(List<ResourceAttachment> onlineFileList) {
        this.onlineFileList = onlineFileList;
    }

    public void setToolContentHandler(IToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }
}

