/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.web.action;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.rsrc.model.Resource;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceAttachment;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItem;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItemInstruction;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceUser;
import org.lamsfoundation.lams.tool.rsrc.service.IResourceService;
import org.lamsfoundation.lams.tool.rsrc.service.UploadResourceFileException;
import org.lamsfoundation.lams.tool.rsrc.util.ResourceItemComparator;
import org.lamsfoundation.lams.tool.rsrc.util.ResourceWebUtils;
import org.lamsfoundation.lams.tool.rsrc.web.form.ResourceForm;
import org.lamsfoundation.lams.tool.rsrc.web.form.ResourceItemForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthoringAction
extends Action {
    private static final int INIT_INSTRUCTION_COUNT = 2;
    private static final String INSTRUCTION_ITEM_DESC_PREFIX = "instructionItemDesc";
    private static final String INSTRUCTION_ITEM_COUNT = "instructionCount";
    private static final String ITEM_TYPE = "itemType";
    private static Logger log = Logger.getLogger(AuthoringAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = mapping.getParameter();
        if (param.equals("start")) {
            ToolAccessMode mode = this.getAccessMode(request);
            if (mode != null) {
                request.setAttribute("mode", (Object)mode.toString());
            } else {
                request.setAttribute("mode", (Object)ToolAccessMode.AUTHOR.toString());
            }
            return this.start(mapping, form, request, response);
        }
        if (param.equals("definelater")) {
            Long contentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
            IResourceService service = this.getResourceService();
            Resource resource = service.getResourceByContentId(contentId);
            boolean isEditable = ResourceWebUtils.isResourceEditable(resource);
            if (!isEditable) {
                request.setAttribute("isPageEditable", (Object)new Boolean(isEditable));
                return mapping.findForward("forbidden");
            }
            if (!resource.isContentInUse()) {
                resource.setDefineLater(true);
                service.saveOrUpdateResource(resource);
            }
            request.setAttribute("mode", (Object)ToolAccessMode.TEACHER.toString());
            return this.start(mapping, form, request, response);
        }
        if (param.equals("initPage")) {
            return this.initPage(mapping, form, request, response);
        }
        if (param.equals("updateContent")) {
            return this.updateContent(mapping, form, request, response);
        }
        if (param.equals("uploadOnlineFile")) {
            return this.uploadOnline(mapping, form, request, response);
        }
        if (param.equals("uploadOfflineFile")) {
            return this.uploadOffline(mapping, form, request, response);
        }
        if (param.equals("deleteOnlineFile")) {
            return this.deleteOnlineFile(mapping, form, request, response);
        }
        if (param.equals("deleteOfflineFile")) {
            return this.deleteOfflineFile(mapping, form, request, response);
        }
        if (param.equals("newItemInit")) {
            return this.newItemlInit(mapping, form, request, response);
        }
        if (param.equals("editItemInit")) {
            return this.editItemInit(mapping, form, request, response);
        }
        if (param.equals("saveOrUpdateItem")) {
            return this.saveOrUpdateItem(mapping, form, request, response);
        }
        if (param.equals("removeItem")) {
            return this.removeItem(mapping, form, request, response);
        }
        if (param.equals("newInstruction")) {
            return this.newInstruction(mapping, form, request, response);
        }
        if (param.equals("removeInstruction")) {
            return this.removeInstruction(mapping, form, request, response);
        }
        if (param.equals("removeItemAttachment")) {
            return this.removeItemAttachment(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward removeItemAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("itemAttachment", null);
        return mapping.findForward("success");
    }

    private ActionForward removeItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)-1);
        if (itemIdx != -1) {
            SortedSet<ResourceItem> resourceList = this.getResourceItemList(sessionMap);
            ArrayList<ResourceItem> rList = new ArrayList<ResourceItem>(resourceList);
            ResourceItem item = (ResourceItem)rList.remove(itemIdx);
            resourceList.clear();
            resourceList.addAll(rList);
            List delList = this.getDeletedResourceItemList(sessionMap);
            delList.add(item);
        }
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward editItemInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SortedSet<ResourceItem> resourceList;
        ArrayList<ResourceItem> rList;
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)-1);
        ResourceItem item = null;
        if (itemIdx != -1 && (item = (ResourceItem)(rList = new ArrayList<ResourceItem>(resourceList = this.getResourceItemList(sessionMap))).get(itemIdx)) != null) {
            this.populateItemToForm(itemIdx, item, (ResourceItemForm)form, request);
        }
        return this.findForward(item == null ? (short)-1 : (short)item.getType(), mapping);
    }

    private ActionForward newItemlInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        ((ResourceItemForm)form).setSessionMapID(sessionMapID);
        short type = (short)NumberUtils.stringToInt((String)request.getParameter(ITEM_TYPE));
        ArrayList<String> instructionList = new ArrayList<String>(2);
        for (int idx = 0; idx < 2; ++idx) {
            instructionList.add("");
        }
        request.setAttribute("instructionList", instructionList);
        return this.findForward(type, mapping);
    }

    private ActionForward saveOrUpdateItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ResourceItemForm itemForm;
        block3: {
            List<String> instructionList = this.getInstructionsFromRequest(request);
            itemForm = (ResourceItemForm)form;
            ActionErrors errors = this.validateResourceItem(itemForm);
            if (!errors.isEmpty()) {
                this.addErrors(request, (ActionMessages)errors);
                request.setAttribute("instructionList", instructionList);
                return this.findForward(itemForm.getItemType(), mapping);
            }
            try {
                this.extractFormToResourceItem(request, instructionList, itemForm);
            }
            catch (Exception e) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.upload.failed", (Object)e.getMessage()));
                if (errors.isEmpty()) break block3;
                this.addErrors(request, (ActionMessages)errors);
                request.setAttribute("instructionList", instructionList);
                return this.findForward(itemForm.getItemType(), mapping);
            }
        }
        request.setAttribute("sessionMapID", (Object)itemForm.getSessionMapID());
        return mapping.findForward("success");
    }

    private ActionForward newInstruction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        int count = NumberUtils.stringToInt((String)request.getParameter(INSTRUCTION_ITEM_COUNT), (int)0);
        ArrayList<String> instructionList = new ArrayList<String>(++count);
        for (int idx = 0; idx < count; ++idx) {
            String item = request.getParameter(INSTRUCTION_ITEM_DESC_PREFIX + idx);
            if (item == null) {
                instructionList.add("");
                continue;
            }
            instructionList.add(item);
        }
        request.setAttribute("instructionList", instructionList);
        return mapping.findForward("success");
    }

    private ActionForward removeInstruction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        int count = NumberUtils.stringToInt((String)request.getParameter(INSTRUCTION_ITEM_COUNT), (int)0);
        int removeIdx = NumberUtils.stringToInt((String)request.getParameter("removeIdx"), (int)-1);
        ArrayList<String> instructionList = new ArrayList<String>(count - 1);
        for (int idx = 0; idx < count; ++idx) {
            String item = request.getParameter(INSTRUCTION_ITEM_DESC_PREFIX + idx);
            if (idx == removeIdx) continue;
            if (item == null) {
                instructionList.add("");
                continue;
            }
            instructionList.add(item);
        }
        request.setAttribute("instructionList", instructionList);
        return mapping.findForward("success");
    }

    private ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Long contentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        IResourceService service = this.getResourceService();
        ArrayList items = null;
        Resource resource = null;
        ResourceForm resourceForm = (ResourceForm)form;
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        resourceForm.setContentFolderID(contentFolderID);
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        resourceForm.setSessionMapID(sessionMap.getSessionID());
        try {
            resource = service.getResourceByContentId(contentId);
            items = resource == null ? ((resource = service.getDefaultContent(contentId)).getResourceItems() != null ? new ArrayList(resource.getResourceItems()) : null) : service.getAuthoredItems(resource.getUid());
            resourceForm.setResource(resource);
            List attachmentList = this.getAttachmentList(sessionMap);
            attachmentList.clear();
            attachmentList.addAll(resource.getAttachments());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        if (items == null) {
            items = new ArrayList();
        } else {
            ResourceUser resourceUser = null;
            for (ResourceItem item : items) {
                if (item.getCreateBy() != null) continue;
                if (resourceUser == null) {
                    HttpSession ss = SessionManager.getSession();
                    UserDTO user = (UserDTO)ss.getAttribute("user");
                    resourceUser = new ResourceUser(user, resource);
                }
                item.setCreateBy(resourceUser);
            }
        }
        SortedSet<ResourceItem> resourceItemList = this.getResourceItemList(sessionMap);
        resourceItemList.clear();
        resourceItemList.addAll(items);
        sessionMap.put((Object)"resourceForm", (Object)resourceForm);
        return mapping.findForward("success");
    }

    private ActionForward initPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        ResourceForm existForm = (ResourceForm)((Object)sessionMap.get((Object)"resourceForm"));
        ResourceForm resourceForm = (ResourceForm)form;
        try {
            PropertyUtils.copyProperties((Object)((Object)resourceForm), (Object)((Object)existForm));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        ToolAccessMode mode = this.getAccessMode(request);
        if (mode.isAuthor()) {
            return mapping.findForward("success");
        }
        return mapping.findForward("definelater");
    }

    private ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(resourceForm.getSessionMapID());
        ToolAccessMode mode = this.getAccessMode(request);
        ActionMessages errors = this.validate(resourceForm, mapping, request);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            if (mode.isAuthor()) {
                return mapping.findForward("author");
            }
            return mapping.findForward("monitor");
        }
        Resource resource = resourceForm.getResource();
        IResourceService service = this.getResourceService();
        Resource resourcePO = service.getResourceByContentId(resourceForm.getResource().getContentId());
        if (resourcePO == null) {
            resourcePO = resource;
            resourcePO.setCreated(new Timestamp(new Date().getTime()));
            resourcePO.setUpdated(new Timestamp(new Date().getTime()));
        } else {
            if (mode.isAuthor()) {
                Long uid = resourcePO.getUid();
                PropertyUtils.copyProperties((Object)resourcePO, (Object)resource);
                resourcePO.setUid(uid);
            } else {
                resourcePO.setInstructions(resource.getInstructions());
                resourcePO.setTitle(resource.getTitle());
                resourcePO.setDefineLater(false);
            }
            resourcePO.setUpdated(new Timestamp(new Date().getTime()));
        }
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        ResourceUser resourceUser = service.getUserByIDAndContent(new Long(user.getUserID().intValue()), resourceForm.getResource().getContentId());
        if (resourceUser == null) {
            resourceUser = new ResourceUser(user, resourcePO);
        }
        resourcePO.setCreatedBy(resourceUser);
        HashSet<ResourceAttachment> attPOSet = resourcePO.getAttachments();
        if (attPOSet == null) {
            attPOSet = new HashSet<ResourceAttachment>();
        }
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        for (ResourceAttachment newAtt : attachmentList) {
            attPOSet.add(newAtt);
        }
        attachmentList.clear();
        Iterator iter = deleteAttachmentList.iterator();
        while (iter.hasNext()) {
            ResourceAttachment delAtt = (ResourceAttachment)iter.next();
            iter.remove();
            if (delAtt.getUid() == null) continue;
            Iterator attIter = attPOSet.iterator();
            while (attIter.hasNext()) {
                ResourceAttachment att = (ResourceAttachment)attIter.next();
                if (!delAtt.getUid().equals(att.getUid())) continue;
                attIter.remove();
                break;
            }
            service.deleteResourceAttachment(delAtt.getUid());
        }
        resourcePO.setAttachments(attPOSet);
        LinkedHashSet<ResourceItem> itemList = new LinkedHashSet<ResourceItem>();
        SortedSet<ResourceItem> topics = this.getResourceItemList(sessionMap);
        for (ResourceItem item : topics) {
            if (item == null) continue;
            item.setCreateBy(resourceUser);
            itemList.add(item);
        }
        resourcePO.setResourceItems(itemList);
        List delResourceItemList = this.getDeletedResourceItemList(sessionMap);
        iter = delResourceItemList.iterator();
        while (iter.hasNext()) {
            ResourceItem item = (ResourceItem)iter.next();
            iter.remove();
            if (item.getUid() == null) continue;
            service.deleteResourceItem(item.getUid());
        }
        List delItemAttList = this.getDeletedItemAttachmentList(sessionMap);
        iter = delItemAttList.iterator();
        while (iter.hasNext()) {
            ResourceItem delAtt = (ResourceItem)iter.next();
            iter.remove();
        }
        if (resourcePO.getMiniViewResourceNumber() > topics.size()) {
            resourcePO.setMiniViewResourceNumber(topics.size());
        }
        service.saveOrUpdateResource(resourcePO);
        attachmentList = this.getAttachmentList(sessionMap);
        attachmentList.addAll(resource.getAttachments());
        resourceForm.setResource(resourcePO);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        if (mode.isAuthor()) {
            return mapping.findForward("author");
        }
        return mapping.findForward("monitor");
    }

    public ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws UploadResourceFileException {
        return this.uploadFile(mapping, form, "ONLINE", request);
    }

    public ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws UploadResourceFileException {
        return this.uploadFile(mapping, form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, ActionForm form, String type, HttpServletRequest request) throws UploadResourceFileException {
        ResourceForm resourceForm = (ResourceForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(resourceForm.getSessionMapID());
        FormFile file = StringUtils.equals((String)"OFFLINE", (String)type) ? resourceForm.getOfflineFile() : resourceForm.getOnlineFile();
        if (file == null || StringUtils.isBlank((String)file.getFileName())) {
            return mapping.findForward("success");
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("success");
        }
        IResourceService service = this.getResourceService();
        ResourceAttachment att = service.uploadInstructionFile(file, type);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            ResourceAttachment existAtt = (ResourceAttachment)iter.next();
            if (!StringUtils.equals((String)existAtt.getFileName(), (String)att.getFileName())) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
            break;
        }
        attachmentList.add(att);
        return mapping.findForward("success");
    }

    public ActionForward deleteOfflineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, request, response, form, "OFFLINE");
    }

    public ActionForward deleteOnlineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, request, response, form, "ONLINE");
    }

    private ActionForward deleteFile(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, ActionForm form, String type) {
        Long versionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"fileVersionId"));
        Long uuID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"fileUuid"));
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            ResourceAttachment existAtt = (ResourceAttachment)iter.next();
            if (!existAtt.getFileUuid().equals(uuID) || !existAtt.getFileVersionId().equals(versionID)) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
        }
        request.setAttribute("fileTypeFlag", (Object)type);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private IResourceService getResourceService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IResourceService)wac.getBean("resourceService");
    }

    private List getAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "instructionAttachmentList");
    }

    private List getDeletedAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedAttachmmentList");
    }

    private SortedSet<ResourceItem> getResourceItemList(SessionMap sessionMap) {
        TreeSet<ResourceItem> list = (TreeSet<ResourceItem>)sessionMap.get((Object)"resourceList");
        if (list == null) {
            list = new TreeSet<ResourceItem>(new ResourceItemComparator());
            sessionMap.put((Object)"resourceList", list);
        }
        return list;
    }

    private List getDeletedResourceItemList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deleteResourceList");
    }

    private List getDeletedItemAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedItemAttachmmentList");
    }

    private List getListFromSession(SessionMap sessionMap, String name) {
        ArrayList list = (ArrayList)sessionMap.get((Object)name);
        if (list == null) {
            list = new ArrayList();
            sessionMap.put((Object)name, list);
        }
        return list;
    }

    private List<String> getInstructionsFromRequest(HttpServletRequest request) {
        String list = request.getParameter("instructionList");
        String[] params = list.split("&");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String item : params) {
            String[] pair = item.split("=");
            if (pair == null || pair.length != 2) continue;
            try {
                paramMap.put(pair[0], URLDecoder.decode(pair[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Error occurs when decode instruction string:" + e.toString()));
            }
        }
        int count = NumberUtils.stringToInt((String)((String)paramMap.get(INSTRUCTION_ITEM_COUNT)));
        ArrayList<String> instructionList = new ArrayList<String>();
        for (int idx = 0; idx < count; ++idx) {
            String item;
            item = (String)paramMap.get(INSTRUCTION_ITEM_DESC_PREFIX + idx);
            if (item == null) continue;
            instructionList.add(item);
        }
        return instructionList;
    }

    private ActionForward findForward(short type, ActionMapping mapping) {
        ActionForward forward;
        switch (type) {
            case 1: {
                forward = mapping.findForward("url");
                break;
            }
            case 2: {
                forward = mapping.findForward("file");
                break;
            }
            case 3: {
                forward = mapping.findForward("website");
                break;
            }
            case 4: {
                forward = mapping.findForward("learningobject");
                break;
            }
            default: {
                forward = null;
            }
        }
        return forward;
    }

    private void populateItemToForm(int itemIdx, ResourceItem item, ResourceItemForm form, HttpServletRequest request) {
        form.setDescription(item.getDescription());
        form.setTitle(item.getTitle());
        form.setUrl(item.getUrl());
        form.setOpenUrlNewWindow(item.isOpenUrlNewWindow());
        if (itemIdx >= 0) {
            form.setItemIndex(new Integer(itemIdx).toString());
        }
        Set instructionList = item.getItemInstructions();
        ArrayList<String> instructions = new ArrayList<String>();
        for (ResourceItemInstruction in : instructionList) {
            instructions.add(in.getDescription());
        }
        if (item.getFileUuid() != null) {
            form.setFileUuid(item.getFileUuid());
            form.setFileVersionId(item.getFileVersionId());
            form.setFileName(item.getFileName());
            form.setHasFile(true);
        } else {
            form.setHasFile(false);
        }
        request.setAttribute("instructionList", instructions);
    }

    private void extractFormToResourceItem(HttpServletRequest request, List<String> instructionList, ResourceItemForm itemForm) throws Exception {
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(itemForm.getSessionMapID());
        SortedSet<ResourceItem> resourceList = this.getResourceItemList(sessionMap);
        int itemIdx = NumberUtils.stringToInt((String)itemForm.getItemIndex(), (int)-1);
        ResourceItem item = null;
        if (itemIdx == -1) {
            item = new ResourceItem();
            item.setCreateDate(new Timestamp(new Date().getTime()));
            resourceList.add(item);
        } else {
            ArrayList<ResourceItem> rList = new ArrayList<ResourceItem>(resourceList);
            item = (ResourceItem)rList.get(itemIdx);
        }
        short type = itemForm.getItemType();
        item.setType(itemForm.getItemType());
        if (itemForm.getFile() != null && (type == 3 || type == 4 || type == 2)) {
            ResourceItem delAttItem = new ResourceItem();
            boolean hasOld = false;
            if (item.getFileUuid() != null) {
                hasOld = true;
                delAttItem.setFileUuid(item.getFileUuid());
                delAttItem.setFileVersionId(item.getFileVersionId());
            }
            IResourceService service = this.getResourceService();
            try {
                service.uploadResourceItemFile(item, itemForm.getFile());
            }
            catch (UploadResourceFileException e) {
                if (itemIdx == -1) {
                    resourceList.remove(item);
                }
                throw e;
            }
            if (hasOld) {
                List delAtt = this.getDeletedItemAttachmentList(sessionMap);
                delAtt.add(delAttItem);
            }
        }
        item.setTitle(itemForm.getTitle());
        item.setCreateByAuthor(true);
        item.setHide(false);
        LinkedHashSet<ResourceItemInstruction> instructions = new LinkedHashSet<ResourceItemInstruction>();
        int idx = 0;
        for (String ins : instructionList) {
            ResourceItemInstruction rii = new ResourceItemInstruction();
            rii.setDescription(ins);
            rii.setSequenceId(idx++);
            instructions.add(rii);
        }
        item.setItemInstructions(instructions);
        if (type == 1) {
            item.setUrl(itemForm.getUrl());
            item.setOpenUrlNewWindow(itemForm.isOpenUrlNewWindow());
        }
        item.setDescription(itemForm.getDescription());
    }

    private ActionErrors validateResourceItem(ResourceItemForm itemForm) {
        ActionErrors errors = new ActionErrors();
        if (StringUtils.isBlank((String)itemForm.getTitle())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.resource.item.title.blank"));
        }
        if (itemForm.getItemType() == 1 && StringUtils.isBlank((String)itemForm.getUrl())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.resource.item.url.blank"));
        }
        if (itemForm.getItemType() == 3 || itemForm.getItemType() == 4 || itemForm.getItemType() == 2) {
            FileValidatorUtil.validateFileSize((FormFile)itemForm.getFile(), (boolean)true, (ActionMessages)errors);
            if (!itemForm.isHasFile() && (itemForm.getFile() == null || StringUtils.isEmpty((String)itemForm.getFile().getFileName()))) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.resource.item.file.blank"));
            }
        }
        return errors;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    private ActionMessages validate(ResourceForm resourceForm, ActionMapping mapping, HttpServletRequest request) {
        ActionMessages errors = new ActionMessages();
        String modeStr = request.getParameter("mode");
        if (StringUtils.equals((String)modeStr, (String)ToolAccessMode.TEACHER.toString())) {
            return errors;
        }
        return errors;
    }
}

