/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.web.action;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.rsrc.model.Resource;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItem;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceSession;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceUser;
import org.lamsfoundation.lams.tool.rsrc.service.IResourceService;
import org.lamsfoundation.lams.tool.rsrc.service.ResourceApplicationException;
import org.lamsfoundation.lams.tool.rsrc.service.UploadResourceFileException;
import org.lamsfoundation.lams.tool.rsrc.util.ResourceItemComparator;
import org.lamsfoundation.lams.tool.rsrc.web.form.ReflectionForm;
import org.lamsfoundation.lams.tool.rsrc.web.form.ResourceItemForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LearningAction
extends Action {
    private static Logger log = Logger.getLogger(LearningAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String param = mapping.getParameter();
        if (param.equals("start")) {
            return this.start(mapping, form, request, response);
        }
        if (param.equals("complete")) {
            return this.complete(mapping, form, request, response);
        }
        if (param.equals("finish")) {
            return this.finish(mapping, form, request, response);
        }
        if (param.equals("addfile")) {
            return this.addItem(mapping, form, request, response);
        }
        if (param.equals("addurl")) {
            return this.addItem(mapping, form, request, response);
        }
        if (param.equals("saveOrUpdateItem")) {
            return this.saveOrUpdateItem(mapping, form, request, response);
        }
        if (param.equals("newReflection")) {
            return this.newReflection(mapping, form, request, response);
        }
        if (param.equals("submitReflection")) {
            return this.submitReflection(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward addItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ResourceItemForm itemForm = (ResourceItemForm)form;
        itemForm.setMode(WebUtil.readStrParam((HttpServletRequest)request, (String)"mode"));
        itemForm.setSessionMapID(WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID"));
        return mapping.findForward("success");
    }

    private ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        NotebookEntry notebookEntry;
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        Long sessionId = new Long(request.getParameter("toolSessionID"));
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        request.setAttribute("mode", (Object)mode);
        request.setAttribute("toolSessionID", (Object)sessionId);
        IResourceService service = this.getResourceService();
        ResourceUser resourceUser = null;
        resourceUser = mode != null && mode.isTeacher() ? this.getSpecifiedUser(service, sessionId, WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)false)) : this.getCurrentUser(service, sessionId);
        List<ResourceItem> items = null;
        items = service.getResourceItemsBySessionId(sessionId);
        Resource resource = service.getResourceBySessionId(sessionId);
        boolean lock = resource.getLockWhenFinished() && resourceUser != null && resourceUser.isSessionFinished();
        boolean runAuto = false;
        int itemsNumber = 0;
        if (resource.getResourceItems() != null) {
            ResourceItem item;
            itemsNumber = resource.getResourceItems().size();
            if (resource.isRunAuto() && itemsNumber == 1 && !(item = (ResourceItem)resource.getResourceItems().iterator().next()).isHide()) {
                runAuto = true;
                request.setAttribute("itemUid", (Object)item.getUid());
            }
        }
        String entryText = new String();
        if (resourceUser != null && (notebookEntry = service.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "larsrc11", resourceUser.getUserId().intValue())) != null) {
            entryText = notebookEntry.getEntry();
        }
        sessionMap.put((Object)"title", (Object)resource.getTitle());
        sessionMap.put((Object)"instructions", (Object)resource.getInstructions());
        sessionMap.put((Object)"finishedLock", (Object)lock);
        sessionMap.put((Object)"userFinished", (Object)(resourceUser != null && resourceUser.isSessionFinished() ? 1 : 0));
        sessionMap.put((Object)"toolSessionID", (Object)sessionId);
        sessionMap.put((Object)"mode", (Object)mode);
        sessionMap.put((Object)"reflectOn", (Object)resource.isReflectOnActivity());
        sessionMap.put((Object)"reflectInstructions", (Object)resource.getReflectInstructions());
        sessionMap.put((Object)"reflectEntry", (Object)entryText);
        sessionMap.put((Object)"runAuto", (Object)new Boolean(runAuto));
        if (resource.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        resource.setContentInUse(true);
        resource.setDefineLater(false);
        service.saveOrUpdateResource(resource);
        if (resource.getRunOffline()) {
            sessionMap.put((Object)"runOffline", (Object)true);
            return mapping.findForward("runOffline");
        }
        sessionMap.put((Object)"runOffline", (Object)false);
        SortedSet<ResourceItem> resourceItemList = this.getResourceItemList(sessionMap);
        resourceItemList.clear();
        if (items != null) {
            for (ResourceItem item : items) {
                if (item.getCreateBy() != null) {
                    item.getCreateBy().getLoginName();
                }
                if (item.isHide()) continue;
                resourceItemList.add(item);
            }
        }
        if (resourceUser != null) {
            service.retrieveComplete(resourceItemList, resourceUser);
        }
        sessionMap.put((Object)"resource", (Object)resource);
        return mapping.findForward("success");
    }

    private ActionForward complete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String mode = request.getParameter("mode");
        String sessionMapID = request.getParameter("sessionMapID");
        this.doComplete(request);
        request.setAttribute("mode", (Object)mode);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        ToolAccessMode mode = (ToolAccessMode)sessionMap.get((Object)"mode");
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        String resourceItemUid = request.getParameter("itemUid");
        if (resourceItemUid != null) {
            this.doComplete(request);
            request.setAttribute("runAuto", (Object)true);
        } else {
            request.setAttribute("runAuto", (Object)false);
        }
        if (!this.validateBeforeFinish(request, sessionMapID)) {
            return mapping.getInputForward();
        }
        IResourceService service = this.getResourceService();
        String nextActivityUrl = null;
        try {
            HttpSession ss = SessionManager.getSession();
            UserDTO user = (UserDTO)ss.getAttribute("user");
            Long userID = new Long(user.getUserID().longValue());
            nextActivityUrl = service.finishToolSession(sessionId, userID);
            request.setAttribute("nextActivityUrl", (Object)nextActivityUrl);
        }
        catch (ResourceApplicationException e) {
            log.error((Object)("Failed get next activity url:" + e.getMessage()));
        }
        return mapping.findForward("success");
    }

    private ActionForward saveOrUpdateItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        String mode = request.getParameter("mode");
        ResourceItemForm itemForm = (ResourceItemForm)form;
        ActionErrors errors = this.validateResourceItem(itemForm);
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
            return this.findForward(itemForm.getItemType(), mapping);
        }
        short type = itemForm.getItemType();
        ResourceItem item = new ResourceItem();
        IResourceService service = this.getResourceService();
        ResourceUser resourceUser = this.getCurrentUser(service, sessionId);
        item.setType(type);
        item.setTitle(itemForm.getTitle());
        item.setDescription(itemForm.getDescription());
        item.setCreateDate(new Timestamp(new Date().getTime()));
        item.setCreateByAuthor(false);
        item.setCreateBy(resourceUser);
        if (type == 2) {
            try {
                service.uploadResourceItemFile(item, itemForm.getFile());
            }
            catch (UploadResourceFileException e) {
                log.error((Object)("Failed upload Resource File " + e.toString()));
                return mapping.findForward("error");
            }
        } else if (type == 1) {
            item.setUrl(itemForm.getUrl());
            item.setOpenUrlNewWindow(itemForm.isOpenUrlNewWindow());
        }
        ResourceSession resSession = service.getResourceSessionBySessionId(sessionId);
        if (resSession == null) {
            log.error((Object)("Failed update ResourceSession by ID[" + sessionId + "]"));
            return mapping.findForward("error");
        }
        HashSet<ResourceItem> items = resSession.getResourceItems();
        if (items == null) {
            items = new HashSet<ResourceItem>();
            resSession.setResourceItems(items);
        }
        items.add(item);
        service.saveOrUpdateResourceSession(resSession);
        SortedSet<ResourceItem> resourceItemList = this.getResourceItemList(sessionMap);
        resourceItemList.add(item);
        request.setAttribute("addType", (Object)new Short(type));
        request.setAttribute("mode", (Object)mode);
        return mapping.findForward("success");
    }

    private ActionForward newReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        if (!this.validateBeforeFinish(request, sessionMapID)) {
            return mapping.getInputForward();
        }
        ReflectionForm refForm = (ReflectionForm)form;
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        refForm.setUserID(user.getUserID());
        refForm.setSessionMapID(sessionMapID);
        IResourceService submitFilesService = this.getResourceService();
        SessionMap map = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long toolSessionID = (Long)map.get((Object)"toolSessionID");
        NotebookEntry entry = submitFilesService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "larsrc11", user.getUserID());
        if (entry != null) {
            refForm.setEntryText(entry.getEntry());
        }
        return mapping.findForward("success");
    }

    private ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReflectionForm refForm = (ReflectionForm)form;
        Integer userId = refForm.getUserID();
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        IResourceService service = this.getResourceService();
        NotebookEntry entry = service.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "larsrc11", userId);
        if (entry == null) {
            service.createNotebookEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "larsrc11", userId, refForm.getEntryText());
        } else {
            entry.setEntry(refForm.getEntryText());
            entry.setLastModified(new Date());
            service.updateEntry(entry);
        }
        return this.finish(mapping, form, request, response);
    }

    private boolean validateBeforeFinish(HttpServletRequest request, String sessionMapID) {
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Long userID = new Long(user.getUserID().longValue());
        IResourceService service = this.getResourceService();
        int miniViewFlag = service.checkMiniView(sessionId, userID);
        Boolean runOffline = (Boolean)sessionMap.get((Object)"runOffline");
        if (miniViewFlag > 0 && !runOffline.booleanValue()) {
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("lable.learning.minimum.view.number.less", (Object)miniViewFlag));
            this.addErrors(request, (ActionMessages)errors);
            return false;
        }
        return true;
    }

    private IResourceService getResourceService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IResourceService)wac.getBean("resourceService");
    }

    private SortedSet<ResourceItem> getResourceItemList(SessionMap sessionMap) {
        TreeSet<ResourceItem> list = (TreeSet<ResourceItem>)sessionMap.get((Object)"resourceList");
        if (list == null) {
            list = new TreeSet<ResourceItem>(new ResourceItemComparator());
            sessionMap.put((Object)"resourceList", list);
        }
        return list;
    }

    private List getListFromSession(SessionMap sessionMap, String name) {
        ArrayList list = (ArrayList)sessionMap.get((Object)name);
        if (list == null) {
            list = new ArrayList();
            sessionMap.put((Object)name, list);
        }
        return list;
    }

    private ActionForward findForward(short type, ActionMapping mapping) {
        ActionForward forward;
        switch (type) {
            case 1: {
                forward = mapping.findForward("url");
                break;
            }
            case 2: {
                forward = mapping.findForward("file");
                break;
            }
            case 3: {
                forward = mapping.findForward("website");
                break;
            }
            case 4: {
                forward = mapping.findForward("learningobject");
                break;
            }
            default: {
                forward = null;
            }
        }
        return forward;
    }

    private ResourceUser getCurrentUser(IResourceService service, Long sessionId) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        ResourceUser resourceUser = service.getUserByIDAndSession(new Long(user.getUserID().intValue()), sessionId);
        if (resourceUser == null) {
            ResourceSession session = service.getResourceSessionBySessionId(sessionId);
            resourceUser = new ResourceUser(user, session);
            service.createUser(resourceUser);
        }
        return resourceUser;
    }

    private ResourceUser getSpecifiedUser(IResourceService service, Long sessionId, Integer userId) {
        ResourceUser resourceUser = service.getUserByIDAndSession(new Long(userId.intValue()), sessionId);
        if (resourceUser == null) {
            log.error((Object)("Unable to find specified user for share resources activity. Screens are likely to fail. SessionId=" + sessionId + " UserId=" + userId));
        }
        return resourceUser;
    }

    private ActionErrors validateResourceItem(ResourceItemForm itemForm) {
        ActionErrors errors = new ActionErrors();
        if (StringUtils.isBlank((String)itemForm.getTitle())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.resource.item.title.blank"));
        }
        if (itemForm.getItemType() == 1 && StringUtils.isBlank((String)itemForm.getUrl())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.resource.item.url.blank"));
        }
        if (itemForm.getItemType() == 3 || itemForm.getItemType() == 4 || itemForm.getItemType() == 2) {
            if (itemForm.getFile() != null && FileUtil.isExecutableFile((String)itemForm.getFile().getFileName())) {
                ActionMessage msg = new ActionMessage("error.attachment.executable");
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", msg);
            }
            FileValidatorUtil.validateFileSize((FormFile)itemForm.getFile(), (boolean)false, (ActionMessages)errors);
            if (!itemForm.isHasFile() && (itemForm.getFile() == null || StringUtils.isEmpty((String)itemForm.getFile().getFileName()))) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.resource.item.file.blank"));
            }
        }
        return errors;
    }

    private void doComplete(HttpServletRequest request) {
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long resourceItemUid = new Long(request.getParameter("itemUid"));
        IResourceService service = this.getResourceService();
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        service.setItemComplete(resourceItemUid, new Long(user.getUserID().intValue()), sessionId);
        SortedSet<ResourceItem> resourceItemList = this.getResourceItemList(sessionMap);
        for (ResourceItem item : resourceItemList) {
            if (!item.getUid().equals(resourceItemUid)) continue;
            item.setComplete(true);
            break;
        }
    }
}

