/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.rsrc.web.action;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.rsrc.dto.InstructionNavDTO;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItem;
import org.lamsfoundation.lams.tool.rsrc.model.ResourceItemInstruction;
import org.lamsfoundation.lams.tool.rsrc.service.IResourceService;
import org.lamsfoundation.lams.tool.rsrc.util.ResourceItemComparator;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ViewItemAction
extends Action {
    private static final Logger log = Logger.getLogger(ViewItemAction.class);
    private static final String DEFUALT_PROTOCOL_REFIX = "http://";
    private static final String ALLOW_PROTOCOL_REFIX = new String("[http://|https://|ftp://|nntp://]");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String param = mapping.getParameter();
        if (param.equals("reviewItem")) {
            return this.reviewItem(mapping, form, request, response);
        }
        if (param.equals("nextInstruction")) {
            return this.nextInstruction(mapping, form, request, response);
        }
        if (param.equals("openUrlPopup")) {
            return this.openUrlPopup(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward openUrlPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String url = request.getParameter("popupUrl");
        String title = request.getParameter("title");
        request.setAttribute("popupUrl", (Object)url);
        request.setAttribute("title", (Object)title);
        return mapping.findForward("success");
    }

    private ActionForward nextInstruction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String mode = request.getParameter("mode");
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sesionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        ResourceItem item = this.getResourceItem(request, sesionMap, mode);
        if (item == null) {
            return mapping.findForward("error");
        }
        int currIns = NumberUtils.stringToInt((String)request.getParameter("insIdx"), (int)0);
        Set instructions = item.getItemInstructions();
        InstructionNavDTO navDto = new InstructionNavDTO();
        if (!item.isCreateByAuthor()) {
            ArrayList<ResourceItemInstruction> navItems = new ArrayList<ResourceItemInstruction>(1);
            ResourceItemInstruction ins = new ResourceItemInstruction();
            ins.setSequenceId(1);
            ins.setDescription(item.getDescription());
            navItems.add(ins);
            navDto.setAllInstructions(navItems);
            instructions.add(ins);
        } else {
            navDto.setAllInstructions(new ArrayList(instructions));
        }
        navDto.setTitle(item.getTitle());
        navDto.setType(item.getType());
        navDto.setTotal(instructions.size());
        if (instructions.size() > 0) {
            navDto.setInstruction((ResourceItemInstruction)new ArrayList(instructions).get(currIns));
            navDto.setCurrent(currIns + 1);
        } else {
            navDto.setCurrent(0);
            navDto.setInstruction(null);
        }
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        request.setAttribute("instructions", (Object)navDto);
        return mapping.findForward("success");
    }

    private ActionForward reviewItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String mode = request.getParameter("mode");
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        ResourceItem item = this.getResourceItem(request, sessionMap, mode);
        String idStr = request.getParameter("toolSessionID");
        Long sessionId = NumberUtils.createLong((String)idStr);
        if (ToolAccessMode.LEARNER.toString().equals(mode)) {
            IResourceService service = this.getResourceService();
            HttpSession ss = SessionManager.getSession();
            UserDTO user = (UserDTO)ss.getAttribute("user");
            service.setItemAccess(item.getUid(), new Long(user.getUserID().intValue()), sessionId);
        }
        if (item == null) {
            return mapping.findForward("error");
        }
        if (item.getType() == 4) {
            sessionMap.put((Object)"cpPackage", (Object)item);
        }
        request.setAttribute("resourceItemReviewUrl", this.getReviewUrl(item, sessionMapID));
        request.setAttribute("mode", (Object)mode);
        int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"));
        request.setAttribute("itemIndex", (Object)itemIdx);
        Long itemUid = NumberUtils.createLong((String)request.getParameter("itemUid"));
        request.setAttribute("itemUid", (Object)itemUid);
        request.setAttribute("toolSessionID", (Object)sessionId);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("success");
    }

    private ResourceItem getResourceItem(HttpServletRequest request, SessionMap sessionMap, String mode) {
        ResourceItem item = null;
        if ("author_session".equals(mode)) {
            int itemIdx = NumberUtils.stringToInt((String)request.getParameter("itemIndex"), (int)0);
            ArrayList<ResourceItem> resourceList = new ArrayList<ResourceItem>(this.getResourceItemList(sessionMap));
            item = (ResourceItem)resourceList.get(itemIdx);
        } else {
            Long itemUid = NumberUtils.createLong((String)request.getParameter("itemUid"));
            IResourceService service = this.getResourceService();
            item = service.getResourceItemByUid(itemUid);
        }
        return item;
    }

    private IResourceService getResourceService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IResourceService)wac.getBean("resourceService");
    }

    private Object getReviewUrl(ResourceItem item, String sessionMapID) {
        short type = item.getType();
        String url = null;
        switch (type) {
            case 1: {
                if (item.isOpenUrlNewWindow()) {
                    try {
                        url = "/openUrlPopup.do?popupUrl=" + URLEncoder.encode(this.protocol(item.getUrl()), "UTF8") + "&title=" + URLEncoder.encode(item.getTitle(), "UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)e);
                    }
                    break;
                }
                url = this.protocol(item.getUrl());
                break;
            }
            case 2: {
                url = "/download/?uuid=" + item.getFileUuid() + "&preferDownload=false";
                break;
            }
            case 3: {
                url = "/download/?uuid=" + item.getFileUuid() + "&preferDownload=false";
                break;
            }
            case 4: {
                url = "/pages/learningobj/mainframe.jsp?sessionMapID=" + sessionMapID;
            }
        }
        return url;
    }

    private String protocol(String url) {
        if (url == null) {
            return "";
        }
        if (!url.matches("^" + ALLOW_PROTOCOL_REFIX + ".*")) {
            url = DEFUALT_PROTOCOL_REFIX + url;
        }
        return url;
    }

    private SortedSet<ResourceItem> getResourceItemList(SessionMap sessionMap) {
        TreeSet<ResourceItem> list = (TreeSet<ResourceItem>)sessionMap.get((Object)"resourceList");
        if (list == null) {
            list = new TreeSet<ResourceItem>(new ResourceItemComparator());
            sessionMap.put((Object)"resourceList", list);
        }
        return list;
    }
}

