/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.security;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.log4j.Logger;

public class SingleSignOn
extends org.apache.catalina.authenticator.SingleSignOn {
    private static Logger log = Logger.getLogger(SingleSignOn.class);

    public void invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        request.removeNote("org.apache.catalina.request.SSOID");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process request for '" + request.getRequestURI() + "'"));
        }
        Principal p = request.getUserPrincipal();
        String username = null;
        String password = null;
        if (request.getUserPrincipal() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Principal '" + request.getUserPrincipal().getName() + "' has already been authenticated"));
            }
            this.getNext().invoke(request, response);
            return;
        }
        Session session = request.getSessionInternal(false);
        if (session != null) {
            p = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            username = (String)session.getNote("org.apache.catalina.session.PASSWORD");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" SSO cookie is not present");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Checking for cached principal for " + cookie.getValue()));
        }
        if (p != null) {
            log.debug((Object)("principal - " + p.getName()));
            this.register(cookie.getValue(), p, "FORM", username, password);
        }
        if ((entry = this.lookup(cookie.getValue())) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Found cached principal '" + entry.getPrincipal().getName() + "' with auth type '" + entry.getAuthType() + "'"));
            }
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            if (!this.getRequireReauthentication()) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(entry.getPrincipal());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }
}

