/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.filetransfer.Base64;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.IBBExtensions;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class IBBTransferNegotiator
extends StreamNegotiator {
    protected static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    private XMPPConnection connection;
    static /* synthetic */ Class class$org$jivesoftware$smackx$packet$IBBExtensions$Close;
    static /* synthetic */ Class class$org$jivesoftware$smackx$packet$IBBExtensions$Open;

    protected IBBTransferNegotiator(XMPPConnection connection) {
        this.connection = connection;
    }

    public PacketFilter getInitiationPacketFilter(String from, String streamID) {
        return new AndFilter((PacketFilter)new FromContainsFilter(from), (PacketFilter)new IBBOpenSidFilter(streamID));
    }

    InputStream negotiateIncomingStream(Packet streamInitiation) throws XMPPException {
        IBBExtensions.Open openRequest = (IBBExtensions.Open)streamInitiation;
        if (openRequest.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException(openRequest.getError());
        }
        IBBMessageSidFilter dataFilter = new IBBMessageSidFilter(openRequest.getFrom(), openRequest.getSessionID());
        AndFilter closeFilter = new AndFilter((PacketFilter)new PacketTypeFilter(class$org$jivesoftware$smackx$packet$IBBExtensions$Close == null ? (class$org$jivesoftware$smackx$packet$IBBExtensions$Close = IBBTransferNegotiator.class$("org.jivesoftware.smackx.packet.IBBExtensions$Close")) : class$org$jivesoftware$smackx$packet$IBBExtensions$Close), (PacketFilter)new FromMatchesFilter(openRequest.getFrom()));
        IBBInputStream stream = new IBBInputStream(openRequest.getSessionID(), dataFilter, (PacketFilter)closeFilter);
        this.initInBandTransfer(openRequest);
        return stream;
    }

    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException {
        Packet openRequest = this.initiateIncomingStream(this.connection, initiation);
        return this.negotiateIncomingStream(openRequest);
    }

    private void initInBandTransfer(IBBExtensions.Open openRequest) {
        this.connection.sendPacket((Packet)FileTransferNegotiator.createIQ(openRequest.getPacketID(), openRequest.getFrom(), openRequest.getTo(), IQ.Type.RESULT));
    }

    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws XMPPException {
        IBBExtensions.Open openIQ = new IBBExtensions.Open(streamID, 4096);
        openIQ.setTo(target);
        openIQ.setType(IQ.Type.SET);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(openIQ.getPacketID()));
        this.connection.sendPacket((Packet)openIQ);
        IQ openResponse = (IQ)collector.nextResult();
        collector.cancel();
        if (openResponse == null) {
            throw new XMPPException("No response from peer");
        }
        IQ.Type type = openResponse.getType();
        if (!type.equals(IQ.Type.RESULT)) {
            if (type.equals(IQ.Type.ERROR)) {
                throw new XMPPException("Target returned an error", openResponse.getError());
            }
            throw new XMPPException("Target returned unknown response");
        }
        return new IBBOutputStream(target, streamID, 4096);
    }

    public String[] getNamespaces() {
        return new String[]{NAMESPACE};
    }

    public void cleanup() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IBBMessageSidFilter
    implements PacketFilter {
        private final String sessionID;
        private String from;

        public IBBMessageSidFilter(String from, String sessionID) {
            this.from = from;
            this.sessionID = sessionID;
        }

        public boolean accept(Packet packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            if (!packet.getFrom().equalsIgnoreCase(this.from)) {
                return false;
            }
            IBBExtensions.Data data = (IBBExtensions.Data)packet.getExtension("data", IBBTransferNegotiator.NAMESPACE);
            if (data == null) {
                return false;
            }
            return data.getSessionID() != null && data.getSessionID().equalsIgnoreCase(this.sessionID);
        }
    }

    private static class IBBOpenSidFilter
    implements PacketFilter {
        private String sessionID;

        public IBBOpenSidFilter(String sessionID) {
            if (sessionID == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = sessionID;
        }

        public boolean accept(Packet packet) {
            if (!(class$org$jivesoftware$smackx$packet$IBBExtensions$Open == null ? (class$org$jivesoftware$smackx$packet$IBBExtensions$Open = IBBTransferNegotiator.class$("org.jivesoftware.smackx.packet.IBBExtensions$Open")) : class$org$jivesoftware$smackx$packet$IBBExtensions$Open).isInstance(packet)) {
                return false;
            }
            IBBExtensions.Open open = (IBBExtensions.Open)packet;
            String sessionID = open.getSessionID();
            return sessionID != null && sessionID.equals(this.sessionID);
        }
    }

    private class IBBInputStream
    extends InputStream
    implements PacketListener {
        private String streamID;
        private PacketCollector dataCollector;
        private byte[] buffer;
        private int bufferPointer;
        private int seq = -1;
        private boolean isDone;
        private boolean isEOF;
        private boolean isClosed;
        private IQ closeConfirmation;
        private Message lastMess;

        private IBBInputStream(String streamID, PacketFilter dataFilter, PacketFilter closeFilter) {
            this.streamID = streamID;
            this.dataCollector = IBBTransferNegotiator.this.connection.createPacketCollector(dataFilter);
            IBBTransferNegotiator.this.connection.addPacketListener((PacketListener)this, closeFilter);
            this.bufferPointer = -1;
        }

        public synchronized int read() throws IOException {
            if (this.isEOF || this.isClosed) {
                return -1;
            }
            if (this.bufferPointer == -1 || this.bufferPointer >= this.buffer.length) {
                this.loadBufferWait();
            }
            return this.buffer[this.bufferPointer++];
        }

        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.isEOF || this.isClosed) {
                return -1;
            }
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBufferWait())) {
                this.isEOF = true;
                return -1;
            }
            if (len - off > this.buffer.length - this.bufferPointer) {
                len = this.buffer.length - this.bufferPointer;
            }
            System.arraycopy(this.buffer, this.bufferPointer, b, off, len);
            this.bufferPointer += len;
            return len;
        }

        private boolean loadBufferWait() throws IOException {
            Message mess = null;
            while (mess == null) {
                if (this.isDone) {
                    mess = (Message)this.dataCollector.pollResult();
                    if (mess != null) continue;
                    return false;
                }
                mess = (Message)this.dataCollector.nextResult(1000L);
            }
            this.lastMess = mess;
            IBBExtensions.Data data = (IBBExtensions.Data)mess.getExtension("data", IBBTransferNegotiator.NAMESPACE);
            this.checkSequence(mess, (int)data.getSeq());
            this.buffer = Base64.decode(data.getData());
            this.bufferPointer = 0;
            return true;
        }

        private void checkSequence(Message mess, int seq) throws IOException {
            if (this.seq == 65535) {
                this.seq = -1;
            }
            if (seq - 1 != this.seq) {
                this.cancelTransfer(mess);
                throw new IOException("Packets out of sequence");
            }
            this.seq = seq;
        }

        private void cancelTransfer(Message mess) {
            this.cleanup();
            this.sendCancelMessage(mess);
        }

        private void cleanup() {
            this.dataCollector.cancel();
            IBBTransferNegotiator.this.connection.removePacketListener((PacketListener)this);
        }

        private void sendCancelMessage(Message message) {
            IQ error = FileTransferNegotiator.createIQ(message.getPacketID(), message.getFrom(), message.getTo(), IQ.Type.ERROR);
            error.setError(new XMPPError(504));
            IBBTransferNegotiator.this.connection.sendPacket((Packet)error);
        }

        public boolean markSupported() {
            return false;
        }

        public void processPacket(Packet packet) {
            IBBExtensions.Close close = (IBBExtensions.Close)packet;
            if (close.getSessionID().equals(this.streamID)) {
                this.isDone = true;
                this.closeConfirmation = FileTransferNegotiator.createIQ(packet.getPacketID(), packet.getFrom(), packet.getTo(), IQ.Type.RESULT);
            }
        }

        public synchronized void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.cleanup();
            if (this.isEOF) {
                this.sendCloseConfirmation();
            } else if (this.lastMess != null) {
                this.sendCancelMessage(this.lastMess);
            }
            this.isClosed = true;
        }

        private void sendCloseConfirmation() {
            IBBTransferNegotiator.this.connection.sendPacket((Packet)this.closeConfirmation);
        }
    }

    private class IBBOutputStream
    extends OutputStream {
        protected byte[] buffer;
        protected int count = 0;
        protected int seq = 0;
        final String userID;
        private final int options = 8;
        private final IQ closePacket;
        private String messageID;
        private String sid;

        IBBOutputStream(String userID, String sid, int blockSize) {
            if (blockSize <= 0) {
                throw new IllegalArgumentException("Buffer size <= 0");
            }
            this.buffer = new byte[blockSize];
            this.userID = userID;
            Message template = new Message(userID);
            this.messageID = template.getPacketID();
            this.sid = sid;
            this.closePacket = this.createClosePacket(userID, sid);
        }

        private IQ createClosePacket(String userID, String sid) {
            IBBExtensions.Close packet = new IBBExtensions.Close(sid);
            packet.setTo(userID);
            packet.setType(IQ.Type.SET);
            return packet;
        }

        public void write(int b) throws IOException {
            if (this.count >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.count++] = (byte)b;
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (len >= this.buffer.length) {
                throw new IllegalArgumentException("byte size exceeds blocksize");
            }
            if (len > this.buffer.length - this.count) {
                this.flushBuffer();
            }
            System.arraycopy(b, off, this.buffer, this.count, len);
            this.count += len;
        }

        private void flushBuffer() {
            this.writeToXML(this.buffer, 0, this.count);
            this.count = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void writeToXML(byte[] buffer, int offset, int len) {
            Message template = this.createTemplate(this.messageID + "_" + this.seq);
            IBBExtensions.Data ext = new IBBExtensions.Data(this.sid);
            template.addExtension((PacketExtension)ext);
            String enc = Base64.encodeBytes(buffer, offset, len, 8);
            ext.setData(enc);
            ext.setSeq(this.seq);
            IBBOutputStream iBBOutputStream = this;
            synchronized (iBBOutputStream) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            IBBTransferNegotiator.this.connection.sendPacket((Packet)template);
            this.seq = this.seq + 1 == 65535 ? 0 : this.seq + 1;
        }

        public void close() throws IOException {
            IBBTransferNegotiator.this.connection.sendPacket((Packet)this.closePacket);
        }

        public void flush() throws IOException {
            this.flushBuffer();
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public Message createTemplate(String messageID) {
            Message template = new Message(this.userID);
            template.setPacketID(messageID);
            return template;
        }
    }
}

