/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheGui;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.TreeCacheViewMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceMBeanSupport;
import org.jgroups.View;

public class TreeCacheView
extends ServiceMBeanSupport
implements TreeCacheViewMBean {
    ObjectName cache_service = null;
    TreeCacheGui gui = null;
    TreeCacheMBean cache;
    static /* synthetic */ Class class$org$jboss$cache$TreeCacheMBean;
    static /* synthetic */ Class class$org$jboss$cache$TreeCache;

    public TreeCacheView() throws Exception {
        this.init(null);
    }

    public TreeCacheView(String cache_service) throws Exception {
        this.init(cache_service);
    }

    public void create() throws Exception {
        super.create();
    }

    public void start() throws Exception {
        super.start();
        if (this.gui == null) {
            this.log.info((Object)"start(): creating the GUI");
            this.gui = new TreeCacheGui(this.cache);
        }
    }

    public void stop() {
        super.stop();
        if (this.gui != null) {
            this.log.info((Object)"stop(): disposing the GUI");
            this.gui.dispose();
            this.gui = null;
        }
    }

    public void destroy() {
        super.destroy();
    }

    public String getCacheService() {
        return this.cache_service != null ? this.cache_service.toString() : null;
    }

    public void setCacheService(String cache_service) throws Exception {
        this.init(cache_service);
    }

    void init(String cache_service) throws Exception {
        MBeanServer server = null;
        if (cache_service == null) {
            return;
        }
        this.cache_service = new ObjectName(cache_service);
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers == null || servers.size() == 0) {
            throw new Exception("TreeCacheView.init(): no MBeanServers found");
        }
        server = (MBeanServer)servers.get(0);
        this.log.info((Object)("init(): found MBeanServer " + server));
        this.cache = (TreeCacheMBean)MBeanProxyExt.create((Class)(class$org$jboss$cache$TreeCacheMBean == null ? (class$org$jboss$cache$TreeCacheMBean = TreeCacheView.class$("org.jboss.cache.TreeCacheMBean")) : class$org$jboss$cache$TreeCacheMBean), (String)cache_service, (MBeanServer)server);
    }

    void populateTree(String dir) throws Exception {
        String[] children;
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        this.put(dir, null);
        if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.populateTree(dir + "/" + children[i]);
            }
        }
    }

    void put(String fqn, Map m) {
        try {
            this.cache.put(fqn, m);
        }
        catch (Throwable t) {
            System.err.println("TreeCacheView.put(): " + t);
        }
    }

    public static void main(String[] args) {
        TreeCache tree = null;
        String start_directory = null;
        String mbean_name = "jboss.cache:service=TreeCache";
        String props = TreeCacheView.getDefaultProps();
        boolean use_queue = false;
        int queue_interval = 5000;
        int queue_max_elements = 100;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-mbean_name")) {
                mbean_name = args[++i];
                continue;
            }
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-start_directory")) {
                start_directory = args[++i];
                continue;
            }
            if (args[i].equals("-use_queue")) {
                use_queue = true;
                continue;
            }
            if (args[i].equals("-queue_interval")) {
                queue_interval = Integer.parseInt(args[++i]);
                use_queue = true;
                continue;
            }
            if (args[i].equals("-queue_max_elements")) {
                queue_max_elements = Integer.parseInt(args[++i]);
                use_queue = true;
                continue;
            }
            TreeCacheView.help();
            return;
        }
        try {
            Logger log = Logger.getLogger((Class)(class$org$jboss$cache$TreeCache == null ? (class$org$jboss$cache$TreeCache = TreeCacheView.class$("org.jboss.cache.TreeCache")) : class$org$jboss$cache$TreeCache));
            MBeanServer srv = MBeanServerFactory.createMBeanServer();
            tree = new TreeCache();
            tree.setClusterName("TreeCacheGroup");
            tree.setClusterProperties(props);
            tree.setInitialStateRetrievalTimeout(10000L);
            tree.setCacheMode(2);
            if (use_queue) {
                tree.setUseReplQueue(true);
                tree.setReplQueueInterval(queue_interval);
                tree.setReplQueueMaxElements(queue_max_elements);
            }
            tree.addTreeCacheListener(new MyListener());
            log.info((Object)("registering the tree as " + mbean_name));
            srv.registerMBean(tree, new ObjectName(mbean_name));
            tree.start();
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(tree));
            TreeCacheView demo = new TreeCacheView(mbean_name);
            demo.create();
            demo.start();
            if (start_directory != null && start_directory.length() > 0) {
                demo.populateTree(start_directory);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getDefaultProps() {
        return "UDP(ip_mcast=true;ip_ttl=64;loopback=false;mcast_addr=228.1.2.3;mcast_port=45566;mcast_recv_buf_size=80000;mcast_send_buf_size=150000;ucast_recv_buf_size=80000;ucast_send_buf_size=150000):PING(down_thread=true;num_initial_members=3;timeout=2000;up_thread=true):MERGE2(max_interval=20000;min_interval=10000):FD(down_thread=true;shun=true;up_thread=true):VERIFY_SUSPECT(down_thread=true;timeout=1500;up_thread=true):pbcast.NAKACK(down_thread=true;gc_lag=50;retransmit_timeout=600,1200,2400,4800;up_thread=true):pbcast.STABLE(desired_avg_gossip=20000;down_thread=true;up_thread=true):UNICAST(down_thread=true;min_threshold=10;timeout=600,1200,2400;window_size=100):FRAG(down_thread=true;frag_size=8192;up_thread=true):pbcast.GMS(join_retry_timeout=2000;join_timeout=5000;print_local_addr=true;shun=true):pbcast.STATE_TRANSFER(down_thread=true;up_thread=true)";
    }

    static void help() {
        System.out.println("TreeCacheView [-help] [-mbean_name <name of TreeCache MBean>] [-start_directory <dirname>] [-props <props>] [-use_queue <true/false>] [-queue_interval <ms>] [-queue_max_elements <num>]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MyListener
    implements TreeCacheListener {
        public void nodeCreated(Fqn fqn) {
            System.out.println("** node added: " + fqn);
        }

        public void nodeRemoved(Fqn fqn) {
            System.out.println("** node removed: " + fqn);
        }

        public void nodeModified(Fqn fqn) {
            System.out.println("** node modified: " + fqn);
        }

        public void nodeLoaded(Fqn fqn) {
            System.out.println("** node loaded: " + fqn);
        }

        public void nodeEvicted(Fqn fqn) {
            System.out.println("*** node evicted: " + fqn);
        }

        public void nodeVisited(Fqn fqn) {
        }

        public void cacheStarted(TreeCache cache) {
        }

        public void cacheStopped(TreeCache cache) {
        }

        public void viewChange(View new_view) {
            System.out.println("** view change: " + new_view);
        }
    }

    static class ShutdownThread
    extends Thread {
        TreeCache tree = null;

        ShutdownThread(TreeCache tree) {
            this.tree = tree;
        }

        public void run() {
            this.tree.stop();
        }
    }
}

