/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.NotSupportedException;
import javax.transaction.Transaction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.tests.SamplePojo;
import org.jboss.cache.transaction.DummyTransactionManager;

public abstract class CacheLoaderTests
extends TestCase {
    TreeCache cache;
    CacheLoader loader = null;
    Transaction tx = null;
    static final Fqn FQN = new Fqn("key");
    static /* synthetic */ Class class$org$jboss$cache$tests$CacheLoaderTests;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = new TreeCache();
        this.cache.setCacheMode("local");
        this.configureCache();
        this.cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache.createService();
        this.cache.startService();
        this.loader = this.cache.getCacheLoader();
    }

    protected abstract void configureCache() throws Exception;

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.tx != null) {
            try {
                this.tx.commit();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.cache.remove("/");
        this.cache.stopService();
        this.cache.destroyService();
    }

    public void testPrint() throws CacheException {
        Fqn NODE = Fqn.fromString("/test");
        String KEY = "key";
        this.cache.put(NODE, (Object)"key", (Object)new Integer(10));
        this.cache.evict(NODE);
        String ret = this.cache.print(NODE);
        CacheLoaderTests.assertNotNull((Object)ret);
    }

    public void testPut() throws CacheException {
        String NODE = "/test";
        String KEY = "key";
        Object retval = null;
        this.cache.remove("/test");
        retval = this.cache.put("/test", (Object)"key", (Object)new Integer(10));
        CacheLoaderTests.assertNull((Object)retval);
        retval = this.cache.put("/test", (Object)"key", (Object)new Integer(20));
        CacheLoaderTests.assertEquals((Object)new Integer(10), (Object)retval);
        this.cache.evict(Fqn.fromString("/test"));
        retval = this.cache.put("/test", (Object)"key", (Object)new Integer(30));
        CacheLoaderTests.assertEquals((Object)new Integer(20), (Object)retval);
    }

    public void testSerialization() throws CacheException {
        SamplePojo pojo = new SamplePojo(39, "Bela");
        pojo.getHobbies().add("Running");
        pojo.getHobbies().add("Beerathlon");
        pojo.getHobbies().add("Triathlon");
        this.cache.put("/mypojo", (Object)new Integer(322649), (Object)pojo);
        CacheLoaderTests.assertNotNull((Object)this.cache.get("/mypojo", (Object)new Integer(322649)));
        this.cache.evict(Fqn.fromString("/mypojo"));
        CacheLoaderTests.assertFalse((boolean)this.cache.exists("/mypojo"));
        SamplePojo pojo2 = (SamplePojo)this.cache.get("/mypojo", (Object)new Integer(322649));
        CacheLoaderTests.assertNotNull((Object)pojo2);
        CacheLoaderTests.assertEquals((int)39, (int)pojo2.getAge());
        CacheLoaderTests.assertEquals((String)"Bela", (String)pojo2.getName());
        CacheLoaderTests.assertEquals((int)3, (int)pojo2.getHobbies().size());
    }

    public void testPopulate() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < 10; ++i) {
                m.put("key" + i, "val" + i);
            }
            this.cache.put("/a/b/c", m);
            this.cache.load("/1/2/3/4/5");
            this.cache.put("/1/2/3/4/5", null);
            this.cache.put("/1/2/3/4/5/a", null);
            this.cache.put("/1/2/3/4/5/b", null);
            this.cache.put("/1/2/3/4/5/c", null);
            this.cache.put("/1/2/3/4/5/d", null);
            this.cache.put("/1/2/3/4/5/e", null);
            this.cache.put("/1/2/3/4/5/d/one", null);
            this.cache.put("/1/2/3/4/5/d/two", null);
            this.cache.put("/1/2/3/4/5/d/three", null);
            System.out.println("cache: " + this.cache);
            CacheLoaderTests.assertTrue((boolean)this.cache.exists("/1/2/3/4"));
            CacheLoaderTests.assertTrue((boolean)this.cache.exists("/a/b/c"));
            CacheLoaderTests.assertFalse((boolean)this.cache.exists("/a/b/c/d"));
        }
        catch (Exception e) {
            CacheLoaderTests.fail((String)e.toString());
        }
    }

    public void testPreloading() throws CacheException {
        this.cache.remove("/");
        this.cache.put("1/2/3/4/5/d", (Object)"key", (Object)"val");
        this.cache.evict(Fqn.fromString("1/2/3/4/5/d"));
        System.out.println("-- checking for 1/2/3/4/5/d");
        CacheLoaderTests.assertFalse((boolean)this.cache.exists("1/2/3/4/5/d"));
        this.cache.get("1/2/3/4/5/d");
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("1/2/3/4/5/d"));
        System.out.println("-- 1/2/3/4/5/d exists");
    }

    public void testCacheLoading2() throws CacheException {
        Set keys = null;
        this.cache.put("/a/b/c", (Object)"key", (Object)"val");
        try {
            keys = this.cache.getKeys("/a/b/c");
            CacheLoaderTests.assertNotNull((Object)keys);
            CacheLoaderTests.assertEquals((int)1, (int)keys.size());
        }
        catch (Exception e) {
            CacheLoaderTests.fail((String)e.toString());
        }
        try {
            keys.add("myKey");
            CacheLoaderTests.fail((String)"adding a key to an unmodifiable set should fail");
        }
        catch (UnsupportedOperationException ex) {
            CacheLoaderTests.assertTrue((String)"adding a key to an unmodifiable set failed (as expected)", (boolean)true);
        }
    }

    public void testExists() throws Exception {
        this.cache.put("/eins/zwei/drei", (Object)"key1", (Object)"val1");
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/eins/zwei/drei"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/eins/zwei/drei", (Object)"key1"));
        CacheLoaderTests.assertFalse((boolean)this.cache.exists("/eins/zwei/drei", (Object)"key2"));
        CacheLoaderTests.assertFalse((boolean)this.cache.exists("/uno/due/tre"));
        CacheLoaderTests.assertFalse((boolean)this.cache.exists("/une/due/tre", (Object)"key1"));
    }

    public void testGetChildren() {
        try {
            this.cache.put("/1/2/3/4/5/d/one", null);
            this.cache.put("/1/2/3/4/5/d/two", null);
            this.cache.put("/1/2/3/4/5/d/three", null);
            Set children = this.cache.getChildrenNames("/1/2/3/4/5/d");
            CacheLoaderTests.assertNotNull((Object)children);
            CacheLoaderTests.assertEquals((int)3, (int)children.size());
            CacheLoaderTests.assertTrue((boolean)children.contains("one"));
            CacheLoaderTests.assertTrue((boolean)children.contains("two"));
            CacheLoaderTests.assertTrue((boolean)children.contains("three"));
        }
        catch (Exception e) {
            CacheLoaderTests.fail((String)e.toString());
        }
    }

    public void testGetChildren2() {
        try {
            this.cache.put("/1", null);
            this.cache.put("a", null);
            Set children = this.cache.getChildrenNames("/");
            CacheLoaderTests.assertNotNull((Object)children);
            CacheLoaderTests.assertEquals((int)2, (int)children.size());
            CacheLoaderTests.assertTrue((boolean)children.contains("1"));
            CacheLoaderTests.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            CacheLoaderTests.fail((String)e.toString());
        }
    }

    public void testGetChildren3() {
        try {
            this.cache.put("/1", null);
            this.cache.put("a", null);
            Set children = this.cache.getChildrenNames("");
            CacheLoaderTests.assertNotNull((Object)children);
            CacheLoaderTests.assertEquals((int)2, (int)children.size());
            CacheLoaderTests.assertTrue((boolean)children.contains("1"));
            CacheLoaderTests.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            CacheLoaderTests.fail((String)e.toString());
        }
    }

    public void testGetChildren4() {
        try {
            if (!this.cache.exists("/a/b/c")) {
                this.cache.put("/a/b/c", null);
            }
            Set children = this.cache.getChildrenNames((Fqn)null);
            CacheLoaderTests.assertNull((Object)children);
        }
        catch (Exception e) {
            CacheLoaderTests.fail((String)e.toString());
        }
    }

    public void testRemoveData() throws Exception {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        CacheLoaderTests.assertEquals((int)3, (int)this.cache.getKeys(key).size());
        this.cache.removeData(key);
        Set keys = this.cache.getKeys(key);
        CacheLoaderTests.assertNull((Object)keys);
        this.cache.remove("/x");
        Object val = this.cache.get(key, (Object)"keyA");
        CacheLoaderTests.assertNull((Object)val);
    }

    public void testRemoveData2() throws Exception {
        Fqn key = Fqn.fromString("/x/y/z/");
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = this.cache.getKeys(key);
        CacheLoaderTests.assertEquals((int)3, (int)keys.size());
        this.cache.removeData(key);
        this.cache.evict(key);
        keys = this.cache.getKeys(key);
        CacheLoaderTests.assertEquals((int)0, (int)keys.size());
    }

    public void testRemoveData3() throws Exception {
        Fqn key = Fqn.fromString("/x/y/z/");
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = this.cache.getKeys(key);
        CacheLoaderTests.assertEquals((int)3, (int)keys.size());
        this.cache.evict(key);
        this.cache.removeData(key);
        keys = this.cache.getKeys(key);
        CacheLoaderTests.assertNull((Object)keys);
    }

    public void testRemoveKey() throws Exception {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        this.cache.remove(key, (Object)"keyA");
        CacheLoaderTests.assertEquals((int)2, (int)this.cache.getKeys(key).size());
        this.cache.remove("/x");
    }

    public void testRemoveKey2() throws CacheException {
        String NODE = "/test";
        String KEY = "key";
        Object retval = null;
        this.cache.remove("/test");
        retval = this.cache.put("/test", (Object)"key", (Object)new Integer(10));
        CacheLoaderTests.assertNull((Object)retval);
        retval = this.cache.remove("/test", (Object)"key");
        CacheLoaderTests.assertEquals((Object)new Integer(10), (Object)retval);
        retval = this.cache.remove("/test", (Object)"key");
        CacheLoaderTests.assertNull((Object)retval);
    }

    public void testRemoveKey3() throws CacheException {
        String NODE = "/test";
        String KEY = "key";
        Object retval = null;
        this.cache.remove("/test");
        retval = this.cache.put("/test", (Object)"key", (Object)new Integer(10));
        CacheLoaderTests.assertNull((Object)retval);
        this.cache.evict(Fqn.fromString("/test"));
        retval = this.cache.remove("/test", (Object)"key");
        CacheLoaderTests.assertEquals((Object)new Integer(10), (Object)retval);
        this.cache.evict(Fqn.fromString("/test"));
        retval = this.cache.remove("/test", (Object)"key");
        CacheLoaderTests.assertNull((Object)retval);
    }

    public void testRemove() throws Exception {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        this.cache.remove("/x");
        CacheLoaderTests.assertNull((Object)this.cache.get(key, (Object)"keyA"));
        Set keys = this.cache.getKeys(key);
        CacheLoaderTests.assertNull((Object)keys);
        this.cache.remove("/x");
    }

    public void testRemoveRoot() throws Exception {
        CacheLoaderTests.assertEquals((int)0, (int)this.cache.getKeys("/").size());
        this.cache.put("/1/2/3/4/5", null);
        this.cache.put("uno/due/tre", null);
        this.cache.put("1/2/3/a", null);
        this.cache.put("/eins/zwei/drei", null);
        this.cache.put("/one/two/three", null);
        this.cache.remove("/");
        CacheLoaderTests.assertEquals((int)0, (int)this.cache.getKeys("/").size());
    }

    public void testEvictionWithCacheLoader() throws Exception {
        this.cache.put("/first/second", (Object)"key1", (Object)"val1");
        this.cache.put("/first/second/third", (Object)"key2", (Object)"val2");
        this.cache.evict(Fqn.fromString("/first/second"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first/second/third"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first/second"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first"));
        String val = (String)this.cache.get("/first/second", (Object)"key1");
        CacheLoaderTests.assertEquals((String)"val1", (String)val);
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first/second/third"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first/second"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first"));
    }

    public void testEvictionWithCacheLoader2() throws Exception {
        this.cache.put("/first/second/third", (Object)"key1", (Object)"val1");
        this.cache.evict(Fqn.fromString("/first/second/third"));
        CacheLoaderTests.assertFalse((boolean)this.cache.exists("/first/second/third"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first/second"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first"));
        String val = (String)this.cache.get("/first/second/third", (Object)"key1");
        CacheLoaderTests.assertEquals((String)"val1", (String)val);
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first/second/third"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first/second"));
        CacheLoaderTests.assertTrue((boolean)this.cache.exists("/first"));
    }

    public void testEvictionWithGetChildrenNames() throws Exception {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.evict(Fqn.fromString("/a/1"));
        this.cache.evict(Fqn.fromString("/a/2"));
        this.cache.evict(Fqn.fromString("/a/3"));
        this.cache.evict(Fqn.fromString("/a"));
        Set children = this.cache.getChildrenNames("/a");
        CacheLoaderTests.assertEquals((int)3, (int)children.size());
        CacheLoaderTests.assertTrue((boolean)children.contains("1"));
        CacheLoaderTests.assertTrue((boolean)children.contains("2"));
        CacheLoaderTests.assertTrue((boolean)children.contains("3"));
    }

    public void testTxPutCommit() throws Exception, NotSupportedException {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        this.tx = mgr.getTransaction();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        this.cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        this.tx.commit();
        CacheLoaderTests.assertNotNull((Object)this.cache.getKeys("/one/two/three"));
        Set children = this.cache.getChildrenNames("/one");
        CacheLoaderTests.assertEquals((int)1, (int)children.size());
        this.cache.remove("/");
    }

    public void testTxPutRollback() throws Exception, NotSupportedException {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        this.cache.remove("/one");
        mgr.begin();
        this.tx = mgr.getTransaction();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        this.cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        this.tx.rollback();
        CacheLoaderTests.assertNull((Object)this.cache.getKeys("/one/two/three"));
        Set children = this.cache.getChildrenNames("/one");
        CacheLoaderTests.assertNull((Object)children);
    }

    public void testBasicOperations() throws Exception {
        this.doTestBasicOperations();
    }

    public void testBasicOperationsTransactional() throws Exception {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        this.tx = mgr.getTransaction();
        this.doTestBasicOperations();
        this.tx.commit();
    }

    private void doTestBasicOperations() throws Exception {
        this.doPutTests(new Fqn("key"));
        this.doRemoveTests(new Fqn("key"));
        this.doPutTests(new Fqn("key1"));
        this.doPutTests(new Fqn("key3"));
        this.doPutTests(new Fqn("key2"));
        CacheLoaderTests.assertEquals((int)4, (int)this.loader.get(new Fqn("key1")).size());
        CacheLoaderTests.assertEquals((int)4, (int)this.loader.get(new Fqn("key2")).size());
        CacheLoaderTests.assertEquals((int)4, (int)this.loader.get(new Fqn("key3")).size());
        this.doRemoveTests(new Fqn("key2"));
        this.doRemoveTests(new Fqn("key3"));
        this.doRemoveTests(new Fqn("key1"));
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(new Fqn("key1")));
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(new Fqn("key2")));
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(new Fqn("key3")));
    }

    private void doPutTests(Fqn fqn) throws Exception {
        CacheLoaderTests.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
        Object oldVal = this.loader.put(fqn, "one", "two");
        CacheLoaderTests.assertNull((Object)oldVal);
        oldVal = this.loader.put(fqn, "three", "four");
        CacheLoaderTests.assertNull((Object)oldVal);
        CacheLoaderTests.assertEquals((Object)"two", (Object)this.loader.get(fqn, "one"));
        CacheLoaderTests.assertEquals((Object)"four", (Object)this.loader.get(fqn, "three"));
        oldVal = this.loader.put(fqn, "one", "xxx");
        CacheLoaderTests.assertEquals((Object)"two", (Object)oldVal);
        oldVal = this.loader.put(fqn, "one", "two");
        CacheLoaderTests.assertEquals((Object)"xxx", (Object)oldVal);
        Map map = this.loader.get(fqn);
        CacheLoaderTests.assertEquals((int)2, (int)map.size());
        CacheLoaderTests.assertEquals((Object)"two", map.get("one"));
        CacheLoaderTests.assertEquals((Object)"four", map.get("three"));
        map.put("five", "six");
        map.put("seven", "eight");
        this.loader.put(fqn, map);
        CacheLoaderTests.assertEquals((Object)"six", (Object)this.loader.get(fqn, "five"));
        CacheLoaderTests.assertEquals((Object)"eight", (Object)this.loader.get(fqn, "seven"));
        CacheLoaderTests.assertEquals((Object)map, (Object)this.loader.get(fqn));
        CacheLoaderTests.assertEquals((int)4, (int)map.size());
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(fqn));
    }

    private void doRemoveTests(Fqn fqn) throws Exception {
        Object oldVal = this.loader.remove(fqn, "one");
        CacheLoaderTests.assertEquals((Object)"two", (Object)oldVal);
        oldVal = this.loader.remove(fqn, "five");
        CacheLoaderTests.assertEquals((Object)"six", (Object)oldVal);
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(fqn, "one"));
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(fqn, "five"));
        CacheLoaderTests.assertEquals((Object)"four", (Object)this.loader.get(fqn, "three"));
        CacheLoaderTests.assertEquals((Object)"eight", (Object)this.loader.get(fqn, "seven"));
        Map map = this.loader.get(fqn);
        CacheLoaderTests.assertEquals((int)2, (int)map.size());
        CacheLoaderTests.assertEquals((Object)"four", map.get("three"));
        CacheLoaderTests.assertEquals((Object)"eight", map.get("seven"));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(fqn));
        this.loader.remove(fqn);
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(fqn, "three"));
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(fqn, "seven"));
        map = this.loader.get(fqn);
        CacheLoaderTests.assertEquals(null, (Object)map);
        CacheLoaderTests.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
    }

    public void testMultiLevelTree() throws Exception {
        CacheLoaderTests.assertTrue((!this.loader.exists(new Fqn("key0")) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString("/key0/level1/level2"), null);
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/level1/level2")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/level1")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key0")));
        this.loader.put(Fqn.fromString("/key0/x/y"), null);
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/x/y")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/x")));
        this.loader.remove(Fqn.fromString("/key0/x/y"));
        CacheLoaderTests.assertTrue((!this.loader.exists(Fqn.fromString("/key0/x/y")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key0/x")));
        this.loader.remove(new Fqn("key0"));
        CacheLoaderTests.assertTrue((!this.loader.exists(new Fqn("key0")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((!this.loader.exists(Fqn.fromString("/key0/level1/level2")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((!this.loader.exists(Fqn.fromString("/key0/level1")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((!this.loader.exists(Fqn.fromString("/key0/x")) ? 1 : 0) != 0);
        this.loader.put(new Fqn("key1"), null);
        this.loader.put(new Fqn("key2"), null);
        this.loader.put(new Fqn("key3"), null);
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key1")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key3")));
        CacheLoaderTests.assertTrue((!this.loader.exists(Fqn.fromString("/key3/level1")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((!this.loader.exists(Fqn.fromString("/key3/level1/level2")) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString("/key3/level1/level2"), null);
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key3/level1/level2")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(Fqn.fromString("/key3/level1")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key1")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key3")));
        this.loader.remove(Fqn.fromString("/key3/level1"));
        CacheLoaderTests.assertTrue((!this.loader.exists(Fqn.fromString("/key3/level1/level2")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((!this.loader.exists(Fqn.fromString("/key3/level1")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key1")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key3")));
        this.loader.remove(new Fqn("key1"));
        CacheLoaderTests.assertTrue((!this.loader.exists(new Fqn("key1")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key3")));
        this.loader.remove(new Fqn("key3"));
        CacheLoaderTests.assertTrue((boolean)this.loader.exists(new Fqn("key2")));
        CacheLoaderTests.assertTrue((!this.loader.exists(new Fqn("key3")) ? 1 : 0) != 0);
        this.loader.remove(new Fqn("key2"));
        CacheLoaderTests.assertTrue((!this.loader.exists(new Fqn("key0")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((!this.loader.exists(new Fqn("key1")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((!this.loader.exists(new Fqn("key2")) ? 1 : 0) != 0);
        CacheLoaderTests.assertTrue((!this.loader.exists(new Fqn("key3")) ? 1 : 0) != 0);
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key0")));
        this.loader.put(Fqn.fromString("/key0/level1/level2"), "a", "b");
        CacheLoaderTests.assertNotNull((Object)this.loader.get(Fqn.fromString("/key0/level1/level2")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key0/level1")));
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key0")));
        this.loader.put(Fqn.fromString("/key0/x/y"), "a", "b");
        CacheLoaderTests.assertNotNull((Object)this.loader.get(Fqn.fromString("/key0/x/y")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key0/x")));
        this.loader.remove(Fqn.fromString("/key0/x/y"));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key0/x/y")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key0/x")));
        this.loader.remove(new Fqn("key0"));
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key0")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key0/level1/level2")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key0/level1")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key0/x")));
        this.loader.put(new Fqn("key1"), "a", "b");
        this.loader.put(new Fqn("key2"), "a", "b");
        this.loader.put(new Fqn("key3"), "a", "b");
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key1")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key3")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1/level2")));
        this.loader.put(Fqn.fromString("/key3/level1/level2"), "a", "b");
        CacheLoaderTests.assertNotNull((Object)this.loader.get(Fqn.fromString("/key3/level1/level2")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key1")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key3")));
        this.loader.remove(Fqn.fromString("/key3/level1"));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1/level2")));
        CacheLoaderTests.assertNull((Object)this.loader.get(Fqn.fromString("/key3/level1")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key1")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key3")));
        this.loader.remove(new Fqn("key1"));
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key1")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key3")));
        this.loader.remove(new Fqn("key3"));
        CacheLoaderTests.assertNotNull((Object)this.loader.get(new Fqn("key2")));
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key3")));
        this.loader.remove(new Fqn("key2"));
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key0")));
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key1")));
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key2")));
        CacheLoaderTests.assertNull((Object)this.loader.get(new Fqn("key3")));
    }

    public void testGetChildrenNames() throws Exception {
        this.checkChildren(new Fqn(), null);
        this.checkChildren(Fqn.fromString("/key0"), null);
        this.loader.put(Fqn.fromString("/key0"), null);
        this.checkChildren(new Fqn(), new String[]{"key0"});
        this.loader.put(Fqn.fromString("/key1/x"), null);
        this.checkChildren(new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString("/key1"), new String[]{"x"});
        this.loader.remove(Fqn.fromString("/key1/x"));
        this.checkChildren(new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString("/key0"), null);
        this.checkChildren(Fqn.fromString("/key1"), null);
        this.loader.put(Fqn.fromString("/key0/a"), null);
        this.loader.put(Fqn.fromString("/key0/ab"), null);
        this.loader.put(Fqn.fromString("/key0/abc"), null);
        this.checkChildren(Fqn.fromString("/key0"), new String[]{"a", "ab", "abc"});
        this.loader.put(Fqn.fromString("/key0/xxx"), null);
        this.loader.put(Fqn.fromString("/key0/xx"), null);
        this.loader.put(Fqn.fromString("/key0/x"), null);
        this.checkChildren(Fqn.fromString("/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        this.loader.put(Fqn.fromString("/key0/a/1"), null);
        this.loader.put(Fqn.fromString("/key0/a/2"), null);
        this.loader.put(Fqn.fromString("/key0/a/2/1"), null);
        this.checkChildren(Fqn.fromString("/key0/a/2"), new String[]{"1"});
        this.checkChildren(Fqn.fromString("/key0/a"), new String[]{"1", "2"});
        this.checkChildren(Fqn.fromString("/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
    }

    private void checkChildren(Fqn fqn, String[] names) throws Exception {
        Set set = this.loader.getChildrenNames(fqn);
        if (names != null) {
            CacheLoaderTests.assertEquals((int)names.length, (int)set.size());
            for (int i = 0; i < names.length; ++i) {
                CacheLoaderTests.assertTrue((boolean)set.contains(names[i]));
            }
        } else {
            CacheLoaderTests.assertNull((Object)set);
        }
    }

    public void testModifications() throws Exception {
        this.doTestModifications();
    }

    public void testModificationsTransactional() throws Exception {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        this.tx = mgr.getTransaction();
        this.doTestModifications();
        this.tx.commit();
    }

    private void doTestModifications() throws Exception {
        ArrayList<Modification> list = this.createUpdates();
        this.loader.put(list);
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(5);
        mod.setFqn(FQN);
        mod.setKey("one");
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
        list = new ArrayList();
        mod = new Modification();
        mod.setType(4);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(FQN));
        this.loader.put(FQN, "one", "two");
        list = new ArrayList();
        mod = new Modification();
        mod.setType(6);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.checkModifications(list);
    }

    public void testOnePhaseTransaction() throws Exception {
        List mods = this.createUpdates();
        this.loader.prepare(null, mods, true);
        this.checkModifications(mods);
    }

    public void testTwoPhaseTransaction() throws Exception {
        Object txnKey = new Object();
        List mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        this.loader.commit(txnKey);
        this.checkModifications(mods);
    }

    public void testTransactionRollback() throws Exception {
        this.loader.remove(Fqn.fromString("/"));
        int num = this.loader.loadEntireState().length;
        Object txnKey = new Object();
        List mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        this.loader.rollback(txnKey);
        CacheLoaderTests.assertEquals((int)num, (int)this.loader.loadEntireState().length);
    }

    private List createUpdates() {
        ArrayList<Modification> list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(1);
        mod.setFqn(FQN);
        mod.setKey("one");
        mod.setValue("two");
        list.add(mod);
        mod = new Modification();
        mod.setType(1);
        mod.setFqn(FQN);
        mod.setKey("three");
        mod.setValue("four");
        list.add(mod);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("five", "six");
        map.put("seven", "eight");
        mod = new Modification();
        mod.setType(2);
        mod.setFqn(FQN);
        mod.setData(map);
        list.add(mod);
        return list;
    }

    private void checkModifications(List list) throws Exception {
        block7: for (int i = 0; i < list.size(); ++i) {
            Modification mod = (Modification)list.get(i);
            Fqn fqn = mod.getFqn();
            switch (mod.getType()) {
                case 1: {
                    CacheLoaderTests.assertEquals((Object)mod.getValue(), (Object)this.loader.get(fqn, mod.getKey()));
                    continue block7;
                }
                case 2: {
                    Map map = mod.getData();
                    Iterator iter = map.keySet().iterator();
                    while (iter.hasNext()) {
                        Object key = iter.next();
                        CacheLoaderTests.assertEquals(map.get(key), (Object)this.loader.get(fqn, key));
                    }
                    continue block7;
                }
                case 5: {
                    CacheLoaderTests.assertEquals(null, (Object)this.loader.get(fqn, mod.getKey()));
                    continue block7;
                }
                case 6: {
                    Map map = this.loader.get(fqn);
                    CacheLoaderTests.assertNull((Object)map);
                    continue block7;
                }
                case 4: {
                    CacheLoaderTests.assertEquals(null, (Object)this.loader.get(fqn));
                    continue block7;
                }
                default: {
                    CacheLoaderTests.fail((String)("unknown type: " + mod));
                }
            }
        }
    }

    public void testNullKeysAndValues() throws Exception {
        this.loader.put(FQN, null, "x");
        CacheLoaderTests.assertEquals((Object)"x", (Object)this.loader.get(FQN, null));
        HashMap<String, String> map = this.loader.get(FQN);
        CacheLoaderTests.assertEquals((int)1, (int)map.size());
        CacheLoaderTests.assertEquals((Object)"x", map.get(null));
        this.loader.put(FQN, "y", null);
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(FQN, "y"));
        map = this.loader.get(FQN);
        CacheLoaderTests.assertEquals((int)2, (int)map.size());
        CacheLoaderTests.assertEquals((Object)"x", map.get(null));
        CacheLoaderTests.assertEquals(null, map.get("y"));
        this.loader.remove(FQN, null);
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(FQN, null));
        CacheLoaderTests.assertEquals((int)1, (int)this.loader.get(FQN).size());
        this.loader.remove(FQN, "y");
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(FQN, "y"));
        CacheLoaderTests.assertNull((Object)this.loader.get(FQN));
        map = new HashMap<String, String>();
        map.put(null, null);
        this.loader.put(FQN, map);
        CacheLoaderTests.assertEquals(map, (Object)this.loader.get(FQN));
        this.loader.remove(FQN);
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(FQN));
        map = new HashMap();
        map.put("xyz", null);
        map.put(null, "abc");
        this.loader.put(FQN, map);
        CacheLoaderTests.assertEquals(map, (Object)this.loader.get(FQN));
        this.loader.remove(FQN);
        CacheLoaderTests.assertEquals(null, (Object)this.loader.get(FQN));
    }

    public void testDatabaseName() throws Exception {
        this.loader.put(FQN, "one", "two");
        CacheLoaderTests.assertEquals((Object)"two", (Object)this.loader.get(FQN, "one"));
    }

    public void testLoadAndStore() throws Exception {
        this.loader.remove(Fqn.fromString("/"));
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        this.loader.put(FQN, new Integer(1), c1);
        this.loader.put(FQN, new Integer(2), c2);
        CacheLoaderTests.assertEquals((Object)c1, (Object)this.loader.get(FQN, new Integer(1)));
        CacheLoaderTests.assertEquals((Object)c2, (Object)this.loader.get(FQN, new Integer(2)));
        CacheLoaderTests.assertEquals((int)2, (int)this.loader.get(FQN).size());
        byte[] state = this.loader.loadEntireState();
        CacheLoaderTests.assertTrue((state.length > 0 ? 1 : 0) != 0);
        this.loader.storeEntireState(state);
        CacheLoaderTests.assertEquals((Object)c1, (Object)this.loader.get(FQN, new Integer(1)));
        CacheLoaderTests.assertEquals((Object)c2, (Object)this.loader.get(FQN, new Integer(2)));
        CacheLoaderTests.assertEquals((int)2, (int)this.loader.get(FQN).size());
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$CacheLoaderTests == null ? (class$org$jboss$cache$tests$CacheLoaderTests = CacheLoaderTests.class$("org.jboss.cache.tests.CacheLoaderTests")) : class$org$jboss$cache$tests$CacheLoaderTests);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CacheLoaderTests.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Complex
    implements Serializable {
        static final long serialVersionUID = 3254750788071265158L;
        Complex nested;

        Complex() {
            this(null);
        }

        Complex(Complex nested) {
            this.nested = nested;
        }

        public boolean equals(Object o) {
            try {
                Complex x = (Complex)o;
                return this.nested != null ? this.nested.equals(x.nested) : x.nested == null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            if (this.nested == null) {
                return super.hashCode();
            }
            return 13 + this.nested.hashCode();
        }
    }
}

