/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.admin.service.IImportService;
import org.lamsfoundation.lams.admin.web.dto.V1OrgRightDTO;
import org.lamsfoundation.lams.admin.web.dto.V1OrganisationDTO;
import org.lamsfoundation.lams.admin.web.dto.V1UserDTO;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.IAuditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportService
implements IImportService {
    private static Logger log = Logger.getLogger(ImportService.class);
    public IUserManagementService service;
    public MessageService messageService;
    public IAuditService auditService;
    private static final short LOGIN = 0;
    private static final short PASSWORD = 1;
    private static final short TITLE = 2;
    private static final short FIRST_NAME = 3;
    private static final short LAST_NAME = 4;
    private static final short AUTH_METHOD = 5;
    private static final short EMAIL = 6;
    private static final short FLASH_THEME = 7;
    private static final short HTML_THEME = 8;
    private static final short LOCALE = 9;
    private static final short ADDRESS1 = 10;
    private static final short ADDRESS2 = 11;
    private static final short ADDRESS3 = 12;
    private static final short CITY = 13;
    private static final short STATE = 14;
    private static final short POSTCODE = 15;
    private static final short COUNTRY = 16;
    private static final short DAY_PHONE = 17;
    private static final short EVE_PHONE = 18;
    private static final short MOB_PHONE = 19;
    private static final short FAX = 20;
    private static final short ORGANISATION = 1;
    private static final short ROLES = 2;
    ArrayList<ArrayList> results = new ArrayList();
    ArrayList<String> rowResult = new ArrayList();
    private boolean emptyRow;
    private boolean hasError;

    public IUserManagementService getService() {
        return this.service;
    }

    public void setService(IUserManagementService service) {
        this.service = service;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    private HSSFSheet getSheet(FormFile fileItem) throws IOException {
        POIFSFileSystem fs = new POIFSFileSystem(fileItem.getInputStream());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        return wb.getSheetAt(0);
    }

    @Override
    public boolean isUserSpreadsheet(FormFile fileItem) throws IOException {
        HSSFSheet sheet = this.getSheet(fileItem);
        HSSFRow row = sheet.getRow(sheet.getFirstRowNum());
        String string = this.parseStringCell(row.getCell((short)1));
        return StringUtils.equals((String)string, (String)"* password");
    }

    @Override
    public boolean isRolesSpreadsheet(FormFile fileItem) throws IOException {
        HSSFSheet sheet = this.getSheet(fileItem);
        HSSFRow row = sheet.getRow(sheet.getFirstRowNum());
        String string = this.parseStringCell(row.getCell((short)1));
        return StringUtils.equals((String)string, (String)"* organisation");
    }

    @Override
    public List parseSpreadsheet(FormFile fileItem) throws IOException {
        if (this.isUserSpreadsheet(fileItem)) {
            return this.parseUserSpreadsheet(fileItem);
        }
        if (this.isRolesSpreadsheet(fileItem)) {
            return this.parseRolesSpreadsheet(fileItem);
        }
        return new ArrayList();
    }

    @Override
    public List<List> parseV1UsersFile(FormFile fileItem, boolean includeIntegrated) throws IOException {
        ArrayList<V1UserDTO> users = new ArrayList<V1UserDTO>();
        ArrayList<V1OrganisationDTO> orgs = new ArrayList<V1OrganisationDTO>();
        ArrayList<List> results = new ArrayList<List>();
        ArrayList<String> integPrefixes = new ArrayList<String>();
        ArrayList<String> integOrgid = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileItem.getInputStream()));
        String line = reader.readLine();
        while (!line.startsWith("login\tpassword")) {
            if (!line.startsWith("prefix")) {
                String[] lineArray = line.split("\t");
                if (lineArray.length > 0) {
                    integPrefixes.add(lineArray[0]);
                }
                if (lineArray.length > 1) {
                    integOrgid.add(lineArray[1]);
                }
            }
            line = reader.readLine();
        }
        line = reader.readLine();
        while (!line.startsWith("sid\tname")) {
            String[] userDetails = line.split("\t");
            line = reader.readLine();
            if (!includeIntegrated && this.isIntegratedUser(integPrefixes, userDetails[0])) continue;
            V1UserDTO userDTO = new V1UserDTO(userDetails[0], userDetails[1], userDetails[2], userDetails[3]);
            if (userDetails.length > 4 && !StringUtils.equals((String)userDetails[4], (String)"NULL")) {
                userDTO.setEmail(userDetails[4]);
            }
            users.add(userDTO);
        }
        line = reader.readLine();
        while (!line.startsWith("login\tg")) {
            String[] orgDetails = line.split("\t");
            line = reader.readLine();
            if (orgDetails.length != 4) {
                log.debug((Object)"LAMS 1 text file has troublesome organisation: ");
                for (int i = 0; i < orgDetails.length; ++i) {
                    log.debug((Object)("column: " + orgDetails[i]));
                }
                continue;
            }
            if (!includeIntegrated && integOrgid.contains(orgDetails[0])) continue;
            V1OrganisationDTO org = new V1OrganisationDTO(orgDetails[0], orgDetails[1], orgDetails[2], orgDetails[3]);
            orgs.add(org);
        }
        line = reader.readLine();
        ArrayList<String> currentRoles = new ArrayList<String>();
        String currentLogin = "";
        while (!line.startsWith("login\tsid")) {
            String[] userRole = line.split("\t");
            line = reader.readLine();
            if (!includeIntegrated && this.isIntegratedUser(integPrefixes, userRole[0])) continue;
            if (!StringUtils.equals((String)userRole[0], (String)currentLogin)) {
                if (!currentRoles.isEmpty()) {
                    int index = users.indexOf(new V1UserDTO(currentLogin));
                    V1UserDTO userDTO = (V1UserDTO)users.get(index);
                    userDTO.setRoleIds(new ArrayList<String>(currentRoles));
                    users.set(index, userDTO);
                }
                currentLogin = userRole[0];
                currentRoles.clear();
            }
            currentRoles.add(userRole[1]);
        }
        int index = users.indexOf(new V1UserDTO(currentLogin));
        V1UserDTO userDTO = (V1UserDTO)users.get(index);
        userDTO.setRoleIds(new ArrayList<String>(currentRoles));
        users.set(index, userDTO);
        line = reader.readLine();
        while (line != null) {
            String[] userRight = line.split("\t");
            line = reader.readLine();
            if (!includeIntegrated && this.isIntegratedUser(integPrefixes, userRight[0])) continue;
            V1OrgRightDTO orgRightDTO = new V1OrgRightDTO(userRight[1], userRight[2]);
            index = users.indexOf(new V1UserDTO(userRight[0]));
            userDTO = (V1UserDTO)users.get(index);
            List<V1OrgRightDTO> orgRights = userDTO.getOrgRights();
            if (orgRights == null) {
                orgRights = new ArrayList<V1OrgRightDTO>();
            }
            orgRights.add(orgRightDTO);
            userDTO.setOrgRights(orgRights);
            users.set(index, userDTO);
        }
        results.add(users);
        results.add(orgs);
        return results;
    }

    private boolean isIntegratedUser(List<String> integPrefixes, String login) {
        int underscore = login.indexOf(95);
        return underscore >= 0 && integPrefixes.contains(login.substring(0, underscore));
    }

    @Override
    public List parseUserSpreadsheet(FormFile fileItem) throws IOException {
        this.results = new ArrayList();
        HSSFSheet sheet = this.getSheet(fileItem);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        log.debug((Object)("sheet rows: " + startRow + ".." + endRow));
        User user = null;
        for (int i = startRow + 1; i < endRow + 1; ++i) {
            log.debug((Object)("starting row: " + i));
            this.emptyRow = true;
            this.hasError = false;
            this.rowResult = new ArrayList();
            HSSFRow row = sheet.getRow(i);
            user = this.parseUser(row, i);
            if (this.emptyRow) {
                log.debug((Object)("emptyRow: " + this.emptyRow));
                break;
            }
            if (this.hasError) {
                log.debug((Object)("hasError: " + this.hasError));
                this.results.add(this.rowResult);
                continue;
            }
            try {
                this.service.save((Object)user);
                this.writeAuditLog(user);
                log.debug((Object)("saved user: " + user.getUserId()));
            }
            catch (Exception e) {
                log.debug((Object)e);
                this.rowResult.add(this.messageService.getMessage("error.fail.add"));
            }
            log.debug((Object)("rowResult size: " + this.rowResult.size()));
            this.results.add(this.rowResult);
        }
        log.debug((Object)("found " + this.results.size() + " users in spreadsheet."));
        return this.results;
    }

    @Override
    public List parseRolesSpreadsheet(FormFile fileItem) throws IOException {
        this.results = new ArrayList();
        HSSFSheet sheet = this.getSheet(fileItem);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        log.debug((Object)("sheet rows: " + startRow + ".." + endRow));
        for (int i = startRow + 1; i < endRow + 1; ++i) {
            log.debug((Object)("starting row: " + i));
            this.emptyRow = true;
            this.hasError = false;
            this.rowResult = new ArrayList();
            HSSFRow row = sheet.getRow(i);
            String login = this.parseStringCell(row.getCell((short)0));
            String orgId = this.parseStringCell(row.getCell((short)1));
            List<String> roles = this.parseRolesCell(row.getCell((short)2));
            if (this.emptyRow) {
                log.debug((Object)("emptyRow: " + this.emptyRow));
                break;
            }
            if (this.hasError) {
                log.debug((Object)("hasError: " + this.hasError));
                this.results.add(this.rowResult);
                continue;
            }
            try {
                this.saveUserRoles(login, orgId, roles, row);
            }
            catch (Exception e) {
                log.debug((Object)e);
                this.rowResult.add(this.messageService.getMessage("error.fail.add"));
            }
            log.debug((Object)("rowResult size: " + this.rowResult.size()));
            this.results.add(this.rowResult);
        }
        log.debug((Object)("found " + this.results.size() + " users in spreadsheet."));
        return this.results;
    }

    private void setError(String message, String arg) {
        if (StringUtils.isBlank((String)arg)) {
            this.rowResult.add(this.messageService.getMessage(message));
        } else {
            Object[] args = new String[]{arg};
            this.rowResult.add(this.messageService.getMessage(message, args));
        }
        this.hasError = true;
    }

    private void saveUserRoles(String login, String orgId, List<String> roles, HSSFRow row) {
        User user = null;
        if (StringUtils.isNotBlank((String)login)) {
            user = this.service.getUserByLogin(login);
        } else if (StringUtils.isBlank((String)login)) {
            this.setError("error.login.required", "");
        }
        if (user == null) {
            this.setError("user.does.not.exist", login);
        }
        Organisation org = null;
        if (StringUtils.isNotBlank((String)orgId)) {
            org = (Organisation)this.service.findById(Organisation.class, (Serializable)new Integer(orgId));
        }
        if (StringUtils.isBlank((String)orgId) || org == null) {
            this.setError("error.org.invalid", "(" + orgId + ")");
        } else if (roles == null || !this.checkValidRoles(roles, this.service.isUserSysAdmin(), org.getOrganisationType())) {
            this.setError("error.roles.invalid", "(" + this.parseStringCell(row.getCell((short)2)) + ")");
        }
        if (!this.hasError) {
            this.service.setRolesForUserOrganisation(user, org, roles);
            log.debug((Object)("added: " + login + " to: " + org.getName() + " with roles: " + roles));
        }
    }

    private User parseUser(HSSFRow row, int rowIndex) {
        User user = new User();
        Object[] args = new String[1];
        String login = this.parseStringCell(row.getCell((short)0));
        if (login == null || login == "") {
            this.rowResult.add(this.messageService.getMessage("error.login.required"));
            this.hasError = true;
            return null;
        }
        if (this.service.getUserByLogin(login) != null) {
            args[0] = "(" + login + ")";
            this.rowResult.add(this.messageService.getMessage("error.login.unique", args));
            this.hasError = true;
            return null;
        }
        user.setLogin(login);
        String password = HashUtil.sha1((String)this.parseStringCell(row.getCell((short)1)));
        user.setPassword(password);
        user.setTitle(this.parseStringCell(row.getCell((short)2)));
        String fname = this.parseStringCell(row.getCell((short)3));
        if (fname == null || fname == "") {
            this.rowResult.add(this.messageService.getMessage("error.firstname.required"));
            this.hasError = true;
        } else {
            user.setFirstName(fname);
        }
        String lname = this.parseStringCell(row.getCell((short)4));
        if (lname == null || lname == "") {
            this.rowResult.add(this.messageService.getMessage("error.lastname.required"));
            this.hasError = true;
        } else {
            user.setLastName(lname);
        }
        String authMethodName = this.parseStringCell(row.getCell((short)5));
        AuthenticationMethod authMethod = this.getAuthMethod(authMethodName);
        if (authMethod == null) {
            args[0] = "(" + authMethodName + ")";
            this.rowResult.add(this.messageService.getMessage("error.authmethod.invalid", args));
            this.hasError = true;
        } else {
            user.setAuthenticationMethod(authMethod);
        }
        String email = this.parseStringCell(row.getCell((short)6));
        if (email == null || email == "") {
            this.rowResult.add(this.messageService.getMessage("error.email.required"));
            this.hasError = true;
        } else {
            Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
            Matcher m = p.matcher(email);
            if (!m.matches()) {
                this.rowResult.add(this.messageService.getMessage("error.valid.email.required"));
                this.hasError = true;
            }
            user.setEmail(email);
        }
        String flashId = this.parseStringCell(row.getCell((short)7));
        CSSThemeVisualElement flashTheme = this.getFlashTheme(flashId);
        if (flashTheme == null) {
            args[0] = "(" + flashId + ")";
            this.rowResult.add(this.messageService.getMessage("error.flash.theme.invalid", args));
            this.hasError = true;
        } else {
            user.setFlashTheme(flashTheme);
        }
        String htmlId = this.parseStringCell(row.getCell((short)8));
        CSSThemeVisualElement htmlTheme = this.getHtmlTheme(htmlId);
        if (htmlTheme == null) {
            args[0] = "(" + htmlId + ")";
            this.rowResult.add(this.messageService.getMessage("error.html.theme.invalid", args));
            this.hasError = true;
        } else {
            user.setHtmlTheme(htmlTheme);
        }
        String localeId = this.parseStringCell(row.getCell((short)9));
        SupportedLocale locale = this.getLocale(localeId);
        if (locale == null) {
            args[0] = "(" + localeId + ")";
            this.rowResult.add(this.messageService.getMessage("error.locale.invalid", args));
            this.hasError = true;
        } else {
            user.setLocale(locale);
        }
        user.setAddressLine1(this.parseStringCell(row.getCell((short)10)));
        user.setAddressLine2(this.parseStringCell(row.getCell((short)11)));
        user.setAddressLine3(this.parseStringCell(row.getCell((short)12)));
        user.setCity(this.parseStringCell(row.getCell((short)13)));
        user.setState(this.parseStringCell(row.getCell((short)14)));
        user.setPostcode(this.parseStringCell(row.getCell((short)15)));
        user.setCountry(this.parseStringCell(row.getCell((short)16)));
        user.setDayPhone(this.parseStringCell(row.getCell((short)17)));
        user.setEveningPhone(this.parseStringCell(row.getCell((short)18)));
        user.setMobilePhone(this.parseStringCell(row.getCell((short)19)));
        user.setFax(this.parseStringCell(row.getCell((short)20)));
        user.setDisabledFlag(Boolean.valueOf(false));
        user.setCreateDate(new Date());
        return this.hasError ? null : user;
    }

    private String parseStringCell(HSSFCell cell) {
        if (cell != null) {
            try {
                cell.setCellType(1);
                if (cell.getStringCellValue() != null) {
                    if (cell.getStringCellValue().trim().length() != 0) {
                        this.emptyRow = false;
                    }
                } else {
                    return null;
                }
                return cell.getStringCellValue().trim();
            }
            catch (Exception e) {
                cell.setCellType(0);
                double d = cell.getNumericCellValue();
                this.emptyRow = false;
                return new Long(new Double(d).longValue()).toString();
            }
        }
        return null;
    }

    private AuthenticationMethod getAuthMethod(String authMethodName) {
        if (authMethodName == null || authMethodName == "") {
            return (AuthenticationMethod)this.service.findById(AuthenticationMethod.class, (Serializable)AuthenticationMethod.DB);
        }
        List list = this.service.findByProperty(AuthenticationMethod.class, "authenticationMethodName", (Object)authMethodName);
        return list == null || list.isEmpty() ? null : (AuthenticationMethod)list.get(0);
    }

    private List<String> parseRolesCell(HSSFCell cell) {
        String roleDescription = "";
        if (cell != null) {
            String role;
            try {
                cell.setCellType(1);
                if (cell.getStringCellValue() == null && cell.getStringCellValue().trim().length() == 0) {
                    log.debug((Object)"role cell is null");
                    return null;
                }
                this.emptyRow = false;
                roleDescription = cell.getStringCellValue().trim();
            }
            catch (Exception e) {
                log.debug((Object)"role cell exception");
                return null;
            }
            ArrayList<String> roles = new ArrayList<String>();
            int fromIndex = 0;
            int index = roleDescription.indexOf("|", fromIndex);
            while (index != -1) {
                log.debug((Object)("using role name: " + roleDescription.substring(fromIndex, index)));
                role = this.addRoleId(roleDescription, fromIndex, index);
                if (role == null) {
                    return null;
                }
                roles.add(role);
                fromIndex = index + 1;
                index = roleDescription.indexOf("|", fromIndex);
            }
            log.debug((Object)("using rolee name: " + roleDescription.substring(fromIndex, roleDescription.length())));
            role = this.addRoleId(roleDescription, fromIndex, roleDescription.length());
            if (role == null) {
                return null;
            }
            roles.add(role);
            return roles;
        }
        return null;
    }

    private String addRoleId(String roleDescription, int fromIndex, int index) {
        Role role;
        List list = this.service.findByProperty(Role.class, "name", (Object)roleDescription.substring(fromIndex, index));
        Role role2 = role = list == null || list.isEmpty() ? null : (Role)list.get(0);
        if (role != null) {
            log.debug((Object)("role: " + role.getName()));
            return role.getRoleId().toString();
        }
        return null;
    }

    private boolean checkValidRoles(List<String> idList, boolean isSysadmin, OrganisationType orgType) {
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (String id : idList) {
            Role role = (Role)this.service.findById(Role.class, (Serializable)Integer.valueOf(Integer.parseInt(id)));
            if (role != null) {
                roleList.add(role);
                continue;
            }
            return false;
        }
        List validRoles = this.service.filterRoles(roleList, Boolean.valueOf(isSysadmin), orgType);
        for (Role r : roleList) {
            if (validRoles.contains(r)) continue;
            return false;
        }
        return true;
    }

    private CSSThemeVisualElement getFlashTheme(String flashId) {
        if (flashId == null || flashId == "") {
            String flashName = Configuration.get((String)ConfigurationKeys.DEFAULT_FLASH_THEME);
            List list = this.service.findByProperty(CSSThemeVisualElement.class, "name", (Object)flashName);
            return list != null && list.size() > 0 ? (CSSThemeVisualElement)list.get(0) : null;
        }
        try {
            return (CSSThemeVisualElement)this.service.findById(CSSThemeVisualElement.class, (Serializable)new Long(flashId));
        }
        catch (Exception e) {
            return null;
        }
    }

    private CSSThemeVisualElement getHtmlTheme(String htmlId) {
        if (htmlId == null || htmlId == "") {
            String htmlName = Configuration.get((String)ConfigurationKeys.DEFAULT_HTML_THEME);
            List list = this.service.findByProperty(CSSThemeVisualElement.class, "name", (Object)htmlName);
            return list != null && list.size() > 0 ? (CSSThemeVisualElement)list.get(0) : null;
        }
        try {
            return (CSSThemeVisualElement)this.service.findById(CSSThemeVisualElement.class, (Serializable)new Long(htmlId));
        }
        catch (Exception e) {
            return null;
        }
    }

    private SupportedLocale getLocale(String localeId) {
        if (localeId == null || localeId == "") {
            String defaultLocale = Configuration.get((String)ConfigurationKeys.SERVER_LANGUAGE);
            return this.service.getSupportedLocale(defaultLocale.substring(0, 2), defaultLocale.substring(3));
        }
        try {
            return (SupportedLocale)this.service.findById(SupportedLocale.class, (Serializable)new Integer(localeId));
        }
        catch (Exception e) {
            return null;
        }
    }

    private void writeAuditLog(User user) {
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")", user.getFullName()};
        String message = this.messageService.getMessage("audit.user.create", args);
        this.auditService.log("admin", message);
    }
}

