/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class UserOrgAction
extends Action {
    private static final Logger log = Logger.getLogger(UserOrgAction.class);
    private static IUserManagementService service;
    private static MessageService messageService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Organisation orgOfCourseAdmin;
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        messageService = AdminServiceProxy.getMessageService(this.getServlet().getServletContext());
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        log.debug((Object)("orgId: " + orgId));
        Organisation organisation = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        if (orgId == null || orgId <= 0 || organisation == null) {
            request.setAttribute("errorName", (Object)"UserOrgAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.org.invalid"));
            return mapping.findForward("error");
        }
        String orgName = organisation.getName();
        log.debug((Object)("orgName: " + orgName));
        Organisation parentOrg = organisation.getParentOrganisation();
        if (parentOrg != null && !parentOrg.equals((Object)service.getRootOrganisation())) {
            request.setAttribute("pOrgId", (Object)parentOrg.getOrganisationId());
            request.setAttribute("pOrgName", (Object)parentOrg.getName());
        }
        Integer orgType = organisation.getOrganisationType().getOrganisationTypeId();
        request.setAttribute("orgType", (Object)orgType);
        Integer userId = ((UserDTO)SessionManager.getSession().getAttribute("user")).getUserID();
        List users = new ArrayList();
        Organisation organisation2 = orgOfCourseAdmin = orgType.equals(OrganisationType.CLASS_TYPE) ? parentOrg : organisation;
        if (request.isUserInRole("SYSADMIN") || service.isUserGlobalGroupAdmin()) {
            users = service.findAll(User.class);
        } else if (service.isUserInRole(userId, orgOfCourseAdmin.getOrganisationId(), "GROUP ADMIN") || service.isUserInRole(userId, orgOfCourseAdmin.getOrganisationId(), "GROUP MANAGER")) {
            if (orgOfCourseAdmin.getCourseAdminCanBrowseAllUsers().booleanValue()) {
                users = service.findAll(User.class);
            } else if (orgType.equals(OrganisationType.CLASS_TYPE)) {
                users = service.getUsersFromOrganisation(parentOrg.getOrganisationId());
            } else if (orgType.equals(OrganisationType.COURSE_TYPE)) {
                users = service.getUsersFromOrganisation(orgId);
            }
        } else {
            request.setAttribute("errorName", (Object)"UserOrgAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        users = this.removeDisabledUsers(users);
        Collections.sort(users);
        request.setAttribute("userlist", users);
        DynaActionForm userOrgForm = (DynaActionForm)form;
        userOrgForm.set("orgId", (Object)orgId);
        userOrgForm.set("orgName", (Object)orgName);
        List memberUsers = service.getUsersFromOrganisation(orgId);
        String[] userIds = new String[memberUsers.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = ((User)memberUsers.get(i)).getUserId().toString();
        }
        userOrgForm.set("userIds", (Object)userIds);
        return mapping.findForward("userorg");
    }

    private List removeDisabledUsers(List userList) {
        ArrayList<User> filteredList = new ArrayList<User>();
        for (int i = 0; i < userList.size(); ++i) {
            User u = (User)userList.get(i);
            if (u.getDisabledFlag().booleanValue()) continue;
            filteredList.add(u);
        }
        return filteredList;
    }
}

