/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.admin.web.UserBean;
import org.lamsfoundation.lams.admin.web.UserOrgRoleForm;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

public class UserOrgRoleSaveAction
extends Action {
    private static Logger log = Logger.getLogger(UserOrgRoleSaveAction.class);
    private static IUserManagementService service;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        UserOrgRoleForm userOrgRoleForm = (UserOrgRoleForm)form;
        ArrayList userBeans = userOrgRoleForm.getUserBeans();
        log.debug((Object)("userBeans is null? " + userBeans == null ? 1 : 0));
        Integer orgId = userOrgRoleForm.getOrgId();
        log.debug((Object)("orgId: " + orgId));
        Organisation organisation = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        request.setAttribute("org", (Object)orgId);
        request.getSession().removeAttribute("UserOrgRoleForm");
        if (this.isCancelled(request)) {
            return mapping.findForward("userlist");
        }
        for (int i = 0; i < userBeans.size(); ++i) {
            UserBean bean = (UserBean)userBeans.get(i);
            User user = (User)service.findById(User.class, (Serializable)bean.getUserId());
            log.debug((Object)("userId: " + bean.getUserId()));
            String[] roleIds = bean.getRoleIds();
            if (roleIds.length == 0) {
                ActionMessages errors = new ActionMessages();
                errors.add("roles", new ActionMessage("error.roles.empty"));
                this.saveErrors(request, errors);
                request.setAttribute("orgId", (Object)orgId);
                return mapping.findForward("userorg");
            }
            service.setRolesForUserOrganisation(user, organisation, Arrays.asList(roleIds));
            if (!organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) || service.getUserOrganisation(bean.getUserId(), organisation.getParentOrganisation().getOrganisationId()) != null) continue;
            service.setRolesForUserOrganisation(user, organisation.getParentOrganisation(), Arrays.asList(roleIds));
        }
        return mapping.findForward("userlist");
    }
}

