/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.admin.service.AdminServiceProxy;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;

public class UserSearchAction
extends Action {
    private static Logger log = Logger.getLogger(UserSearchAction.class);
    private static IUserManagementService service;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        service = AdminServiceProxy.getService(this.getServlet().getServletContext());
        DynaActionForm userSearchForm = (DynaActionForm)form;
        if (!request.isUserInRole("SYSADMIN") && !service.isUserGlobalGroupAdmin()) {
            log.debug((Object)"user not sysadmin or global group admin");
            ActionMessages errors = new ActionMessages();
            errors.add("authorisation", new ActionMessage("error.authorisation"));
            this.saveErrors(request, errors);
            request.setAttribute("isSysadmin", (Object)false);
            return mapping.findForward("usersearchlist");
        }
        String userId = ((String)userSearchForm.get("sUserId")).trim();
        String login = ((String)userSearchForm.get("sLogin")).trim();
        String firstName = ((String)userSearchForm.get("sFirstName")).trim();
        String lastName = ((String)userSearchForm.get("sLastName")).trim();
        Boolean showAll = (Boolean)userSearchForm.get("showAll");
        Boolean searched = (Boolean)userSearchForm.get("searched");
        String resultsSection = ((String)userSearchForm.get("resultsSection")).trim();
        Integer start = WebUtil.readIntParam((HttpServletRequest)request, (String)"start", (boolean)true);
        if (start != null) {
            userId = WebUtil.readStrParam((HttpServletRequest)request, (String)"uid", (boolean)true);
            login = WebUtil.readStrParam((HttpServletRequest)request, (String)"l", (boolean)true);
            firstName = WebUtil.readStrParam((HttpServletRequest)request, (String)"fn", (boolean)true);
            lastName = WebUtil.readStrParam((HttpServletRequest)request, (String)"ln", (boolean)true);
            showAll = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"sa");
            resultsSection = WebUtil.readStrParam((HttpServletRequest)request, (String)"rs", (boolean)true);
            searched = true;
        }
        log.debug((Object)("got userId: '" + userId + "'"));
        log.debug((Object)("got login: '" + login + "'"));
        log.debug((Object)("got firstName: '" + firstName + "'"));
        log.debug((Object)("got lastName: '" + lastName + "'"));
        List userList = new ArrayList();
        if (showAll.booleanValue()) {
            userList = service.findAll(User.class);
        } else if (userId.length() == 0) {
            HashMap<String, String> stringProperties = new HashMap<String, String>();
            if (login.length() > 0) {
                stringProperties.put("login", "%" + login + "%");
            }
            if (firstName.length() > 0) {
                stringProperties.put("firstName", "%" + firstName + "%");
            }
            if (lastName.length() > 0) {
                stringProperties.put("lastName", "%" + lastName + "%");
            }
            if (!stringProperties.isEmpty()) {
                userList = service.searchByStringProperties(User.class, stringProperties);
            }
        } else {
            HashMap<String, String> objectProperties = new HashMap<String, String>();
            objectProperties.put("userId", userId);
            if (login.length() > 0) {
                objectProperties.put("login", login);
            }
            if (firstName.length() > 0) {
                objectProperties.put("firstName", firstName);
            }
            if (lastName.length() > 0) {
                objectProperties.put("lastName", lastName);
            }
            if (!objectProperties.isEmpty()) {
                userList = service.findByProperties(User.class, objectProperties);
            }
        }
        if (searched.booleanValue()) {
            if (userList.isEmpty()) {
                ActionMessages messages = new ActionMessages();
                messages.add("results", new ActionMessage("msg.results.none"));
                this.saveMessages(request, messages);
            } else {
                userList = this.removeDisabledUsers(userList);
            }
        }
        userSearchForm.set("showAll", (Object)false);
        userSearchForm.set("searched", (Object)true);
        request.setAttribute("userList", userList);
        request.setAttribute("fullSize", (Object)userList.size());
        request.setAttribute("resultsSection", resultsSection.equals("all") ? Integer.valueOf(userList.size()) : resultsSection);
        request.setAttribute("start", (Object)(start != null ? start : 0));
        request.setAttribute("uid", (Object)userId);
        request.setAttribute("login", (Object)login);
        request.setAttribute("firstName", (Object)firstName);
        request.setAttribute("lastName", (Object)lastName);
        request.setAttribute("showAll", (Object)showAll);
        return mapping.findForward("usersearchlist");
    }

    private List removeDisabledUsers(List userList) {
        ArrayList<User> filteredList = new ArrayList<User>();
        for (int i = 0; i < userList.size(); ++i) {
            User u = (User)userList.get(i);
            if (u.getDisabledFlag().booleanValue()) continue;
            filteredList.add(u);
        }
        return filteredList;
    }
}

