/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.exception.GroupingException;
import org.lamsfoundation.lams.usermanagement.User;

public class ChosenGrouper
extends Grouper
implements Serializable {
    private static final long serialVersionUID = -8498560084860150033L;
    private static Logger log = Logger.getLogger(ChosenGrouper.class);

    public void doGrouping(Grouping chosenGrouping, String groupName, User learner) {
        ArrayList<User> learners = new ArrayList<User>();
        learners.add(learner);
        this.doGrouping(chosenGrouping, groupName, learners);
    }

    public void doGrouping(Grouping chosenGrouping, String groupName, List learners) {
        String trimmedName;
        String string = trimmedName = groupName != null ? groupName.trim() : null;
        if (trimmedName == null || trimmedName.length() == 0) {
            String prefix = this.getPrefix();
            trimmedName = prefix + " " + System.currentTimeMillis();
            log.warn((Object)("Chosen grouper for grouping " + chosenGrouping.toString() + " did not get a group name. Selecting default name of " + trimmedName));
        }
        Iterator iter = chosenGrouping.getGroups().iterator();
        Group selectedGroup = null;
        while (iter.hasNext() && selectedGroup == null) {
            Group group = (Group)iter.next();
            if (!trimmedName.equals(selectedGroup.getGroupName())) continue;
            selectedGroup = group;
        }
        this.doGrouping(chosenGrouping, selectedGroup, trimmedName, learners);
    }

    public void doGrouping(Grouping chosenGrouping, Long groupId, List learners) throws GroupingException {
        Iterator iter = chosenGrouping.getGroups().iterator();
        Group selectedGroup = null;
        while (iter.hasNext() && selectedGroup == null) {
            Group group = (Group)iter.next();
            if (!group.getGroupId().equals(groupId)) continue;
            selectedGroup = group;
        }
        if (selectedGroup == null) {
            String error = "Tried to add users to group " + groupId + " but group cannot be found.";
            log.error((Object)error);
            throw new GroupingException(error);
        }
        this.doGrouping(chosenGrouping, selectedGroup, null, learners);
    }

    public void doGrouping(Grouping chosenGrouping, Group group, String groupName, List learners) {
        if (group != null) {
            group.getUsers().addAll(learners);
        } else {
            chosenGrouping.getGroups().add(Group.createLearnerGroup(chosenGrouping, groupName, new HashSet(learners)));
        }
    }

    public Group createGroup(Grouping grouping, String name) throws GroupingException {
        int currentSize = grouping.getGroups().size();
        if (grouping.getMaxNumberOfGroups() != null && currentSize == grouping.getMaxNumberOfGroups()) {
            String error = "Tried to add group " + name + " to grouping " + grouping + ". Exceeded max number of groups - current size is " + currentSize;
            log.error((Object)error);
            throw new GroupingException(error);
        }
        return super.createGroup(grouping, name);
    }
}

