/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.springframework.dao.DataRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingDAO
extends BaseDAO
implements IGroupingDAO {
    private static final String GROUPINGS_FOR_LEARNING_DESIGN = "select grouping from " + Grouping.class.getName() + " grouping, " + GroupingActivity.class.getName() + " activity " + " where activity.createGrouping = grouping and activity.learningDesign.id = ?";

    @Override
    public Grouping getGroupingById(Long groupingID) {
        Grouping grouping = (Grouping)super.find(Grouping.class, groupingID);
        return this.getNonCGLibGrouping(grouping);
    }

    @Override
    public List<Grouping> getGroupingsByLearningDesign(Long learningDesignId) {
        List groupings = this.getHibernateTemplate().find(GROUPINGS_FOR_LEARNING_DESIGN, (Object)learningDesignId);
        ArrayList<Grouping> realGroupings = new ArrayList<Grouping>(groupings.size());
        for (Grouping element : groupings) {
            realGroupings.add(this.getNonCGLibGrouping(element));
        }
        return realGroupings;
    }

    private Grouping getNonCGLibGrouping(Grouping grouping) {
        if (grouping != null) {
            if (grouping.isRandomGrouping()) {
                return (Grouping)super.find(RandomGrouping.class, grouping.getGroupingId());
            }
            if (grouping.isChosenGrouping()) {
                return (Grouping)super.find(ChosenGrouping.class, grouping.getGroupingId());
            }
            throw new DataRetrievalFailureException("Unable to get grouping as the grouping type is unknown or missing. Grouping object is " + grouping);
        }
        return null;
    }
}

