/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityDTOOrderComparator;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.learningdesign.dto.TransitionDTO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class LearningDesignDTO
extends BaseDTO {
    private Long learningDesignID;
    private Integer learningDesignUIID;
    private String description;
    private String title;
    private Long firstActivityID;
    private Integer firstActivityUIID;
    private Integer maxID;
    private Boolean validDesign;
    private Boolean readOnly;
    private Date dateReadOnly;
    private Integer userID;
    private String helpText;
    private Integer copyTypeID;
    private Date createDateTime;
    private String version;
    private Long originalLearningDesignID;
    private Integer workspaceFolderID;
    private Long duration;
    private String licenseText;
    private Long licenseID;
    private Date lastModifiedDateTime;
    private String contentFolderID;
    private String offlineInstructions;
    private String onlineInstructions;
    private ArrayList groupings;
    private ArrayList activities;
    private ArrayList transitions;

    public LearningDesignDTO() {
    }

    public LearningDesignDTO(Long learningDesignId, Integer learningDesignUIID, String description, String title, Long firstActivityID, Integer firstActivityUIID, Integer maxId, Boolean validDesign, Boolean readOnly, Date dateReadOnly, Integer userID, String helpText, Integer copyTypeID, Date createDateTime, String version, Long originalLearningDesignID, Integer workspaceFolderID, Long duration, String licenseText, Long licenseID, Date lastModifiedDateTime, String offlineInstructions, String onlineInstructions) {
        this.learningDesignID = learningDesignId;
        this.learningDesignUIID = learningDesignUIID;
        this.description = description;
        this.title = title;
        this.firstActivityID = firstActivityID;
        this.firstActivityUIID = firstActivityUIID;
        this.maxID = maxId;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.dateReadOnly = dateReadOnly;
        this.offlineInstructions = offlineInstructions;
        this.onlineInstructions = onlineInstructions;
        this.userID = userID;
        this.helpText = helpText;
        this.copyTypeID = copyTypeID;
        this.createDateTime = createDateTime;
        this.version = version;
        this.originalLearningDesignID = originalLearningDesignID;
        this.workspaceFolderID = workspaceFolderID;
        this.duration = duration;
        this.licenseText = licenseText;
        this.licenseID = licenseID;
        this.lastModifiedDateTime = lastModifiedDateTime;
        this.groupings = new ArrayList();
        this.activities = new ArrayList();
        this.transitions = new ArrayList();
    }

    public LearningDesignDTO(LearningDesign learningDesign, ActivityDAO activityDAO) {
        this.learningDesignID = learningDesign.getLearningDesignId();
        this.learningDesignUIID = learningDesign.getLearningDesignUIID();
        this.description = learningDesign.getDescription();
        this.title = learningDesign.getTitle();
        this.firstActivityID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityId() : null;
        this.firstActivityUIID = learningDesign.getFirstActivity() != null ? learningDesign.getFirstActivity().getActivityUIID() : null;
        this.maxID = learningDesign.getMaxID();
        this.validDesign = learningDesign.getValidDesign();
        this.readOnly = learningDesign.getReadOnly();
        this.dateReadOnly = learningDesign.getDateReadOnly();
        this.offlineInstructions = learningDesign.getOfflineInstructions();
        this.onlineInstructions = learningDesign.getOnlineInstructions();
        this.userID = learningDesign.getUser() != null ? learningDesign.getUser().getUserId() : null;
        this.helpText = learningDesign.getHelpText();
        this.copyTypeID = learningDesign.getCopyTypeID();
        this.contentFolderID = learningDesign.getContentFolderID();
        this.createDateTime = learningDesign.getCreateDateTime();
        this.version = learningDesign.getVersion();
        this.originalLearningDesignID = learningDesign.getOriginalLearningDesign() != null ? learningDesign.getOriginalLearningDesign().getLearningDesignId() : null;
        this.workspaceFolderID = learningDesign.getWorkspaceFolder() != null ? learningDesign.getWorkspaceFolder().getWorkspaceFolderId() : null;
        this.duration = learningDesign.getDuration();
        this.licenseText = learningDesign.getLicenseText();
        this.licenseID = learningDesign.getLicense() != null ? learningDesign.getLicense().getLicenseID() : null;
        this.lastModifiedDateTime = learningDesign.getLastModifiedDateTime();
        this.groupings = this.populateGroupings(learningDesign, activityDAO);
        this.activities = this.populateActivities(learningDesign);
        this.transitions = this.populateTransitions(learningDesign);
    }

    public String getContentFolderID() {
        return this.contentFolderID;
    }

    public Integer getCopyTypeID() {
        return this.copyTypeID;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public Date getDateReadOnly() {
        return this.dateReadOnly;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getFirstActivityID() {
        return this.firstActivityID;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Integer getLearningDesignUIID() {
        return this.learningDesignUIID;
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public Integer getMaxID() {
        return this.maxID;
    }

    public Long getOriginalLearningDesignID() {
        return this.originalLearningDesignID;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getUserID() {
        return this.userID;
    }

    public Boolean getValidDesign() {
        return this.validDesign;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID;
    }

    public ArrayList getActivities() {
        return this.activities;
    }

    public ArrayList populateGroupings(LearningDesign design, ActivityDAO activityDAO) {
        ArrayList<GroupingDTO> groupingList = new ArrayList<GroupingDTO>();
        List groupingActivities = activityDAO.getGroupingActivitiesByLearningDesignId(design.getLearningDesignId());
        for (GroupingActivity groupingActivity : groupingActivities) {
            Grouping grouping = groupingActivity.getCreateGrouping();
            groupingList.add(grouping.getGroupingDTO());
        }
        return groupingList;
    }

    public ArrayList populateActivities(LearningDesign design) {
        TreeSet<AuthoringActivityDTO> dtoSet = new TreeSet<AuthoringActivityDTO>(new ActivityDTOOrderComparator());
        for (Activity object : design.getParentActivities()) {
            dtoSet.addAll(object.getAuthoringActivityDTOSet());
        }
        return new ArrayList<AuthoringActivityDTO>(dtoSet);
    }

    public ArrayList populateTransitions(LearningDesign design) {
        ArrayList<TransitionDTO> transitions = new ArrayList<TransitionDTO>();
        if (design.getTransitions() != null) {
            for (Transition trans : design.getTransitions()) {
                transitions.add(trans.getTransitionDTO());
            }
        }
        return transitions;
    }

    public ArrayList getTransitions() {
        return this.transitions;
    }

    public void setActivities(ArrayList activities) {
        this.activities = activities;
    }

    public void setContentFolderID(String contentFolderID) {
        this.contentFolderID = contentFolderID;
    }

    public void setCopyTypeID(Integer copyTypeID) {
        this.copyTypeID = copyTypeID;
    }

    public void setCreateDateTime(Date createDateTime) {
        if (!createDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.createDateTime = createDateTime;
        }
    }

    public void setDateReadOnly(Date dateReadOnly) {
        if (!dateReadOnly.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.dateReadOnly = dateReadOnly;
        }
    }

    public void setDescription(String description) {
        if (!description.equals("string_null_value")) {
            this.description = description;
        }
    }

    public void setDuration(Long duration) {
        if (!duration.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.duration = duration;
        }
    }

    public void setFirstActivityID(Long firstActivityID) {
        if (!firstActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.firstActivityID = firstActivityID;
        }
    }

    public void setHelpText(String helpText) {
        if (!helpText.equals("string_null_value")) {
            this.helpText = helpText;
        }
    }

    public void setLastModifiedDateTime(Date lastModifiedDateTime) {
        if (!lastModifiedDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.lastModifiedDateTime = lastModifiedDateTime;
        }
    }

    public void setLearningDesignID(Long learningDesignId) {
        if (!learningDesignId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningDesignID = learningDesignId;
        }
    }

    public void setLearningDesignUIID(Integer learningDesignUIID) {
        if (!learningDesignUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.learningDesignUIID = learningDesignUIID;
        }
    }

    public void setLicenseID(Long licenseID) {
        if (!licenseID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.licenseID = licenseID;
        }
    }

    public void setLicenseText(String licenseText) {
        if (!licenseText.equals("string_null_value")) {
            this.licenseText = licenseText;
        }
    }

    public void setMaxID(Integer maxID) {
        if (!maxID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.maxID = maxID;
        }
    }

    public void setOriginalLearningDesignID(Long originalLearningDesignID) {
        if (!originalLearningDesignID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.originalLearningDesignID = originalLearningDesignID;
        }
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setTitle(String title) {
        if (!title.equals("string_null_value")) {
            this.title = title;
        }
    }

    public void setTransitions(ArrayList transitions) {
        this.transitions = transitions;
    }

    public void setUserID(Integer userID) {
        if (!userID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.userID = userID;
        }
    }

    public void setValidDesign(Boolean validDesign) {
        this.validDesign = validDesign;
    }

    public void setVersion(String version) {
        if (!version.equals("string_null_value")) {
            this.version = version;
        }
    }

    public void setWorkspaceFolderID(Integer workspaceFolderID) {
        if (!workspaceFolderID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.workspaceFolderID = workspaceFolderID;
        }
    }

    public Integer getFirstActivityUIID() {
        return this.firstActivityUIID;
    }

    public void setFirstActivityUIID(Integer firstActivityUIID) {
        if (!firstActivityUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.firstActivityUIID = firstActivityUIID;
        }
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        if (!onlineInstructions.equals("string_null_value")) {
            this.onlineInstructions = onlineInstructions;
        }
    }

    public void setOfflineInstructions(String offlineInstructions) {
        if (!offlineInstructions.equals("string_null_value")) {
            this.offlineInstructions = offlineInstructions;
        }
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public ArrayList getGroupings() {
        return this.groupings;
    }

    public void setGroupings(ArrayList groupings) {
        this.groupings = groupings;
    }
}

