/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.ImportExportUtil;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolImportSupport;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolImportSupportDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LD102Importer
implements ApplicationContextAware {
    private static final String MSG_KEY_PERM_GATE = "imported.permission.gate.title";
    private static final String MSG_KEY_SYNC_GATE = "imported.synchronise.gate.title";
    private static final String MSG_KEY_SR_WARNING = "import.shareresources.warning";
    private static final String MSG_KEY_VALIDATION_ERROR = "error.import.validation";
    private Logger log = Logger.getLogger(LD102Importer.class);
    private ApplicationContext context;
    private ILearningDesignService learningDesignService = null;
    private MessageService messageService = null;
    private IBaseDAO baseDAO = null;
    private ILearningLibraryDAO learningLibraryDAO = null;
    private ILearningDesignDAO learningDesignDAO = null;
    private IActivityDAO activityDAO = null;
    private IToolDAO toolDAO = null;
    private IToolImportSupportDAO toolImportSupportDAO = null;
    private IToolContentDAO toolContentDAO = null;
    private ISystemToolDAO systemToolDAO = null;
    private LearningDesign ldInProgress = null;
    private Integer maxId = null;
    private String originalPacket = null;
    private List<String> toolsErrorMsgs;
    private Date createDate = new Date();
    private User importer = null;
    private UserDTO importerDTO = null;
    private boolean needShareResourcesWarning = false;
    private Map<Integer, Integer> groupingsToAssign = new HashMap<Integer, Integer>();
    private Map<Integer, Grouping> newGroupings = new HashMap<Integer, Grouping>();
    private Set<Hashtable> optionalActivitiesToDo = new HashSet<Hashtable>();
    private Set<Hashtable> transitionsToDo = new HashSet<Hashtable>();
    private Map<Integer, Activity> newActivityMap = new HashMap<Integer, Activity>();
    private Map<Integer, Integer> flattenedActivityMap = new HashMap<Integer, Integer>();
    private Map<Integer, Hashtable> contentMap = new HashMap<Integer, Hashtable>();
    private int numberOfTopLevelActivitiesInXML = 0;
    private int numberOfTopLevelTransitionsInXML = 0;
    private Map<Long, ToolActivity> libraryActivityForTool;
    private Map<Long, ComplexActivity> complexLibraryActivityForTool;
    private Map<String, Tool> toolImportSupport;
    private static final Integer NUMERIC_NULL_VALUE_INTEGER = new Integer(-1);
    private static final Integer OPT_ACTIVITY_102_MARGIN = 20;
    private static final String LD_OBJECT_TYPE = "LearningDesign";
    private static final String ABSTRACT_TASK_OBJECT_TYPE = "task";
    private static final String MULTI_TASK_OBJECT_TYPE = "Multitask";
    private static final String TRANSITION_OBJECT_TYPE = "transition";
    private static final String ACTIVITY_OBJECT_TYPE = "Activity";
    private static final String OPTIONAL_OBJECT_TYPE = "optionalactivity";
    private static final String CONTENT_OBJECT_TYPE = "content";

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setLearningDesignService(ILearningDesignService learningDesignService) {
        this.learningDesignService = learningDesignService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public void setToolImportSupportDAO(IToolImportSupportDAO toolImportSupportDAO) {
        this.toolImportSupportDAO = toolImportSupportDAO;
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setLearningLibraryDAO(ILearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    private boolean keyExists(Hashtable table, String key) {
        return table.containsKey(key);
    }

    protected static boolean isTask(String objectType) {
        return objectType != null && (objectType.equalsIgnoreCase(ABSTRACT_TASK_OBJECT_TYPE) || objectType.equalsIgnoreCase(MULTI_TASK_OBJECT_TYPE));
    }

    protected static boolean isSimpleTask(String objectType, String toolType) {
        return objectType != null && toolType != null && objectType.equalsIgnoreCase(ABSTRACT_TASK_OBJECT_TYPE) && !toolType.equalsIgnoreCase("group");
    }

    protected static boolean isMultiTask(String objectType, String toolType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(MULTI_TASK_OBJECT_TYPE);
    }

    protected static boolean isGroupingToolTask(String objectType, String toolType) {
        return objectType != null && toolType != null && objectType.equalsIgnoreCase(ABSTRACT_TASK_OBJECT_TYPE) && toolType.equalsIgnoreCase("group");
    }

    protected static boolean isTransition(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(TRANSITION_OBJECT_TYPE);
    }

    protected static boolean isActivity(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(ACTIVITY_OBJECT_TYPE);
    }

    protected static boolean isOptionalActivity(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(OPTIONAL_OBJECT_TYPE);
    }

    protected static boolean isContent(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(CONTENT_OBJECT_TYPE);
    }

    protected static boolean isLearningDesign(String objectType) {
        return objectType == null ? false : objectType.trim().equalsIgnoreCase(LD_OBJECT_TYPE);
    }

    protected static String getExpectedActivityTransition() {
        return "Wrong format for data - object type expected isActivity or optionalactivity or transition";
    }

    protected static String getExpectedActivity() {
        return "Wrong format for data - object type expected isActivity";
    }

    protected static String getExpectedOptionalActivity() {
        return "Wrong format for data - object type expected isoptionalactivity";
    }

    protected static String getExpectedContent() {
        return "Wrong format for data - object type expected iscontent";
    }

    protected static String getExpectedTaskTransition() {
        return "Wrong format for data - object type expected istask or Multitask or transition";
    }

    protected static String getExpectedTask() {
        return "Wrong format for data - object type expected istask or Multitask";
    }

    private boolean containsNulls(String packet) {
        return packet.indexOf("<null />") != -1;
    }

    private String convertAmpersands(String packet) {
        return packet.replaceAll("&amp;", "&amp;amp;");
    }

    public Long storeLDDataWDDX(String ldWddxPacket, User importer, WorkspaceFolder folder, List<String> toolsErrorMsgs) throws ImportToolContentException {
        this.libraryActivityForTool = this.getLibraryActivityForTool();
        this.toolImportSupport = this.getToolImportSupport();
        this.toolsErrorMsgs = toolsErrorMsgs;
        this.numberOfTopLevelActivitiesInXML = 0;
        this.numberOfTopLevelTransitionsInXML = 0;
        if (toolsErrorMsgs == null) {
            this.log.warn((Object)"The list toolsErrorMsgs supplied is null so any warnings will be logged but won't appear in the user's screen.");
            toolsErrorMsgs = new ArrayList<String>();
        }
        this.originalPacket = ldWddxPacket;
        if (importer == null) {
            throw new ImportToolContentException("Importer is missing");
        }
        this.importer = importer;
        this.importerDTO = importer.getUserDTO();
        if (this.containsNulls(ldWddxPacket)) {
            this.log.error((Object)"Unable to process WDDX packet from client due to containing '<null/>' - this would cause WDDX to crash.");
            this.log.error((Object)("Packet was " + ldWddxPacket));
            throw new ImportToolContentException("Invalid packet format - contains nulls. See log for details.");
        }
        if (!ldWddxPacket.startsWith("<wddxPacket")) {
            this.log.debug((Object)"Packet is probably encrypting. Attempting to decrypt.");
            try {
                ldWddxPacket = ImportExportUtil.decryptImport(ldWddxPacket);
            }
            catch (GeneralSecurityException e) {
                this.log.error((Object)"Unable to decrypt packet", (Throwable)e);
                throw new ImportToolContentException("Invalid packet format - failed decryption. See log for details.", e);
            }
        }
        ldWddxPacket = this.convertAmpersands(ldWddxPacket);
        Hashtable ldHashTable = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Request received to import 1.0.x learning design data" + ldWddxPacket));
        }
        try {
            ldHashTable = (Hashtable)WDDXProcessor.deserialize(ldWddxPacket);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to process the imported packet: ", (Throwable)e);
            this.log.error((Object)("Packet was " + ldWddxPacket));
            throw new ImportToolContentException("Invalid import data format - unable to deserialise packet. See log for details.");
        }
        if (ldHashTable == null) {
            this.log.error((Object)("WDDX packet is empty. Packet was " + ldWddxPacket));
            throw new ImportToolContentException("Invalid packet format - no details in packet. See log for details.");
        }
        if (!LD102Importer.isLearningDesign((String)ldHashTable.get("objectType"))) {
            this.log.error((Object)("Packet is not a learning design packet. Packet was " + ldWddxPacket));
            throw new ImportToolContentException("Invalid packet format - it is not a learning design packet. See log for details.");
        }
        this.processLearningDesign(ldHashTable, folder);
        this.validateDesign(toolsErrorMsgs);
        this.baseDAO.update(this.ldInProgress);
        if (this.needShareResourcesWarning) {
            toolsErrorMsgs.add(this.messageService.getMessage(MSG_KEY_SR_WARNING));
        }
        return this.ldInProgress != null ? this.ldInProgress.getLearningDesignId() : null;
    }

    private void validateDesign(List<String> toolsErrorMsgs) {
        Vector<ValidationErrorDTO> listOfValidationErrorDTOs = this.learningDesignService.validateLearningDesign(this.ldInProgress);
        if (listOfValidationErrorDTOs.size() > 0) {
            this.ldInProgress.setValidDesign(Boolean.FALSE);
            this.log.info((Object)("Imported learning design is invalid. New learning design id " + this.ldInProgress.getLearningDesignId() + " title "));
            HashSet<String> messages = new HashSet<String>();
            for (ValidationErrorDTO dto : listOfValidationErrorDTOs) {
                this.log.info((Object)("Learning design id " + this.ldInProgress.getLearningDesignId() + " validation error " + dto));
                messages.add(dto.getMessage());
            }
            StringBuffer buf = new StringBuffer(100);
            buf.append(this.messageService.getMessage(MSG_KEY_VALIDATION_ERROR));
            buf.append(" ");
            for (String msg : messages) {
                buf.append(msg);
                buf.append(" ");
            }
            toolsErrorMsgs.add(buf.toString());
        } else {
            this.ldInProgress.setValidDesign(Boolean.TRUE);
        }
    }

    private void handleWDDXProcessorConversionException(WDDXProcessorConversionException e) {
        this.log.error((Object)"Unable to process the imported packet properly due to a WDDXProcessorConversionException - will continue with the design in case future parts okay.", (Throwable)e);
        this.log.error((Object)("Packet was " + this.originalPacket));
        this.toolsErrorMsgs.add("Invalid import data format - WDDX caused an exception. Some data from the design will have been lost. See log for more details.");
    }

    private void processLearningDesign(Hashtable newLdHashTable, WorkspaceFolder folder) {
        Vector newActivitiesTransitions;
        this.createLearningDesign(newLdHashTable, folder);
        this.baseDAO.insert(this.ldInProgress);
        Vector newContent = (Vector)newLdHashTable.get(CONTENT_OBJECT_TYPE);
        if (newContent != null) {
            this.processContent(newContent);
        }
        if ((newActivitiesTransitions = (Vector)newLdHashTable.get("activitiesTransitions")) == null) {
            this.log.warn((Object)("No activities or transitions were found for  #" + this.ldInProgress.getLearningDesignId()));
        } else {
            this.processActivitiesTransitions(newActivitiesTransitions);
        }
        for (Hashtable optionTable : this.optionalActivitiesToDo) {
            this.setupOptionalActivity(optionTable);
        }
        boolean showErrorOnTransitionWithNoActivity = this.numberOfTopLevelTransitionsInXML < this.numberOfTopLevelActivitiesInXML;
        for (Hashtable transTable : this.transitionsToDo) {
            this.setupTransition(transTable, showErrorOnTransitionWithNoActivity);
        }
        this.assignGroupings();
        this.ldInProgress.setFirstActivity(this.ldInProgress.calculateFirstActivity());
        this.ldInProgress.setMaxID(this.maxId);
        this.baseDAO.update(this.ldInProgress);
    }

    private void createLearningDesign(Hashtable newLdHashTable, WorkspaceFolder folder) {
        LearningDesign ld = new LearningDesign();
        ld.setLearningDesignId(null);
        ld.setLearningDesignUIID(null);
        ld.setDescription((String)newLdHashTable.get("description"));
        String title = (String)newLdHashTable.get("title");
        ld.setTitle(ImportExportUtil.generateUniqueLDTitle(folder, title, this.learningDesignDAO));
        ld.setHelpText((String)newLdHashTable.get("helpText"));
        ld.setValidDesign(Boolean.FALSE);
        ld.setReadOnly(Boolean.FALSE);
        ld.setDateReadOnly(null);
        ld.setOfflineInstructions(null);
        ld.setOnlineInstructions(null);
        try {
            this.maxId = WDDXProcessor.convertToInt("Max ID", newLdHashTable.get("maxId"));
            ld.setMaxID(this.maxId);
        }
        catch (WDDXProcessorConversionException e) {
            this.handleWDDXProcessorConversionException(e);
        }
        ld.setUser(this.importer);
        if (folder != null) {
            ld.setWorkspaceFolder(folder);
        }
        ld.setCopyTypeID(1);
        ld.setCreateDateTime(this.createDate);
        ld.setLastModifiedDateTime(this.createDate);
        ld.setVersion((String)newLdHashTable.get("lamsVersion"));
        ld.setLastModifiedDateTime(this.createDate);
        ld.setDuration(null);
        ld.setLicenseText(null);
        ld.setLicense(null);
        this.ldInProgress = ld;
    }

    protected void processActivitiesTransitions(List newActivitiesTransitions) {
        for (Hashtable clientObj : newActivitiesTransitions) {
            String objectType = (String)clientObj.get("objectType");
            if (!(LD102Importer.isActivity(objectType) || LD102Importer.isTransition(objectType) || LD102Importer.isOptionalActivity(objectType))) {
                String message = LD102Importer.getExpectedActivityTransition() + " received " + objectType + ". The matching activity/transition will be skipped. Object is " + clientObj;
                this.log.warn((Object)message);
                this.toolsErrorMsgs.add(message);
            }
            try {
                Integer objId = WDDXProcessor.convertToInteger("Activity/Transition ID", clientObj.get("id"));
                if (NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
                    String message = "Id value for activity/transition is internal null value. The activity/transition may not appear in the correct place in the sequence. Activity/transition is " + clientObj;
                    this.log.warn((Object)message);
                    this.toolsErrorMsgs.add(message);
                }
                if (LD102Importer.isActivity(objectType)) {
                    ++this.numberOfTopLevelActivitiesInXML;
                    this.processActivity(clientObj, objId);
                    continue;
                }
                if (LD102Importer.isOptionalActivity(objectType)) {
                    ++this.numberOfTopLevelActivitiesInXML;
                    this.optionalActivitiesToDo.add(clientObj);
                    continue;
                }
                ++this.numberOfTopLevelTransitionsInXML;
                this.transitionsToDo.add(clientObj);
            }
            catch (WDDXProcessorConversionException e) {
                this.handleWDDXProcessorConversionException(e);
            }
        }
    }

    private void processActivity(Hashtable activityDetails, Integer activityUIID) throws WDDXProcessorConversionException {
        Long nextTransition = WDDXProcessor.convertToLong(activityDetails, "nextTransition");
        Integer xCoOrd = WDDXProcessor.convertToInteger(activityDetails, "x");
        Integer yCoOrd = WDDXProcessor.convertToInteger(activityDetails, "y");
        String title = WDDXProcessor.convertToString(activityDetails, "title");
        String description = WDDXProcessor.convertToString(activityDetails, "description");
        List taskTransitions = (List)activityDetails.get("tasksTransitions");
        if (taskTransitions.size() != 1 && taskTransitions.size() != 3) {
            HashSet<Integer> knownToolContentIds = new HashSet<Integer>();
            Iterator iter = taskTransitions.iterator();
            while (iter.hasNext()) {
                Hashtable task = (Hashtable)iter.next();
                Integer toolContentId = WDDXProcessor.convertToInteger(task, "inputContent");
                if (knownToolContentIds.contains(toolContentId)) {
                    this.log.warn((Object)("Duplicate task found in activity. Task will be removed. Activity is " + activityDetails));
                    iter.remove();
                    continue;
                }
                knownToolContentIds.add(toolContentId);
            }
        }
        if (taskTransitions.size() == 1) {
            Hashtable task = (Hashtable)taskTransitions.get(0);
            this.createActivityFromTask(task, nextTransition, xCoOrd, yCoOrd, activityUIID, title, description);
        } else if (taskTransitions.size() == 3) {
            this.createTwoPartActivity(activityDetails, activityUIID, nextTransition, xCoOrd, yCoOrd, title, description, taskTransitions);
        } else {
            String message = "Unexpected activity format for activity " + title + " expect either 1 or 3 tasks within an activity. This activity will be missing from the sequence. Activity " + activityDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
    }

    private Activity createTwoPartActivity(Hashtable activityDetails, Integer activityUIID, Long nextTransition, Integer xCoOrd, Integer yCoOrd, String title, String description, List taskTransitions) throws WDDXProcessorConversionException {
        Activity realTask = null;
        Activity protentialReflectiveTask = null;
        String[] reflectiveText = null;
        Integer firstTaskId = this.getFirstTaskId(activityDetails, title, taskTransitions);
        if (firstTaskId == null || NUMERIC_NULL_VALUE_INTEGER.equals(firstTaskId)) {
            String message = "Unable to determine the first task definition in a combined activity " + title + ". This activity will be missing from the sequence. Activity " + activityDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
            return null;
        }
        for (Hashtable task : taskTransitions) {
            String objectType = (String)task.get("objectType");
            String toolType = (String)task.get("toolType");
            if (LD102Importer.isTransition(objectType)) continue;
            Integer taskId = WDDXProcessor.convertToInteger(task, "id");
            if (firstTaskId.equals(taskId)) {
                realTask = this.createActivityFromTask(task, nextTransition, xCoOrd, yCoOrd, activityUIID, title, description);
                protentialReflectiveTask = this.findPotentialReflectiveTask(realTask, task, objectType, toolType);
                continue;
            }
            reflectiveText = this.getReflectiveText(title, task);
        }
        if (realTask == null) {
            String message = "Couldn't find the \"real\" activity inside " + title + ". This activity will be missing from the sequence. Activity " + activityDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        } else if (protentialReflectiveTask != null && reflectiveText != null) {
            try {
                ToolActivity toolActivity = (ToolActivity)protentialReflectiveTask;
                ToolContentImport102Manager toolService = (ToolContentImport102Manager)this.context.getBean(toolActivity.getTool().getServiceName());
                toolService.setReflectiveData(toolActivity.getToolContentId(), (String)reflectiveText[0], (String)reflectiveText[1]);
            }
            catch (Exception e) {
                String message = "Tool content for activity " + title + " should be reflective (" + (String)reflectiveText[0] + ":" + (String)reflectiveText[1] + ") but activity doesn't seem to support reflection. Reflective details will be missing.";
                this.log.warn((Object)message, (Throwable)e);
                this.toolsErrorMsgs.add(message);
            }
        }
        return realTask;
    }

    private Activity findPotentialReflectiveTask(Activity realTask, Hashtable task, String objectType, String toolType) throws WDDXProcessorConversionException {
        Activity reflectiveTask = null;
        Integer outputContentTaskId = null;
        if (LD102Importer.isMultiTask(objectType, toolType)) {
            outputContentTaskId = WDDXProcessor.convertToInteger(task, "outputContentTask");
            ComplexActivity cActivity = (ComplexActivity)realTask;
            if (outputContentTaskId != null && !NUMERIC_NULL_VALUE_INTEGER.equals(outputContentTaskId)) {
                Iterator actIter = cActivity.getActivities().iterator();
                while (reflectiveTask == null && actIter.hasNext()) {
                    Activity subActivity = (Activity)actIter.next();
                    if (!outputContentTaskId.equals(subActivity.getActivityUIID())) continue;
                    reflectiveTask = subActivity;
                }
            }
        } else {
            reflectiveTask = realTask;
        }
        return reflectiveTask;
    }

    private String[] getReflectiveText(String title, Hashtable task) throws WDDXProcessorConversionException {
        String[] reflectiveText = null;
        List subTasks = (List)task.get("subTasks");
        Integer journalTaskInputContentId = null;
        if (subTasks != null) {
            for (Hashtable subTask : subTasks) {
                if (!"journal".equals(subTask.get("toolType"))) continue;
                journalTaskInputContentId = WDDXProcessor.convertToInteger(subTask, "inputContent");
            }
        }
        Hashtable journalContent = null;
        if (journalTaskInputContentId != null && !NUMERIC_NULL_VALUE_INTEGER.equals(journalTaskInputContentId)) {
            journalContent = this.contentMap.get(journalTaskInputContentId);
        }
        if (journalContent != null) {
            reflectiveText = new String[]{(String)journalContent.get("title"), (String)journalContent.get("body")};
        }
        return reflectiveText;
    }

    private Integer getFirstTaskId(Hashtable activityDetails, String title, List taskTransitions) throws WDDXProcessorConversionException {
        Integer firstTaskId = WDDXProcessor.convertToInteger(activityDetails, "firstTask");
        if (firstTaskId == null) {
            for (Hashtable task : taskTransitions) {
                if (!LD102Importer.isTransition((String)task.get("objectType"))) continue;
                firstTaskId = WDDXProcessor.convertToInteger(task, "fromTasks");
            }
            if (firstTaskId != null) {
                String message = "First task definition missing from activity " + title + ". Guessed it from the rest of the packet. This activity may be incorrect. Activity " + activityDetails;
                this.log.warn((Object)message);
                this.toolsErrorMsgs.add(message);
            }
        }
        return firstTaskId;
    }

    private Activity createActivityFromTask(Hashtable taskDetails, Long nextTransition, Integer xCoOrd, Integer yCoOrd, Integer parentActivityId, String parentTitle, String parentDescription) throws WDDXProcessorConversionException {
        String objectType = (String)taskDetails.get("objectType");
        String toolType = (String)taskDetails.get("toolType");
        Integer contentId = WDDXProcessor.convertToInteger(taskDetails, "inputContent");
        Activity activity = null;
        Integer taskUIID = null;
        if (this.keyExists(taskDetails, "id")) {
            taskUIID = WDDXProcessor.convertToInteger(taskDetails, "id");
        } else {
            String message = "Id value for task is missing. The activity may not appear in the correct place in the sequence. Activity is " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
        activity = LD102Importer.isMultiTask(objectType, toolType) ? this.setupParallelActivity(taskDetails, contentId, taskUIID, parentTitle, parentDescription) : (LD102Importer.isGroupingToolTask(objectType, toolType) ? this.setupGroupingActivity(taskDetails, contentId, taskUIID, parentActivityId) : this.setupToolActivity(taskDetails, contentId, taskUIID, parentTitle, parentDescription));
        if (activity != null) {
            this.processCommonActivityFields(taskDetails, xCoOrd, yCoOrd, activity);
            this.newActivityMap.put(activity.getActivityUIID(), activity);
            this.flattenedActivityMap.put(parentActivityId, activity.getActivityUIID());
            this.baseDAO.insert(activity);
            this.ldInProgress.getActivities().add(activity);
        }
        return activity;
    }

    private void processCommonActivityFields(Hashtable taskDetails, Integer xCoOrd, Integer yCoOrd, Activity activity) throws WDDXProcessorConversionException {
        if (activity.getDefineLater() == null) {
            activity.setDefineLater(Boolean.FALSE);
        }
        activity.setXcoord(xCoOrd);
        activity.setYcoord(yCoOrd);
        activity.setHelpText(null);
        activity.setApplyGrouping(false);
        this.parseGroupingValue(taskDetails.get("grouping"), activity);
        activity.setGroupingSupportType(2);
        activity.setOrderId(null);
        activity.setLearningDesign(this.ldInProgress);
        activity.setCreateDateTime(this.createDate);
        activity.setRunOffline(Boolean.FALSE);
    }

    private Activity setupParallelActivity(Hashtable taskDetails, Integer contentId, Integer taskUIID, String parentTitle, String parentDescription) throws WDDXProcessorConversionException {
        ParallelActivity activity = (ParallelActivity)Activity.getActivityInstance(6);
        activity.setActivityTypeId(6);
        activity.setActivityCategoryID(1);
        activity.setActivityUIID(taskUIID);
        activity.setDescription(parentDescription);
        activity.setTitle(parentTitle);
        List subTasks = (List)taskDetails.get("subTasks");
        String subTaskOrderString = (String)taskDetails.get("taskOrder");
        if (subTasks == null || subTasks.size() != 2) {
            String message = "Can't find two subtasks for the parallel activity " + parentTitle + ". The parallel activity will not be in the sequence. Activity is " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
            return null;
        }
        String[] subTaskOrder = subTaskOrderString.split(",");
        int backupUnusedOrderId = subTaskOrder.length;
        for (Hashtable subTask : subTasks) {
            Activity subActivity = this.createActivityFromTask(subTask, null, null, null, null, null, null);
            if (subActivity == null) continue;
            subActivity.setParentActivity(activity);
            subActivity.setParentUIID(activity.getActivityUIID());
            activity.addActivity(subActivity);
            Integer orderId = null;
            String subTaskUIID = subActivity.getActivityUIID() != null ? subActivity.getActivityUIID().toString() : "";
            for (int i = 0; orderId == null && i < subTaskOrder.length; ++i) {
                if (!subTaskOrder[i].equals(subTaskUIID)) continue;
                orderId = new Integer(i + 1);
            }
            if (orderId == null) {
                orderId = backupUnusedOrderId++;
                String message = "Order of activities in parallel activity " + parentTitle + " can't be determined properly. The order on the screen may be wrong. Activity is " + taskDetails;
                this.log.warn((Object)message);
                this.toolsErrorMsgs.add(message);
            }
            subActivity.setOrderId(orderId);
        }
        this.setupParallelActivityIcon(activity);
        return activity;
    }

    private ParallelActivity setupParallelActivityIcon(ParallelActivity activity) {
        Set subActivities = activity.getActivities();
        if (subActivities.size() != 2) {
            return activity;
        }
        activity.setLibraryActivityUiImage(this.findParallelActivityIcon(subActivities));
        return activity;
    }

    private String findParallelActivityIcon(Set subActivities) {
        for (Activity activity : this.complexLibraryActivityForTool.values()) {
            if (!activity.isParallelActivity()) continue;
            ParallelActivity parallelActivity = (ParallelActivity)activity;
            Set toolActivities = parallelActivity.getAllToolActivities();
            Object[] toolActivitiesArray = toolActivities.toArray();
            Object[] subActivitiesArray = subActivities.toArray();
            if (toolActivitiesArray.length != 2) continue;
            if (this.compareToolActivitiesbyTool((ToolActivity)toolActivitiesArray[0], (ToolActivity)subActivitiesArray[0]) && this.compareToolActivitiesbyTool((ToolActivity)toolActivitiesArray[1], (ToolActivity)subActivitiesArray[1])) {
                return parallelActivity.getLibraryActivityUiImage();
            }
            if (!this.compareToolActivitiesbyTool((ToolActivity)toolActivitiesArray[0], (ToolActivity)subActivitiesArray[1]) || !this.compareToolActivitiesbyTool((ToolActivity)toolActivitiesArray[1], (ToolActivity)subActivitiesArray[0])) continue;
            return parallelActivity.getLibraryActivityUiImage();
        }
        return null;
    }

    private boolean compareToolActivitiesbyTool(ToolActivity toolActivity, ToolActivity toolActivityToCompare) {
        return toolActivity.getTool().equals(toolActivityToCompare.getTool());
    }

    private GroupingActivity setupGroupingActivity(Hashtable taskDetails, Integer contentId, Integer taskUIID, Integer parentActivityId) throws WDDXProcessorConversionException {
        RandomGrouping grouping = (RandomGrouping)Grouping.getGroupingInstance(Grouping.RANDOM_GROUPING_TYPE);
        grouping.setGroupingUIID(taskUIID);
        this.baseDAO.insert(grouping);
        GroupingActivity groupingActivity = (GroupingActivity)Activity.getActivityInstance(2);
        groupingActivity.setActivityCategoryID(1);
        groupingActivity.setActivityUIID(parentActivityId);
        groupingActivity.setCreateGrouping(grouping);
        groupingActivity.setCreateGroupingUIID(grouping.getGroupingUIID());
        Hashtable groupingContent = this.contentMap.get(contentId);
        if (groupingContent == null) {
            String message = "Unable to find a content for grouping. Default values will apply. Grouping was " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        } else {
            Integer maxNumLearner;
            Integer numGroups = WDDXProcessor.convertToInteger(groupingContent, "number_groups");
            if (numGroups != null && !NUMERIC_NULL_VALUE_INTEGER.equals(numGroups)) {
                grouping.setNumberOfGroups(numGroups);
            }
            if ((maxNumLearner = WDDXProcessor.convertToInteger(groupingContent, "max_number_in_group")) != null && !NUMERIC_NULL_VALUE_INTEGER.equals(maxNumLearner)) {
                grouping.setLearnersPerGroup(maxNumLearner);
            }
            groupingActivity.setTitle((String)groupingContent.get("title"));
            groupingActivity.setDescription((String)groupingContent.get("description"));
        }
        this.newGroupings.put(grouping.getGroupingUIID(), grouping);
        return groupingActivity;
    }

    private ToolActivity setupToolActivity(Hashtable taskDetails, Integer wddxContentId, Integer taskUIID, String overrideTitle, String overrideDescription) {
        Tool tool;
        ToolActivity activity = new ToolActivity();
        activity.setActivityUIID(taskUIID);
        activity.setActivityTypeId(1);
        String toolType = (String)taskDetails.get("toolType");
        String toolTitle = (String)taskDetails.get("title");
        String toolDescription = (String)taskDetails.get("description");
        Tool tool2 = tool = toolType != null ? this.toolImportSupport.get(toolType) : null;
        if (tool == null) {
            String message = "Unable to find a tool that supports the activity " + toolTitle + ". This activity will be skipped. Activity is " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
            return null;
        }
        if ("urlcontent".equals(toolType)) {
            this.needShareResourcesWarning = true;
        }
        activity.setTitle(overrideTitle != null ? overrideTitle : toolTitle);
        activity.setDescription(overrideDescription != null ? overrideDescription : toolDescription);
        ToolContent newContent = new ToolContent(tool);
        this.toolContentDAO.saveToolContent(newContent);
        Long toolContentId = newContent.getToolContentId();
        activity.setTool(tool);
        activity.setToolContentId(toolContentId);
        Hashtable content = this.contentMap.get(wddxContentId);
        if (content != null) {
            try {
                Boolean defineLater = WDDXProcessor.convertToBoolean(content, "contentDefineLater");
                defineLater = defineLater != null ? defineLater : Boolean.FALSE;
                activity.setDefineLater(defineLater);
                ToolContentImport102Manager toolService = (ToolContentImport102Manager)this.context.getBean(tool.getServiceName());
                toolService.import102ToolContent(toolContentId, this.importerDTO, content);
            }
            catch (Exception e) {
                String message = "Tool content for activity " + toolTitle + " cannot be set up due to an error. Activity will be use the default content. Activity is " + taskDetails;
                this.log.warn((Object)message, (Throwable)e);
                this.toolsErrorMsgs.add(message);
            }
        } else {
            String message = "Tool content for activity " + toolTitle + " is missing. Activity will be set up with default content. Activity is " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
        ToolActivity ta = this.libraryActivityForTool.get(tool.getToolId());
        if (ta != null) {
            activity.setLibraryActivityUiImage(ta.getLibraryActivityUiImage());
            activity.setActivityCategoryID(ta.getActivityCategoryID());
        } else {
            activity.setActivityCategoryID(4);
        }
        return activity;
    }

    private void parseGroupingValue(Object groupingIdRaw, Activity activity) {
        Integer groupingId = null;
        if (groupingIdRaw != null) {
            try {
                groupingId = WDDXProcessor.convertToInteger("Grouping ID", groupingIdRaw);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (groupingId != null) {
            this.groupingsToAssign.put(activity.getActivityUIID(), groupingId);
            this.log.debug((Object)("Is grouped activity, id=" + groupingId));
        }
    }

    private void assignGroupings() {
        for (Map.Entry<Integer, Integer> entry : this.groupingsToAssign.entrySet()) {
            Activity activity = this.newActivityMap.get(entry.getKey());
            Grouping grouping = this.newGroupings.get(entry.getValue());
            if (activity != null && grouping != null) {
                activity.setGrouping(grouping);
                activity.setGroupingUIID(grouping.getGroupingUIID());
                activity.setApplyGrouping(true);
                continue;
            }
            String message = "Unable to find a pair (activity/grouping) for a grouped activity. The activity will not be grouped. Activity UIID" + entry.getKey() + " grouping UIID " + entry.getValue();
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
    }

    protected void processContent(List newContent) {
        for (Hashtable clientObj : newContent) {
            String objectType;
            if (clientObj == null) {
                this.log.warn((Object)"Packet contains invalid content - one of the content objects is null!");
                this.log.warn((Object)("Content list is" + newContent.toString()));
                this.toolsErrorMsgs.add("Packet contained an empty content object. See log for more details.");
            }
            if (!LD102Importer.isContent(objectType = (String)clientObj.get("objectType"))) {
                String message = LD102Importer.getExpectedContent() + " received " + objectType + ". The matching activity will be missing its content. Object is " + clientObj;
                this.log.warn((Object)message);
                this.toolsErrorMsgs.add(message);
            }
            try {
                Integer objId = WDDXProcessor.convertToInteger("Content ID", clientObj.get("id"));
                if (NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
                    String message = "Id value for content is internal null value. The matching activity will be missing its content. Content is " + clientObj;
                    this.log.warn((Object)message);
                    this.toolsErrorMsgs.add(message);
                }
                this.contentMap.put(objId, clientObj);
            }
            catch (WDDXProcessorConversionException e) {
                this.handleWDDXProcessorConversionException(e);
            }
        }
    }

    private void setupOptionalActivity(Hashtable optionObj) {
        try {
            OptionsActivity optionsActivity = (OptionsActivity)Activity.getActivityInstance(7);
            optionsActivity.setActivityCategoryID(1);
            optionsActivity.setActivityUIID(WDDXProcessor.convertToInteger(optionObj, "id"));
            if (this.keyExists(optionObj, "minNumberComplete")) {
                optionsActivity.setMinNumberOfOptions(WDDXProcessor.convertToInteger(optionObj, "minNumberComplete"));
            }
            optionsActivity.setMaxNumberOfOptions(null);
            optionsActivity.setOptionsInstructions(null);
            optionsActivity.setDescription((String)optionObj.get("description"));
            optionsActivity.setTitle((String)optionObj.get("title"));
            Integer xCoOrd = WDDXProcessor.convertToInteger(optionObj, "x");
            Integer yCoOrd = WDDXProcessor.convertToInteger(optionObj, "y");
            this.processCommonActivityFields(optionObj, xCoOrd, yCoOrd, optionsActivity);
            Vector subActivityUIIDs = (Vector)optionObj.get("activities");
            TreeMap<Integer, Activity> sortedMap = new TreeMap<Integer, Activity>();
            int orderId = 1;
            int childy = 1;
            if (subActivityUIIDs != null) {
                Iterator subActIter = subActivityUIIDs.iterator();
                while (subActIter.hasNext()) {
                    Integer id = WDDXProcessor.convertToInteger("Activity ID in Optional Activity", subActIter.next());
                    Activity childActivity = this.getMatchingActivity(id);
                    if (childActivity == null) {
                        String message = "Activity inside optional activity " + optionsActivity.getTitle() + " cannot be matched to a known activity. The child activity will be missing from the optional activity but it may appear in the design elsewhere. Child activity UI ID " + id;
                        this.log.warn((Object)message);
                        this.toolsErrorMsgs.add(message);
                        continue;
                    }
                    if (childActivity.getYcoord() != null) {
                        childy = childActivity.getYcoord();
                    }
                    while (sortedMap.containsKey(childy)) {
                        ++childy;
                    }
                    sortedMap.put(childy, childActivity);
                }
            }
            Activity firstChild = null;
            for (Activity childActivity : sortedMap.values()) {
                if (firstChild == null) {
                    firstChild = childActivity;
                }
                childActivity.setParentActivity(optionsActivity);
                childActivity.setParentUIID(optionsActivity.getActivityUIID());
                childActivity.setOrderId(new Integer(orderId++));
                optionsActivity.getActivities().add(childActivity);
            }
            if (firstChild != null && firstChild.getYcoord() != null) {
                Integer overrideY = firstChild.getYcoord();
                if (overrideY > OPT_ACTIVITY_102_MARGIN) {
                    overrideY = overrideY - OPT_ACTIVITY_102_MARGIN;
                }
                optionsActivity.setYcoord(overrideY);
            }
            optionsActivity.setLearningDesign(this.ldInProgress);
            this.baseDAO.insert(optionsActivity);
            this.newActivityMap.put(optionsActivity.getActivityUIID(), optionsActivity);
            this.ldInProgress.getActivities().add(optionsActivity);
        }
        catch (WDDXProcessorConversionException e) {
            this.handleWDDXProcessorConversionException(e);
        }
    }

    protected void setupTransition(Hashtable clientObj, boolean showErrorOnTransitionWithNoActivity) {
        try {
            Activity activity;
            Activity activity2;
            Integer toActivity;
            Transition transition = new Transition();
            GateActivity gate = null;
            Transition gateTransition = null;
            Integer transitionUIID = WDDXProcessor.convertToInteger("Transition ID", clientObj.get("id"));
            transition.setTransitionUIID(transitionUIID != null && transitionUIID > 0 ? transitionUIID : (this.maxId = Integer.valueOf(this.maxId + 1)));
            transition.setCreateDateTime(this.createDate);
            String completion = (String)clientObj.get("completionType");
            if (completion != null && completion.length() > 0) {
                gate = this.setupGateActivity(completion);
                gateTransition = new Transition();
                this.maxId = this.maxId + 1;
                gateTransition.setTransitionUIID(this.maxId);
                gate.setTransitionFrom(gateTransition);
                gateTransition.setFromActivity(gate);
                gateTransition.setFromUIID(gate.getActivityUIID());
            }
            if (!NUMERIC_NULL_VALUE_INTEGER.equals(toActivity = WDDXProcessor.convertToInteger("ToTaskActivities", clientObj.get("toTasks"))) && (activity2 = this.getMatchingActivity(toActivity)) != null) {
                if (gate != null) {
                    this.setToActivity(transition, gate);
                    this.setToActivity(gateTransition, activity2);
                    int x = activity2.getXcoord() != null ? activity2.getXcoord() : 0;
                    gate.setXcoord(x >= 20 ? x - 20 : 5);
                    gate.setYcoord(activity2.getYcoord());
                } else {
                    this.setToActivity(transition, activity2);
                }
            }
            if (transition.getToActivity() == null) {
                String msg = "Can't find matching activity " + toActivity + " for transition. Transition will be missing in the design. Transition " + clientObj;
                this.log.warn((Object)msg);
                if (showErrorOnTransitionWithNoActivity) {
                    this.toolsErrorMsgs.add(msg);
                }
                return;
            }
            Integer fromActivity = WDDXProcessor.convertToInteger("FromTaskActivities", clientObj.get("fromTasks"));
            if (!NUMERIC_NULL_VALUE_INTEGER.equals(fromActivity) && (activity = this.getMatchingActivity(fromActivity)) != null) {
                transition.setFromUIID(activity.getActivityUIID());
                transition.setFromActivity(activity);
                activity.setTransitionFrom(transition);
            }
            if (transition.getFromActivity() == null) {
                String msg = "Can't find matching activity " + fromActivity + " for transition. Transition will be missing in the design. Transition " + clientObj;
                this.log.warn((Object)msg);
                if (showErrorOnTransitionWithNoActivity) {
                    this.toolsErrorMsgs.add(msg);
                }
                return;
            }
            transition.setLearningDesign(this.ldInProgress);
            this.ldInProgress.getTransitions().add(transition);
            this.baseDAO.insert(transition);
            if (gateTransition != null) {
                gateTransition.setLearningDesign(this.ldInProgress);
                this.ldInProgress.getTransitions().add(gateTransition);
                this.baseDAO.insert(gateTransition);
            }
        }
        catch (WDDXProcessorConversionException e) {
            this.handleWDDXProcessorConversionException(e);
        }
    }

    private GateActivity setupGateActivity(String completion) {
        GateActivity gate = null;
        Integer syncType = null;
        SystemTool systemTool = null;
        Integer activityType = null;
        String title = null;
        if ("synchronize".equals(completion)) {
            syncType = new Integer(3);
            systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.SYNC_GATE);
            activityType = new Integer(3);
            title = this.messageService.getMessage(MSG_KEY_SYNC_GATE);
        } else {
            syncType = new Integer(5);
            systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.PERMISSION_GATE);
            activityType = new Integer(5);
            title = this.messageService.getMessage(MSG_KEY_PERM_GATE);
        }
        if (syncType != null) {
            gate = (GateActivity)Activity.getActivityInstance(syncType);
            gate.setActivityTypeId((int)activityType);
            gate.setActivityCategoryID(1);
            gate.setSystemTool(systemTool);
            this.maxId = this.maxId + 1;
            gate.setActivityUIID(this.maxId);
            gate.setTitle(title != null ? title : "Gate");
            gate.setGateOpen(false);
            gate.setWaitingLearners(null);
            gate.setGateActivityLevelId(1);
            gate.setApplyGrouping(false);
            gate.setGroupingSupportType(2);
            gate.setOrderId(null);
            gate.setDefineLater(Boolean.FALSE);
            gate.setCreateDateTime(this.createDate);
            gate.setRunOffline(Boolean.FALSE);
            gate.setLearningDesign(this.ldInProgress);
            this.ldInProgress.getActivities().add(gate);
            this.baseDAO.insert(gate);
        }
        return gate;
    }

    private void setToActivity(Transition transition, Activity activity) {
        transition.setToUIID(activity.getActivityUIID());
        transition.setToActivity(activity);
        activity.setTransitionTo(transition);
    }

    private Activity getMatchingActivity(Integer uiID) {
        Integer childActivityId;
        Activity activity = this.newActivityMap.get(uiID);
        if (activity == null && (childActivityId = this.flattenedActivityMap.get(uiID)) != null) {
            activity = this.newActivityMap.get(childActivityId);
        }
        return activity;
    }

    private Map<Long, ToolActivity> getLibraryActivityForTool() {
        HashMap<Long, ToolActivity> activityMap = new HashMap<Long, ToolActivity>();
        HashMap<Long, ComplexActivity> complexMap = new HashMap<Long, ComplexActivity>();
        for (LearningLibrary learningLibrary : this.learningLibraryDAO.getAllLearningLibraries()) {
            List templateActivities = this.activityDAO.getActivitiesByLibraryID(learningLibrary.getLearningLibraryId());
            Iterator actIterator = templateActivities.iterator();
            while (actIterator.hasNext()) {
                this.getLibraryActivityFromActivity((Activity)actIterator.next(), activityMap, complexMap);
            }
        }
        this.complexLibraryActivityForTool = complexMap;
        return activityMap;
    }

    private void getLibraryActivityFromActivity(Activity activity, HashMap<Long, ToolActivity> activityMap, HashMap<Long, ComplexActivity> complexMap) {
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId(), ToolActivity.class);
            Tool tool = toolActivity.getTool();
            if (!activityMap.containsKey(tool.getToolId())) {
                activityMap.put(tool.getToolId(), toolActivity);
            }
        } else if (activity.isComplexActivity()) {
            ComplexActivity complex = (ComplexActivity)activity;
            Iterator actIterator = complex.getActivities().iterator();
            if (!complexMap.containsKey(complex.getActivityId())) {
                complexMap.put(complex.getActivityId(), complex);
            }
            while (actIterator.hasNext()) {
                this.getLibraryActivityFromActivity((Activity)actIterator.next(), activityMap, complexMap);
            }
        }
    }

    private Map<String, Tool> getToolImportSupport() {
        HashMap<String, Tool> supportedTools = new HashMap<String, Tool>();
        for (ToolImportSupport support : this.toolImportSupportDAO.getAllToolImportSupport()) {
            Tool tool = this.toolDAO.getToolBySignature(support.getInstalledToolSignature());
            if (tool == null || !tool.isValid()) continue;
            supportedTools.put(support.getSupportsToolSignature(), tool);
        }
        return supportedTools;
    }
}

