/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;

public class Lesson
implements Serializable {
    private static final long serialVersionUID = 5733920851084229175L;
    public static final Integer CREATED = new Integer(1);
    public static final Integer NOT_STARTED_STATE = new Integer(2);
    public static final Integer STARTED_STATE = new Integer(3);
    public static final Integer SUSPENDED_STATE = new Integer(4);
    public static final Integer FINISHED_STATE = new Integer(5);
    public static final Integer ARCHIVED_STATE = new Integer(6);
    public static final Integer REMOVED_STATE = new Integer(7);
    private Long lessonId;
    private String lessonName;
    private String lessonDescription;
    private Date createDateTime;
    private Date startDateTime;
    private Date endDateTime;
    private Date scheduleStartDate;
    private Date scheduleEndDate;
    private User user;
    private Integer lessonStateId;
    private Integer previousLessonStateId;
    private LearningDesign learningDesign;
    private LessonClass lessonClass;
    private Organisation organisation;
    private Set learnerProgresses;
    private Boolean learnerExportAvailable;

    public Lesson() {
    }

    public Lesson(String name, String description, Date createDateTime, User user, Integer lessonStateId, Integer previousLessonStateId, Boolean learnerExportAvailable, LearningDesign learningDesign, Set learnerProgresses) {
        this(null, name, description, createDateTime, null, null, user, lessonStateId, previousLessonStateId, learnerExportAvailable, learningDesign, null, null, learnerProgresses);
    }

    public Lesson(String name, String description, Date createDateTime, User user, Integer lessonStateId, Integer previousLessonStateId, Boolean learnerExportAvailable, LearningDesign learningDesign, LessonClass lessonClass, Organisation organisation, Set learnerProgresses) {
        this(null, name, description, createDateTime, null, null, user, lessonStateId, previousLessonStateId, learnerExportAvailable, learningDesign, lessonClass, organisation, learnerProgresses);
    }

    public Lesson(Long lessonId, String name, String description, Date createDateTime, Date startDateTime, Date endDateTime, User user, Integer lessonStateId, Integer previousLessonStateId, Boolean learnerExportAvailable, LearningDesign learningDesign, LessonClass lessonClass, Organisation organisation, Set learnerProgresses) {
        this.lessonId = lessonId;
        this.lessonName = name;
        this.lessonDescription = description;
        this.createDateTime = createDateTime;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.user = user;
        this.lessonStateId = lessonStateId;
        this.previousLessonStateId = previousLessonStateId;
        this.learnerExportAvailable = learnerExportAvailable != null ? learnerExportAvailable : Boolean.FALSE;
        this.learningDesign = learningDesign;
        this.lessonClass = lessonClass;
        this.organisation = organisation;
        this.learnerProgresses = learnerProgresses;
    }

    public static Lesson createNewLesson(String lessonName, String lessonDescription, User user, Organisation organisation, Boolean learnerExportAvailable, LearningDesign ld, LessonClass newLessonClass) {
        return new Lesson(lessonName, lessonDescription, new Date(System.currentTimeMillis()), user, CREATED, null, learnerExportAvailable, ld, newLessonClass, organisation, new HashSet());
    }

    public static Lesson createNewLessonWithoutClass(String lessonName, String lessonDescription, User user, Boolean learnerExportAvailable, LearningDesign ld) {
        return new Lesson(lessonName, lessonDescription, new Date(System.currentTimeMillis()), user, CREATED, null, learnerExportAvailable, ld, new HashSet());
    }

    public Long getLessonId() {
        return this.lessonId;
    }

    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public void setLessonName(String lessonName) {
        this.lessonName = lessonName;
    }

    public String getLessonDescription() {
        return this.lessonDescription;
    }

    public void setLessonDescription(String lessonDescription) {
        this.lessonDescription = lessonDescription;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
    }

    public Date getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(Date endDateTime) {
        this.endDateTime = endDateTime;
    }

    public Date getScheduleEndDate() {
        return this.scheduleEndDate;
    }

    public void setScheduleEndDate(Date scheduleEndDate) {
        this.scheduleEndDate = scheduleEndDate;
    }

    public Date getScheduleStartDate() {
        return this.scheduleStartDate;
    }

    public void setScheduleStartDate(Date scheduleStartDate) {
        this.scheduleStartDate = scheduleStartDate;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Integer getLessonStateId() {
        return this.lessonStateId;
    }

    public void setLessonStateId(Integer lessonStateId) {
        this.lessonStateId = lessonStateId;
    }

    public Integer getPreviousLessonStateId() {
        return this.previousLessonStateId;
    }

    public void setPreviousLessonStateId(Integer previousLessonStateId) {
        this.previousLessonStateId = previousLessonStateId;
    }

    public Boolean getLearnerExportAvailable() {
        return this.learnerExportAvailable;
    }

    public void setLearnerExportAvailable(Boolean learnerExportAvailable) {
        this.learnerExportAvailable = learnerExportAvailable;
    }

    public LearningDesign getLearningDesign() {
        return this.learningDesign;
    }

    public void setLearningDesign(LearningDesign learningDesign) {
        this.learningDesign = learningDesign;
    }

    public LessonClass getLessonClass() {
        return this.lessonClass;
    }

    public void setLessonClass(LessonClass lessonClass) {
        this.lessonClass = lessonClass;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public Set getLearnerProgresses() {
        return this.learnerProgresses;
    }

    public void setLearnerProgresses(Set learnerProgresses) {
        this.learnerProgresses = learnerProgresses;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("lessonId", (Object)this.getLessonId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Lesson)) {
            return false;
        }
        Lesson castOther = (Lesson)other;
        return new EqualsBuilder().append((Object)this.getLessonId(), (Object)castOther.getLessonId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getLessonId()).toHashCode();
    }

    public Set getAllLearners() {
        return this.lessonClass.getLearners();
    }

    public LessonDTO getLessonData() {
        return new LessonDTO(this);
    }

    public LessonDetailsDTO getLessonDetails() {
        return new LessonDetailsDTO(this);
    }

    public boolean isPreviewLesson() {
        Integer copyTypeID = this.getLearningDesign().getCopyTypeID();
        return copyTypeID != null && 3 == copyTypeID;
    }

    public boolean isLessonStarted() {
        return this.isStarted(this.lessonStateId) || this.isStarted(this.previousLessonStateId);
    }

    private boolean isStarted(Integer stateId) {
        return stateId != null && (stateId.equals(STARTED_STATE) || stateId.equals(FINISHED_STATE) || stateId.equals(ARCHIVED_STATE) || stateId.equals(REMOVED_STATE));
    }
}

