/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ToolDAO
extends HibernateDaoSupport
implements IToolDAO {
    private static final String FIND_ALL = "from obj in class " + Tool.class.getName();
    private static final String LOAD_TOOL_BY_SIG = "from tool in class Tool where tool.toolSignature=:toolSignature";

    public Tool getToolByID(Long toolID) {
        return (Tool)this.getHibernateTemplate().get(Tool.class, (Serializable)toolID);
    }

    public List getAllTools() {
        return this.getHibernateTemplate().find(FIND_ALL);
    }

    public Tool getToolBySignature(final String toolSignature) {
        return (Tool)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(ToolDAO.LOAD_TOOL_BY_SIG).setString("toolSignature", toolSignature).uniqueResult();
            }
        });
    }

    public long getToolDefaultContentIdBySignature(final String toolSignature) {
        Tool tool = (Tool)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(ToolDAO.LOAD_TOOL_BY_SIG).setString("toolSignature", toolSignature).uniqueResult();
            }
        });
        if (tool != null) {
            return tool.getDefaultToolContentId();
        }
        return 0L;
    }
}

